/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.properties;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.h2.util.StringUtils;
import org.h2gis.api.AbstractFunction;
import org.h2gis.api.ScalarFunction;
import org.h2gis.functions.spatial.properties.ST_SRID;
import org.h2gis.utilities.SFSUtilities;
import org.h2gis.utilities.TableLocation;

public class ColumnSRID
extends AbstractFunction
implements ScalarFunction {
    private static final String SRID_FUNC = ST_SRID.class.getSimpleName();
    private static final Pattern SRID_CONSTRAINT_PATTERN = Pattern.compile("ST_SRID\\s*\\(\\s*((([\"`][^\"`]+[\"`])|(\\w+)))\\s*\\)\\s*=\\s*(\\d+)", 2);

    public ColumnSRID() {
        this.addProperty("remarks", "Get the column SRID from constraints and data.");
        this.addProperty("name", "_ColumnSRID");
    }

    public String getJavaStaticMethod() {
        return "getSRID";
    }

    public static int getSRIDFromConstraint(String constraint, String columnName) {
        int srid = 0;
        Matcher matcher = SRID_CONSTRAINT_PATTERN.matcher(constraint);
        while (matcher.find()) {
            String extractedColumnName = matcher.group(1).replace("\"", "").replace("`", "");
            int sridConstr = Integer.valueOf(matcher.group(5));
            if (!extractedColumnName.equalsIgnoreCase(columnName)) continue;
            if (srid != 0 && srid != sridConstr) {
                return 0;
            }
            srid = sridConstr;
        }
        return srid;
    }

    /*
     * Loose catch block
     */
    public static String fetchConstraint(Connection connection, String catalogName, String schemaName, String tableName) throws SQLException {
        try (PreparedStatement pst = SFSUtilities.prepareInformationSchemaStatement((Connection)connection, (String)catalogName, (String)schemaName, (String)tableName, (String)"INFORMATION_SCHEMA.CONSTRAINTS", (String)"", (String)"TABLE_CATALOG", (String)"TABLE_SCHEMA", (String)"TABLE_NAME");){
            try (ResultSet rsConstraint = pst.executeQuery();){
                StringBuilder constraint = new StringBuilder();
                while (rsConstraint.next()) {
                    String tableConstr = rsConstraint.getString("CHECK_EXPRESSION");
                    if (tableConstr == null) continue;
                    constraint.append(tableConstr);
                }
                String string = constraint.toString();
                return string;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getSRID(Connection connection, String catalogName, String schemaName, String tableName, String columnName, String constraint) {
        try {
            int srid2;
            Statement st = connection.createStatement();
            constraint = constraint + ColumnSRID.fetchConstraint(connection, catalogName, schemaName, tableName);
            if (constraint.toUpperCase().contains(SRID_FUNC) && (srid2 = ColumnSRID.getSRIDFromConstraint(constraint, columnName)) > 0) {
                return srid2;
            }
            try (ResultSet rs = st.executeQuery(String.format("select ST_SRID(%s) from %s LIMIT 1;", StringUtils.quoteJavaString((String)columnName.toUpperCase()), new TableLocation(catalogName, schemaName, tableName)));){
                if (!rs.next()) return 0;
                int srid = rs.getInt(1);
                if (srid <= 0) return 0;
                int n = srid;
                return n;
            }
        }
        catch (SQLException ex) {
            return 0;
        }
    }
}

