/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.earth;

import java.util.Date;
import org.h2gis.api.DeterministicScalarFunction;
import org.h2gis.functions.spatial.earth.SunCalc;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;

public class ST_SunPosition
extends DeterministicScalarFunction {
    public ST_SunPosition() {
        this.addProperty("remarks", "Return the sun position (horizontal coordinate system) as a Point where : \nx = sun azimuth in radians (direction along the horizon, measured from north to\neast).\ny = sun altitude above the horizon in radians, e.g. 0 at the\nhorizon and PI/2 at the zenith.\n");
    }

    public String getJavaStaticMethod() {
        return "sunPosition";
    }

    public static Geometry sunPosition(Geometry point) {
        return ST_SunPosition.sunPosition(point, new Date());
    }

    public static Geometry sunPosition(Geometry point, Date date) throws IllegalArgumentException {
        if (point == null) {
            return null;
        }
        if (point instanceof Point) {
            Coordinate coord = point.getCoordinate();
            return point.getFactory().createPoint(SunCalc.getPosition(date, coord.y, coord.x));
        }
        throw new IllegalArgumentException("The sun position is computed according a point location.");
    }
}

