/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.distance;

import java.util.HashSet;
import org.h2gis.api.DeterministicScalarFunction;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;

public class ST_FurthestCoordinate
extends DeterministicScalarFunction {
    private static final GeometryFactory GEOMETRY_FACTORY = new GeometryFactory();

    public ST_FurthestCoordinate() {
        this.addProperty("remarks", "Computes the furthest coordinate(s) contained in the given geometry starting from the given point, using the 2D distance.");
    }

    public String getJavaStaticMethod() {
        return "getFurthestCoordinate";
    }

    public static Geometry getFurthestCoordinate(Point point, Geometry geom) {
        if (point == null || geom == null) {
            return null;
        }
        double maxDistance = Double.NEGATIVE_INFINITY;
        Coordinate pointCoordinate = point.getCoordinate();
        HashSet<Coordinate> furthestCoordinates = new HashSet<Coordinate>();
        for (Coordinate c : geom.getCoordinates()) {
            double distance = c.distance(pointCoordinate);
            if (Double.compare(distance, maxDistance) == 0) {
                furthestCoordinates.add(c);
            }
            if (Double.compare(distance, maxDistance) <= 0) continue;
            maxDistance = distance;
            furthestCoordinates.clear();
            furthestCoordinates.add(c);
        }
        if (furthestCoordinates.size() == 1) {
            return GEOMETRY_FACTORY.createPoint((Coordinate)furthestCoordinates.iterator().next());
        }
        return GEOMETRY_FACTORY.createMultiPoint(furthestCoordinates.toArray(new Coordinate[0]));
    }
}

