/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.create;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.h2.value.Value;
import org.h2.value.ValueGeometry;
import org.h2.value.ValueString;
import org.h2gis.api.AbstractFunction;
import org.h2gis.api.ScalarFunction;
import org.h2gis.functions.spatial.create.GridRowSet;

public class ST_MakeGrid
extends AbstractFunction
implements ScalarFunction {
    public ST_MakeGrid() {
        this.addProperty("remarks", "Calculate a regular grid.\nThe first argument is either a geometry or a table.\nThe delta X and Y cell grid are expressed in a cartesian plane.Note :The geometry could be expressed using a subquery as\n (SELECT the_geom from myTable)");
        this.addProperty("nobuffer", true);
    }

    public String getJavaStaticMethod() {
        return "createGrid";
    }

    public static ResultSet createGrid(Connection connection, Value value, double deltaX, double deltaY) throws SQLException {
        if (value == null) {
            return null;
        }
        if (value instanceof ValueString) {
            GridRowSet gridRowSet = new GridRowSet(connection, deltaX, deltaY, value.getString());
            return gridRowSet.getResultSet();
        }
        if (value instanceof ValueGeometry) {
            ValueGeometry geom = (ValueGeometry)value;
            GridRowSet gridRowSet = new GridRowSet(connection, deltaX, deltaY, geom.getGeometry().getEnvelopeInternal());
            return gridRowSet.getResultSet();
        }
        throw new SQLException("This function supports only table name or geometry as first argument.");
    }
}

