/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.io.utility;

import java.io.File;
import java.io.FileNotFoundException;
import java.sql.SQLException;

public class FileUtil {
    public static boolean isFileImportable(File file, String prefix) throws SQLException, FileNotFoundException {
        if (FileUtil.isExtensionWellFormated(file, prefix)) {
            if (file.exists()) {
                return true;
            }
            throw new FileNotFoundException("The following file does not exists:\n" + file.getPath());
        }
        throw new SQLException("Please use " + prefix + " extension.");
    }

    public static boolean isExtensionWellFormated(File file, String prefix) {
        String path = file.getAbsolutePath();
        String extension = "";
        int i = path.lastIndexOf(46);
        if (i >= 0) {
            extension = path.substring(i + 1);
        }
        return extension.equalsIgnoreCase(prefix);
    }
}

