/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.io.shp.internal;

import java.io.IOException;
import org.h2gis.functions.io.shp.internal.ShapeHandler;
import org.h2gis.functions.io.shp.internal.ShapeType;
import org.h2gis.functions.io.shp.internal.ShapefileException;
import org.h2gis.functions.io.utility.ReadBufferManager;
import org.h2gis.functions.io.utility.WriteBufferManager;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;

public class PointHandler
implements ShapeHandler {
    final ShapeType shapeType;
    GeometryFactory geometryFactory = new GeometryFactory();

    public PointHandler(ShapeType type) throws ShapefileException {
        if (type != ShapeType.POINT && type != ShapeType.POINTM && type != ShapeType.POINTZ) {
            throw new ShapefileException("PointHandler constructor: expected a type of 1, 11 or 21");
        }
        this.shapeType = type;
    }

    public PointHandler() {
        this.shapeType = ShapeType.POINT;
    }

    @Override
    public ShapeType getShapeType() {
        return this.shapeType;
    }

    @Override
    public int getLength(Object geometry) {
        int length;
        if (this.shapeType == ShapeType.POINT) {
            length = 20;
        } else if (this.shapeType == ShapeType.POINTM) {
            length = 28;
        } else if (this.shapeType == ShapeType.POINTZ) {
            length = 36;
        } else {
            throw new IllegalStateException("Expected ShapeType of Point, got" + this.shapeType);
        }
        return length;
    }

    @Override
    public Geometry read(ReadBufferManager buffer, ShapeType type) throws IOException {
        if (type == ShapeType.NULL) {
            return null;
        }
        double x = buffer.getDouble();
        double y = buffer.getDouble();
        double z = Double.NaN;
        if (this.shapeType == ShapeType.POINTM) {
            buffer.getDouble();
        }
        if (this.shapeType == ShapeType.POINTZ) {
            z = buffer.getDouble();
        }
        return this.geometryFactory.createPoint(new Coordinate(x, y, z));
    }

    @Override
    public void write(WriteBufferManager buffer, Object geometry) throws IOException {
        Coordinate c = ((Point)geometry).getCoordinate();
        buffer.putDouble(c.x);
        buffer.putDouble(c.y);
        if (this.shapeType == ShapeType.POINTZ) {
            if (Double.isNaN(c.z)) {
                buffer.putDouble(0.0);
            } else {
                buffer.putDouble(c.z);
            }
        }
        if (this.shapeType == ShapeType.POINTZ || this.shapeType == ShapeType.POINTM) {
            buffer.putDouble(-1.0E41);
        }
    }
}

