/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.io.geojson;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import org.h2gis.api.DriverFunction;
import org.h2gis.api.ProgressVisitor;
import org.h2gis.functions.io.geojson.GeoJsonReaderDriver;
import org.h2gis.functions.io.geojson.GeoJsonWriteDriver;
import org.h2gis.utilities.JDBCUtilities;
import org.h2gis.utilities.TableLocation;

public class GeoJsonDriverFunction
implements DriverFunction {
    public DriverFunction.IMPORT_DRIVER_TYPE getImportDriverType() {
        return DriverFunction.IMPORT_DRIVER_TYPE.COPY;
    }

    public String[] getImportFormats() {
        return new String[]{"geojson"};
    }

    public String[] getExportFormats() {
        return new String[]{"geojson"};
    }

    public String getFormatDescription(String format) {
        if (format.equalsIgnoreCase("geojson")) {
            return "GeoJSON 1.0";
        }
        return "";
    }

    public boolean isSpatialFormat(String extension) {
        return extension.equals("geojson");
    }

    public void exportTable(Connection connection, String tableReference, File fileName, ProgressVisitor progress) throws SQLException, IOException {
        this.exportTable(connection, tableReference, fileName, progress, null);
    }

    public void exportTable(Connection connection, String tableReference, File fileName, ProgressVisitor progress, String encoding) throws SQLException, IOException {
        GeoJsonWriteDriver geoJsonDriver = new GeoJsonWriteDriver(connection);
        geoJsonDriver.write(progress, tableReference, fileName, encoding);
    }

    public void importFile(Connection connection, String tableReference, File fileName, ProgressVisitor progress) throws SQLException, IOException {
        GeoJsonReaderDriver geoJsonReaderDriver = new GeoJsonReaderDriver(connection, fileName);
        geoJsonReaderDriver.read(progress, tableReference);
    }

    public void importFile(Connection connection, String tableReference, File fileName, ProgressVisitor progress, String options) throws SQLException, IOException {
        this.importFile(connection, tableReference, fileName, progress);
    }

    public void importFile(Connection connection, String tableReference, File fileName, ProgressVisitor progress, boolean deleteTables) throws SQLException, IOException {
        if (deleteTables) {
            boolean isH2 = JDBCUtilities.isH2DataBase((DatabaseMetaData)connection.getMetaData());
            TableLocation requestedTable = TableLocation.parse((String)tableReference, (Boolean)isH2);
            String table = requestedTable.getTable();
            Statement stmt = connection.createStatement();
            stmt.execute("DROP TABLE IF EXISTS " + table);
            stmt.close();
        }
        this.importFile(connection, tableReference, fileName, progress);
    }
}

