/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.utilities;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.h2gis.api.ProgressVisitor;
import org.h2gis.utilities.TableLocation;

public class JDBCUtilities {
    public static final String H2_DRIVER_NAME = "H2 JDBC Driver";

    private JDBCUtilities() {
    }

    private static ResultSet getTablesView(Connection connection, String catalog, String schema, String table) throws SQLException {
        Integer n;
        Integer n2;
        Integer catalogIndex = null;
        Integer schemaIndex = null;
        Integer tableIndex = 1;
        StringBuilder sb = new StringBuilder("SELECT * from INFORMATION_SCHEMA.TABLES where ");
        if (!catalog.isEmpty()) {
            sb.append("UPPER(table_catalog) = ? AND ");
            catalogIndex = 1;
            n2 = tableIndex;
            n = tableIndex = Integer.valueOf(tableIndex + 1);
        }
        if (!schema.isEmpty()) {
            sb.append("UPPER(table_schema) = ? AND ");
            schemaIndex = tableIndex;
            n2 = tableIndex;
            n = tableIndex = Integer.valueOf(tableIndex + 1);
        }
        sb.append("UPPER(table_name) = ? ");
        PreparedStatement geomStatement = connection.prepareStatement(sb.toString());
        if (catalogIndex != null) {
            geomStatement.setString(catalogIndex, catalog.toUpperCase());
        }
        if (schemaIndex != null) {
            geomStatement.setString(schemaIndex, schema.toUpperCase());
        }
        geomStatement.setString(tableIndex, table.toUpperCase());
        return geomStatement.executeQuery();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasField(Connection connection, String tableName, String fieldName) throws SQLException {
        try (Statement statement = connection.createStatement();){
            boolean bl;
            ResultSet resultSet = statement.executeQuery("SELECT * FROM " + TableLocation.parse(tableName) + " LIMIT 0;");
            try {
                bl = JDBCUtilities.hasField(resultSet.getMetaData(), fieldName);
            }
            catch (Throwable throwable) {
                try {
                    resultSet.close();
                    throw throwable;
                }
                catch (SQLException ex) {
                    boolean bl2 = false;
                    return bl2;
                }
            }
            resultSet.close();
            return bl;
        }
    }

    private static boolean hasField(ResultSetMetaData resultSetMetaData, String fieldName) throws SQLException {
        return JDBCUtilities.getFieldIndex(resultSetMetaData, fieldName) != -1;
    }

    public static int getFieldIndex(ResultSetMetaData resultSetMetaData, String fieldName) throws SQLException {
        for (int columnId = 1; columnId <= resultSetMetaData.getColumnCount(); ++columnId) {
            if (!fieldName.equalsIgnoreCase(resultSetMetaData.getColumnName(columnId))) continue;
            return columnId;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFieldName(DatabaseMetaData meta, String table, int fieldIndex) throws SQLException {
        TableLocation location = TableLocation.parse(table);
        try (ResultSet rs = meta.getColumns(location.getCatalog(null), location.getSchema(null), location.getTable(), null);){
            while (rs.next()) {
                if (rs.getInt("ORDINAL_POSITION") != fieldIndex) continue;
                String string = rs.getString("COLUMN_NAME");
                return string;
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getFieldNames(DatabaseMetaData meta, String table) throws SQLException {
        ArrayList<String> fieldNameList = new ArrayList<String>();
        TableLocation location = TableLocation.parse(table);
        try (ResultSet rs = meta.getColumns(location.getCatalog(null), location.getSchema(null), location.getTable(), null);){
            while (rs.next()) {
                fieldNameList.add(rs.getString("COLUMN_NAME"));
            }
        }
        return fieldNameList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getRowCount(Connection connection, String tableReference) throws SQLException {
        int rowCount = 0;
        try (Statement st = connection.createStatement();
             ResultSet rs = st.executeQuery(String.format("select count(*) rowcount from %s", TableLocation.parse(tableReference)));){
            if (rs.next()) {
                rowCount = rs.getInt(1);
            }
        }
        return rowCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isTemporaryTable(Connection connection, String tableReference) throws SQLException {
        boolean isTemporary;
        block4: {
            TableLocation location = TableLocation.parse(tableReference);
            isTemporary = false;
            try (ResultSet rs = JDBCUtilities.getTablesView(connection, location.getCatalog(), location.getSchema(), location.getTable());){
                if (rs.next()) {
                    String tableType = JDBCUtilities.hasField(rs.getMetaData(), "STORAGE_TYPE") ? rs.getString("STORAGE_TYPE") : rs.getString("TABLE_TYPE");
                    isTemporary = tableType.contains("TEMPORARY");
                    break block4;
                }
                throw new SQLException("The table " + location + " does not exists");
            }
        }
        return isTemporary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isLinkedTable(Connection connection, String tableReference) throws SQLException {
        boolean isLinked;
        block4: {
            TableLocation location = TableLocation.parse(tableReference);
            try (ResultSet rs = JDBCUtilities.getTablesView(connection, location.getCatalog(), location.getSchema(), location.getTable());){
                if (rs.next()) {
                    String tableType = rs.getString("TABLE_TYPE");
                    isLinked = tableType.contains("TABLE LINK");
                    break block4;
                }
                throw new SQLException("The table " + location + " does not exists");
            }
        }
        return isLinked;
    }

    public static boolean isH2DataBase(DatabaseMetaData metaData) throws SQLException {
        return metaData.getDriverName().equals(H2_DRIVER_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getIntegerPrimaryKey(Connection connection, String tableReference) throws SQLException {
        if (!JDBCUtilities.tableExists(connection, tableReference)) {
            throw new SQLException("Table " + tableReference + " not found.");
        }
        DatabaseMetaData meta = connection.getMetaData();
        TableLocation tableLocation = TableLocation.parse(tableReference);
        String columnNamePK = null;
        try (ResultSet rs = meta.getPrimaryKeys(tableLocation.getCatalog(null), tableLocation.getSchema(null), tableLocation.getTable());){
            while (rs.next()) {
                if (tableLocation.getSchema().isEmpty() && !"public".equalsIgnoreCase(rs.getString("TABLE_SCHEM"))) continue;
                if (columnNamePK == null) {
                    columnNamePK = rs.getString("COLUMN_NAME");
                    continue;
                }
                columnNamePK = null;
                break;
            }
        }
        if (columnNamePK != null) {
            rs = meta.getColumns(tableLocation.getCatalog(null), tableLocation.getSchema(null), tableLocation.getTable(), columnNamePK);
            try {
                while (rs.next()) {
                    if (tableLocation.getSchema().isEmpty() && !"public".equalsIgnoreCase(rs.getString("TABLE_SCHEM"))) continue;
                    int dataType = rs.getInt("DATA_TYPE");
                    if (dataType != -5 && dataType != 4 && dataType != -8) continue;
                    int n = rs.getInt("ORDINAL_POSITION");
                    return n;
                }
            }
            finally {
                rs.close();
            }
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean tableExists(Connection connection, String tableName) throws SQLException {
        try (Statement statement = connection.createStatement();){
            statement.execute("SELECT * FROM " + TableLocation.parse(tableName) + " LIMIT 0;");
            boolean bl = true;
            return bl;
        }
        catch (SQLException ex) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getTableNames(DatabaseMetaData metaData, String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        ArrayList<String> tableList = new ArrayList<String>();
        ResultSet rs = metaData.getTables(catalog, schemaPattern, tableNamePattern, types);
        boolean isH2 = JDBCUtilities.isH2DataBase(metaData);
        try {
            while (rs.next()) {
                tableList.add(new TableLocation(rs).toString(isH2));
            }
        }
        finally {
            rs.close();
        }
        return tableList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getUniqueFieldValues(Connection connection, String tableName, String fieldName) throws SQLException {
        ArrayList<String> fieldValues = new ArrayList<String>();
        try (Statement statement = connection.createStatement();){
            ResultSet result = statement.executeQuery("SELECT DISTINCT " + TableLocation.quoteIdentifier(fieldName) + " FROM " + TableLocation.parse(tableName));
            while (result.next()) {
                fieldValues.add(result.getString(1));
            }
        }
        return fieldValues;
    }

    public static void createEmptyTable(Connection connection, String tableReference) throws SQLException {
        try (Statement statement = connection.createStatement();){
            statement.execute("CREATE TABLE " + tableReference + " ()");
        }
    }

    public static List<String> getFieldNames(ResultSetMetaData resultSetMetaData) throws SQLException {
        ArrayList<String> columnNames = new ArrayList<String>();
        int cols = resultSetMetaData.getColumnCount();
        for (int i = 1; i <= cols; ++i) {
            columnNames.add(resultSetMetaData.getColumnName(i));
        }
        return columnNames;
    }

    public static PropertyChangeListener attachCancelResultSet(Statement st, ProgressVisitor progressVisitor) {
        CancelResultSet propertyChangeListener = new CancelResultSet(st);
        progressVisitor.addPropertyChangeListener("CANCELED", (PropertyChangeListener)propertyChangeListener);
        return propertyChangeListener;
    }

    private static final class CancelResultSet
    implements PropertyChangeListener {
        private final Statement st;

        private CancelResultSet(Statement st) {
            this.st = st;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            try {
                this.st.cancel();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static enum FUNCTION_TYPE {
        ALL,
        BUILT_IN,
        ALIAS;

    }
}

