/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.io.gml2;

import java.util.HashMap;
import java.util.List;
import java.util.WeakHashMap;
import java.util.regex.Pattern;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.io.gml2.GMLHandler;
import org.locationtech.jts.util.StringUtil;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class GeometryStrategies {
    private static HashMap strategies = GeometryStrategies.loadStrategies();

    private static HashMap loadStrategies() {
        HashMap<String, ParseStrategy> strats = new HashMap<String, ParseStrategy>();
        strats.put("Point".toLowerCase(), new ParseStrategy(){

            @Override
            public Object parse(GMLHandler.Handler arg, GeometryFactory gf) throws SAXException {
                if (arg.children.size() != 1) {
                    throw new SAXException("Cannot create a point without exactly one coordinate");
                }
                int srid = GeometryStrategies.getSrid(arg.attrs, gf.getSRID());
                Object c = arg.children.get(0);
                Point p = null;
                p = c instanceof Coordinate ? gf.createPoint((Coordinate)c) : gf.createPoint((CoordinateSequence)c);
                if (p.getSRID() != srid) {
                    p.setSRID(srid);
                }
                return p;
            }
        });
        strats.put("LineString".toLowerCase(), new ParseStrategy(){

            @Override
            public Object parse(GMLHandler.Handler arg, GeometryFactory gf) throws SAXException {
                if (arg.children.size() < 1) {
                    throw new SAXException("Cannot create a linestring without atleast two coordinates or one coordinate sequence");
                }
                int srid = GeometryStrategies.getSrid(arg.attrs, gf.getSRID());
                LineString ls = null;
                if (arg.children.size() == 1) {
                    try {
                        CoordinateSequence cs = (CoordinateSequence)arg.children.get(0);
                        ls = gf.createLineString(cs);
                    }
                    catch (ClassCastException e) {
                        throw new SAXException("Cannot create a linestring without atleast two coordinates or one coordinate sequence", e);
                    }
                }
                try {
                    Coordinate[] coords = arg.children.toArray(new Coordinate[arg.children.size()]);
                    ls = gf.createLineString(coords);
                }
                catch (ClassCastException e) {
                    throw new SAXException("Cannot create a linestring without atleast two coordinates or one coordinate sequence", e);
                }
                if (ls.getSRID() != srid) {
                    ls.setSRID(srid);
                }
                return ls;
            }
        });
        strats.put("LinearRing".toLowerCase(), new ParseStrategy(){

            @Override
            public Object parse(GMLHandler.Handler arg, GeometryFactory gf) throws SAXException {
                if (arg.children.size() != 1 && arg.children.size() < 4) {
                    throw new SAXException("Cannot create a linear ring without atleast four coordinates or one coordinate sequence");
                }
                int srid = GeometryStrategies.getSrid(arg.attrs, gf.getSRID());
                LinearRing ls = null;
                if (arg.children.size() == 1) {
                    try {
                        CoordinateSequence cs = (CoordinateSequence)arg.children.get(0);
                        ls = gf.createLinearRing(cs);
                    }
                    catch (ClassCastException e) {
                        throw new SAXException("Cannot create a linear ring without atleast four coordinates or one coordinate sequence", e);
                    }
                }
                try {
                    Coordinate[] coords = arg.children.toArray(new Coordinate[arg.children.size()]);
                    ls = gf.createLinearRing(coords);
                }
                catch (ClassCastException e) {
                    throw new SAXException("Cannot create a linear ring without atleast four coordinates or one coordinate sequence", e);
                }
                if (ls.getSRID() != srid) {
                    ls.setSRID(srid);
                }
                return ls;
            }
        });
        strats.put("Polygon".toLowerCase(), new ParseStrategy(){

            @Override
            public Object parse(GMLHandler.Handler arg, GeometryFactory gf) throws SAXException {
                List t;
                LinearRing[] inner;
                if (arg.children.size() < 1) {
                    throw new SAXException("Cannot create a polygon without atleast one linear ring");
                }
                int srid = GeometryStrategies.getSrid(arg.attrs, gf.getSRID());
                LinearRing outer = (LinearRing)arg.children.get(0);
                Polygon p = gf.createPolygon(outer, inner = (t = arg.children.size() > 1 ? arg.children.subList(1, arg.children.size()) : null) == null ? null : t.toArray(new LinearRing[t.size()]));
                if (p.getSRID() != srid) {
                    p.setSRID(srid);
                }
                return p;
            }
        });
        strats.put("Box".toLowerCase(), new ParseStrategy(){

            @Override
            public Object parse(GMLHandler.Handler arg, GeometryFactory gf) throws SAXException {
                if (arg.children.size() < 1 || arg.children.size() > 2) {
                    throw new SAXException("Cannot create a box without either two coords or one coordinate sequence");
                }
                Envelope box = null;
                if (arg.children.size() == 1) {
                    CoordinateSequence cs = (CoordinateSequence)arg.children.get(0);
                    box = cs.expandEnvelope(new Envelope());
                } else {
                    box = new Envelope((Coordinate)arg.children.get(0), (Coordinate)arg.children.get(1));
                }
                return box;
            }
        });
        strats.put("MultiPoint".toLowerCase(), new ParseStrategy(){

            @Override
            public Object parse(GMLHandler.Handler arg, GeometryFactory gf) throws SAXException {
                if (arg.children.size() < 1) {
                    throw new SAXException("Cannot create a multi-point without atleast one point");
                }
                int srid = GeometryStrategies.getSrid(arg.attrs, gf.getSRID());
                Point[] pts = arg.children.toArray(new Point[arg.children.size()]);
                MultiPoint mp = gf.createMultiPoint(pts);
                if (mp.getSRID() != srid) {
                    mp.setSRID(srid);
                }
                return mp;
            }
        });
        strats.put("MultiLineString".toLowerCase(), new ParseStrategy(){

            @Override
            public Object parse(GMLHandler.Handler arg, GeometryFactory gf) throws SAXException {
                if (arg.children.size() < 1) {
                    throw new SAXException("Cannot create a multi-linestring without atleast one linestring");
                }
                int srid = GeometryStrategies.getSrid(arg.attrs, gf.getSRID());
                LineString[] lns = arg.children.toArray(new LineString[arg.children.size()]);
                MultiLineString mp = gf.createMultiLineString(lns);
                if (mp.getSRID() != srid) {
                    mp.setSRID(srid);
                }
                return mp;
            }
        });
        strats.put("MultiPolygon".toLowerCase(), new ParseStrategy(){

            @Override
            public Object parse(GMLHandler.Handler arg, GeometryFactory gf) throws SAXException {
                if (arg.children.size() < 1) {
                    throw new SAXException("Cannot create a multi-polygon without atleast one polygon");
                }
                int srid = GeometryStrategies.getSrid(arg.attrs, gf.getSRID());
                Polygon[] plys = arg.children.toArray(new Polygon[arg.children.size()]);
                MultiPolygon mp = gf.createMultiPolygon(plys);
                if (mp.getSRID() != srid) {
                    mp.setSRID(srid);
                }
                return mp;
            }
        });
        strats.put("MultiGeometry".toLowerCase(), new ParseStrategy(){

            @Override
            public Object parse(GMLHandler.Handler arg, GeometryFactory gf) throws SAXException {
                if (arg.children.size() < 1) {
                    throw new SAXException("Cannot create a multi-polygon without atleast one geometry");
                }
                Geometry[] geoms = arg.children.toArray(new Geometry[arg.children.size()]);
                GeometryCollection gc = gf.createGeometryCollection(geoms);
                return gc;
            }
        });
        strats.put("coordinates".toLowerCase(), new ParseStrategy(){
            private WeakHashMap patterns = new WeakHashMap();

            @Override
            public Object parse(GMLHandler.Handler arg, GeometryFactory gf) throws SAXException {
                int i;
                String[] touples;
                if (arg.text == null || "".equals(arg.text)) {
                    throw new SAXException("Cannot create a coordinate sequence without text to parse");
                }
                String decimal = ".";
                String coordSeperator = ",";
                String toupleSeperator = " ";
                if (arg.attrs.getIndex("decimal") >= 0) {
                    decimal = arg.attrs.getValue("decimal");
                } else if (arg.attrs.getIndex("http://www.opengis.net/gml", "decimal") >= 0) {
                    decimal = arg.attrs.getValue("http://www.opengis.net/gml", "decimal");
                }
                if (arg.attrs.getIndex("cs") >= 0) {
                    coordSeperator = arg.attrs.getValue("cs");
                } else if (arg.attrs.getIndex("http://www.opengis.net/gml", "cs") >= 0) {
                    coordSeperator = arg.attrs.getValue("http://www.opengis.net/gml", "cs");
                }
                if (arg.attrs.getIndex("ts") >= 0) {
                    toupleSeperator = arg.attrs.getValue("ts");
                } else if (arg.attrs.getIndex("http://www.opengis.net/gml", "ts") >= 0) {
                    toupleSeperator = arg.attrs.getValue("http://www.opengis.net/gml", "ts");
                }
                String t = arg.text.toString();
                t = t.replaceAll("\\s", " ");
                Pattern ptn = (Pattern)this.patterns.get(toupleSeperator);
                if (ptn == null) {
                    String ts = new String(toupleSeperator);
                    if (ts.indexOf(92) > -1) {
                        ts = ts.replaceAll("\\", "\\\\");
                    }
                    if (ts.indexOf(46) > -1) {
                        ts = ts.replaceAll("\\.", "\\\\.");
                    }
                    ptn = Pattern.compile(ts);
                    this.patterns.put(toupleSeperator, ptn);
                }
                if ((touples = ptn.split(t.trim())).length == 0) {
                    throw new SAXException("Cannot create a coordinate sequence without a touple to parse");
                }
                int numNonNullTouples = 0;
                for (i = 0; i < touples.length; ++i) {
                    if (touples[i] == null || "".equals(touples[i].trim())) continue;
                    if (i != numNonNullTouples) {
                        touples[numNonNullTouples] = touples[i];
                    }
                    ++numNonNullTouples;
                }
                for (i = numNonNullTouples; i < touples.length; ++i) {
                    touples[i] = null;
                }
                if (numNonNullTouples == 0) {
                    throw new SAXException("Cannot create a coordinate sequence without a non-null touple to parse");
                }
                int dim = StringUtil.split(touples[0], coordSeperator).length;
                CoordinateSequence cs = gf.getCoordinateSequenceFactory().create(numNonNullTouples, dim);
                dim = cs.getDimension();
                boolean replaceDec = !".".equals(decimal);
                for (int i2 = 0; i2 < numNonNullTouples; ++i2) {
                    ptn = (Pattern)this.patterns.get(coordSeperator);
                    if (ptn == null) {
                        String ts = new String(coordSeperator);
                        if (ts.indexOf(92) > -1) {
                            ts = ts.replaceAll("\\", "\\\\");
                        }
                        if (ts.indexOf(46) > -1) {
                            ts = ts.replaceAll("\\.", "\\\\.");
                        }
                        ptn = Pattern.compile(ts);
                        this.patterns.put(coordSeperator, ptn);
                    }
                    String[] coords = ptn.split(touples[i2]);
                    int dimIndex = 0;
                    for (int j = 0; j < coords.length && j < dim; ++j) {
                        if (coords[j] == null || "".equals(coords[j].trim())) continue;
                        double ordinate = Double.parseDouble(replaceDec ? coords[j].replaceAll(decimal, ".") : coords[j]);
                        cs.setOrdinate(i2, dimIndex++, ordinate);
                    }
                    while (dimIndex < dim) {
                        cs.setOrdinate(i2, dimIndex++, Double.NaN);
                    }
                }
                return cs;
            }
        });
        strats.put("coord".toLowerCase(), new ParseStrategy(){

            @Override
            public Object parse(GMLHandler.Handler arg, GeometryFactory gf) throws SAXException {
                if (arg.children.size() < 1) {
                    throw new SAXException("Cannot create a coordinate without atleast one axis");
                }
                if (arg.children.size() > 3) {
                    throw new SAXException("Cannot create a coordinate with more than 3 axis");
                }
                Double[] axis = arg.children.toArray(new Double[arg.children.size()]);
                Coordinate c = new Coordinate();
                c.x = axis[0];
                if (axis.length > 1) {
                    c.y = axis[1];
                }
                if (axis.length > 2) {
                    c.z = axis[2];
                }
                return c;
            }
        });
        ParseStrategy coord_child = new ParseStrategy(){

            @Override
            public Object parse(GMLHandler.Handler arg, GeometryFactory gf) throws SAXException {
                if (arg.text == null) {
                    return null;
                }
                return new Double(arg.text.toString());
            }
        };
        strats.put("X".toLowerCase(), coord_child);
        strats.put("Y".toLowerCase(), coord_child);
        strats.put("Z".toLowerCase(), coord_child);
        ParseStrategy member = new ParseStrategy(){

            @Override
            public Object parse(GMLHandler.Handler arg, GeometryFactory gf) throws SAXException {
                if (arg.children.size() != 1) {
                    throw new SAXException("Geometry Members may only contain one geometry.");
                }
                return arg.children.get(0);
            }
        };
        strats.put("outerBoundaryIs".toLowerCase(), member);
        strats.put("innerBoundaryIs".toLowerCase(), member);
        strats.put("pointMember".toLowerCase(), member);
        strats.put("lineStringMember".toLowerCase(), member);
        strats.put("polygonMember".toLowerCase(), member);
        return strats;
    }

    static int getSrid(Attributes attrs, int defaultValue) {
        String srs = null;
        if (attrs.getIndex("srsName") >= 0) {
            srs = attrs.getValue("srsName");
        } else if (attrs.getIndex("http://www.opengis.net/gml", "srsName") >= 0) {
            srs = attrs.getValue("http://www.opengis.net/gml", "srsName");
        }
        if (srs != null && (srs = srs.trim()) != null && !"".equals(srs)) {
            try {
                return Integer.parseInt(srs);
            }
            catch (NumberFormatException e) {
                int index = srs.lastIndexOf(35);
                if (index > -1) {
                    srs = srs.substring(index);
                }
                try {
                    return Integer.parseInt(srs);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return defaultValue;
    }

    public static ParseStrategy findStrategy(String uri, String localName) {
        return localName == null ? null : (ParseStrategy)strategies.get(localName.toLowerCase());
    }

    static interface ParseStrategy {
        public Object parse(GMLHandler.Handler var1, GeometryFactory var2) throws SAXException;
    }
}

