/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.edit;

import java.util.ArrayList;
import org.h2gis.api.DeterministicScalarFunction;
import org.h2gis.utilities.jts_utils.CoordinateUtils;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class ST_RemoveDuplicatedCoordinates
extends DeterministicScalarFunction {
    private static final GeometryFactory FACTORY = new GeometryFactory();

    public ST_RemoveDuplicatedCoordinates() {
        this.addProperty("remarks", "Returns a version of the given geometry without duplicated coordinates.");
    }

    public String getJavaStaticMethod() {
        return "removeDuplicatedCoordinates";
    }

    public static Geometry removeDuplicatedCoordinates(Geometry geometry) {
        return ST_RemoveDuplicatedCoordinates.removeCoordinates(geometry);
    }

    public static Geometry removeCoordinates(Geometry geom) {
        if (geom == null) {
            return null;
        }
        if (geom.isEmpty()) {
            return geom;
        }
        if (geom instanceof Point) {
            return geom;
        }
        if (geom instanceof MultiPoint) {
            return ST_RemoveDuplicatedCoordinates.removeCoordinates((MultiPoint)geom);
        }
        if (geom instanceof LineString) {
            return ST_RemoveDuplicatedCoordinates.removeCoordinates((LineString)geom);
        }
        if (geom instanceof MultiLineString) {
            return ST_RemoveDuplicatedCoordinates.removeCoordinates((MultiLineString)geom);
        }
        if (geom instanceof Polygon) {
            return ST_RemoveDuplicatedCoordinates.removeCoordinates((Polygon)geom);
        }
        if (geom instanceof MultiPolygon) {
            return ST_RemoveDuplicatedCoordinates.removeCoordinates((MultiPolygon)geom);
        }
        if (geom instanceof GeometryCollection) {
            return ST_RemoveDuplicatedCoordinates.removeCoordinates((GeometryCollection)geom);
        }
        return null;
    }

    public static MultiPoint removeCoordinates(MultiPoint g) {
        Coordinate[] coords = CoordinateUtils.removeDuplicatedCoordinates((Coordinate[])g.getCoordinates(), (boolean)false);
        return FACTORY.createMultiPoint(coords);
    }

    public static LineString removeCoordinates(LineString g) {
        Coordinate[] coords = CoordinateUtils.removeDuplicatedCoordinates((Coordinate[])g.getCoordinates(), (boolean)false);
        return FACTORY.createLineString(coords);
    }

    public static LinearRing removeCoordinates(LinearRing g) {
        Coordinate[] coords = CoordinateUtils.removeDuplicatedCoordinates((Coordinate[])g.getCoordinates(), (boolean)false);
        return FACTORY.createLinearRing(coords);
    }

    public static MultiLineString removeCoordinates(MultiLineString g) {
        ArrayList<LineString> lines = new ArrayList<LineString>();
        for (int i = 0; i < g.getNumGeometries(); ++i) {
            LineString line = (LineString)g.getGeometryN(i);
            lines.add(ST_RemoveDuplicatedCoordinates.removeCoordinates(line));
        }
        return FACTORY.createMultiLineString(GeometryFactory.toLineStringArray(lines));
    }

    public static Polygon removeCoordinates(Polygon poly) {
        Coordinate[] shellCoords = CoordinateUtils.removeDuplicatedCoordinates((Coordinate[])poly.getExteriorRing().getCoordinates(), (boolean)true);
        LinearRing shell = FACTORY.createLinearRing(shellCoords);
        ArrayList<LinearRing> holes = new ArrayList<LinearRing>();
        for (int i = 0; i < poly.getNumInteriorRing(); ++i) {
            Coordinate[] holeCoords = CoordinateUtils.removeDuplicatedCoordinates((Coordinate[])poly.getInteriorRingN(i).getCoordinates(), (boolean)true);
            holes.add(FACTORY.createLinearRing(holeCoords));
        }
        return FACTORY.createPolygon(shell, GeometryFactory.toLinearRingArray(holes));
    }

    public static MultiPolygon removeCoordinates(MultiPolygon g) {
        ArrayList<Polygon> polys = new ArrayList<Polygon>();
        for (int i = 0; i < g.getNumGeometries(); ++i) {
            Polygon poly = (Polygon)g.getGeometryN(i);
            polys.add(ST_RemoveDuplicatedCoordinates.removeCoordinates(poly));
        }
        return FACTORY.createMultiPolygon(GeometryFactory.toPolygonArray(polys));
    }

    public static GeometryCollection removeCoordinates(GeometryCollection g) {
        ArrayList<Geometry> geoms = new ArrayList<Geometry>();
        for (int i = 0; i < g.getNumGeometries(); ++i) {
            Geometry geom = g.getGeometryN(i);
            geoms.add(ST_RemoveDuplicatedCoordinates.removeCoordinates(geom));
        }
        return FACTORY.createGeometryCollection(GeometryFactory.toGeometryArray(geoms));
    }
}

