/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.sqlgen.generator_impl.jdbc;

import ch.ehi.sqlgen.generator_impl.jdbc.GeneratorJdbc;
import ch.ehi.sqlgen.repository.DbColBoolean;
import ch.ehi.sqlgen.repository.DbColDateTime;
import ch.ehi.sqlgen.repository.DbColDecimal;
import ch.ehi.sqlgen.repository.DbColGeometry;
import ch.ehi.sqlgen.repository.DbColId;
import ch.ehi.sqlgen.repository.DbColNumber;
import ch.ehi.sqlgen.repository.DbColUuid;
import ch.ehi.sqlgen.repository.DbColVarchar;
import ch.ehi.sqlgen.repository.DbColumn;
import java.io.IOException;

public class GeneratorOracleWKB
extends GeneratorJdbc {
    public void visitColumn(DbColumn column) throws IOException {
        String isNull;
        String type = "";
        String size = "";
        Object notSupported = null;
        if (column instanceof DbColBoolean) {
            type = "NUMBER(1)";
        } else if (column instanceof DbColDateTime) {
            type = "TIMESTAMP";
        } else if (column instanceof DbColDecimal) {
            DbColDecimal col = (DbColDecimal)column;
            type = "DECIMAL(" + Integer.toString(col.getSize()) + "," + Integer.toString(col.getPrecision()) + ")";
        } else if (column instanceof DbColGeometry) {
            type = "BLOB";
        } else if (column instanceof DbColId) {
            type = "NUMBER(9)";
        } else if (column instanceof DbColUuid) {
            type = "VARCHAR2(36)";
        } else if (column instanceof DbColNumber) {
            DbColNumber col = (DbColNumber)column;
            type = "NUMBER(" + Integer.toString(col.getSize()) + ")";
        } else if (column instanceof DbColVarchar) {
            int colsize = ((DbColVarchar)column).getSize();
            type = "VARCHAR2(" + Integer.toString(colsize) + ")";
        } else {
            type = "VARCHAR2(20)";
        }
        String string = isNull = column.isNotNull() ? "NOT NULL" : "NULL";
        if (column instanceof DbColId && ((DbColId)column).isPrimaryKey()) {
            isNull = "PRIMARY KEY";
        }
        String name = column.getName();
        this.out.write(this.getIndent() + this.colSep + name + " " + type + " " + isNull + this.newline());
        this.colSep = ",";
    }
}

