/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.iom_j.itf.impl.jtsext.geom;

import ch.ehi.basics.logging.EhiLogger;
import ch.interlis.iom_j.itf.impl.jtsext.geom.CompoundCurve;
import ch.interlis.iom_j.itf.impl.jtsext.geom.CompoundCurveRing;
import ch.interlis.iom_j.itf.impl.jtsext.geom.CurveSegment;
import ch.interlis.iom_j.itf.impl.jtsext.geom.JtsextGeometryFactory;
import ch.interlis.iom_j.itf.impl.jtsext.io.WKTWriterJtsext;
import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateArrays;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import java.util.ArrayList;
import java.util.Arrays;

public class CurvePolygon
extends Polygon {
    public static final String VALID_OVERLAP = "valoverlap";

    public CurvePolygon(LinearRing shell, LinearRing[] holes, GeometryFactory factory) {
        super(shell, holes, factory);
    }

    public void normalize() {
        this.normalize(this.shell, true);
        for (int i = 0; i < this.holes.length; ++i) {
            this.normalize(this.holes[i], false);
        }
        Arrays.sort(this.holes);
    }

    public Geometry reverse() {
        return super.reverse();
    }

    private void normalize(LinearRing ring, boolean clockwise) {
        if (ring.isEmpty()) {
            return;
        }
        if (ring instanceof CompoundCurveRing) {
            CompoundCurveRing cring = (CompoundCurveRing)ring;
            ArrayList<CurveSegment> segv = new ArrayList<CurveSegment>();
            for (CompoundCurve line : cring.getLines()) {
                for (CurveSegment seg : line.getSegments()) {
                    segv.add(seg);
                }
            }
            ArrayList<CurveSegment> newsegv = CompoundCurveRing.normalizeRing(clockwise, segv);
            CompoundCurve newline = null;
            newline = ((JtsextGeometryFactory)this.factory).createCompoundCurve(newsegv);
            cring.setLines(newline);
        } else {
            Coordinate[] uniqueCoordinates = new Coordinate[ring.getCoordinates().length - 1];
            System.arraycopy(ring.getCoordinates(), 0, uniqueCoordinates, 0, uniqueCoordinates.length);
            Coordinate minCoordinate = CoordinateArrays.minCoordinate((Coordinate[])ring.getCoordinates());
            CoordinateArrays.scroll((Coordinate[])uniqueCoordinates, (Coordinate)minCoordinate);
            System.arraycopy(uniqueCoordinates, 0, ring.getCoordinates(), 0, uniqueCoordinates.length);
            ring.getCoordinates()[uniqueCoordinates.length] = uniqueCoordinates[0];
            if (CGAlgorithms.isCCW((Coordinate[])ring.getCoordinates()) == clockwise) {
                CoordinateArrays.reverse((Coordinate[])ring.getCoordinates());
            }
        }
    }

    public String toText() {
        WKTWriterJtsext writer = new WKTWriterJtsext();
        return writer.write((Geometry)this);
    }

    public void dumpPolygonAsJava(String poly) {
        EhiLogger.debug((String)"CompoundCurveRing shell=null;");
        this.dumpRingAsJava(this.shell, "shell");
        if (this.holes.length > 0) {
            EhiLogger.debug((String)("CompoundCurveRing holes[]=new CompoundCurveRing[" + this.holes.length + "];"));
            for (int i = 0; i < this.holes.length; ++i) {
                this.dumpRingAsJava(this.holes[i], "holes[i]");
            }
        }
        if (this.holes.length > 0) {
            EhiLogger.debug((String)(poly + "=new CurvePolygon(shell,holes);"));
        } else {
            EhiLogger.debug((String)(poly + "=new CurvePolygon(shell);"));
        }
    }

    public void dumpRingAsJava(LinearRing shell, String ring) {
        EhiLogger.debug((String)"ArrayList<CurveSegment> segs = new ArrayList<CurveSegment>();");
        if (shell instanceof CompoundCurveRing) {
            CompoundCurveRing ringo = (CompoundCurveRing)shell;
            for (CompoundCurve line : ringo.getLines()) {
                line.dumpLineAsJava("segs");
            }
        } else {
            throw new IllegalArgumentException("not yet implemented");
        }
        EhiLogger.debug((String)"CompoundCurve line=new CompoundCurve(segs);");
        EhiLogger.debug((String)(ring + "=new CompoundCurveRing(line);"));
    }

    public static boolean polygonOverlays(Polygon e0, Polygon e1) {
        return e0.equals((Geometry)e1) || e0.overlaps((Geometry)e1) || e0.within((Geometry)e1) || e1.within((Geometry)e0);
    }
}

