/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.ili2h2gis;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.ili2db.base.AbstractJdbcMapping;
import ch.ehi.ili2db.gui.Config;
import ch.ehi.ili2h2gis.GeneratorH2gis;
import ch.ehi.sqlgen.repository.DbTableName;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

public class H2gisMapping
extends AbstractJdbcMapping {
    private Boolean isNewFile = null;

    @Override
    public void preConnect(String url, String dbusr, String dbpwd, Config config) {
        String fileName = config.getDbfile();
        if (fileName != null) {
            this.isNewFile = new File(fileName).exists() ? Boolean.valueOf(false) : Boolean.valueOf(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void postConnect(Connection conn, Config config) {
        if (this.isNewFile != null && this.isNewFile.booleanValue()) {
            Statement dbstmt = null;
            try {
                try {
                    String line = "CREATE ALIAS IF NOT EXISTS H2GIS_SPATIAL FOR \"org.h2gis.functions.factory.H2GISFunctions.load\";";
                    dbstmt = conn.createStatement();
                    EhiLogger.traceBackendCmd((String)line);
                    dbstmt.execute(line);
                    line = "CREATE ALIAS IF NOT EXISTS H2GIS_UNLOAD FOR \"org.h2gis.functions.factory.H2GISFunctions.unRegisterH2GISFunctions\";";
                    dbstmt = conn.createStatement();
                    EhiLogger.traceBackendCmd((String)line);
                    dbstmt.execute(line);
                    line = "CALL H2GIS_SPATIAL();";
                    dbstmt = conn.createStatement();
                    EhiLogger.traceBackendCmd((String)line);
                    dbstmt.execute(line);
                }
                finally {
                    if (dbstmt != null) {
                        dbstmt.close();
                        dbstmt = null;
                    }
                }
            }
            catch (SQLException ex) {
                throw new IllegalStateException(ex);
            }
        }
    }

    @Override
    public void postPostScript(Connection conn, Config config) {
        Statement dbstmt = null;
        try {
            if (dbstmt != null) {
                dbstmt.close();
                dbstmt = null;
            }
        }
        catch (SQLException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public boolean tableExists(Connection conn, DbTableName tableName) {
        return GeneratorH2gis.tableExists(conn, tableName);
    }
}

