/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.io.geojson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import org.h2gis.functions.io.geojson.GeoJsonField;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class GJGeometryReader {
    private final GeometryFactory GF;

    public GJGeometryReader(GeometryFactory GF) {
        this.GF = GF;
    }

    public Geometry parseGeometry(JsonParser jsParser) throws IOException, SQLException {
        jsParser.nextToken();
        jsParser.nextToken();
        jsParser.nextToken();
        String geomType = jsParser.getText();
        if (geomType.equalsIgnoreCase(GeoJsonField.POINT)) {
            return this.parsePoint(jsParser);
        }
        if (geomType.equalsIgnoreCase(GeoJsonField.MULTIPOINT)) {
            return this.parseMultiPoint(jsParser);
        }
        if (geomType.equalsIgnoreCase(GeoJsonField.LINESTRING)) {
            return this.parseLinestring(jsParser);
        }
        if (geomType.equalsIgnoreCase(GeoJsonField.MULTILINESTRING)) {
            return this.parseMultiLinestring(jsParser);
        }
        if (geomType.equalsIgnoreCase(GeoJsonField.POLYGON)) {
            return this.parsePolygon(jsParser);
        }
        if (geomType.equalsIgnoreCase(GeoJsonField.MULTIPOLYGON)) {
            return this.parseMultiPolygon(jsParser);
        }
        if (geomType.equalsIgnoreCase(GeoJsonField.GEOMETRYCOLLECTION)) {
            return this.parseGeometryCollection(jsParser);
        }
        throw new SQLException("Unsupported geometry : " + geomType);
    }

    private Point parsePoint(JsonParser jp) throws IOException, SQLException {
        jp.nextToken();
        String coordinatesField = jp.getText();
        if (coordinatesField.equalsIgnoreCase(GeoJsonField.COORDINATES)) {
            jp.nextToken();
            Point point = this.GF.createPoint(this.parseCoordinate(jp));
            jp.nextToken();
            return point;
        }
        throw new SQLException("Malformed GeoJSON file. Expected 'coordinates', found '" + coordinatesField + "'");
    }

    private MultiPoint parseMultiPoint(JsonParser jp) throws IOException, SQLException {
        jp.nextToken();
        String coordinatesField = jp.getText();
        if (coordinatesField.equalsIgnoreCase(GeoJsonField.COORDINATES)) {
            jp.nextToken();
            MultiPoint mPoint = this.GF.createMultiPoint(this.parseCoordinates(jp));
            jp.nextToken();
            return mPoint;
        }
        throw new SQLException("Malformed GeoJSON file. Expected 'coordinates', found '" + coordinatesField + "'");
    }

    private LineString parseLinestring(JsonParser jp) throws IOException, SQLException {
        jp.nextToken();
        String coordinatesField = jp.getText();
        if (coordinatesField.equalsIgnoreCase(GeoJsonField.COORDINATES)) {
            jp.nextToken();
            LineString line = this.GF.createLineString(this.parseCoordinates(jp));
            jp.nextToken();
            return line;
        }
        throw new SQLException("Malformed GeoJSON file. Expected 'coordinates', found '" + coordinatesField + "'");
    }

    private MultiLineString parseMultiLinestring(JsonParser jp) throws IOException, SQLException {
        jp.nextToken();
        String coordinatesField = jp.getText();
        if (coordinatesField.equalsIgnoreCase(GeoJsonField.COORDINATES)) {
            ArrayList<LineString> lineStrings = new ArrayList<LineString>();
            jp.nextToken();
            jp.nextToken();
            while (jp.getCurrentToken() != JsonToken.END_ARRAY) {
                lineStrings.add(this.GF.createLineString(this.parseCoordinates(jp)));
                jp.nextToken();
            }
            MultiLineString line = this.GF.createMultiLineString(lineStrings.toArray(new LineString[0]));
            jp.nextToken();
            return line;
        }
        throw new SQLException("Malformed GeoJSON file. Expected 'coordinates', found '" + coordinatesField + "'");
    }

    private Polygon parsePolygon(JsonParser jp) throws IOException, SQLException {
        jp.nextToken();
        String coordinatesField = jp.getText();
        if (coordinatesField.equalsIgnoreCase(GeoJsonField.COORDINATES)) {
            jp.nextToken();
            jp.nextToken();
            int linesIndex = 0;
            LinearRing linearRing = null;
            ArrayList<LinearRing> holes = new ArrayList<LinearRing>();
            while (jp.getCurrentToken() != JsonToken.END_ARRAY) {
                if (linesIndex == 0) {
                    linearRing = this.GF.createLinearRing(this.parseCoordinates(jp));
                } else {
                    holes.add(this.GF.createLinearRing(this.parseCoordinates(jp)));
                }
                jp.nextToken();
                ++linesIndex;
            }
            if (linesIndex > 1) {
                jp.nextToken();
                return this.GF.createPolygon(linearRing, holes.toArray(new LinearRing[0]));
            }
            jp.nextToken();
            return this.GF.createPolygon(linearRing, null);
        }
        throw new SQLException("Malformed GeoJSON file. Expected 'coordinates', found '" + coordinatesField + "'");
    }

    private MultiPolygon parseMultiPolygon(JsonParser jp) throws IOException, SQLException {
        jp.nextToken();
        String coordinatesField = jp.getText();
        if (coordinatesField.equalsIgnoreCase(GeoJsonField.COORDINATES)) {
            ArrayList<Polygon> polygons = new ArrayList<Polygon>();
            jp.nextToken();
            jp.nextToken();
            while (jp.getCurrentToken() != JsonToken.END_ARRAY) {
                jp.nextToken();
                int linesIndex = 0;
                LinearRing linearRing = null;
                ArrayList<LinearRing> holes = new ArrayList<LinearRing>();
                while (jp.getCurrentToken() != JsonToken.END_ARRAY) {
                    if (linesIndex == 0) {
                        linearRing = this.GF.createLinearRing(this.parseCoordinates(jp));
                    } else {
                        holes.add(this.GF.createLinearRing(this.parseCoordinates(jp)));
                    }
                    jp.nextToken();
                    ++linesIndex;
                }
                if (linesIndex > 1) {
                    jp.nextToken();
                    polygons.add(this.GF.createPolygon(linearRing, holes.toArray(new LinearRing[0])));
                    continue;
                }
                jp.nextToken();
                polygons.add(this.GF.createPolygon(linearRing, null));
            }
            jp.nextToken();
            return this.GF.createMultiPolygon(polygons.toArray(new Polygon[0]));
        }
        throw new SQLException("Malformed GeoJSON file. Expected 'coordinates', found '" + coordinatesField + "'");
    }

    private GeometryCollection parseGeometryCollection(JsonParser jp) throws IOException, SQLException {
        jp.nextToken();
        String coordinatesField = jp.getText();
        if (coordinatesField.equalsIgnoreCase(GeoJsonField.GEOMETRIES)) {
            jp.nextToken();
            ArrayList<Geometry> geometries = new ArrayList<Geometry>();
            while (jp.getCurrentToken() != JsonToken.END_ARRAY) {
                geometries.add(this.parseGeometry(jp));
            }
            jp.nextToken();
            return this.GF.createGeometryCollection(geometries.toArray(new Geometry[0]));
        }
        throw new SQLException("Malformed GeoJSON file. Expected 'geometries', found '" + coordinatesField + "'");
    }

    private Coordinate[] parseCoordinates(JsonParser jp) throws IOException {
        jp.nextToken();
        ArrayList<Coordinate> coords = new ArrayList<Coordinate>();
        while (jp.getCurrentToken() != JsonToken.END_ARRAY) {
            coords.add(this.parseCoordinate(jp));
        }
        return coords.toArray(new Coordinate[0]);
    }

    private Coordinate parseCoordinate(JsonParser jp) throws IOException {
        Coordinate coord;
        jp.nextToken();
        double x = jp.getDoubleValue();
        jp.nextToken();
        double y = jp.getDoubleValue();
        jp.nextToken();
        if (jp.getCurrentToken() == JsonToken.END_ARRAY) {
            coord = new Coordinate(x, y);
        } else {
            double z = jp.getDoubleValue();
            jp.nextToken();
            coord = new Coordinate(x, y, z);
        }
        jp.nextToken();
        return coord;
    }
}

