/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.affine_transformations;

import org.h2gis.api.DeterministicScalarFunction;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.util.AffineTransformation;

public class ST_Rotate
extends DeterministicScalarFunction {
    public ST_Rotate() {
        this.addProperty("remarks", "Rotates a geometry by a given angle (inradians) about the geometry's center.");
    }

    public String getJavaStaticMethod() {
        return "rotate";
    }

    public static Geometry rotate(Geometry geom, double theta) {
        if (geom != null) {
            Coordinate center = geom.getEnvelopeInternal().centre();
            return ST_Rotate.rotate(geom, theta, center.x, center.y);
        }
        return null;
    }

    public static Geometry rotate(Geometry geom, double theta, Point point) {
        return ST_Rotate.rotate(geom, theta, point.getX(), point.getY());
    }

    public static Geometry rotate(Geometry geom, double theta, double x0, double y0) {
        if (geom != null) {
            return AffineTransformation.rotationInstance((double)theta, (double)x0, (double)y0).transform(geom);
        }
        return null;
    }
}

