/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.ili2db.fromxtf;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.ili2db.base.Ili2dbException;
import ch.ehi.ili2db.mapping.NameMapping;
import ch.ehi.sqlgen.repository.DbTableName;
import ch.interlis.ili2c.metamodel.AbstractEnumerationType;
import ch.interlis.ili2c.metamodel.AttributeDef;
import ch.interlis.ili2c.metamodel.Domain;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.EnumTreeValueType;
import ch.interlis.ili2c.metamodel.Enumeration;
import ch.interlis.ili2c.metamodel.Model;
import ch.interlis.iom_j.itf.ModelUtilities;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class EnumValueMap {
    private HashMap<Long, String> id2xtf = new HashMap();
    private HashMap<String, Long> xtf2id = new HashMap();
    private HashMap<String, Integer> xtf2itfCode = new HashMap();
    private HashMap<String, Integer> xtf2seq = new HashMap();
    private HashMap<String, String> xtf2displayName = new HashMap();
    private HashMap<String, String> xtf2doc = new HashMap();

    private EnumValueMap() {
    }

    public long mapXtfValue(String xtfvalue) {
        return this.xtf2id.get(xtfvalue);
    }

    public String mapIdValue(long value) {
        return this.id2xtf.get(value);
    }

    public String mapXtfValueToDisplayName(String xtfvalue) {
        return this.xtf2displayName.get(xtfvalue);
    }

    public int mapXtfValueToItfCode(String xtfvalue) {
        return this.xtf2itfCode.get(xtfvalue);
    }

    public int mapXtfValueToSeq(String xtfvalue) {
        return this.xtf2seq.get(xtfvalue);
    }

    public String mapXtfValueToDoc(String xtfvalue) {
        return this.xtf2doc.get(xtfvalue);
    }

    public Set<String> getXtfCodes() {
        HashSet<String> ret = new HashSet<String>();
        ret.addAll(this.xtf2id.keySet());
        return ret;
    }

    public static Set<String> readIliCodesFromDb(Connection conn, String tidColumnName, boolean hasThisClassColumn, String qualifiedIliName, DbTableName sqlDbName) throws Ili2dbException {
        try {
            EnumValueMap map = EnumValueMap.readEnumValueMapFromDb(conn, tidColumnName, hasThisClassColumn, qualifiedIliName, sqlDbName);
            return map.getXtfCodes();
        }
        catch (SQLException ex) {
            throw new Ili2dbException("failed to read enum-table " + sqlDbName, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EnumValueMap readEnumValueMapFromDb(Connection conn, String tidColumnName, boolean hasThisClassColumn, String qualifiedIliName, DbTableName sqlDbName) throws SQLException {
        EnumValueMap ret = new EnumValueMap();
        String sqlName = sqlDbName.getName();
        if (sqlDbName.getSchema() != null) {
            sqlName = sqlDbName.getSchema() + "." + sqlName;
        }
        String exstStmt = null;
        exstStmt = !hasThisClassColumn ? "SELECT iliCode" + (tidColumnName != null ? "," + tidColumnName : "") + "," + "dispName" + "," + "description" + "," + "itfCode" + " FROM " + sqlName : "SELECT iliCode" + (tidColumnName != null ? "," + tidColumnName : "") + "," + "dispName" + "," + "description" + "," + "itfCode" + " FROM " + sqlName + " WHERE " + "thisClass" + " = '" + qualifiedIliName + "'";
        EhiLogger.traceBackendCmd((String)exstStmt);
        PreparedStatement exstPrepStmt = null;
        ResultSet rs = null;
        try {
            exstPrepStmt = conn.prepareStatement(exstStmt);
            rs = exstPrepStmt.executeQuery();
            Long id = 0L;
            int seq = 0;
            while (rs.next()) {
                int col = 1;
                String iliCode = rs.getString(col++);
                if (tidColumnName != null) {
                    id = rs.getLong(col++);
                } else {
                    Long l = id;
                    Long l2 = id = Long.valueOf(id + 1L);
                }
                String displayName = rs.getString(col++);
                String desc = rs.getString(col++);
                int itfCode = rs.getInt(col++);
                ret.addValue(id, iliCode, itfCode, displayName, desc, seq++);
            }
        }
        finally {
            if (rs != null) {
                rs.close();
                rs = null;
            }
            if (exstPrepStmt != null) {
                exstPrepStmt.close();
                exstPrepStmt = null;
            }
        }
        return ret;
    }

    void addValue(long id, String xtfCode, int itfCode, String displayName, String doc, int seq) {
        this.id2xtf.put(id, xtfCode);
        this.xtf2id.put(xtfCode, id);
        this.xtf2displayName.put(xtfCode, displayName);
        this.xtf2itfCode.put(xtfCode, itfCode);
        this.xtf2seq.put(xtfCode, seq);
        this.xtf2doc.put(xtfCode, doc);
    }

    public static EnumValueMap createEnumValueMap(Element attrOrDomain, NameMapping ili2sqlName) {
        Element attrOrDomain_tr = ili2sqlName.getTranslatedElement(attrOrDomain);
        String lang_tr = ((Model)attrOrDomain_tr.getContainer(Model.class)).getLanguage();
        AbstractEnumerationType type = null;
        AbstractEnumerationType type_tr = null;
        if (attrOrDomain instanceof AttributeDef) {
            type = (AbstractEnumerationType)((AttributeDef)attrOrDomain).getDomainResolvingAll();
            type_tr = (AbstractEnumerationType)((AttributeDef)attrOrDomain_tr).getDomainResolvingAll();
        } else if (attrOrDomain instanceof Domain) {
            type = (AbstractEnumerationType)((Domain)attrOrDomain).getType();
            type_tr = (AbstractEnumerationType)((Domain)attrOrDomain_tr).getType();
        } else {
            throw new IllegalArgumentException("unexpected element " + attrOrDomain);
        }
        EnumValueMap ret = new EnumValueMap();
        ArrayList ev = new ArrayList();
        ArrayList ev_tr = new ArrayList();
        if (type instanceof EnumTreeValueType) {
            ModelUtilities.buildEnumElementListAll(ev, (String)"", (Enumeration)type.getConsolidatedEnumeration());
            ModelUtilities.buildEnumElementListAll(ev_tr, (String)"", (Enumeration)type_tr.getConsolidatedEnumeration());
        } else {
            ModelUtilities.buildEnumElementList(ev, (String)"", (Enumeration)type.getConsolidatedEnumeration());
            ModelUtilities.buildEnumElementList(ev_tr, (String)"", (Enumeration)type_tr.getConsolidatedEnumeration());
        }
        boolean isOrdered = type.isOrdered();
        int itfCode = 0;
        int seq = 0;
        Iterator evi = ev.iterator();
        Iterator evi_tr = ev_tr.iterator();
        while (evi.hasNext()) {
            String doc;
            Map.Entry ele = (Map.Entry)evi.next();
            Map.Entry ele_tr = (Map.Entry)evi_tr.next();
            String eleName = (String)ele.getKey();
            String eleName_tr = (String)ele_tr.getKey();
            Enumeration.Element eleElement = (Enumeration.Element)ele.getValue();
            Enumeration.Element eleElement_tr = (Enumeration.Element)ele_tr.getValue();
            String dispName = null;
            if (lang_tr != null) {
                dispName = eleElement_tr.getMetaValues().getValue("ili2db.dispName_" + lang_tr);
            }
            if (dispName == null) {
                dispName = eleElement_tr.getMetaValues().getValue("ili2db.dispName");
            }
            if (dispName == null) {
                dispName = eleElement.getMetaValues().getValue("ili2db.dispName");
            }
            if (dispName == null) {
                dispName = ili2sqlName.beautifyEnumDispName(eleName_tr);
            }
            if ((doc = eleElement_tr.getDocumentation()) == null) {
                doc = eleElement.getDocumentation();
            }
            ret.addValue(seq, eleName, itfCode, dispName, doc, seq);
            ++itfCode;
            ++seq;
        }
        return ret;
    }
}

