/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.system;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.h2gis.api.DeterministicScalarFunction;
import org.h2gis.functions.factory.H2GISFunctions;

public class H2GISversion
extends DeterministicScalarFunction {
    public H2GISversion() {
        this.addProperty("remarks", "Returns H2GISGIS version number");
    }

    public String getJavaStaticMethod() {
        return "geth2gisVersion";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String geth2gisVersion() {
        try (InputStream fs = H2GISFunctions.class.getResourceAsStream("/org/h2gis/functions/system/version.txt");){
            BufferedReader bufRead = new BufferedReader(new InputStreamReader(fs));
            StringBuilder builder = new StringBuilder();
            String line = null;
            while ((line = bufRead.readLine()) != null) {
                builder.append(line).append(" ");
            }
            String string = builder.toString();
            return string;
        }
        catch (IOException ex) {
            return "unknown";
        }
    }
}

