/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.ili2db.fromxtf;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.basics.types.OutParam;
import ch.ehi.ili2db.base.DbIdGen;
import ch.ehi.ili2db.base.DbNames;
import ch.ehi.ili2db.base.Ili2cUtility;
import ch.ehi.ili2db.converter.AbstractRecordConverter;
import ch.ehi.ili2db.converter.ConverterException;
import ch.ehi.ili2db.converter.SqlColumnConverter;
import ch.ehi.ili2db.fromili.TransferFromIli;
import ch.ehi.ili2db.fromxtf.AbstractStructWrapper;
import ch.ehi.ili2db.fromxtf.EmbeddedLinkWrapper;
import ch.ehi.ili2db.fromxtf.EnumValueMap;
import ch.ehi.ili2db.fromxtf.StructWrapper;
import ch.ehi.ili2db.fromxtf.XtfidPool;
import ch.ehi.ili2db.gui.Config;
import ch.ehi.ili2db.mapping.ArrayMapping;
import ch.ehi.ili2db.mapping.ColumnWrapper;
import ch.ehi.ili2db.mapping.MultiLineMapping;
import ch.ehi.ili2db.mapping.MultiPointMapping;
import ch.ehi.ili2db.mapping.MultiSurfaceMapping;
import ch.ehi.ili2db.mapping.NameMapping;
import ch.ehi.ili2db.mapping.StructAttrPath;
import ch.ehi.ili2db.mapping.TrafoConfig;
import ch.ehi.ili2db.mapping.Viewable2TableMapping;
import ch.ehi.ili2db.mapping.ViewableWrapper;
import ch.ehi.sqlgen.repository.DbColId;
import ch.ehi.sqlgen.repository.DbColNumber;
import ch.ehi.sqlgen.repository.DbColVarchar;
import ch.ehi.sqlgen.repository.DbTableName;
import ch.interlis.ili2c.metamodel.AbstractClassDef;
import ch.interlis.ili2c.metamodel.AbstractEnumerationType;
import ch.interlis.ili2c.metamodel.AbstractSurfaceOrAreaType;
import ch.interlis.ili2c.metamodel.AreaType;
import ch.interlis.ili2c.metamodel.AssociationDef;
import ch.interlis.ili2c.metamodel.AttributeDef;
import ch.interlis.ili2c.metamodel.BlackboxType;
import ch.interlis.ili2c.metamodel.CompositionType;
import ch.interlis.ili2c.metamodel.CoordType;
import ch.interlis.ili2c.metamodel.Domain;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.EnumerationType;
import ch.interlis.ili2c.metamodel.LineType;
import ch.interlis.ili2c.metamodel.Model;
import ch.interlis.ili2c.metamodel.MultiCoordType;
import ch.interlis.ili2c.metamodel.MultiPolylineType;
import ch.interlis.ili2c.metamodel.MultiSurfaceOrAreaType;
import ch.interlis.ili2c.metamodel.NumericType;
import ch.interlis.ili2c.metamodel.NumericalType;
import ch.interlis.ili2c.metamodel.PolylineType;
import ch.interlis.ili2c.metamodel.PrecisionDecimal;
import ch.interlis.ili2c.metamodel.ReferenceType;
import ch.interlis.ili2c.metamodel.RoleDef;
import ch.interlis.ili2c.metamodel.SurfaceOrAreaType;
import ch.interlis.ili2c.metamodel.SurfaceType;
import ch.interlis.ili2c.metamodel.Table;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.ili2c.metamodel.Type;
import ch.interlis.ili2c.metamodel.TypeAlias;
import ch.interlis.ili2c.metamodel.Viewable;
import ch.interlis.ili2c.metamodel.ViewableTransferElement;
import ch.interlis.iom.IomObject;
import ch.interlis.iom_j.Iom_jObject;
import ch.interlis.iox_j.validator.Validator;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

public class FromXtfRecordConverter
extends AbstractRecordConverter {
    private SqlColumnConverter geomConv = null;
    private Timestamp today = null;
    private int defaultSrsid = 0;
    private Connection conn = null;
    private String dbusr = null;
    private String datasetName = null;
    private boolean isItfReader;
    private XtfidPool oidPool = null;
    private HashMap tag2class = null;
    private Integer defaultEpsgCode = null;
    private Map<AttributeDef, EnumValueMap> enumCache = new HashMap<AttributeDef, EnumValueMap>();
    private String dbSchema;
    private boolean importTid = false;
    private final int LEN_LANG_PREFIX = "_".length();
    private HashMap<AttributeDef, Integer> srsCache = new HashMap();
    private HashMap<LineType, Double> typeCache = new HashMap();

    public FromXtfRecordConverter(TransferDescription td1, NameMapping ili2sqlName, HashMap tag2class1, Config config, DbIdGen idGen1, SqlColumnConverter geomConv1, Connection conn1, String dbusr1, boolean isItfReader1, XtfidPool oidPool1, TrafoConfig trafoConfig, Viewable2TableMapping class2wrapper1, String datasetName, String dbSchema) {
        super(td1, ili2sqlName, config, idGen1, trafoConfig, class2wrapper1);
        this.conn = conn1;
        this.tag2class = tag2class1;
        this.dbusr = dbusr1;
        this.oidPool = oidPool1;
        this.geomConv = geomConv1;
        this.isItfReader = isItfReader1;
        this.datasetName = datasetName;
        this.dbSchema = dbSchema;
        this.today = new Timestamp(System.currentTimeMillis());
        this.importTid = config.isImportTid();
        this.defaultSrsid = -1;
        if (this.defaultCrsAuthority != null && this.defaultCrsCode != null) {
            try {
                Integer srsid = this.geomConv.getSrsid(this.defaultCrsAuthority, this.defaultCrsCode, this.conn);
                if (srsid != null) {
                    this.defaultSrsid = srsid;
                }
            }
            catch (UnsupportedOperationException ex) {
                EhiLogger.logAdaption((String)"no CRS support by converter; use -1 as default srsid");
                this.defaultSrsid = -1;
            }
            catch (ConverterException ex) {
                throw new IllegalArgumentException("failed to get srsid for " + this.defaultCrsAuthority + ":" + this.defaultCrsCode + ", " + ex.getLocalizedMessage());
            }
            this.defaultEpsgCode = TransferFromIli.parseEpsgCode(this.defaultCrsAuthority + ":" + this.defaultCrsCode);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void writeRecord(long basketSqlId, Map<String, String> genericDomains, IomObject iomMainObj, Viewable iomClass, AbstractStructWrapper structEle0, ViewableWrapper tableWrapper, String sqlType, long sqlId, boolean updateObj, PreparedStatement ps, ArrayList<AbstractStructWrapper> structQueue, Viewable originalClass, int iomValueIndex, long parentSqlId) throws SQLException, ConverterException {
        int valuei = 1;
        if (!updateObj) {
            ps.setLong(valuei, sqlId);
            ++valuei;
        }
        if (this.createBasketCol) {
            ps.setLong(valuei, basketSqlId);
            ++valuei;
        }
        if (this.createDatasetCol) {
            ps.setString(valuei, this.datasetName);
            ++valuei;
        }
        if (tableWrapper.isSecondaryTable()) {
            AttributeDef attr = tableWrapper.getPrimitiveCollectionAttr();
            if (attr != null) {
                ps.setInt(valuei, iomValueIndex);
                ps.setLong(++valuei, parentSqlId);
                ++valuei;
            }
        } else if (tableWrapper.getExtending() == null) {
            if (this.createTypeDiscriminator || tableWrapper.includesMultipleTypes()) {
                ps.setString(valuei, sqlType);
                ++valuei;
            }
            if (structEle0 == null && !updateObj && (this.importTid && !(tableWrapper.getViewable() instanceof AssociationDef) || tableWrapper.hasOid())) {
                String oid = iomMainObj.getobjectoid();
                if (FromXtfRecordConverter.isUuidOid(this.td, tableWrapper.getOid())) {
                    oid = Validator.normalizeUUID((String)oid);
                    Object toInsertUUID = this.geomConv.fromIomUuid(oid);
                    ps.setObject(valuei, toInsertUUID);
                } else {
                    ps.setString(valuei, oid);
                }
                ++valuei;
            }
            if (structEle0 != null && structEle0 instanceof StructWrapper) {
                StructWrapper structEle = (StructWrapper)structEle0;
                ps.setLong(valuei, structEle.getParentSqlId());
                ps.setInt(++valuei, structEle.getStructi());
                ++valuei;
            }
        }
        Map<? extends Element, ? extends Element> attrs = this.getIomObjectAttrs(iomClass);
        Iterator<ColumnWrapper> iter = tableWrapper.getAttrIterator();
        while (iter.hasNext()) {
            ViewableTransferElement obj;
            ColumnWrapper columnWrapper = iter.next();
            if (columnWrapper.isTypeCol()) {
                IomObject iomObj = this.findStructEle(iomMainObj, columnWrapper.getStructAttrPath());
                String sqlStructType = null;
                if (iomObj != null) {
                    sqlStructType = this.getSqlType((Viewable)this.tag2class.get(iomObj.getobjecttag())).getName();
                }
                ps.setString(valuei, sqlStructType);
                ++valuei;
                continue;
            }
            if (columnWrapper.isIliAttr()) {
                obj = columnWrapper.getViewableTransferElement();
                AttributeDef attr = (AttributeDef)obj.obj;
                AttributeDef rootAttr = Ili2cUtility.getRootBaseAttr(attr);
                IomObject iomObj = iomMainObj;
                StructAttrPath structAttrPath = columnWrapper.getStructAttrPath();
                StructAttrPath.PathEl[] pathv = structAttrPath.getPath();
                Viewable structClass = null;
                Map<? extends Element, ? extends Element> structAttrs = null;
                AttributeDef attrInObj = null;
                if (pathv.length == 1) {
                    iomObj = iomMainObj;
                    structClass = originalClass;
                    structAttrs = attrs;
                    attrInObj = (AttributeDef)structAttrs.get(rootAttr);
                } else {
                    iomObj = this.findStructEle(iomMainObj, structAttrPath);
                    if (iomObj != null) {
                        structClass = (Viewable)this.tag2class.get(iomObj.getobjecttag());
                        structAttrs = this.getIomObjectAttrs(structClass);
                        attrInObj = (AttributeDef)structAttrs.get(rootAttr);
                    }
                }
                Integer attrIdx = pathv[pathv.length - 1].getIdx();
                if (attrIdx == null) {
                    attrIdx = iomValueIndex;
                }
                if (this.mapAsTextCol(attrInObj)) {
                    valuei = this.addAttrValueTXT(iomObj, sqlType, sqlId, tableWrapper.getSqlTablename(), ps, valuei, columnWrapper, attrInObj, structQueue, genericDomains, structClass, attrIdx);
                    continue;
                }
                valuei = this.addAttrValue(iomObj, sqlType, sqlId, tableWrapper.getSqlTablename(), ps, valuei, columnWrapper, attrInObj, structQueue, genericDomains, structClass, attrIdx);
                continue;
            }
            if (!columnWrapper.isIliRole()) continue;
            obj = columnWrapper.getViewableTransferElement();
            RoleDef role = (RoleDef)obj.obj;
            RoleDef rootRole = Ili2cUtility.getRootBaseRole(role);
            if (!attrs.containsKey(rootRole)) continue;
            String refoid = null;
            String roleName = role.getName();
            if (obj.embedded) {
                AssociationDef roleOwner = (AssociationDef)role.getContainer();
                if (roleOwner.getDerivedFrom() == null) {
                    IomObject structvalue = iomMainObj.getattrobj(roleName, 0);
                    if (roleOwner.getAttributes().hasNext() || roleOwner.getLightweightAssociations().iterator().hasNext()) {
                        // empty if block
                    }
                    if (structvalue != null) {
                        refoid = structvalue.getobjectrefoid();
                        long orderPos = structvalue.getobjectreforderpos();
                        if (orderPos == 0L) {
                            // empty if block
                        }
                    } else {
                        refoid = null;
                    }
                }
            } else if (structEle0 != null) {
                EmbeddedLinkWrapper structEle = (EmbeddedLinkWrapper)structEle0;
                refoid = role == structEle.getTargetRole() ? structEle.getStruct().getobjectrefoid() : structEle.getParentXtfId();
            } else {
                IomObject structvalue = iomMainObj.getattrobj(roleName, 0);
                refoid = structvalue.getobjectrefoid();
                long orderPos = structvalue.getobjectreforderpos();
                if (orderPos != 0L) {
                    // empty if block
                }
            }
            OutParam valueiRef = new OutParam((Object)valuei);
            this.setReferenceColumn(ps, role.getDestination(), refoid, (OutParam<Integer>)valueiRef, this.createExtRef && role.isExternal());
            valuei = (Integer)valueiRef.value;
        }
        if (this.createStdCols) {
            ps.setTimestamp(valuei, this.today);
            ++valuei;
            if (!updateObj) {
                ps.setTimestamp(valuei, this.today);
                ++valuei;
            }
            ps.setString(valuei, this.dbusr);
            ++valuei;
        }
        if (updateObj) {
            ps.setLong(valuei, sqlId);
            ++valuei;
        }
    }

    private IomObject findStructEle(IomObject iomObj, StructAttrPath structAttrPath) {
        StructAttrPath.PathEl[] pathv = structAttrPath.getPath();
        if (pathv.length < 2) {
            return null;
        }
        for (int pathi = 0; pathi < pathv.length - 1; ++pathi) {
            StructAttrPath.PathEl path = pathv[pathi];
            Integer attrIdx = path.getIdx();
            if (attrIdx == null) {
                attrIdx = 0;
            }
            if ((iomObj = iomObj.getattrobj(path.getName(), attrIdx.intValue())) != null) continue;
            return null;
        }
        return iomObj;
    }

    private void setReferenceColumn(PreparedStatement ps, AbstractClassDef destination, String refoid, OutParam<Integer> valuei, boolean isExtRef) throws SQLException {
        if (isExtRef) {
            if (refoid != null) {
                ps.setString((Integer)valuei.value, refoid);
            } else {
                ps.setNull((Integer)valuei.value, 12);
            }
            OutParam<Integer> outParam = valuei;
            Integer n = (Integer)outParam.value;
            outParam.value = (Integer)outParam.value + 1;
            Integer n2 = outParam.value;
        } else {
            if (FromXtfRecordConverter.isUuidOid(this.td, destination.getOid())) {
                refoid = Validator.normalizeUUID((String)refoid);
            }
            String targetRootClassName = Ili2cUtility.getRootViewable((Viewable)destination).getScopedName(null);
            ViewableWrapper targetObjTable = null;
            ArrayList<ViewableWrapper> targetTables = this.getTargetTables((Viewable)destination);
            if (refoid != null) {
                String targetObjClass = this.oidPool.getObjecttag(targetRootClassName, refoid);
                if (targetObjClass == null) {
                    refoid = null;
                } else {
                    targetObjTable = this.getViewableWrapper(this.getSqlType((Viewable)this.tag2class.get(targetObjClass)).getName());
                    while (!targetTables.contains(targetObjTable)) {
                        targetObjTable = targetObjTable.getExtending();
                    }
                    if (targetObjTable == null) {
                        throw new IllegalStateException("targetObjTable==null");
                    }
                }
            }
            for (ViewableWrapper targetTable : targetTables) {
                if (refoid != null && targetTable == targetObjTable) {
                    long refsqlId = this.oidPool.getObjSqlId(targetRootClassName, refoid);
                    ps.setLong((Integer)valuei.value, refsqlId);
                } else {
                    ps.setNull((Integer)valuei.value, -5);
                }
                OutParam<Integer> outParam = valuei;
                Integer n = (Integer)outParam.value;
                outParam.value = (Integer)outParam.value + 1;
                Integer n3 = outParam.value;
            }
        }
    }

    public String createInsertStmt(boolean isUpdate, Viewable iomClass, DbTableName sqlTableName, ViewableWrapper tableWrapper, AbstractStructWrapper structEle0) {
        StringBuffer ret = new StringBuffer();
        StringBuffer values = new StringBuffer();
        if (isUpdate) {
            ret.append("UPDATE ");
        } else {
            ret.append("INSERT INTO ");
        }
        ret.append(sqlTableName.getQName());
        String sep = null;
        sep = isUpdate ? " SET " : " (";
        if (!isUpdate) {
            ret.append(sep);
            ret.append(this.colT_ID);
            values.append("?");
            sep = ",";
        }
        if (this.createBasketCol) {
            ret.append(sep);
            ret.append("T_basket");
            if (isUpdate) {
                ret.append("=?");
            } else {
                values.append(",?");
            }
            sep = ",";
        }
        if (this.createDatasetCol) {
            ret.append(sep);
            ret.append("T_datasetname");
            if (isUpdate) {
                ret.append("=?");
            } else {
                values.append(",?");
            }
            sep = ",";
        }
        if (tableWrapper.isSecondaryTable()) {
            AttributeDef attr = tableWrapper.getPrimitiveCollectionAttr();
            if (attr != null) {
                ret.append(sep);
                ret.append("T_Seq");
                if (isUpdate) {
                    ret.append("=?");
                } else {
                    values.append(",?");
                }
                sep = ",";
                ret.append(sep);
                ViewableWrapper parentTable = tableWrapper.getMainTable();
                ret.append(this.ili2sqlName.mapIliAttributeDefReverse(attr, tableWrapper.getSqlTablename(), parentTable.getSqlTablename()));
                if (isUpdate) {
                    ret.append("=?");
                } else {
                    values.append(",?");
                }
                sep = ",";
            }
        } else if (tableWrapper.getExtending() == null) {
            if (this.createTypeDiscriminator || tableWrapper.includesMultipleTypes()) {
                ret.append(sep);
                ret.append("T_Type");
                if (isUpdate) {
                    ret.append("=?");
                } else {
                    values.append(",?");
                }
                sep = ",";
            }
            if (structEle0 == null && !isUpdate && (this.importTid && !(tableWrapper.getViewable() instanceof AssociationDef) || tableWrapper.hasOid())) {
                ret.append(sep);
                ret.append("T_Ili_Tid");
                values.append(",?");
                sep = ",";
            }
            if (tableWrapper.isStructure() && structEle0 != null) {
                ret.append(sep);
                StructWrapper structEle = (StructWrapper)structEle0;
                Viewable parentViewable = this.getViewable(structEle.getParentSqlType());
                ViewableWrapper parentTable = this.getViewableWrapperOfAbstractClass((Viewable)structEle.getParentAttr().getContainer(), parentViewable);
                ret.append(this.ili2sqlName.mapIliAttributeDefReverse(structEle.getParentAttr(), sqlTableName.getName(), parentTable.getSqlTablename()));
                if (isUpdate) {
                    ret.append("=?");
                } else {
                    values.append(",?");
                }
                sep = ",";
                ret.append(sep);
                ret.append("T_Seq");
                if (isUpdate) {
                    ret.append("=?");
                } else {
                    values.append(",?");
                }
                sep = ",";
            }
        }
        Map<? extends Element, ? extends Element> attrs = this.getIomObjectAttrs(iomClass);
        Iterator<ColumnWrapper> iter = tableWrapper.getAttrIterator();
        while (iter.hasNext()) {
            boolean isExtRef;
            ColumnWrapper columnWrapper = iter.next();
            if (columnWrapper.isTypeCol()) {
                ret.append(sep);
                String sqlColName = this.ili2sqlName.mapIliAttributeDef(columnWrapper.getStructAttrPath(), null, sqlTableName.getName(), null);
                ret.append(sqlColName);
                if (isUpdate) {
                    ret.append("=?");
                } else {
                    values.append(",?");
                }
                sep = ",";
                continue;
            }
            if (columnWrapper.isIliAttr()) {
                sep = this.addAttrToInsertStmt(isUpdate, ret, values, sep, columnWrapper, sqlTableName.getName());
                continue;
            }
            if (!columnWrapper.isIliRole()) continue;
            ViewableTransferElement obj = columnWrapper.getViewableTransferElement();
            RoleDef role = (RoleDef)obj.obj;
            RoleDef rootRole = Ili2cUtility.getRootBaseRole(role);
            if (!attrs.containsKey(rootRole)) continue;
            boolean bl = isExtRef = this.createExtRef && role.isExternal();
            if (isExtRef) {
                String roleName = this.ili2sqlName.mapIliRoleDef(role, sqlTableName.getName(), this.getSqlType((Viewable)role.getDestination()).getName(), false);
                if (obj.embedded) {
                    AssociationDef roleOwner = (AssociationDef)role.getContainer();
                    if (roleOwner.getDerivedFrom() != null) continue;
                    ret.append(sep);
                    ret.append(roleName);
                    if (isUpdate) {
                        ret.append("=?");
                    } else {
                        values.append(",?");
                    }
                    sep = ",";
                    continue;
                }
                ret.append(sep);
                ret.append(roleName);
                if (isUpdate) {
                    ret.append("=?");
                } else {
                    values.append(",?");
                }
                sep = ",";
                continue;
            }
            ArrayList<ViewableWrapper> targetTables = this.getTargetTables((Viewable)role.getDestination());
            for (ViewableWrapper targetTable : targetTables) {
                String roleName = this.ili2sqlName.mapIliRoleDef(role, sqlTableName.getName(), targetTable.getSqlTablename(), targetTables.size() > 1);
                if (obj.embedded) {
                    AssociationDef roleOwner = (AssociationDef)role.getContainer();
                    if (roleOwner.getDerivedFrom() != null) continue;
                    ret.append(sep);
                    ret.append(roleName);
                    if (isUpdate) {
                        ret.append("=?");
                    } else {
                        values.append(",?");
                    }
                    sep = ",";
                    continue;
                }
                ret.append(sep);
                ret.append(roleName);
                if (isUpdate) {
                    ret.append("=?");
                } else {
                    values.append(",?");
                }
                sep = ",";
            }
        }
        if (this.createStdCols) {
            ret.append(sep);
            ret.append("T_LastChange");
            if (isUpdate) {
                ret.append("=?");
            } else {
                values.append(",?");
            }
            sep = ",";
            if (!isUpdate) {
                ret.append(sep);
                ret.append("T_CreateDate");
                values.append(",?");
                sep = ",";
            }
            ret.append(sep);
            ret.append("T_User");
            if (isUpdate) {
                ret.append("=?");
            } else {
                values.append(",?");
            }
            sep = ",";
        }
        if (isUpdate) {
            ret.append(" WHERE ");
            ret.append(this.colT_ID);
            ret.append("=?");
        } else {
            ret.append(") VALUES (");
            ret.append(values);
            ret.append(")");
        }
        return ret.toString();
    }

    private ViewableWrapper getViewableWrapperOfAbstractClass(Viewable abstractClass, Viewable concreteClass) {
        if (abstractClass == concreteClass) {
            return this.class2wrapper.get(concreteClass);
        }
        ArrayList<ViewableWrapper> rets = new ArrayList<ViewableWrapper>();
        rets.add(this.class2wrapper.get(concreteClass));
        for (Viewable superClass = (Viewable)concreteClass.getExtending(); superClass != null; superClass = (Viewable)superClass.getExtending()) {
            ViewableWrapper ret2 = this.class2wrapper.get(superClass);
            if (ret2 != null && !rets.contains(ret2)) {
                rets.add(0, ret2);
            }
            if (superClass == abstractClass) break;
        }
        for (int i = 0; i < rets.size(); ++i) {
            ViewableWrapper ret = (ViewableWrapper)rets.get(i);
            if (i == rets.size() - 1) {
                return ret;
            }
            if ("newAndSubClass".equals(this.trafoConfig.getViewableConfig(ret.getViewable(), "ch.ehi.ili2db.inheritance"))) continue;
            return ret;
        }
        return null;
    }

    public ViewableWrapper getViewableWrapper(String sqlType) {
        Viewable aclass = this.getViewable(sqlType);
        return this.class2wrapper.get(aclass);
    }

    private Viewable getViewable(String sqlType) {
        String iliQname = this.ili2sqlName.mapSqlTableName(sqlType);
        Viewable aclass = (Viewable)this.tag2class.get(iliQname);
        return aclass;
    }

    public String addAttrToInsertStmt(boolean isUpdate, StringBuffer sqlStmtCols, StringBuffer sqlStmtVals, String sep, ColumnWrapper colWrapper, String sqlTableName) {
        Integer epsgCode = colWrapper.getEpsgCode();
        AttributeDef attrDefOfColumn = (AttributeDef)colWrapper.getViewableTransferElement().obj;
        Type type = attrDefOfColumn.getDomainResolvingAliases();
        if ("coalesce".equals(this.trafoConfig.getAttrConfig(attrDefOfColumn, "ch.ehi.ili2db.jsonTrafo"))) {
            String attrSqlName = this.ili2sqlName.mapIliAttributeDef(colWrapper.getStructAttrPath(), epsgCode, sqlTableName, null);
            sqlStmtCols.append(sep);
            sqlStmtCols.append(attrSqlName);
            if (isUpdate) {
                sqlStmtCols.append("=" + this.geomConv.getInsertValueWrapperJson("?"));
            } else {
                sqlStmtVals.append("," + this.geomConv.getInsertValueWrapperJson("?"));
            }
            sep = ",";
        } else if ("coalesce".equals(this.trafoConfig.getAttrConfig(attrDefOfColumn, "ch.ehi.ili2db.arrayTrafo"))) {
            this.arrayAttrs.addArrayAttr(attrDefOfColumn);
            ArrayMapping attrMapping = this.arrayAttrs.getMapping(attrDefOfColumn);
            AttributeDef localAttr = attrMapping.getValueAttr();
            Type localType = localAttr.getDomainResolvingAll();
            if (Ili2cUtility.isIomObjectPrimType(this.td, localAttr)) {
                String attrSqlName = this.ili2sqlName.mapIliAttributeDef(colWrapper.getStructAttrPath(), epsgCode, sqlTableName, null);
                sqlStmtCols.append(sep);
                sqlStmtCols.append(attrSqlName);
                if (isUpdate) {
                    sqlStmtCols.append("=" + this.geomConv.getInsertValueWrapperArray("?"));
                } else {
                    sqlStmtVals.append("," + this.geomConv.getInsertValueWrapperArray("?"));
                }
                sep = ",";
            } else if (Ili2cUtility.isReferenceType(this.td, localAttr)) {
                String attrSqlName = this.ili2sqlName.mapIliAttributeDef(colWrapper.getStructAttrPath(), sqlTableName, this.getSqlType((Viewable)((ReferenceType)localType).getReferred()).getName(), false);
                sqlStmtCols.append(sep);
                sqlStmtCols.append(attrSqlName);
                if (isUpdate) {
                    sqlStmtCols.append("=" + this.geomConv.getInsertValueWrapperArray("?"));
                } else {
                    sqlStmtVals.append("," + this.geomConv.getInsertValueWrapperArray("?"));
                }
                sep = ",";
            }
        } else if (attrDefOfColumn.isDomainBoolean()) {
            String attrSqlName = this.ili2sqlName.mapIliAttributeDef(colWrapper.getStructAttrPath(), epsgCode, sqlTableName, null);
            sqlStmtCols.append(sep);
            sqlStmtCols.append(attrSqlName);
            if (isUpdate) {
                sqlStmtCols.append("=?");
            } else {
                sqlStmtVals.append(",?");
            }
            sep = ",";
            if (this.createEnumTxtCol) {
                sqlStmtCols.append(sep);
                sqlStmtCols.append(attrSqlName + "_txt");
                if (isUpdate) {
                    sqlStmtCols.append("=?");
                } else {
                    sqlStmtVals.append(",?");
                }
                sep = ",";
            }
        } else if (type instanceof CompositionType) {
            if ("coalesce".equals(this.trafoConfig.getAttrConfig(attrDefOfColumn, "ch.ehi.ili2db.catalogueRefTrafo"))) {
                if (this.createExtRef) {
                    String attrSqlName = this.ili2sqlName.mapIliAttributeDef(colWrapper.getStructAttrPath(), sqlTableName, this.getSqlType((Viewable)FromXtfRecordConverter.getCatalogueRefTarget(type)).getName(), false);
                    sqlStmtCols.append(sep);
                    sqlStmtCols.append(attrSqlName);
                    if (isUpdate) {
                        sqlStmtCols.append("=?");
                    } else {
                        sqlStmtVals.append(",?");
                    }
                    sep = ",";
                } else {
                    ArrayList<ViewableWrapper> targetTables = this.getTargetTables((Viewable)FromXtfRecordConverter.getCatalogueRefTarget(type));
                    for (ViewableWrapper targetTable : targetTables) {
                        String attrSqlName = this.ili2sqlName.mapIliAttributeDef(colWrapper.getStructAttrPath(), sqlTableName, targetTable.getSqlTablename(), targetTables.size() > 1);
                        sqlStmtCols.append(sep);
                        sqlStmtCols.append(attrSqlName);
                        if (isUpdate) {
                            sqlStmtCols.append("=?");
                        } else {
                            sqlStmtVals.append(",?");
                        }
                        sep = ",";
                    }
                }
            } else if ("coalesce".equals(this.trafoConfig.getAttrConfig(attrDefOfColumn, "ch.ehi.ili2db.multiSurfaceTrafo"))) {
                String attrSqlName = this.ili2sqlName.mapIliAttributeDef(colWrapper.getStructAttrPath(), epsgCode, sqlTableName, null);
                sqlStmtCols.append(sep);
                sqlStmtCols.append(attrSqlName);
                this.multiSurfaceAttrs.addMultiSurfaceAttr(attrDefOfColumn);
                if (isUpdate) {
                    sqlStmtCols.append("=" + this.geomConv.getInsertValueWrapperMultiSurface("?", epsgCode));
                } else {
                    sqlStmtVals.append("," + this.geomConv.getInsertValueWrapperMultiSurface("?", epsgCode));
                }
                sep = ",";
            } else if ("coalesce".equals(this.trafoConfig.getAttrConfig(attrDefOfColumn, "ch.ehi.ili2db.multiLineTrafo"))) {
                String attrSqlName = this.ili2sqlName.mapIliAttributeDef(colWrapper.getStructAttrPath(), epsgCode, sqlTableName, null);
                sqlStmtCols.append(sep);
                sqlStmtCols.append(attrSqlName);
                this.multiLineAttrs.addMultiLineAttr(attrDefOfColumn);
                if (isUpdate) {
                    sqlStmtCols.append("=" + this.geomConv.getInsertValueWrapperMultiPolyline("?", epsgCode));
                } else {
                    sqlStmtVals.append("," + this.geomConv.getInsertValueWrapperMultiPolyline("?", epsgCode));
                }
                sep = ",";
            } else if ("coalesce".equals(this.trafoConfig.getAttrConfig(attrDefOfColumn, "ch.ehi.ili2db.multiPointTrafo"))) {
                String attrSqlName = this.ili2sqlName.mapIliAttributeDef(colWrapper.getStructAttrPath(), epsgCode, sqlTableName, null);
                sqlStmtCols.append(sep);
                sqlStmtCols.append(attrSqlName);
                this.multiPointAttrs.addMultiPointAttr(attrDefOfColumn);
                if (isUpdate) {
                    sqlStmtCols.append("=" + this.geomConv.getInsertValueWrapperMultiCoord("?", epsgCode));
                } else {
                    sqlStmtVals.append("," + this.geomConv.getInsertValueWrapperMultiCoord("?", epsgCode));
                }
                sep = ",";
            } else if ("expand".equals(this.trafoConfig.getAttrConfig(attrDefOfColumn, "ch.ehi.ili2db.multilingualTrafo"))) {
                String attrSqlName = this.ili2sqlName.mapIliAttributeDef(colWrapper.getStructAttrPath(), epsgCode, sqlTableName, null);
                for (String sfx : DbNames.MULTILINGUAL_TXT_COL_SUFFIXS) {
                    sqlStmtCols.append(sep);
                    sqlStmtCols.append(attrSqlName + sfx);
                    if (isUpdate) {
                        sqlStmtCols.append("=?");
                    } else {
                        sqlStmtVals.append(",?");
                    }
                    sep = ",";
                }
            } else if ("expand".equals(this.trafoConfig.getAttrConfig(attrDefOfColumn, "ch.ehi.ili2db.localisedTrafo"))) {
                String attrSqlName = this.ili2sqlName.mapIliAttributeDef(colWrapper.getStructAttrPath(), epsgCode, sqlTableName, null);
                sqlStmtCols.append(sep);
                sqlStmtCols.append(attrSqlName);
                if (isUpdate) {
                    sqlStmtCols.append("=?");
                } else {
                    sqlStmtVals.append(",?");
                }
                sep = ",";
                sqlStmtCols.append(sep);
                sqlStmtCols.append(attrSqlName + "_lang");
                if (isUpdate) {
                    sqlStmtCols.append("=?");
                } else {
                    sqlStmtVals.append(",?");
                }
                sep = ",";
            }
        } else if (type instanceof PolylineType) {
            String attrSqlName = this.ili2sqlName.mapIliAttributeDef(colWrapper.getStructAttrPath(), epsgCode, sqlTableName, null);
            sqlStmtCols.append(sep);
            sqlStmtCols.append(attrSqlName);
            if (isUpdate) {
                sqlStmtCols.append("=" + this.geomConv.getInsertValueWrapperPolyline("?", epsgCode));
            } else {
                sqlStmtVals.append("," + this.geomConv.getInsertValueWrapperPolyline("?", epsgCode));
            }
            sep = ",";
        } else if (type instanceof MultiPolylineType) {
            String attrSqlName = this.ili2sqlName.mapIliAttributeDef(colWrapper.getStructAttrPath(), epsgCode, sqlTableName, null);
            sqlStmtCols.append(sep);
            sqlStmtCols.append(attrSqlName);
            if (isUpdate) {
                sqlStmtCols.append("=" + this.geomConv.getInsertValueWrapperMultiPolyline("?", epsgCode));
            } else {
                sqlStmtVals.append("," + this.geomConv.getInsertValueWrapperMultiPolyline("?", epsgCode));
            }
            sep = ",";
        } else if (type instanceof AbstractSurfaceOrAreaType) {
            String attrSqlName;
            if (!this.createItfLineTables) {
                if (this.createXtfLineTables) {
                    attrSqlName = this.ili2sqlName.mapIliAttributeDef(colWrapper.getStructAttrPath(), epsgCode, sqlTableName, null);
                    sqlStmtCols.append(sep);
                    sqlStmtCols.append(attrSqlName);
                    if (isUpdate) {
                        sqlStmtCols.append("=" + this.geomConv.getInsertValueWrapperMultiPolyline("?", epsgCode));
                    } else {
                        sqlStmtVals.append("," + this.geomConv.getInsertValueWrapperMultiPolyline("?", epsgCode));
                    }
                    sep = ",";
                } else {
                    attrSqlName = this.ili2sqlName.mapIliAttributeDef(colWrapper.getStructAttrPath(), epsgCode, sqlTableName, null);
                    sqlStmtCols.append(sep);
                    sqlStmtCols.append(attrSqlName);
                    if (isUpdate) {
                        sqlStmtCols.append("=" + this.geomConv.getInsertValueWrapperSurface("?", epsgCode));
                    } else {
                        sqlStmtVals.append("," + this.geomConv.getInsertValueWrapperSurface("?", epsgCode));
                    }
                    sep = ",";
                }
            }
            if (this.createItfAreaRef && type instanceof AreaType) {
                attrSqlName = this.ili2sqlName.mapIliAttributeDef(colWrapper.getStructAttrPath(), epsgCode, sqlTableName, null);
                sqlStmtCols.append(sep);
                sqlStmtCols.append(attrSqlName + "_ref");
                if (isUpdate) {
                    sqlStmtCols.append("=" + this.geomConv.getInsertValueWrapperCoord("?", epsgCode));
                } else {
                    sqlStmtVals.append("," + this.geomConv.getInsertValueWrapperCoord("?", epsgCode));
                }
                sep = ",";
            }
        } else if (type instanceof CoordType) {
            String attrSqlName = this.ili2sqlName.mapIliAttributeDef(colWrapper.getStructAttrPath(), epsgCode, sqlTableName, null);
            sqlStmtCols.append(sep);
            sqlStmtCols.append(attrSqlName);
            if (isUpdate) {
                sqlStmtCols.append("=" + this.geomConv.getInsertValueWrapperCoord("?", epsgCode));
            } else {
                sqlStmtVals.append("," + this.geomConv.getInsertValueWrapperCoord("?", epsgCode));
            }
            sep = ",";
        } else if (type instanceof MultiCoordType) {
            String attrSqlName = this.ili2sqlName.mapIliAttributeDef(colWrapper.getStructAttrPath(), epsgCode, sqlTableName, null);
            sqlStmtCols.append(sep);
            sqlStmtCols.append(attrSqlName);
            if (isUpdate) {
                sqlStmtCols.append("=" + this.geomConv.getInsertValueWrapperMultiCoord("?", epsgCode));
            } else {
                sqlStmtVals.append("," + this.geomConv.getInsertValueWrapperMultiCoord("?", epsgCode));
            }
            sep = ",";
        } else if (type instanceof AbstractEnumerationType) {
            String attrSqlName = this.ili2sqlName.mapIliAttributeDef(colWrapper.getStructAttrPath(), epsgCode, sqlTableName, null);
            sqlStmtCols.append(sep);
            sqlStmtCols.append(attrSqlName);
            if (isUpdate) {
                sqlStmtCols.append("=?");
            } else {
                sqlStmtVals.append(",?");
            }
            sep = ",";
            if (this.createEnumTxtCol) {
                sqlStmtCols.append(sep);
                sqlStmtCols.append(attrSqlName + "_txt");
                if (isUpdate) {
                    sqlStmtCols.append("=?");
                } else {
                    sqlStmtVals.append(",?");
                }
                sep = ",";
            }
        } else if (type instanceof ReferenceType) {
            boolean isExtRef;
            boolean bl = isExtRef = this.createExtRef && ((ReferenceType)type).isExternal();
            if (isExtRef) {
                String attrSqlName = this.ili2sqlName.mapIliAttributeDef(colWrapper.getStructAttrPath(), sqlTableName, this.getSqlType((Viewable)((ReferenceType)type).getReferred()).getName(), false);
                sqlStmtCols.append(sep);
                sqlStmtCols.append(attrSqlName);
                if (isUpdate) {
                    sqlStmtCols.append("=?");
                } else {
                    sqlStmtVals.append(",?");
                }
                sep = ",";
            } else {
                ArrayList<ViewableWrapper> targetTables = this.getTargetTables((Viewable)((ReferenceType)type).getReferred());
                for (ViewableWrapper targetTable : targetTables) {
                    String attrSqlName = this.ili2sqlName.mapIliAttributeDef(colWrapper.getStructAttrPath(), sqlTableName, targetTable.getSqlTablename(), targetTables.size() > 1);
                    sqlStmtCols.append(sep);
                    sqlStmtCols.append(attrSqlName);
                    if (isUpdate) {
                        sqlStmtCols.append("=?");
                    } else {
                        sqlStmtVals.append(",?");
                    }
                    sep = ",";
                }
            }
        } else {
            String attrSqlName = this.ili2sqlName.mapIliAttributeDef(colWrapper.getStructAttrPath(), epsgCode, sqlTableName, null);
            sqlStmtCols.append(sep);
            sqlStmtCols.append(attrSqlName);
            if (isUpdate) {
                sqlStmtCols.append("=?");
            } else {
                sqlStmtVals.append(",?");
            }
            sep = ",";
        }
        return sep;
    }

    public int addAttrValueTXT(IomObject iomObj, String sqlType, long sqlId, String sqlTableName, PreparedStatement ps, int valuei, ColumnWrapper colWrapper, AttributeDef classAttr, ArrayList<AbstractStructWrapper> structQueue, Map<String, String> genericDomains, Viewable originalClass, int attrIndex) throws SQLException, ConverterException {
        String value;
        AttributeDef tableAttr = (AttributeDef)colWrapper.getViewableTransferElement().obj;
        Integer epsgCode = colWrapper.getEpsgCode();
        String attrName = tableAttr.getName();
        String string = value = classAttr == null ? null : iomObj.getattrprim(attrName, attrIndex);
        if (value != null) {
            ps.setString(valuei, value);
        } else {
            ps.setNull(valuei, 12);
        }
        return ++valuei;
    }

    public int addAttrValue(IomObject iomObj, String sqlTypeOfMainObj, long sqlIdOfMainObj, String sqlTableNameOfMainObj, PreparedStatement ps, int sqlParamIndex, ColumnWrapper colWrapper, AttributeDef classAttr, ArrayList<AbstractStructWrapper> structQueue, Map<String, String> genericDomains, Viewable originalClass, int iomValueIndex) throws SQLException, ConverterException {
        AttributeDef tableAttr = (AttributeDef)colWrapper.getViewableTransferElement().obj;
        Integer epsgCode = colWrapper.getEpsgCode();
        String attrName = tableAttr.getName();
        if ("coalesce".equals(this.trafoConfig.getAttrConfig(tableAttr, "ch.ehi.ili2db.jsonTrafo"))) {
            int valuec;
            Type type = tableAttr.getDomainResolvingAliases();
            boolean createJsonArray = type.getCardinality().getMaximum() > 1L;
            int n = valuec = classAttr == null ? 0 : iomObj.getattrvaluecount(attrName);
            if (valuec > 0) {
                Object geomObj = null;
                String simpleVal = iomObj.getattrprim(attrName, 0);
                if (simpleVal != null) {
                    String[] iomValues = new String[valuec];
                    for (int i = 0; i < valuec; ++i) {
                        iomValues[i] = iomObj.getattrprim(attrName, i);
                    }
                    geomObj = this.geomConv.fromIomValueArrayToJson(tableAttr, iomValues, false);
                } else {
                    IomObject[] iomValues = new IomObject[valuec];
                    for (int i = 0; i < valuec; ++i) {
                        iomValues[i] = iomObj.getattrobj(attrName, i);
                    }
                    geomObj = createJsonArray ? this.geomConv.fromIomStructureToJsonArray(tableAttr, iomValues) : this.geomConv.fromIomStructureToJson(tableAttr, iomValues);
                }
                ps.setObject(sqlParamIndex, geomObj);
            } else {
                this.geomConv.setJsonNull(ps, sqlParamIndex);
            }
            ++sqlParamIndex;
        } else if ("coalesce".equals(this.trafoConfig.getAttrConfig(tableAttr, "ch.ehi.ili2db.arrayTrafo"))) {
            int valuec = classAttr == null ? 0 : iomObj.getattrvaluecount(attrName);
            ArrayList<String> iomArray = new ArrayList<String>();
            ArrayMapping attrMapping = this.arrayAttrs.getMapping(tableAttr);
            Type type = tableAttr.getDomainResolvingAliases();
            Type arrayElementType = attrMapping.getValueAttr().getDomainResolvingAliases();
            Class dbColHint = null;
            boolean refidx = false;
            for (int elei = 0; elei < valuec; ++elei) {
                IomObject iomValue;
                if (Ili2cUtility.isReferenceType(this.td, attrMapping.getValueAttr())) {
                    IomObject structvalue = null;
                    if (type instanceof CompositionType) {
                        iomValue = iomObj.getattrobj(attrName, elei);
                        structvalue = classAttr == null ? null : iomValue.getattrobj(attrMapping.getValueAttr().getName(), 0);
                    } else {
                        structvalue = classAttr == null ? null : iomObj.getattrobj(attrName, elei);
                    }
                    String refoid = null;
                    if (structvalue != null) {
                        refoid = structvalue.getobjectrefoid();
                    }
                    if (!this.createExtRef || !((ReferenceType)arrayElementType).isExternal()) {
                        if (FromXtfRecordConverter.isUuidOid(this.td, ((ReferenceType)arrayElementType).getReferred().getOid())) {
                            refoid = Validator.normalizeUUID((String)refoid);
                        }
                        AbstractClassDef destination = ((ReferenceType)arrayElementType).getReferred();
                        String targetRootClassName = Ili2cUtility.getRootViewable((Viewable)destination).getScopedName(null);
                        if (refoid != null) {
                            long refsqlId = this.oidPool.getObjSqlId(targetRootClassName, refoid);
                            refoid = Long.toString(refsqlId);
                        }
                        dbColHint = DbColId.class;
                    }
                    if (refoid == null) continue;
                    iomArray.add(refoid);
                    continue;
                }
                String value = null;
                if (type instanceof CompositionType) {
                    iomValue = iomObj.getattrobj(attrName, elei);
                    value = iomValue.getattrvalue(attrMapping.getValueAttr().getName());
                } else {
                    value = iomObj.getattrprim(attrName, elei);
                }
                if (arrayElementType instanceof EnumerationType && !attrMapping.getValueAttr().isDomainBoolean()) {
                    if (this.createEnumColAsItfCode) {
                        value = this.enumTypes.mapXtfCode2ItfCode((EnumerationType)arrayElementType, value);
                    } else if ("multiTableWithId".equals(this.createEnumTable)) {
                        value = Long.toString(this.mapEnumValue2sqlid(attrMapping.getValueAttr(), value));
                    }
                }
                dbColHint = this.createEnumColAsItfCode || "multiTableWithId".equals(this.createEnumTable) ? DbColNumber.class : DbColVarchar.class;
                iomArray.add(value);
            }
            if (iomArray.size() > 0) {
                Object geomObj = this.geomConv.fromIomArray(attrMapping.getValueAttr(), iomArray.toArray(new String[iomArray.size()]), dbColHint);
                ps.setObject(sqlParamIndex, geomObj);
            } else {
                this.geomConv.setArrayNull(ps, sqlParamIndex);
            }
            ++sqlParamIndex;
        } else if (tableAttr.isDomainBoolean()) {
            String value;
            String string = value = classAttr == null ? null : iomObj.getattrprim(attrName, iomValueIndex);
            if (value != null) {
                if (value.equals("true")) {
                    this.geomConv.setBoolean(ps, sqlParamIndex, true);
                } else {
                    this.geomConv.setBoolean(ps, sqlParamIndex, false);
                }
            } else {
                ps.setNull(sqlParamIndex, -7);
            }
            ++sqlParamIndex;
            if (this.createEnumTxtCol) {
                if (value != null) {
                    ps.setString(sqlParamIndex, this.ili2sqlName.beautifyEnumDispName(value));
                } else {
                    ps.setNull(sqlParamIndex, 12);
                }
                ++sqlParamIndex;
            }
        } else if (tableAttr.isDomainIliUuid()) {
            String value;
            String string = value = classAttr == null ? null : iomObj.getattrprim(attrName, iomValueIndex);
            if (value == null) {
                this.geomConv.setUuidNull(ps, sqlParamIndex);
            } else {
                Object toInsertUUID = this.geomConv.fromIomUuid(Validator.normalizeUUID((String)value));
                ps.setObject(sqlParamIndex, toInsertUUID);
            }
            ++sqlParamIndex;
        } else if (tableAttr.isDomainIli1Date()) {
            String value;
            String string = value = classAttr == null ? null : iomObj.getattrprim(attrName, iomValueIndex);
            if (value != null) {
                GregorianCalendar gdate = new GregorianCalendar(Integer.parseInt(value.substring(0, 4)), Integer.parseInt(value.substring(4, 6)) - 1, Integer.parseInt(value.substring(6, 8)));
                Date date = new Date(gdate.getTimeInMillis());
                this.geomConv.setDate(ps, sqlParamIndex, date);
            } else {
                ps.setNull(sqlParamIndex, 91);
            }
            ++sqlParamIndex;
        } else if (tableAttr.isDomainIli2Date()) {
            String value;
            String string = value = classAttr == null ? null : iomObj.getattrprim(attrName, iomValueIndex);
            if (value != null) {
                XMLGregorianCalendar xmldate;
                try {
                    xmldate = DatatypeFactory.newInstance().newXMLGregorianCalendar(value);
                }
                catch (DatatypeConfigurationException e) {
                    throw new ConverterException(e);
                }
                Date date = new Date(xmldate.toGregorianCalendar().getTimeInMillis());
                this.geomConv.setDate(ps, sqlParamIndex, date);
            } else {
                ps.setNull(sqlParamIndex, 91);
            }
            ++sqlParamIndex;
        } else if (tableAttr.isDomainIli2Time()) {
            String value;
            String string = value = classAttr == null ? null : iomObj.getattrprim(attrName, iomValueIndex);
            if (value != null) {
                XMLGregorianCalendar xmldate;
                try {
                    xmldate = DatatypeFactory.newInstance().newXMLGregorianCalendar(value);
                }
                catch (DatatypeConfigurationException e) {
                    throw new ConverterException(e);
                }
                Time time = new Time(xmldate.toGregorianCalendar().getTimeInMillis());
                this.geomConv.setTime(ps, sqlParamIndex, time);
            } else {
                ps.setNull(sqlParamIndex, 92);
            }
            ++sqlParamIndex;
        } else if (tableAttr.isDomainIli2DateTime()) {
            String value;
            String string = value = classAttr == null ? null : iomObj.getattrprim(attrName, iomValueIndex);
            if (value != null) {
                XMLGregorianCalendar xmldate;
                try {
                    xmldate = DatatypeFactory.newInstance().newXMLGregorianCalendar(value);
                }
                catch (DatatypeConfigurationException e) {
                    throw new ConverterException(e);
                }
                Timestamp datetime = new Timestamp(xmldate.toGregorianCalendar().getTimeInMillis());
                this.geomConv.setTimestamp(ps, sqlParamIndex, datetime);
            } else {
                ps.setNull(sqlParamIndex, 93);
            }
            ++sqlParamIndex;
        } else {
            Type type = tableAttr.getDomainResolvingAliases();
            Model model = (Model)tableAttr.getContainer(Model.class);
            if (type instanceof CompositionType) {
                int structc;
                int n = structc = classAttr == null ? 0 : iomObj.getattrvaluecount(attrName);
                if ("coalesce".equals(this.trafoConfig.getAttrConfig(tableAttr, "ch.ehi.ili2db.catalogueRefTrafo"))) {
                    IomObject structvalue;
                    IomObject catref = classAttr == null ? null : iomObj.getattrobj(attrName, 0);
                    String refoid = null;
                    if (catref != null && (structvalue = catref.getattrobj("Reference", 0)) != null) {
                        refoid = structvalue.getobjectrefoid();
                    }
                    OutParam valueiRef = new OutParam((Object)sqlParamIndex);
                    this.setReferenceColumn(ps, FromXtfRecordConverter.getCatalogueRefTarget(type), refoid, (OutParam<Integer>)valueiRef, this.createExtRef);
                    sqlParamIndex = (Integer)valueiRef.value;
                } else if ("coalesce".equals(this.trafoConfig.getAttrConfig(tableAttr, "ch.ehi.ili2db.multiSurfaceTrafo"))) {
                    IomObject iomValue = classAttr == null ? null : iomObj.getattrobj(attrName, 0);
                    Iom_jObject iomMultisurface = null;
                    MultiSurfaceMapping attrMapping = null;
                    if (iomValue != null) {
                        attrMapping = this.multiSurfaceAttrs.getMapping(tableAttr);
                        int surfacec = iomValue.getattrvaluecount(attrMapping.getBagOfSurfacesAttrName());
                        for (int surfacei = 0; surfacei < surfacec; ++surfacei) {
                            IomObject iomSurfaceStructure = iomValue.getattrobj(attrMapping.getBagOfSurfacesAttrName(), surfacei);
                            IomObject iomPoly = iomSurfaceStructure.getattrobj(attrMapping.getSurfaceAttrName(), 0);
                            if (iomPoly == null) continue;
                            IomObject iomSurface = iomPoly.getattrobj("surface", 0);
                            if (iomMultisurface == null) {
                                iomMultisurface = new Iom_jObject("MULTISURFACE", null);
                            }
                            iomMultisurface.addattrobj("surface", iomSurface);
                        }
                    }
                    if (iomMultisurface != null) {
                        AttributeDef surfaceAttr = this.getMultiSurfaceAttrDef(type, attrMapping);
                        SurfaceType surface = (SurfaceType)surfaceAttr.getDomainResolvingAliases();
                        CoordType coord = (CoordType)surface.getControlPointDomain().getType();
                        boolean is3D = coord.getDimensions().length == 3;
                        Object geomObj = this.geomConv.fromIomMultiSurface((IomObject)iomMultisurface, epsgCode, surface.getLineAttributeStructure() != null, is3D, this.getP((LineType)surface, model, epsgCode));
                        ps.setObject(sqlParamIndex, geomObj);
                    } else {
                        this.geomConv.setSurfaceNull(ps, sqlParamIndex);
                    }
                    ++sqlParamIndex;
                } else if ("coalesce".equals(this.trafoConfig.getAttrConfig(tableAttr, "ch.ehi.ili2db.multiLineTrafo"))) {
                    IomObject iomValue = classAttr == null ? null : iomObj.getattrobj(attrName, 0);
                    Iom_jObject iomMultiline = null;
                    MultiLineMapping attrMapping = null;
                    if (iomValue != null) {
                        attrMapping = this.multiLineAttrs.getMapping(tableAttr);
                        int polylinec = iomValue.getattrvaluecount(attrMapping.getBagOfLinesAttrName());
                        for (int polylinei = 0; polylinei < polylinec; ++polylinei) {
                            IomObject iomPolylineStructure = iomValue.getattrobj(attrMapping.getBagOfLinesAttrName(), polylinei);
                            IomObject iomPoly = iomPolylineStructure.getattrobj(attrMapping.getLineAttrName(), 0);
                            if (iomMultiline == null) {
                                iomMultiline = new Iom_jObject("MULTIPOLYLINE", null);
                            }
                            iomMultiline.addattrobj("polyline", iomPoly);
                        }
                    }
                    if (iomMultiline != null) {
                        AttributeDef polylineAttr = this.getMultiLineAttrDef(type, attrMapping);
                        PolylineType line = (PolylineType)polylineAttr.getDomainResolvingAliases();
                        CoordType coord = (CoordType)line.getControlPointDomain().getType();
                        boolean is3D = coord.getDimensions().length == 3;
                        Object geomObj = this.geomConv.fromIomMultiPolyline((IomObject)iomMultiline, epsgCode, is3D, this.getP((LineType)line, model, epsgCode));
                        ps.setObject(sqlParamIndex, geomObj);
                    } else {
                        this.geomConv.setPolylineNull(ps, sqlParamIndex);
                    }
                    ++sqlParamIndex;
                } else if ("coalesce".equals(this.trafoConfig.getAttrConfig(tableAttr, "ch.ehi.ili2db.multiPointTrafo"))) {
                    IomObject iomValue = classAttr == null ? null : iomObj.getattrobj(attrName, 0);
                    Iom_jObject iomMultipoint = null;
                    MultiPointMapping attrMapping = null;
                    if (iomValue != null) {
                        attrMapping = this.multiPointAttrs.getMapping(tableAttr);
                        int pointc = iomValue.getattrvaluecount(attrMapping.getBagOfPointsAttrName());
                        for (int pointi = 0; pointi < pointc; ++pointi) {
                            IomObject iomPointStructure = iomValue.getattrobj(attrMapping.getBagOfPointsAttrName(), pointi);
                            IomObject iomPoint = iomPointStructure.getattrobj(attrMapping.getPointAttrName(), 0);
                            if (iomMultipoint == null) {
                                iomMultipoint = new Iom_jObject("MULTICOORD", null);
                            }
                            iomMultipoint.addattrobj("coord", iomPoint);
                        }
                    }
                    if (iomMultipoint != null) {
                        AttributeDef coordAttr = this.getMultiPointAttrDef(type, attrMapping);
                        CoordType coord = (CoordType)coordAttr.getDomainResolvingAliases();
                        boolean is3D = coord.getDimensions().length == 3;
                        Object geomObj = this.geomConv.fromIomMultiCoord((IomObject)iomMultipoint, epsgCode, is3D);
                        ps.setObject(sqlParamIndex, geomObj);
                    } else {
                        this.geomConv.setCoordNull(ps, sqlParamIndex);
                    }
                    ++sqlParamIndex;
                } else if ("expand".equals(this.trafoConfig.getAttrConfig(tableAttr, "ch.ehi.ili2db.multilingualTrafo"))) {
                    IomObject iomMulti = classAttr == null ? null : iomObj.getattrobj(attrName, 0);
                    for (String sfx : DbNames.MULTILINGUAL_TXT_COL_SUFFIXS) {
                        if (iomMulti != null) {
                            String value = this.getMultilingualText(iomMulti, sfx);
                            if (value != null) {
                                ps.setString(sqlParamIndex, value);
                            } else {
                                ps.setNull(sqlParamIndex, 12);
                            }
                        } else {
                            ps.setNull(sqlParamIndex, 12);
                        }
                        ++sqlParamIndex;
                    }
                } else if ("expand".equals(this.trafoConfig.getAttrConfig(tableAttr, "ch.ehi.ili2db.localisedTrafo"))) {
                    IomObject iomTxt;
                    IomObject iomObject = iomTxt = classAttr == null ? null : iomObj.getattrobj(attrName, 0);
                    if (iomTxt != null) {
                        String text = iomTxt.getattrvalue("Text");
                        String lang = null;
                        if (text != null) {
                            ps.setString(sqlParamIndex, text);
                            lang = iomTxt.getattrvalue("Language");
                        } else {
                            ps.setNull(sqlParamIndex, 12);
                        }
                        ++sqlParamIndex;
                        if (lang != null) {
                            ps.setString(sqlParamIndex, lang);
                        } else {
                            ps.setNull(sqlParamIndex, 12);
                        }
                        ++sqlParamIndex;
                    } else {
                        ps.setNull(sqlParamIndex, 12);
                        ps.setNull(++sqlParamIndex, 12);
                        ++sqlParamIndex;
                    }
                } else {
                    for (int structi = 0; structi < structc; ++structi) {
                        IomObject struct = iomObj.getattrobj(attrName, structi);
                        String sqlAttrName = this.ili2sqlName.mapIliAttributeDef(colWrapper.getStructAttrPath(), null, sqlTableNameOfMainObj, null);
                        this.enqueStructValue(structQueue, sqlIdOfMainObj, sqlTypeOfMainObj, sqlAttrName, struct, structi, tableAttr);
                    }
                }
            } else if (type instanceof PolylineType) {
                IomObject value = classAttr == null ? null : iomObj.getattrobj(attrName, 0);
                int actualEpsgCode = TransferFromIli.getEpsgCode(originalClass, tableAttr, genericDomains, this.defaultEpsgCode);
                if (value != null && actualEpsgCode == epsgCode) {
                    boolean is3D = ((CoordType)((PolylineType)type).getControlPointDomain().getType()).getDimensions().length == 3;
                    ps.setObject(sqlParamIndex, this.geomConv.fromIomPolyline(value, epsgCode, is3D, this.getP((LineType)((PolylineType)type), model, epsgCode)));
                } else {
                    this.geomConv.setPolylineNull(ps, sqlParamIndex);
                }
                ++sqlParamIndex;
            } else if (type instanceof MultiPolylineType) {
                IomObject value = classAttr == null ? null : iomObj.getattrobj(attrName, 0);
                int actualEpsgCode = TransferFromIli.getEpsgCode(originalClass, tableAttr, genericDomains, this.defaultEpsgCode);
                if (value != null && actualEpsgCode == epsgCode) {
                    boolean is3D = ((CoordType)((MultiPolylineType)type).getControlPointDomain().getType()).getDimensions().length == 3;
                    ps.setObject(sqlParamIndex, this.geomConv.fromIomMultiPolyline(value, epsgCode, is3D, this.getP((LineType)((MultiPolylineType)type), model, epsgCode)));
                } else {
                    this.geomConv.setPolylineNull(ps, sqlParamIndex);
                }
                ++sqlParamIndex;
            } else if (type instanceof AbstractSurfaceOrAreaType) {
                boolean is3D;
                IomObject value;
                if (!this.createItfLineTables) {
                    if (this.createXtfLineTables) {
                        value = classAttr == null ? null : iomObj.getattrobj(attrName, 0);
                        IomObject iomMultiline = null;
                        int actualEpsgCode = TransferFromIli.getEpsgCode(originalClass, tableAttr, genericDomains, this.defaultEpsgCode);
                        if (value != null && actualEpsgCode == epsgCode) {
                            iomMultiline = this.mapSurface2MultiPolyline(value);
                        }
                        if (iomMultiline != null) {
                            boolean is3D2 = ((CoordType)((SurfaceOrAreaType)type).getControlPointDomain().getType()).getDimensions().length == 3;
                            Object geomObj = this.geomConv.fromIomMultiPolyline(iomMultiline, epsgCode, is3D2, this.getP((LineType)((SurfaceOrAreaType)type), model, epsgCode));
                            ps.setObject(sqlParamIndex, geomObj);
                        } else {
                            this.geomConv.setSurfaceNull(ps, sqlParamIndex);
                        }
                        ++sqlParamIndex;
                    } else {
                        value = classAttr == null ? null : iomObj.getattrobj(attrName, 0);
                        int actualEpsgCode = TransferFromIli.getEpsgCode(originalClass, tableAttr, genericDomains, this.defaultEpsgCode);
                        if (value != null && actualEpsgCode == epsgCode) {
                            boolean bl = is3D = ((CoordType)((AbstractSurfaceOrAreaType)type).getControlPointDomain().getType()).getDimensions().length == 3;
                            if (type instanceof SurfaceOrAreaType) {
                                Object geomObj = this.geomConv.fromIomSurface(value, epsgCode, ((SurfaceOrAreaType)type).getLineAttributeStructure() != null, is3D, this.getP((LineType)((SurfaceOrAreaType)type), model, epsgCode));
                                ps.setObject(sqlParamIndex, geomObj);
                            } else if (type instanceof MultiSurfaceOrAreaType) {
                                Object geomObj = this.geomConv.fromIomMultiSurface(value, epsgCode, ((MultiSurfaceOrAreaType)type).getLineAttributeStructure() != null, is3D, this.getP((LineType)((MultiSurfaceOrAreaType)type), model, epsgCode));
                                ps.setObject(sqlParamIndex, geomObj);
                            }
                        } else {
                            this.geomConv.setSurfaceNull(ps, sqlParamIndex);
                        }
                        ++sqlParamIndex;
                    }
                }
                if (this.createItfAreaRef && type instanceof AreaType) {
                    value = null;
                    value = this.isItfReader ? (classAttr == null ? null : iomObj.getattrobj(attrName, 0)) : (classAttr == null ? null : iomObj.getattrobj("_itf_" + attrName, 0));
                    int actualEpsgCode = TransferFromIli.getEpsgCode(originalClass, tableAttr, genericDomains, this.defaultEpsgCode);
                    if (value != null && actualEpsgCode == epsgCode) {
                        is3D = ((CoordType)((AbstractSurfaceOrAreaType)type).getControlPointDomain().getType()).getDimensions().length == 3;
                        ps.setObject(sqlParamIndex, this.geomConv.fromIomCoord(value, epsgCode, is3D));
                    } else {
                        this.geomConv.setCoordNull(ps, sqlParamIndex);
                    }
                    ++sqlParamIndex;
                }
            } else if (type instanceof CoordType) {
                IomObject value;
                IomObject iomObject = value = classAttr == null ? null : iomObj.getattrobj(attrName, 0);
                if (value != null) {
                    int actualEpsgCode = TransferFromIli.getEpsgCode(originalClass, tableAttr, genericDomains, this.defaultEpsgCode);
                    if (actualEpsgCode == epsgCode) {
                        boolean is3D = ((CoordType)type).getDimensions().length == 3;
                        ps.setObject(sqlParamIndex, this.geomConv.fromIomCoord(value, epsgCode, is3D));
                    } else {
                        this.geomConv.setCoordNull(ps, sqlParamIndex);
                    }
                } else {
                    this.geomConv.setCoordNull(ps, sqlParamIndex);
                }
                ++sqlParamIndex;
            } else if (type instanceof MultiCoordType) {
                IomObject value;
                IomObject iomObject = value = classAttr == null ? null : iomObj.getattrobj(attrName, 0);
                if (value != null) {
                    int actualEpsgCode = TransferFromIli.getEpsgCode(originalClass, tableAttr, genericDomains, this.defaultEpsgCode);
                    if (actualEpsgCode == epsgCode) {
                        boolean is3D = ((MultiCoordType)type).getDimensions().length == 3;
                        ps.setObject(sqlParamIndex, this.geomConv.fromIomMultiCoord(value, epsgCode, is3D));
                    } else {
                        this.geomConv.setCoordNull(ps, sqlParamIndex);
                    }
                } else {
                    this.geomConv.setCoordNull(ps, sqlParamIndex);
                }
                ++sqlParamIndex;
            } else if (type instanceof NumericType) {
                String value;
                String string = value = classAttr == null ? null : iomObj.getattrprim(attrName, iomValueIndex);
                if (!type.isAbstract()) {
                    PrecisionDecimal min = ((NumericType)type).getMinimum();
                    PrecisionDecimal max = ((NumericType)type).getMaximum();
                    if (min.getAccuracy() > 0) {
                        if (value != null) {
                            try {
                                ps.setDouble(sqlParamIndex, Double.parseDouble(value));
                            }
                            catch (NumberFormatException ex) {
                                EhiLogger.logError((Throwable)ex);
                            }
                        } else {
                            this.geomConv.setDecimalNull(ps, sqlParamIndex);
                        }
                    } else if (value != null) {
                        try {
                            long val = Long.parseLong(value);
                            ps.setLong(sqlParamIndex, val);
                        }
                        catch (NumberFormatException ex) {
                            EhiLogger.logError((Throwable)ex);
                        }
                    } else {
                        ps.setNull(sqlParamIndex, 4);
                    }
                    ++sqlParamIndex;
                }
            } else if (type instanceof AbstractEnumerationType) {
                String value;
                String string = value = classAttr == null ? null : iomObj.getattrprim(attrName, iomValueIndex);
                if (this.createEnumColAsItfCode) {
                    if (value != null) {
                        int itfCode = this.mapXtfCode2ItfCode((EnumerationType)type, value);
                        ps.setInt(sqlParamIndex, itfCode);
                    } else {
                        ps.setNull(sqlParamIndex, 4);
                    }
                } else if ("multiTableWithId".equals(this.createEnumTable)) {
                    if (value != null) {
                        ps.setLong(sqlParamIndex, this.mapEnumValue2sqlid(classAttr, value));
                    } else {
                        ps.setNull(sqlParamIndex, -5);
                    }
                } else if (value != null) {
                    ps.setString(sqlParamIndex, value);
                } else {
                    ps.setNull(sqlParamIndex, 12);
                }
                ++sqlParamIndex;
                if (this.createEnumTxtCol) {
                    if (value != null) {
                        ps.setString(sqlParamIndex, this.mapEnumValue2dispName(classAttr, value));
                    } else {
                        ps.setNull(sqlParamIndex, 12);
                    }
                    ++sqlParamIndex;
                }
            } else if (type instanceof ReferenceType) {
                IomObject structvalue = classAttr == null ? null : iomObj.getattrobj(attrName, 0);
                String refoid = null;
                if (structvalue != null) {
                    refoid = structvalue.getobjectrefoid();
                }
                OutParam valueiRef = new OutParam((Object)sqlParamIndex);
                this.setReferenceColumn(ps, ((ReferenceType)type).getReferred(), refoid, (OutParam<Integer>)valueiRef, this.createExtRef && ((ReferenceType)type).isExternal());
                sqlParamIndex = (Integer)valueiRef.value;
            } else if (type instanceof BlackboxType) {
                String value;
                String string = value = classAttr == null ? null : iomObj.getattrprim(attrName, iomValueIndex);
                if (((BlackboxType)type).getKind() == 1) {
                    if (value == null) {
                        this.geomConv.setXmlNull(ps, sqlParamIndex);
                    } else {
                        Object toInsertXml = this.geomConv.fromIomXml(value);
                        ps.setObject(sqlParamIndex, toInsertXml);
                    }
                    ++sqlParamIndex;
                } else {
                    if (value == null) {
                        this.geomConv.setBlobNull(ps, sqlParamIndex);
                    } else {
                        Object toInsertBlob = this.geomConv.fromIomBlob(value);
                        ps.setObject(sqlParamIndex, toInsertBlob);
                    }
                    ++sqlParamIndex;
                }
            } else {
                String value;
                String string = value = classAttr == null ? null : iomObj.getattrprim(attrName, iomValueIndex);
                if (value != null) {
                    ps.setString(sqlParamIndex, value);
                } else {
                    ps.setNull(sqlParamIndex, 12);
                }
                ++sqlParamIndex;
            }
        }
        return sqlParamIndex;
    }

    private IomObject mapSurface2MultiPolyline(IomObject obj) {
        Iom_jObject iomMultiline = null;
        for (int surfacei = 0; surfacei < obj.getattrvaluecount("surface"); ++surfacei) {
            IomObject surface = obj.getattrobj("surface", surfacei);
            int boundaryc = surface.getattrvaluecount("boundary");
            for (int boundaryi = 0; boundaryi < boundaryc; ++boundaryi) {
                IomObject boundary = surface.getattrobj("boundary", boundaryi);
                for (int polylinei = 0; polylinei < boundary.getattrvaluecount("polyline"); ++polylinei) {
                    IomObject polyline = boundary.getattrobj("polyline", polylinei);
                    if (iomMultiline == null) {
                        iomMultiline = new Iom_jObject("MULTIPOLYLINE", null);
                    }
                    iomMultiline.addattrobj("polyline", polyline);
                }
            }
        }
        return iomMultiline;
    }

    private long mapEnumValue2sqlid(AttributeDef attr, String xtfvalue) throws SQLException {
        EnumValueMap map = null;
        if (this.enumCache.containsKey(attr)) {
            map = this.enumCache.get(attr);
        } else {
            OutParam qualifiedIliName = new OutParam();
            DbTableName sqlDbName = this.getEnumTargetTableName(attr, (OutParam<String>)qualifiedIliName, this.dbSchema);
            map = EnumValueMap.readEnumValueMapFromDb(this.conn, this.colT_ID, true, (String)qualifiedIliName.value, sqlDbName);
            this.enumCache.put(attr, map);
        }
        return map.mapXtfValue(xtfvalue);
    }

    private String mapEnumValue2dispName(AttributeDef attr, String xtfvalue) throws SQLException {
        EnumValueMap map = null;
        if (this.enumCache.containsKey(attr)) {
            map = this.enumCache.get(attr);
        } else {
            if (this.createEnumTable != null) {
                OutParam qualifiedIliName = new OutParam();
                DbTableName sqlDbName = this.getEnumTargetTableName(attr, (OutParam<String>)qualifiedIliName, this.dbSchema);
                map = EnumValueMap.readEnumValueMapFromDb(this.conn, null, false, (String)qualifiedIliName.value, sqlDbName);
            } else {
                map = EnumValueMap.createEnumValueMap((Element)attr, this.ili2sqlName);
            }
            this.enumCache.put(attr, map);
        }
        String mappedDisplayName = null;
        mappedDisplayName = map.mapXtfValueToDisplayName(xtfvalue);
        if (mappedDisplayName == null || mappedDisplayName.isEmpty()) {
            mappedDisplayName = this.ili2sqlName.beautifyEnumDispName(xtfvalue);
        }
        return mappedDisplayName;
    }

    protected AttributeDef getMultiPointAttrDef(Type type, MultiPointMapping attrMapping) {
        Table multiPointType = ((CompositionType)type).getComponentType();
        Table pointStructureType = ((CompositionType)((AttributeDef)multiPointType.getElement(AttributeDef.class, attrMapping.getBagOfPointsAttrName())).getDomain()).getComponentType();
        AttributeDef coordAttr = (AttributeDef)pointStructureType.getElement(AttributeDef.class, attrMapping.getPointAttrName());
        return coordAttr;
    }

    protected AttributeDef getMultiLineAttrDef(Type type, MultiLineMapping attrMapping) {
        Table multiLineType = ((CompositionType)type).getComponentType();
        Table lineStructureType = ((CompositionType)((AttributeDef)multiLineType.getElement(AttributeDef.class, attrMapping.getBagOfLinesAttrName())).getDomain()).getComponentType();
        AttributeDef polylineAttr = (AttributeDef)lineStructureType.getElement(AttributeDef.class, attrMapping.getLineAttrName());
        return polylineAttr;
    }

    protected AttributeDef getMultiSurfaceAttrDef(Type type, MultiSurfaceMapping attrMapping) {
        Table multiSurfaceType = ((CompositionType)type).getComponentType();
        Table surfaceStructureType = ((CompositionType)((AttributeDef)multiSurfaceType.getElement(AttributeDef.class, attrMapping.getBagOfSurfacesAttrName())).getDomain()).getComponentType();
        AttributeDef surfaceAttr = (AttributeDef)surfaceStructureType.getElement(AttributeDef.class, attrMapping.getSurfaceAttrName());
        return surfaceAttr;
    }

    private String getMultilingualText(IomObject iomMulti, String sfx) {
        if (sfx.length() > 0) {
            sfx = sfx.substring(this.LEN_LANG_PREFIX);
        }
        int txtc = iomMulti.getattrvaluecount("LocalisedText");
        for (int txti = 0; txti < txtc; ++txti) {
            IomObject iomTxt = iomMulti.getattrobj("LocalisedText", txti);
            String lang = iomTxt.getattrvalue("Language");
            if (lang == null) {
                lang = "";
            }
            if (!lang.equals(sfx)) continue;
            return iomTxt.getattrvalue("Text");
        }
        return null;
    }

    public int _getSrsid(AttributeDef attr) {
        String crs;
        Domain coordDomain;
        Integer srsid = this.srsCache.get(attr);
        if (srsid != null) {
            return srsid;
        }
        AttributeDef attrOrDomainDef = attr;
        Type attrType = attr.getDomain();
        if (attrType instanceof TypeAlias) {
            attrOrDomainDef = ((TypeAlias)attrType).getAliasing();
            attrType = ((Domain)attrOrDomainDef).getType();
        }
        CoordType coord = null;
        if (attrType instanceof CoordType) {
            coord = (CoordType)attrType;
        } else if (attrType instanceof LineType && (coordDomain = ((LineType)attrType).getControlPointDomain()) != null) {
            attrOrDomainDef = coordDomain;
            coord = (CoordType)coordDomain.getType();
        }
        if (coord != null && (crs = coord.getCrs((Element)attrOrDomainDef)) != null) {
            String[] crsv = crs.split(":");
            String crsAuthority = crsv[0];
            String crsCode = crsv[1];
            try {
                srsid = this.geomConv.getSrsid(crsAuthority, crsCode, this.conn);
                if (srsid != null) {
                    this.srsCache.put(attr, srsid);
                    return srsid;
                }
            }
            catch (UnsupportedOperationException ex) {
                EhiLogger.logAdaption((String)("no CRS support by converter; use default " + this.defaultSrsid));
            }
            catch (ConverterException ex) {
                throw new IllegalArgumentException("failed to get srsid for " + crsAuthority + ":" + crsCode + ", " + ex.getLocalizedMessage());
            }
        }
        srsid = this.defaultSrsid;
        this.srsCache.put(attr, srsid);
        return srsid;
    }

    public double getP(LineType type, Model model, Integer epsgCode) {
        NumericalType[] dimv;
        int accuracy;
        if (this.typeCache.containsKey(type)) {
            return this.typeCache.get(type);
        }
        Domain coordDomain = type.getControlPointDomain();
        CoordType coordType = (CoordType)coordDomain.getType();
        if (coordType.isGeneric()) {
            coordType = (CoordType)Ili2cUtility.resolveGenericCoordDomain(model, coordDomain, epsgCode).getType();
        }
        double p = (accuracy = ((NumericType)(dimv = coordType.getDimensions())[0]).getMaximum().getAccuracy()) == 0 ? 0.5 : Math.pow(10.0, -accuracy);
        this.typeCache.put(type, new Double(p));
        return p;
    }

    private void enqueStructValue(ArrayList<AbstractStructWrapper> structQueue, long parentSqlId, String parentSqlType, String parentSqlAttr, IomObject struct, int structi, AttributeDef attr) {
        structQueue.add(new StructWrapper(parentSqlId, parentSqlType, parentSqlAttr, struct, structi, attr));
    }
}

