/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.h2.engine.Session;
import org.h2.index.AbstractFunctionCursor;
import org.h2.index.FunctionIndex;
import org.h2.message.DbException;
import org.h2.result.SearchRow;
import org.h2.value.DataType;
import org.h2.value.Value;

public class FunctionCursorResultSet
extends AbstractFunctionCursor {
    private final ResultSet result;
    private final ResultSetMetaData meta;

    FunctionCursorResultSet(FunctionIndex functionIndex, SearchRow searchRow, SearchRow searchRow2, Session session, ResultSet resultSet) {
        super(functionIndex, searchRow, searchRow2, session);
        this.result = resultSet;
        try {
            this.meta = resultSet.getMetaData();
        }
        catch (SQLException sQLException) {
            throw DbException.convert(sQLException);
        }
    }

    @Override
    boolean nextImpl() {
        this.row = null;
        try {
            if (this.result != null && this.result.next()) {
                int n = this.meta.getColumnCount();
                this.values = new Value[n];
                for (int i = 0; i < n; ++i) {
                    int n2 = DataType.getValueTypeFromResultSet(this.meta, i + 1);
                    this.values[i] = DataType.readValue(this.session, this.result, i + 1, n2);
                }
            } else {
                this.values = null;
            }
        }
        catch (SQLException sQLException) {
            throw DbException.convert(sQLException);
        }
        return this.values != null;
    }
}

