/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.edit;

import org.h2gis.api.DeterministicScalarFunction;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;

public class ST_RemoveHoles
extends DeterministicScalarFunction {
    private static final GeometryFactory FACTORY = new GeometryFactory();

    public ST_RemoveHoles() {
        this.addProperty("remarks", "Remove all holes in a polygon or a multipolygon. \n If the geometry doesn't contain any hole return the input geometry.\n If the input geometry is not a polygon or multipolygon return null.");
    }

    public String getJavaStaticMethod() {
        return "removeHoles";
    }

    public static Geometry removeHoles(Geometry geometry) {
        if (geometry == null) {
            return null;
        }
        if (geometry instanceof Polygon) {
            return ST_RemoveHoles.removeHolesPolygon((Polygon)geometry);
        }
        if (geometry instanceof MultiPolygon) {
            return ST_RemoveHoles.removeHolesMultiPolygon((MultiPolygon)geometry);
        }
        if (geometry instanceof GeometryCollection) {
            Geometry[] geometries = new Geometry[geometry.getNumGeometries()];
            for (int i = 0; i < geometry.getNumGeometries(); ++i) {
                Geometry geom = geometry.getGeometryN(i);
                geometries[i] = geometry instanceof Polygon ? ST_RemoveHoles.removeHolesPolygon((Polygon)geom) : (geometry instanceof MultiPolygon ? ST_RemoveHoles.removeHolesMultiPolygon((MultiPolygon)geom) : geom);
            }
            return FACTORY.createGeometryCollection(geometries);
        }
        return null;
    }

    public static MultiPolygon removeHolesMultiPolygon(MultiPolygon multiPolygon) {
        int num = multiPolygon.getNumGeometries();
        Polygon[] polygons = new Polygon[num];
        for (int i = 0; i < num; ++i) {
            polygons[i] = ST_RemoveHoles.removeHolesPolygon((Polygon)multiPolygon.getGeometryN(i));
        }
        return multiPolygon.getFactory().createMultiPolygon(polygons);
    }

    public static Polygon removeHolesPolygon(Polygon polygon) {
        return new Polygon((LinearRing)polygon.getExteriorRing(), null, polygon.getFactory());
    }
}

