/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.convert;

import java.io.IOException;
import java.sql.SQLException;
import org.h2gis.api.DeterministicScalarFunction;
import org.h2gis.utilities.jts_utils.GeometryMetaData;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKBReader;

public class ST_PolyFromWKB
extends DeterministicScalarFunction {
    public ST_PolyFromWKB() {
        this.addProperty("remarks", "Convert Well Known Binary into Geometry then check that it is a POLYGON.\n If an SRID is not specified, it defaults to 0.");
    }

    public String getJavaStaticMethod() {
        return "toPolygon";
    }

    public static Geometry toPolygon(byte[] bytes) throws SQLException, IOException {
        return ST_PolyFromWKB.toPolygon(bytes, 0);
    }

    public static Geometry toPolygon(byte[] bytes, int srid) throws SQLException, IOException {
        if (bytes == null) {
            return null;
        }
        WKBReader wkbReader = new WKBReader();
        try {
            if (GeometryMetaData.getMetaDataFromWKB((byte[])bytes).geometryType != 3) {
                throw new SQLException("Provided WKB is not a Polygon.");
            }
            Geometry geometry = wkbReader.read(bytes);
            geometry.setSRID(srid);
            return geometry;
        }
        catch (ParseException ex) {
            throw new SQLException("ParseException while evaluating ST_PolyFromWKB", ex);
        }
    }
}

