/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.io.geojson;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import org.h2gis.api.AbstractFunction;
import org.h2gis.api.EmptyProgressVisitor;
import org.h2gis.api.ProgressVisitor;
import org.h2gis.api.ScalarFunction;
import org.h2gis.functions.io.geojson.GeoJsonDriverFunction;
import org.h2gis.utilities.URIUtilities;

public class GeoJsonRead
extends AbstractFunction
implements ScalarFunction {
    public GeoJsonRead() {
        this.addProperty("remarks", "Import a GeoJSON 1.0 file.");
    }

    public String getJavaStaticMethod() {
        return "readGeoJson";
    }

    public static void readGeoJson(Connection connection, String fileName) throws IOException, SQLException {
        String name = URIUtilities.fileFromString((String)fileName).getName();
        String tableName = name.substring(0, name.lastIndexOf(".")).toUpperCase();
        if (!tableName.matches("^[a-zA-Z][a-zA-Z0-9_]*$")) {
            throw new SQLException("The file name contains unsupported characters");
        }
        GeoJsonRead.readGeoJson(connection, fileName, tableName);
    }

    public static void readGeoJson(Connection connection, String fileName, String tableReference) throws IOException, SQLException {
        GeoJsonDriverFunction gjdf = new GeoJsonDriverFunction();
        gjdf.importFile(connection, tableReference, URIUtilities.fileFromString((String)fileName), (ProgressVisitor)new EmptyProgressVisitor());
    }
}

