/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.utilities.jts_utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.math.Vector3D;

public final class CoordinateUtils {
    public static double[] zMinMax(Coordinate[] cs) {
        boolean validZFound = false;
        double[] result = new double[2];
        double zmin = Double.NaN;
        double zmax = Double.NaN;
        for (int t = cs.length - 1; t >= 0; --t) {
            double z = cs[t].z;
            if (Double.isNaN(z)) continue;
            if (validZFound) {
                if (z < zmin) {
                    zmin = z;
                }
                if (!(z > zmax)) continue;
                zmax = z;
                continue;
            }
            validZFound = true;
            zmin = z;
            zmax = z;
        }
        result[0] = zmin;
        result[1] = zmax;
        return result;
    }

    public static double interpolate(Coordinate firstCoordinate, Coordinate lastCoordinate, Coordinate toBeInterpolated) {
        if (Double.isNaN(firstCoordinate.z)) {
            return Double.NaN;
        }
        if (Double.isNaN(lastCoordinate.z)) {
            return Double.NaN;
        }
        return firstCoordinate.z + (lastCoordinate.z - firstCoordinate.z) * firstCoordinate.distance(toBeInterpolated) / (firstCoordinate.distance(toBeInterpolated) + toBeInterpolated.distance(lastCoordinate));
    }

    public static boolean contains2D(Coordinate[] coords, Coordinate coord) {
        for (Coordinate coordinate : coords) {
            if (!coordinate.equals2D(coord)) continue;
            return true;
        }
        return false;
    }

    public static Coordinate vectorIntersection(Coordinate p1, Vector3D v1, Coordinate p2, Vector3D v2) {
        Coordinate i;
        block2: {
            block3: {
                i = null;
                double delta = v1.getX() * -v2.getY() - -v1.getY() * v2.getX();
                if (delta == 0.0) break block2;
                double k = ((p2.x - p1.x) * -v2.getY() - (p2.y - p1.y) * -v2.getX()) / delta;
                i = new Coordinate(p1.x + k * v1.getX(), p1.y + k * v1.getY(), p1.z + k * v1.getZ());
                if (new LineSegment(p1, new Coordinate(p1.x + v1.getX(), p1.y + v1.getY())).projectionFactor(i) < 0.0) break block3;
                LineSegment lineSegment = new LineSegment(p2, new Coordinate(p2.x + v2.getX(), p2.y + v2.getY()));
                if (!(lineSegment.projectionFactor(i) < 0.0)) break block2;
            }
            return null;
        }
        return i;
    }

    public static Coordinate[] removeDuplicatedCoordinates(Coordinate[] coords, boolean closeRing) {
        LinkedHashSet<Coordinate> finalCoords = new LinkedHashSet<Coordinate>();
        Coordinate prevCoord = coords[0];
        finalCoords.add(prevCoord);
        Coordinate firstCoord = prevCoord;
        int nbCoords = coords.length;
        for (int i = 1; i < nbCoords; ++i) {
            Coordinate currentCoord = coords[i];
            if (currentCoord.equals2D(prevCoord)) continue;
            finalCoords.add(currentCoord);
            prevCoord = currentCoord;
        }
        if (closeRing) {
            Coordinate[] coordsFinal = finalCoords.toArray(new Coordinate[0]);
            Coordinate[] closedCoords = Arrays.copyOf(coordsFinal, coordsFinal.length + 1);
            closedCoords[closedCoords.length - 1] = firstCoord;
            return closedCoords;
        }
        return finalCoords.toArray(new Coordinate[0]);
    }

    public static Coordinate[] removeRepeatedCoordinates(Coordinate[] coords, double tolerance, boolean duplicateFirstLast) {
        ArrayList<Coordinate> finalCoords = new ArrayList<Coordinate>();
        Coordinate prevCoord = coords[0];
        finalCoords.add(prevCoord);
        Coordinate firstCoord = prevCoord;
        int nbCoords = coords.length;
        for (int i = 1; i < nbCoords; ++i) {
            Coordinate currentCoord = coords[i];
            if (currentCoord.distance(prevCoord) <= tolerance) continue;
            finalCoords.add(currentCoord);
            prevCoord = currentCoord;
        }
        if (!duplicateFirstLast) {
            if (firstCoord.distance(prevCoord) <= tolerance) {
                finalCoords.remove(finalCoords.size() - 1);
            }
        } else {
            finalCoords.add(firstCoord);
        }
        return finalCoords.toArray(new Coordinate[0]);
    }

    private CoordinateUtils() {
    }
}

