/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.mesh;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.h2gis.api.DeterministicScalarFunction;
import org.h2gis.utilities.jts_utils.Voronoi;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateFilter;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.Triangle;
import org.locationtech.jts.triangulate.VoronoiDiagramBuilder;
import org.locationtech.jts.triangulate.quadedge.QuadEdge;
import org.locationtech.jts.triangulate.quadedge.QuadEdgeSubdivision;
import org.locationtech.jts.triangulate.quadedge.TriangleVisitor;

public class ST_Voronoi
extends DeterministicScalarFunction {
    private static final int DEFAULT_DIMENSION = 2;

    public ST_Voronoi() {
        this.addProperty("remarks", "Construct a voronoi diagram from a delaunay triangulation or a set of points.\nST_VORONOI(THE_GEOM MULTIPOLYGON)\nST_VORONOI(THE_GEOM MULTIPOLYGON,OUT_DIMENSION INTEGER)\nST_VORONOI(THE_GEOM MULTIPOLYGON,OUT_DIMENSION INTEGER,ENVELOPE POLYGON)\nST_VORONOI(THE_GEOM MULTIPOINTS)\nST_VORONOI(THE_GEOM MULTIPOINTS,OUT_DIMENSION INTEGER)\nST_VORONOI(THE_GEOM MULTIPOINTS,OUT_DIMENSION INTEGER,ENVELOPE POLYGON)\nEx:\nSELECT ST_VORONOI(ST_DELAUNAY('MULTIPOINT(2 2 0,6 3 0,4 7 0,2 8 0,1 6 0,3 5 0)')) the_geom;\nSELECT ST_VORONOI(ST_DELAUNAY('MULTIPOINT(2 2 0,6 3 0,4 7 0,2 8 0,1 6 0,3 5 0)'), 1)\nSELECT ST_VORONOI(ST_DELAUNAY('MULTIPOINT(2 2 0,6 3 0,4 7 0,2 8 0,1 6 0,3 5 0)'), 1, ST_EXPAND('POINT(3 5)', 10, 10))");
    }

    public String getJavaStaticMethod() {
        return "voronoi";
    }

    public static GeometryCollection voronoi(Geometry geomCollection) throws SQLException {
        return ST_Voronoi.voronoi(geomCollection, 2);
    }

    public static GeometryCollection voronoi(Geometry geomCollection, int outputDimension) throws SQLException {
        return ST_Voronoi.voronoi(geomCollection, outputDimension, null);
    }

    private static GeometryCollection returnEmptyCollection(int outputDimension) {
        switch (outputDimension) {
            case 2: {
                return new GeometryFactory().createMultiPolygon(new Polygon[0]);
            }
            case 1: {
                return new GeometryFactory().createMultiLineString(new LineString[0]);
            }
        }
        return new GeometryFactory().createMultiPoint(new Point[0]);
    }

    public static GeometryCollection voronoi(Geometry geomCollection, int outputDimension, Geometry envelope) throws SQLException {
        if (geomCollection == null) {
            return ST_Voronoi.returnEmptyCollection(outputDimension);
        }
        if (geomCollection instanceof MultiPoint || geomCollection instanceof GeometryCollection && geomCollection.getNumGeometries() > 0 && geomCollection.getGeometryN(0) instanceof Point) {
            VoronoiDiagramBuilder diagramBuilder = new VoronoiDiagramBuilder();
            diagramBuilder.setSites(geomCollection);
            if (envelope != null) {
                diagramBuilder.setClipEnvelope(envelope.getEnvelopeInternal());
            }
            if (outputDimension == 2) {
                return (GeometryCollection)diagramBuilder.getDiagram(geomCollection.getFactory());
            }
            if (outputDimension == 1) {
                return ST_Voronoi.mergeTrianglesEdges((GeometryCollection)diagramBuilder.getDiagram(geomCollection.getFactory()));
            }
            QuadEdgeSubdivision subdivision = diagramBuilder.getSubdivision();
            ArrayList<Coordinate> circumcenter = new ArrayList<Coordinate>(geomCollection.getNumGeometries());
            subdivision.visitTriangles((TriangleVisitor)new TriangleVisitorCircumCenter(circumcenter), false);
            return geomCollection.getFactory().createMultiPoint(circumcenter.toArray(new Coordinate[0]));
        }
        if (Double.compare(geomCollection.getEnvelopeInternal().getArea(), 0.0) == 0) {
            return ST_Voronoi.returnEmptyCollection(outputDimension);
        }
        Voronoi voronoi = new Voronoi();
        if (envelope != null) {
            voronoi.setEnvelope(envelope.getEnvelopeInternal());
        }
        voronoi.generateTriangleNeighbors(geomCollection);
        return voronoi.generateVoronoi(outputDimension);
    }

    private static MultiLineString mergeTrianglesEdges(GeometryCollection polygons) {
        GeometryFactory factory = polygons.getFactory();
        HashSet<LineSegment> segments = new HashSet<LineSegment>(polygons.getNumGeometries());
        SegmentMerge segmentMerge = new SegmentMerge(segments);
        for (int idGeom = 0; idGeom < polygons.getNumGeometries(); ++idGeom) {
            Geometry polygonGeom = polygons.getGeometryN(idGeom);
            if (!(polygonGeom instanceof Polygon)) continue;
            Polygon polygon = (Polygon)polygonGeom;
            segmentMerge.reset();
            polygon.getExteriorRing().apply((CoordinateFilter)segmentMerge);
        }
        LineString[] lineStrings = new LineString[segments.size()];
        int idLine = 0;
        for (LineSegment lineSegment : segments) {
            lineStrings[idLine++] = factory.createLineString(new Coordinate[]{lineSegment.p0, lineSegment.p1});
        }
        segments.clear();
        return factory.createMultiLineString(lineStrings);
    }

    private static class SegmentMerge
    implements CoordinateFilter {
        private Set<LineSegment> segments;
        private Coordinate firstPt = null;

        public SegmentMerge(Set<LineSegment> segments) {
            this.segments = segments;
        }

        public void filter(Coordinate coord) {
            if (this.firstPt != null) {
                LineSegment segment = new LineSegment(this.firstPt, coord);
                segment.normalize();
                this.segments.add(segment);
            }
            this.firstPt = coord;
        }

        public void reset() {
            this.firstPt = null;
        }
    }

    private static class TriangleVisitorCircumCenter
    implements TriangleVisitor {
        List<Coordinate> circumCenters;

        public TriangleVisitorCircumCenter(List<Coordinate> circumCenters) {
            this.circumCenters = circumCenters;
        }

        public void visit(QuadEdge[] triEdges) {
            Coordinate a = triEdges[0].orig().getCoordinate();
            Coordinate b = triEdges[1].orig().getCoordinate();
            Coordinate c = triEdges[2].orig().getCoordinate();
            this.circumCenters.add(Triangle.circumcentre((Coordinate)a, (Coordinate)b, (Coordinate)c));
        }
    }
}

