/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.io.shp.internal;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import org.h2gis.functions.io.shp.internal.ShapeHandler;
import org.h2gis.functions.io.shp.internal.ShapeType;
import org.h2gis.functions.io.shp.internal.ShapefileException;
import org.h2gis.functions.io.shp.internal.ShapefileHeader;
import org.h2gis.functions.io.utility.ReadBufferManager;
import org.locationtech.jts.geom.Geometry;

public class ShapefileReader {
    private ShapeHandler handler;
    private ShapefileHeader header;
    private FileChannel channel;
    private ReadBufferManager buffer;
    private ShapeType fileShapeType = ShapeType.UNDEFINED;

    public ShapefileReader(FileChannel channel) throws IOException, ShapefileException {
        this.channel = channel;
        this.init();
    }

    public static ShapefileHeader readHeader(ReadableByteChannel channel) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocateDirect(100);
        if (channel.read(buffer) != 100) {
            throw new EOFException("Premature end of header");
        }
        buffer.flip();
        ShapefileHeader header = new ShapefileHeader();
        header.read(buffer);
        return header;
    }

    private void init() throws IOException, ShapefileException {
        this.header = ShapefileReader.readHeader(this.channel);
        this.fileShapeType = this.header.getShapeType();
        this.handler = this.fileShapeType.getShapeHandler();
        if (this.handler == null) {
            throw new IOException("Unsuported shape type:" + this.fileShapeType);
        }
        this.buffer = new ReadBufferManager(this.channel);
    }

    public ShapefileHeader getHeader() {
        return this.header;
    }

    public void close() throws IOException {
        if (this.channel != null && this.channel.isOpen()) {
            this.channel.close();
        }
        this.channel = null;
        this.header = null;
    }

    public Geometry geomAt(int offset) throws IOException {
        this.buffer.position(offset);
        this.buffer.skip(8);
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
        ShapeType recordType = ShapeType.forID(this.buffer.getInt());
        if (recordType != ShapeType.NULL && recordType != this.fileShapeType) {
            throw new IllegalStateException("ShapeType changed illegally from " + this.fileShapeType + " to " + recordType);
        }
        return this.handler.read(this.buffer, recordType);
    }

    public void setHandler(ShapeHandler handler) {
        this.handler = handler;
    }
}

