/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.io;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import org.h2.util.StringUtils;
import org.h2gis.api.AbstractFunction;
import org.h2gis.api.DriverFunction;
import org.h2gis.api.ProgressVisitor;
import org.h2gis.api.ScalarFunction;
import org.h2gis.functions.io.dbf.DBFDriverFunction;
import org.h2gis.functions.io.dbf.DBFEngine;
import org.h2gis.functions.io.shp.SHPDriverFunction;
import org.h2gis.functions.io.shp.SHPEngine;
import org.h2gis.utilities.JDBCUtilities;
import org.h2gis.utilities.TableLocation;

public class DriverManager
extends AbstractFunction
implements ScalarFunction,
DriverFunction {
    private static final DriverDef[] DRIVERS = new DriverDef[]{new DriverDef(DBFEngine.class.getName(), "dbf"), new DriverDef(SHPEngine.class.getName(), "shp")};
    private static final int FORMAT = 0;
    private static final int DESCRIPTION = 1;
    private static final String[][] formatDescription = new String[][]{{"dbf", DBFDriverFunction.DESCRIPTION}, {"shp", SHPDriverFunction.DESCRIPTION}};

    public DriverManager() {
        this.addProperty("name", "FILE_TABLE");
        this.addProperty("remarks", "Use the appropriate driver to open a specified file path.");
    }

    public String getJavaStaticMethod() {
        return "openFile";
    }

    public String getFormatDescription(String format) {
        for (String[] descr : formatDescription) {
            if (!descr[0].equalsIgnoreCase(format)) continue;
            return descr[1];
        }
        return "";
    }

    public boolean isSpatialFormat(String extension) {
        return extension.equalsIgnoreCase("shp");
    }

    public static void openFile(Connection connection, String fileName, String tableName) throws SQLException {
        String ext = fileName.substring(fileName.lastIndexOf(46) + 1, fileName.length());
        boolean isH2 = JDBCUtilities.isH2DataBase((DatabaseMetaData)connection.getMetaData());
        for (DriverDef driverDef : DRIVERS) {
            if (!driverDef.getFileExt().equalsIgnoreCase(ext)) continue;
            try (Statement st = connection.createStatement();){
                st.execute(String.format("CREATE TABLE %s COMMENT %s ENGINE %s WITH %s", TableLocation.parse((String)tableName, (Boolean)isH2).toString(isH2), StringUtils.quoteStringSQL((String)fileName), StringUtils.quoteJavaString((String)driverDef.getClassName()), StringUtils.quoteJavaString((String)fileName)));
            }
            return;
        }
        throw new SQLException("No driver is available to open the " + ext + " file format");
    }

    public void exportTable(Connection connection, String tableReference, File fileName, ProgressVisitor progress) throws SQLException, IOException {
        throw new SQLFeatureNotSupportedException("Work in progress..");
    }

    public void exportTable(Connection connection, String tableReference, File fileName, ProgressVisitor progress, String options) throws SQLException, IOException {
        throw new SQLFeatureNotSupportedException("Work in progress..");
    }

    public DriverFunction.IMPORT_DRIVER_TYPE getImportDriverType() {
        return DriverFunction.IMPORT_DRIVER_TYPE.LINK;
    }

    public String[] getImportFormats() {
        String[] formats = new String[DRIVERS.length];
        for (int idDriver = 0; idDriver < DRIVERS.length; ++idDriver) {
            formats[idDriver] = DRIVERS[idDriver].getFileExt();
        }
        return formats;
    }

    public String[] getExportFormats() {
        return new String[0];
    }

    public void importFile(Connection connection, String tableReference, File fileName, ProgressVisitor progress) throws SQLException, IOException {
        DriverManager.openFile(connection, fileName.getAbsolutePath(), tableReference);
    }

    public void importFile(Connection connection, String tableReference, File fileName, ProgressVisitor progress, String options) throws SQLException, IOException {
        DriverManager.openFile(connection, fileName.getAbsolutePath(), tableReference);
    }

    public void importFile(Connection connection, String tableReference, File fileName, ProgressVisitor progress, boolean deleteTables) throws SQLException, IOException {
        DriverManager.openFile(connection, fileName.getAbsolutePath(), tableReference);
    }

    private static class DriverDef {
        private String className;
        private String fileExt;

        private DriverDef(String className, String fileExt) {
            this.className = className;
            this.fileExt = fileExt;
        }

        public String getClassName() {
            return this.className;
        }

        public String getFileExt() {
            return this.fileExt;
        }
    }
}

