/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.create;

import java.sql.SQLException;
import org.h2gis.api.AbstractFunction;
import org.h2gis.api.ScalarFunction;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.operation.buffer.BufferOp;
import org.locationtech.jts.operation.buffer.BufferParameters;

public class ST_RingBuffer
extends AbstractFunction
implements ScalarFunction {
    public ST_RingBuffer() {
        this.addProperty("remarks", "Compute a ring buffer around a geometry.\nAvalaible arguments are :\n (1) the geometry, (2) the size of each ring,  (3) the number of rings, (4) optional - the end cap style (square, round) Default is round\na list of blank-separated key=value pairs (string case) iso used t manage line style parameters.\n Please read the ST_Buffer documention.\n (5) optional - createHole True if you want to keep only difference between buffers Default is true.\nNote : Holes are not supported by this function.");
    }

    public String getJavaStaticMethod() {
        return "ringBuffer";
    }

    public static Geometry ringBuffer(Geometry geom, double bufferSize, int numBuffer) throws SQLException {
        return ST_RingBuffer.ringBuffer(geom, bufferSize, numBuffer, "endcap=round");
    }

    public static Geometry ringBuffer(Geometry geom, double bufferDistance, int numBuffer, String parameters) throws SQLException {
        return ST_RingBuffer.ringBuffer(geom, bufferDistance, numBuffer, parameters, true);
    }

    public static Geometry ringBuffer(Geometry geom, double bufferDistance, int numBuffer, String parameters, boolean doDifference) throws SQLException {
        if (geom == null) {
            return null;
        }
        if (geom.getNumGeometries() > 1) {
            throw new SQLException("This function supports only single geometry : point, linestring or polygon.");
        }
        String[] buffParemeters = parameters.split("\\s+");
        BufferParameters bufferParameters = new BufferParameters();
        for (String params : buffParemeters) {
            String param;
            String[] keyValue = params.split("=");
            if (keyValue[0].equalsIgnoreCase("endcap")) {
                param = keyValue[1];
                if (param.equalsIgnoreCase("round")) {
                    bufferParameters.setEndCapStyle(1);
                    continue;
                }
                if (param.equalsIgnoreCase("square")) {
                    bufferParameters.setEndCapStyle(3);
                    continue;
                }
                throw new IllegalArgumentException("Supported join values are round or square.");
            }
            if (keyValue[0].equalsIgnoreCase("join")) {
                param = keyValue[1];
                if (param.equalsIgnoreCase("bevel")) {
                    bufferParameters.setJoinStyle(3);
                    continue;
                }
                if (param.equalsIgnoreCase("mitre") || param.equalsIgnoreCase("miter")) {
                    bufferParameters.setJoinStyle(2);
                    continue;
                }
                if (param.equalsIgnoreCase("round")) {
                    bufferParameters.setJoinStyle(1);
                    continue;
                }
                throw new IllegalArgumentException("Supported join values are bevel, mitre, miter or round.");
            }
            if (keyValue[0].equalsIgnoreCase("mitre_limit") || keyValue[0].equalsIgnoreCase("miter_limit")) {
                bufferParameters.setMitreLimit(Double.valueOf(keyValue[1]).doubleValue());
                continue;
            }
            if (keyValue[0].equalsIgnoreCase("quad_segs")) {
                bufferParameters.setQuadrantSegments(Integer.valueOf(keyValue[1]).intValue());
                continue;
            }
            throw new IllegalArgumentException("Unknown parameters. Please read the documentation.");
        }
        if (bufferDistance > 0.0) {
            return ST_RingBuffer.computePositiveRingBuffer(geom, bufferDistance, numBuffer, bufferParameters, doDifference);
        }
        if (bufferDistance < 0.0) {
            if (geom instanceof Point) {
                throw new SQLException("Cannot compute a negative ring buffer on a point.");
            }
            return ST_RingBuffer.computeNegativeRingBuffer(geom, bufferDistance, numBuffer, bufferParameters, doDifference);
        }
        return geom;
    }

    public static Geometry computePositiveRingBuffer(Geometry geom, double bufferDistance, int numBuffer, BufferParameters bufferParameters, boolean doDifference) throws SQLException {
        Polygon[] buffers = new Polygon[numBuffer];
        if (geom instanceof Polygon) {
            geom = geom.getFactory().createPolygon(((Polygon)geom).getExteriorRing().getCoordinateSequence());
        }
        Geometry previous = geom;
        double distance = 0.0;
        for (int i = 0; i < numBuffer; ++i) {
            Geometry newBuffer = ST_RingBuffer.runBuffer(geom, distance += bufferDistance, bufferParameters);
            buffers[i] = doDifference ? (Polygon)newBuffer.difference(previous) : (Polygon)newBuffer;
            previous = newBuffer;
        }
        return geom.getFactory().createMultiPolygon(buffers);
    }

    public static Geometry computeNegativeRingBuffer(Geometry geom, double bufferDistance, int numBuffer, BufferParameters bufferParameters, boolean doDifference) throws SQLException {
        Polygon[] buffers = new Polygon[numBuffer];
        Geometry previous = geom;
        double distance = 0.0;
        if (geom instanceof Polygon) {
            geom = ((Polygon)geom).getExteriorRing();
            bufferParameters.setSingleSided(true);
        }
        for (int i = 0; i < numBuffer; ++i) {
            Geometry newBuffer = ST_RingBuffer.runBuffer(geom, distance += bufferDistance, bufferParameters);
            buffers[i] = i == 0 ? (Polygon)newBuffer : (doDifference ? (Polygon)newBuffer.difference(previous) : (Polygon)newBuffer);
            previous = newBuffer;
        }
        return geom.getFactory().createMultiPolygon(buffers);
    }

    public static Geometry runBuffer(Geometry geom, double bufferSize, BufferParameters bufferParameters) throws SQLException {
        return BufferOp.bufferOp((Geometry)geom, (double)bufferSize, (BufferParameters)bufferParameters);
    }
}

