/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.distance;

import org.h2gis.api.DeterministicScalarFunction;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.operation.distance.DistanceOp;

public class ST_ClosestPoint
extends DeterministicScalarFunction {
    public ST_ClosestPoint() {
        this.addProperty("remarks", "Returns the 2D point on geometry A that is closest to geometry B.");
    }

    public String getJavaStaticMethod() {
        return "closestPoint";
    }

    public static Point closestPoint(Geometry geomA, Geometry geomB) {
        if (geomA == null || geomB == null) {
            return null;
        }
        return geomA.getFactory().createPoint(DistanceOp.nearestPoints((Geometry)geomA, (Geometry)geomB)[0]);
    }
}

