/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.ili2gpkg;

import ch.ehi.ili2db.AbstractMain;
import ch.ehi.ili2db.base.DbUrlConverter;
import ch.ehi.ili2db.base.TableBasedIdGen;
import ch.ehi.ili2db.gui.AbstractDbPanelDescriptor;
import ch.ehi.ili2db.gui.Config;
import ch.ehi.ili2gpkg.GpkgColumnConverter;
import ch.ehi.ili2gpkg.GpkgDbPanelDescriptor;
import ch.ehi.ili2gpkg.GpkgMapping;
import ch.ehi.sqlgen.generator_impl.jdbc.GeneratorGeoPackage;
import java.text.ParseException;

public class GpkgMain
extends AbstractMain {
    public void initConfig(Config config) {
        super.initConfig(config);
        config.setGeometryConverter(GpkgColumnConverter.class.getName());
        config.setDdlGenerator(GeneratorGeoPackage.class.getName());
        config.setJdbcDriver("org.sqlite.JDBC");
        config.setIdGenerator(TableBasedIdGen.class.getName());
        config.setIli2dbCustomStrategy(GpkgMapping.class.getName());
        config.setOneGeomPerTable(true);
    }

    public DbUrlConverter getDbUrlConverter() {
        return new DbUrlConverter(){

            public String makeUrl(Config config) {
                if (config.getDbfile() != null) {
                    return "jdbc:sqlite:" + config.getDbfile();
                }
                return null;
            }
        };
    }

    public AbstractDbPanelDescriptor getDbPanelDescriptor() {
        return new GpkgDbPanelDescriptor();
    }

    public static void main(String[] args) {
        new GpkgMain().domain(args);
    }

    public String getAPP_NAME() {
        return "ili2gpkg";
    }

    public String getDB_PRODUCT_NAME() {
        return "GeoPackage";
    }

    public String getJAR_NAME() {
        return "ili2gpkg.jar";
    }

    protected void printConnectOptions() {
        System.err.println("--dbfile gpkgfile       The filename of the database.");
    }

    protected void printSpecificOptions() {
        System.err.println("--dbschema  schema     The name of the schema in the database. Defaults to not set.");
        System.err.println("--gpkgMultiGeomPerTable Create more than one geometry per table, if required (no secondary table).");
    }

    protected int doArgs(String[] args, int argi, Config config) throws ParseException {
        String arg = args[argi];
        if (arg.equals("--dbfile")) {
            config.setDbfile(args[++argi]);
            ++argi;
        } else if (this.isOption(arg, "--gpkgMultiGeomPerTable")) {
            config.setOneGeomPerTable(!this.parseBooleanArgument(arg));
            ++argi;
        }
        return argi;
    }
}

