/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.ili2gpkg;

import ch.interlis.iom.IomObject;
import ch.interlis.iox_j.wkb.Wkb2iox;
import com.vividsolutions.jts.io.ParseException;
import java.util.Arrays;

public class Gpkg2iox {
    Wkb2iox helper = new Wkb2iox();

    public IomObject read(byte[] bytes) throws ParseException {
        byte version;
        byte magic2;
        byte magic1;
        int pos = 0;
        if ((magic1 = bytes[pos++]) != 71) {
            throw new ParseException("unexpected magic1 " + magic1);
        }
        if ((magic2 = bytes[pos++]) != 80) {
            throw new ParseException("unexpected magic2 " + magic2);
        }
        if ((version = bytes[pos++]) != 0) {
            throw new ParseException("unexpected version " + version);
        }
        byte flags = bytes[pos++];
        int env = (flags & 0xE) >> 1;
        int envlen = 0;
        if (env == 0) {
            envlen = 0;
        } else if (env == 1) {
            envlen = 32;
        } else if (env == 2) {
            envlen = 48;
        } else if (env == 3) {
            envlen = 48;
        } else if (env == 4) {
            envlen = 64;
        } else {
            throw new ParseException("unexpected envelope " + env);
        }
        pos += 4;
        return this.helper.read(Arrays.copyOfRange(bytes, pos += envlen, bytes.length));
    }
}

