/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.ili2gpkg;

import ch.ehi.basics.i18n.ResourceBundle;
import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.ili2db.base.AbstractJdbcMapping;
import ch.ehi.ili2db.gui.Config;
import ch.ehi.sqlgen.repository.DbColumn;
import ch.ehi.sqlgen.repository.DbTable;
import ch.ehi.sqlgen.repository.DbTableName;
import ch.interlis.ili2c.metamodel.AssociationDef;
import ch.interlis.ili2c.metamodel.AttributeDef;
import ch.interlis.ili2c.metamodel.RoleDef;
import ch.interlis.ili2c.metamodel.Viewable;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.io.ByteArrayInStream;
import com.vividsolutions.jts.io.ByteOrderDataInStream;
import com.vividsolutions.jts.io.InStream;
import com.vividsolutions.jts.io.WKBReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.sqlite.Function;

public class GpkgMapping
extends AbstractJdbcMapping {
    private boolean isNewFile = false;

    public void fromIliInit(Config config) {
    }

    public void fromIliEnd(Config config) {
    }

    public void fixupViewable(DbTable sqlTableDef, Viewable iliClassDef) {
    }

    public void fixupAttribute(DbTable sqlTableDef, DbColumn sqlColDef, AttributeDef iliAttrDef) {
    }

    public void fixupEmbeddedLink(DbTable dbTable, DbColumn dbColId, AssociationDef roleOwner, RoleDef role, DbTableName targetTable, String targetPk) {
    }

    public void preConnect(String url, String dbusr, String dbpwd, Config config) {
        String fileName = config.getDbfile();
        this.isNewFile = !new File(fileName).exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postConnect(Connection conn, Config config) {
        if (this.isNewFile) {
            LineNumberReader reader = null;
            try {
                String filename = null;
                filename = config.isOneGeomPerTable() ? ResourceBundle.class2packagePath(((Object)((Object)this)).getClass()) + "/init.sql" : ResourceBundle.class2packagePath(((Object)((Object)this)).getClass()) + "/init-mg.sql";
                InputStream initsqlStream = ((Object)((Object)this)).getClass().getResourceAsStream(filename);
                if (initsqlStream == null) {
                    throw new IllegalStateException("Resource " + filename + " not found");
                }
                reader = new LineNumberReader(new InputStreamReader(initsqlStream, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException(e);
            }
            try {
                String line = reader.readLine();
                while (line != null) {
                    if ((line = line.trim()).length() > 0) {
                        Statement dbstmt = null;
                        try {
                            try {
                                dbstmt = conn.createStatement();
                                EhiLogger.traceBackendCmd((String)line);
                                dbstmt.execute(line);
                            }
                            finally {
                                dbstmt.close();
                            }
                        }
                        catch (SQLException ex) {
                            throw new IllegalStateException(ex);
                        }
                    }
                    line = reader.readLine();
                }
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
            finally {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
        }
        if ("True".equalsIgnoreCase(config.getValue("ch.ehi.sqlgen.createGeomIndex"))) {
            try {
                int MASK_GEOMETRY_EMPTY = 16;
                boolean MASK_HEADER_BYTE_ORDER = true;
                int MASK_HEADER_ENVELOPE_CODE = 14;
                int FLAG_GEOMETRY_EMPTY = 16;
                boolean FLAG_LITTLE_ENDIAN = true;
                boolean FLAG_BIG_ENDIAN = false;
                boolean FLAG_HEADER_ENVELOPE_EMPTY = false;
                Function.create((Connection)conn, (String)"ST_IsEmpty", (Function)new Function(){

                    protected void xFunc() throws SQLException {
                        try {
                            byte[] blobArgument = this.value_blob(0);
                            ByteArrayInStream input = new ByteArrayInStream(blobArgument);
                            byte[] bytes = new byte[4];
                            input.read(bytes);
                            byte flags = bytes[3];
                            if ((flags & 0x10) == 16) {
                                this.result(1);
                            } else {
                                this.result(0);
                            }
                        }
                        catch (IOException e) {
                            EhiLogger.logError((String)"The implementation of SQL function ST_IsEmpty needed for a rtree spatial index failed. There was an error during the execution of the function.");
                            throw new IllegalStateException(e);
                        }
                    }
                });
                Function.create((Connection)conn, (String)"ST_MinX", (Function)new Function(){

                    protected void xFunc() throws SQLException {
                        try {
                            byte[] blobArgument = this.value_blob(0);
                            ByteArrayInStream input = new ByteArrayInStream(blobArgument);
                            byte[] bytes = new byte[4];
                            input.read(bytes);
                            byte flags = bytes[3];
                            ByteOrderDataInStream din = new ByteOrderDataInStream((InStream)input);
                            if ((flags & 1) == 1) {
                                din.setOrder(2);
                            } else {
                                din.setOrder(1);
                            }
                            int srsId = din.readInt();
                            if ((flags & 0xE) != 0) {
                                double minX = din.readDouble();
                                double maxX = din.readDouble();
                                double minY = din.readDouble();
                                double maxY = din.readDouble();
                                this.result(minX);
                            } else {
                                WKBReader wkbReader = new WKBReader(new GeometryFactory());
                                Geometry geom = wkbReader.read((InStream)input);
                                geom.setSRID(srsId);
                                this.result(geom.getEnvelopeInternal().getMinX());
                            }
                        }
                        catch (Exception e) {
                            EhiLogger.logError((String)"The implementation of SQL function ST_MinX needed for a rtree spatial index failed. There was an error during the execution of the function.");
                            throw new IllegalStateException(e);
                        }
                    }
                });
                Function.create((Connection)conn, (String)"ST_MaxX", (Function)new Function(){

                    protected void xFunc() throws SQLException {
                        try {
                            byte[] blobArgument = this.value_blob(0);
                            ByteArrayInStream input = new ByteArrayInStream(blobArgument);
                            byte[] bytes = new byte[4];
                            input.read(bytes);
                            byte flags = bytes[3];
                            ByteOrderDataInStream din = new ByteOrderDataInStream((InStream)input);
                            if ((flags & 1) == 1) {
                                din.setOrder(2);
                            } else {
                                din.setOrder(1);
                            }
                            int srsId = din.readInt();
                            if ((flags & 0xE) != 0) {
                                double minX = din.readDouble();
                                double maxX = din.readDouble();
                                double minY = din.readDouble();
                                double maxY = din.readDouble();
                                this.result(maxX);
                            } else {
                                WKBReader wkbReader = new WKBReader(new GeometryFactory());
                                Geometry geom = wkbReader.read((InStream)input);
                                geom.setSRID(srsId);
                                this.result(geom.getEnvelopeInternal().getMaxX());
                            }
                        }
                        catch (Exception e) {
                            EhiLogger.logError((String)"The implementation of SQL function ST_MaxX needed for a rtree spatial index failed. There was an error during the execution of the function.");
                            throw new IllegalStateException(e);
                        }
                    }
                });
                Function.create((Connection)conn, (String)"ST_MinY", (Function)new Function(){

                    protected void xFunc() throws SQLException {
                        try {
                            byte[] blobArgument = this.value_blob(0);
                            ByteArrayInStream input = new ByteArrayInStream(blobArgument);
                            byte[] bytes = new byte[4];
                            input.read(bytes);
                            byte flags = bytes[3];
                            ByteOrderDataInStream din = new ByteOrderDataInStream((InStream)input);
                            if ((flags & 1) == 1) {
                                din.setOrder(2);
                            } else {
                                din.setOrder(1);
                            }
                            int srsId = din.readInt();
                            if ((flags & 0xE) != 0) {
                                double minX = din.readDouble();
                                double maxX = din.readDouble();
                                double minY = din.readDouble();
                                double maxY = din.readDouble();
                                this.result(minY);
                            } else {
                                WKBReader wkbReader = new WKBReader(new GeometryFactory());
                                Geometry geom = wkbReader.read((InStream)input);
                                geom.setSRID(srsId);
                                this.result(geom.getEnvelopeInternal().getMinY());
                            }
                        }
                        catch (Exception e) {
                            EhiLogger.logError((String)"The implementation of SQL function ST_MinY needed for a rtree spatial index failed. There was an error during the execution of the function.");
                            throw new IllegalStateException(e);
                        }
                    }
                });
                Function.create((Connection)conn, (String)"ST_MaxY", (Function)new Function(){

                    protected void xFunc() throws SQLException {
                        try {
                            byte[] blobArgument = this.value_blob(0);
                            ByteArrayInStream input = new ByteArrayInStream(blobArgument);
                            byte[] bytes = new byte[4];
                            input.read(bytes);
                            byte flags = bytes[3];
                            ByteOrderDataInStream din = new ByteOrderDataInStream((InStream)input);
                            if ((flags & 1) == 1) {
                                din.setOrder(2);
                            } else {
                                din.setOrder(1);
                            }
                            int srsId = din.readInt();
                            if ((flags & 0xE) != 0) {
                                double minX = din.readDouble();
                                double maxX = din.readDouble();
                                double minY = din.readDouble();
                                double maxY = din.readDouble();
                                this.result(maxY);
                            } else {
                                WKBReader wkbReader = new WKBReader(new GeometryFactory());
                                Geometry geom = wkbReader.read((InStream)input);
                                geom.setSRID(srsId);
                                this.result(geom.getEnvelopeInternal().getMaxY());
                            }
                        }
                        catch (Exception e) {
                            EhiLogger.logError((String)"The implementation of SQL function ST_MaxY needed for a rtree spatial index failed. There was an error during the execution of the function.");
                            throw new IllegalStateException(e);
                        }
                    }
                });
            }
            catch (SQLException e) {
                EhiLogger.logError((String)"Failed to create SQL functions ST_MinX, ST_MaxX, ST_MinY, ST_MaxY needed for a rtree spatial index.");
                throw new IllegalStateException(e);
            }
        }
    }
}

