/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.ili2db.fromili;

import ch.interlis.ili2c.modelscan.IliFile;
import ch.interlis.ili2c.modelscan.IliModel;
import java.util.Iterator;

public class IliImportsUtility {
    private String content = null;
    private int pos = 0;

    public static String getIliImports(IliFile ilifile) {
        StringBuffer ret = new StringBuffer();
        Iterator modeli = ilifile.iteratorModel();
        String sep = "";
        while (modeli.hasNext()) {
            IliModel model = (IliModel)modeli.next();
            ret.append(sep + model.getName());
            sep = " ";
            Iterator deps = model.getDependencies().iterator();
            if (!deps.hasNext()) continue;
            ret.append("{");
            while (deps.hasNext()) {
                String dep = (String)deps.next();
                ret.append(" ");
                ret.append(dep);
            }
            ret.append("}");
        }
        return ret.toString();
    }

    public static IliFile parseIliImports(double iliversion, String value) {
        IliFile ret = null;
        IliImportsUtility parser = new IliImportsUtility(value);
        String token = parser.nextToken();
        while (token != null) {
            IliModel model;
            String modelName = token;
            if (ret == null) {
                ret = new IliFile();
            }
            if ((token = parser.nextToken()) != null && token.equals("{")) {
                model = new IliModel();
                model.setIliVersion(iliversion);
                model.setName(modelName);
                token = parser.nextToken();
                while (token != null && !token.equals("}")) {
                    String imports = token;
                    model.addDepenedency(imports);
                    token = parser.nextToken();
                }
                ret.addModel(model);
                token = parser.nextToken();
                continue;
            }
            model = new IliModel();
            model.setIliVersion(iliversion);
            model.setName(modelName);
            ret.addModel(model);
        }
        return ret;
    }

    private IliImportsUtility(String value) {
        this.content = value;
    }

    private String nextToken() {
        char c;
        if (this.content == null) {
            return null;
        }
        if (this.pos >= this.content.length()) {
            return null;
        }
        while (this.pos < this.content.length() && this.content.charAt(this.pos) == ' ') {
            ++this.pos;
        }
        if (this.pos >= this.content.length()) {
            return null;
        }
        if (this.content.charAt(this.pos) == '{') {
            ++this.pos;
            return "{";
        }
        if (this.content.charAt(this.pos) == '}') {
            ++this.pos;
            return "}";
        }
        StringBuffer name = new StringBuffer();
        while (this.pos < this.content.length() && (c = this.content.charAt(this.pos)) != ' ' && c != '{' && c != '}') {
            name.append(c);
            ++this.pos;
        }
        return name.toString();
    }

    public static void main(String[] args) {
        IliFile file = IliImportsUtility.parseIliImports(1.0, "ModelA{ModelC}ModelB");
        System.out.println(file);
    }
}

