/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.ili2gpkg;

import ch.ehi.basics.settings.Settings;
import ch.ehi.ili2db.converter.AbstractWKBColumnConverter;
import ch.ehi.ili2db.converter.ConverterException;
import ch.ehi.ili2db.gui.Config;
import ch.ehi.ili2gpkg.Gpkg2iox;
import ch.ehi.ili2gpkg.Iox2gpkg;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.iom.IomObject;
import ch.interlis.iox_j.wkb.Iox2wkbException;
import com.vividsolutions.jts.io.ParseException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import net.iharder.Base64;

public class GpkgColumnConverter
extends AbstractWKBColumnConverter {
    private TransferDescription td = null;
    private boolean strokeArcs = true;
    private boolean repairTouchingLines;

    public Integer getSrsid(String crsAuthority, String crsCode, Connection conn) throws ConverterException {
        int srsid;
        Statement stmt = null;
        ResultSet ret = null;
        try {
            stmt = conn.createStatement();
            ret = stmt.executeQuery("SELECT srs_id FROM gpkg_spatial_ref_sys WHERE organization='" + crsAuthority + "' AND organization_coordsys_id=" + crsCode);
            if (!ret.next()) {
                Integer n = null;
                return n;
            }
            srsid = ret.getInt(1);
        }
        catch (SQLException ex) {
            throw new ConverterException("failed to query srsid from database", (Throwable)ex);
        }
        finally {
            if (ret != null) {
                try {
                    ret.close();
                }
                catch (SQLException e) {
                    throw new ConverterException("failed to close rs", (Throwable)e);
                }
                ret = null;
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    throw new ConverterException("failed to close stmt", (Throwable)e);
                }
                stmt = null;
            }
        }
        return srsid;
    }

    public void setup(Connection conn, Settings config) {
        super.setup(conn, config);
        this.strokeArcs = "enable".equals(Config.getStrokeArcs((Settings)config));
        this.repairTouchingLines = ((Config)config).getRepairTouchingLines();
    }

    public String getInsertValueWrapperCoord(String wkfValue, int srid) {
        return wkfValue;
    }

    public String getInsertValueWrapperMultiCoord(String wkfValue, int srid) {
        return wkfValue;
    }

    public String getInsertValueWrapperPolyline(String wkfValue, int srid) {
        return wkfValue;
    }

    public String getInsertValueWrapperMultiPolyline(String wkfValue, int srid) {
        return wkfValue;
    }

    public String getInsertValueWrapperSurface(String wkfValue, int srid) {
        return wkfValue;
    }

    public String getInsertValueWrapperMultiSurface(String wkfValue, int srid) {
        return wkfValue;
    }

    public String getSelectValueWrapperDate(String sqlColName) {
        return "strftime('%Y-%m-%d %H:%M:%fZ'," + sqlColName + ")";
    }

    public String getSelectValueWrapperTime(String sqlColName) {
        return "strftime('%Y-%m-%d %H:%M:%fZ'," + sqlColName + ")";
    }

    public String getSelectValueWrapperDateTime(String sqlColName) {
        return "strftime('%Y-%m-%d %H:%M:%fZ'," + sqlColName + ")";
    }

    public String getSelectValueWrapperCoord(String dbNativeValue) {
        return dbNativeValue;
    }

    public String getSelectValueWrapperMultiCoord(String dbNativeValue) {
        return dbNativeValue;
    }

    public String getSelectValueWrapperPolyline(String dbNativeValue) {
        return dbNativeValue;
    }

    public String getSelectValueWrapperMultiPolyline(String dbNativeValue) {
        return dbNativeValue;
    }

    public String getSelectValueWrapperSurface(String dbNativeValue) {
        return dbNativeValue;
    }

    public String getSelectValueWrapperMultiSurface(String dbNativeValue) {
        return dbNativeValue;
    }

    public Object fromIomUuid(String uuid) throws SQLException, ConverterException {
        return uuid;
    }

    public Object fromIomXml(String xml) throws SQLException, ConverterException {
        return xml;
    }

    public Object fromIomBlob(String blob) throws SQLException, ConverterException {
        byte[] bytearray;
        try {
            bytearray = Base64.decode((String)blob);
        }
        catch (IOException e) {
            throw new ConverterException((Throwable)e);
        }
        return bytearray;
    }

    public Object fromIomSurface(IomObject value, int srsid, boolean hasLineAttr, boolean is3D, double p) throws SQLException, ConverterException {
        if (value != null) {
            Iox2gpkg conv = new Iox2gpkg(is3D ? 3 : 2);
            try {
                return conv.surface2wkb(value, !this.strokeArcs, p, this.repairTouchingLines, srsid);
            }
            catch (Iox2wkbException ex) {
                throw new ConverterException((Throwable)ex);
            }
        }
        return null;
    }

    public Object fromIomMultiSurface(IomObject value, int srsid, boolean hasLineAttr, boolean is3D, double p) throws SQLException, ConverterException {
        if (value != null) {
            Iox2gpkg conv = new Iox2gpkg(is3D ? 3 : 2);
            try {
                return conv.multisurface2wkb(value, !this.strokeArcs, p, this.repairTouchingLines, srsid);
            }
            catch (Iox2wkbException ex) {
                throw new ConverterException((Throwable)ex);
            }
        }
        return null;
    }

    public Object fromIomCoord(IomObject value, int srsid, boolean is3D) throws SQLException, ConverterException {
        if (value != null) {
            Iox2gpkg conv = new Iox2gpkg(is3D ? 3 : 2);
            try {
                return conv.coord2wkb(value, srsid);
            }
            catch (Iox2wkbException ex) {
                throw new ConverterException((Throwable)ex);
            }
        }
        return null;
    }

    public Object fromIomMultiCoord(IomObject value, int srsid, boolean is3D) throws SQLException, ConverterException {
        if (value != null) {
            Iox2gpkg conv = new Iox2gpkg(is3D ? 3 : 2);
            try {
                return conv.multicoord2wkb(value, srsid);
            }
            catch (Iox2wkbException ex) {
                throw new ConverterException((Throwable)ex);
            }
        }
        return null;
    }

    public Object fromIomPolyline(IomObject value, int srsid, boolean is3D, double p) throws SQLException, ConverterException {
        if (value != null) {
            Iox2gpkg conv = new Iox2gpkg(is3D ? 3 : 2);
            try {
                return conv.polyline2wkb(value, false, !this.strokeArcs, p, srsid);
            }
            catch (Iox2wkbException ex) {
                throw new ConverterException((Throwable)ex);
            }
        }
        return null;
    }

    public Object fromIomMultiPolyline(IomObject value, int srsid, boolean is3D, double p) throws SQLException, ConverterException {
        if (value != null) {
            Iox2gpkg conv = new Iox2gpkg(is3D ? 3 : 2);
            try {
                return conv.multiline2wkb(value, !this.strokeArcs, p, srsid);
            }
            catch (Iox2wkbException ex) {
                throw new ConverterException((Throwable)ex);
            }
        }
        return null;
    }

    public IomObject toIomCoord(Object geomobj, String sqlAttrName, boolean is3D) throws SQLException, ConverterException {
        byte[] bv = (byte[])geomobj;
        Gpkg2iox conv = new Gpkg2iox();
        try {
            return conv.read(bv);
        }
        catch (ParseException e) {
            throw new ConverterException((Throwable)e);
        }
    }

    public IomObject toIomMultiCoord(Object geomobj, String sqlAttrName, boolean is3D) throws SQLException, ConverterException {
        byte[] bv = (byte[])geomobj;
        Gpkg2iox conv = new Gpkg2iox();
        try {
            return conv.read(bv);
        }
        catch (ParseException e) {
            throw new ConverterException((Throwable)e);
        }
    }

    public IomObject toIomSurface(Object geomobj, String sqlAttrName, boolean is3D) throws SQLException, ConverterException {
        byte[] bv = (byte[])geomobj;
        Gpkg2iox conv = new Gpkg2iox();
        try {
            return conv.read(bv);
        }
        catch (ParseException e) {
            throw new ConverterException((Throwable)e);
        }
    }

    public IomObject toIomMultiSurface(Object geomobj, String sqlAttrName, boolean is3D) throws SQLException, ConverterException {
        byte[] bv = (byte[])geomobj;
        Gpkg2iox conv = new Gpkg2iox();
        try {
            return conv.read(bv);
        }
        catch (ParseException e) {
            throw new ConverterException((Throwable)e);
        }
    }

    public IomObject toIomPolyline(Object geomobj, String sqlAttrName, boolean is3D) throws SQLException, ConverterException {
        byte[] bv = (byte[])geomobj;
        Gpkg2iox conv = new Gpkg2iox();
        try {
            return conv.read(bv);
        }
        catch (ParseException e) {
            throw new ConverterException((Throwable)e);
        }
    }

    public IomObject toIomMultiPolyline(Object geomobj, String sqlAttrName, boolean is3D) throws SQLException, ConverterException {
        byte[] bv = (byte[])geomobj;
        Gpkg2iox conv = new Gpkg2iox();
        try {
            return conv.read(bv);
        }
        catch (ParseException e) {
            throw new ConverterException((Throwable)e);
        }
    }

    public String toIomXml(Object obj) throws SQLException, ConverterException {
        return (String)obj;
    }

    public String toIomBlob(Object obj) throws SQLException, ConverterException {
        String s = Base64.encodeBytes((byte[])((byte[])obj));
        return s;
    }

    public void setTimestamp(PreparedStatement ps, int valuei, Timestamp datetime) throws SQLException {
        SimpleDateFormat dfm = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
        dfm.setTimeZone(TimeZone.getTimeZone("GMT+0"));
        String stmp = dfm.format(datetime) + "Z";
        ps.setString(valuei, stmp);
    }

    public void setDate(PreparedStatement ps, int valuei, Date date) throws SQLException {
        SimpleDateFormat dfm = new SimpleDateFormat("yyyy-MM-dd");
        String stmp = dfm.format(date);
        ps.setString(valuei, stmp);
    }

    public void setTime(PreparedStatement ps, int valuei, Time time) throws SQLException {
        SimpleDateFormat dfm = new SimpleDateFormat("HH:mm:ss.SSS");
        String stmp = dfm.format(time);
        ps.setString(valuei, stmp);
    }

    public void setXmlNull(PreparedStatement stmt, int parameterIndex) throws SQLException {
        stmt.setNull(parameterIndex, 12);
    }

    public void setBlobNull(PreparedStatement stmt, int parameterIndex) throws SQLException {
        stmt.setNull(parameterIndex, -3);
    }
}

