/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.iox_j.logging;

import ch.ehi.basics.logging.AbstractStdListener;
import ch.ehi.basics.logging.LogEvent;
import ch.ehi.basics.logging.LogListener;
import ch.interlis.iom_j.Iom_jObject;
import ch.interlis.iox.IoxLogEvent;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import org.interlis2.validator.models.IliVErrors.ErrorLog.Error;
import org.interlis2.validator.models.IliVErrors.ErrorLog.Error_Type;

public abstract class AbstractXtfErrorsLogger
implements LogListener {
    private static final String UNDEFINED_MESSAGE = "UNDEFINED MESSAGE";
    private int objc = 1;

    public abstract void writeObject(Error var1);

    public abstract void close();

    @Override
    public void logEvent(LogEvent event) {
        Throwable ex;
        Error iomObj = new Error("o" + this.objc++);
        String msg = event.getEventMsg();
        if (msg == null && (ex = event.getException()) != null) {
            msg = ex.getLocalizedMessage();
            if (msg != null && (msg = msg.trim()).length() == 0) {
                msg = null;
            }
            if (msg == null) {
                msg = ex.getClass().getName();
            }
        }
        if (msg != null) {
            iomObj.setMessage(msg);
        } else {
            iomObj.setMessage(UNDEFINED_MESSAGE);
        }
        switch (event.getEventKind()) {
            case 7: {
                iomObj.setType(Error_Type.Error);
                break;
            }
            case 6: {
                iomObj.setType(Error_Type.Warning);
                break;
            }
            case 5: {
                iomObj.setType(Error_Type.Info);
                break;
            }
            default: {
                iomObj.setType(Error_Type.DetailInfo);
            }
        }
        if (event instanceof IoxLogEvent) {
            Integer sourceLineNr;
            String dataSource;
            String modelEleQName;
            String sourceObjectUsrId;
            String sourceObjectTechId;
            String sourceObjectXtfId;
            IoxLogEvent ioxEvent = (IoxLogEvent)((Object)event);
            String sourceObjectTag = ioxEvent.getSourceObjectTag();
            if (sourceObjectTag != null) {
                iomObj.setObjTag(sourceObjectTag);
            }
            if ((sourceObjectXtfId = ioxEvent.getSourceObjectXtfId()) != null) {
                iomObj.setTid(sourceObjectXtfId);
            }
            if ((sourceObjectTechId = ioxEvent.getSourceObjectTechId()) != null) {
                iomObj.setTechId(sourceObjectTechId);
            }
            if ((sourceObjectUsrId = ioxEvent.getSourceObjectUsrId()) != null) {
                iomObj.setUserId(sourceObjectUsrId);
            }
            if ((modelEleQName = ioxEvent.getModelEleQName()) != null) {
                iomObj.setIliQName(modelEleQName);
            }
            if ((dataSource = ioxEvent.getDataSource()) != null) {
                iomObj.setDataSource(dataSource);
            }
            if ((sourceLineNr = ioxEvent.getSourceLineNr()) != null) {
                iomObj.setLine(sourceLineNr);
            }
            if (ioxEvent.getGeomC1() != null && ioxEvent.getGeomC2() != null) {
                Iom_jObject iomCoord = new Iom_jObject("COORD", null);
                iomCoord.setattrvalue("C1", ioxEvent.getGeomC1().toString());
                iomCoord.setattrvalue("C2", ioxEvent.getGeomC2().toString());
                iomObj.addattrobj("Geometry", iomCoord);
            }
        }
        if (event.getException() != null) {
            StringBuffer details = new StringBuffer();
            AbstractXtfErrorsLogger.logThrowable(details, "", event.getException(), true);
            iomObj.setTechDetails(details.toString());
        } else if (event.getOrigin() != null) {
            iomObj.setTechDetails(AbstractStdListener.fmtOriginMsg(event.getOrigin(), ""));
        }
        this.writeObject(iomObj);
    }

    private static void logThrowable(StringBuffer out, String ind, Throwable ex, boolean doStacktrace) {
        SQLException exTarget;
        Throwable exTarget2;
        Throwable ex2;
        String msg = ex.getLocalizedMessage();
        if (msg != null && (msg = msg.trim()).length() == 0) {
            msg = null;
        }
        if (msg == null) {
            msg = ex.getClass().getName();
        }
        out.append(ind + msg + "\n");
        if (doStacktrace) {
            StackTraceElement[] stackv = ex.getStackTrace();
            for (int i = 0; i < stackv.length; ++i) {
                out.append(ind + "    " + stackv[i].toString() + "\n");
            }
        }
        if ((ex2 = ex.getCause()) != null) {
            AbstractXtfErrorsLogger.logThrowable(out, ind + "  ", ex2, doStacktrace);
        }
        if (ex instanceof SQLException && (exTarget2 = (exTarget = (SQLException)ex).getNextException()) != null) {
            AbstractXtfErrorsLogger.logThrowable(out, ind + "  ", exTarget2, doStacktrace);
        }
        if (ex instanceof InvocationTargetException && (exTarget2 = (exTarget = (InvocationTargetException)ex).getTargetException()) != null) {
            AbstractXtfErrorsLogger.logThrowable(out, ind + "  ", exTarget2, doStacktrace);
        }
    }
}

