/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.iom_j.iligml;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.basics.tools.StringUtility;
import ch.ehi.iox.objpool.ObjectPoolManager;
import ch.ehi.iox.objpool.impl.IomObjectSerializer;
import ch.interlis.ili2c.generator.Gml32Generator;
import ch.interlis.ili2c.generator.Iligml20Generator;
import ch.interlis.ili2c.generator.XSDGenerator;
import ch.interlis.ili2c.metamodel.AbstractClassDef;
import ch.interlis.ili2c.metamodel.AreaType;
import ch.interlis.ili2c.metamodel.AssociationDef;
import ch.interlis.ili2c.metamodel.AttributeDef;
import ch.interlis.ili2c.metamodel.Container;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.Extendable;
import ch.interlis.ili2c.metamodel.RoleDef;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.ili2c.metamodel.Type;
import ch.interlis.ili2c.metamodel.Viewable;
import ch.interlis.ili2c.metamodel.ViewableTransferElement;
import ch.interlis.iom.IomObject;
import ch.interlis.iom_j.ViewableProperties;
import ch.interlis.iom_j.ViewableProperty;
import ch.interlis.iom_j.iligml.FixRefs;
import ch.interlis.iom_j.xtf.Ili2cUtility;
import ch.interlis.iom_j.xtf.XtfModel;
import ch.interlis.iox.EndBasketEvent;
import ch.interlis.iox.EndTransferEvent;
import ch.interlis.iox.IoxEvent;
import ch.interlis.iox.IoxException;
import ch.interlis.iox.IoxFactoryCollection;
import ch.interlis.iox.IoxWriter;
import ch.interlis.iox.StartBasketEvent;
import ch.interlis.iox.StartTransferEvent;
import ch.interlis.iox_j.DefaultIoxFactoryCollection;
import ch.interlis.iox_j.ObjectEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class Iligml20Writer
implements IoxWriter {
    private XMLStreamWriter xout = null;
    private ObjectPoolManager recman = null;
    private ViewableProperties mapping = null;
    private XtfModel[] xtfModels = null;
    private HashMap nameMapping = null;
    private HashMap tag2class = null;
    private HashSet unkClsv = new HashSet();
    private long maxOid = 0L;
    private String currentTopic = null;
    private TransferDescription td = null;
    private IoxFactoryCollection factory = new DefaultIoxFactoryCollection();
    private String defaultCrs = "EPSG:21781";
    public static final String INTERNAL_T_ID = "_t_id";
    public static final String iligmlBase = "http://www.interlis.ch/ILIGML-2.0";
    public static final String xmlns_ili = "http://www.interlis.ch/ILIGML-2.0/INTERLIS";
    public static final String xmlns_gml = "http://www.opengis.net/gml/3.2";
    public static final String xmlns_xlink = "http://www.w3.org/1999/xlink";
    public static final String xmlns_xsi = "http://www.w3.org/2001/XMLSchema-instance";
    private static String nl = null;
    private String lastBasketNs = null;
    Map<String, IomObject> pool = null;
    private Map<String, FixRefs> fixrefs = null;
    private int tid = 1;

    public Iligml20Writer(OutputStreamWriter buffer, TransferDescription td) throws IoxException {
        this.init(td, buffer);
    }

    public Iligml20Writer(File buffer, TransferDescription td) throws IoxException {
        String encoding = "UTF-8";
        try {
            this.init(td, new OutputStreamWriter((OutputStream)new FileOutputStream(buffer), encoding));
        }
        catch (UnsupportedEncodingException ex) {
            throw new IoxException(ex);
        }
        catch (FileNotFoundException ex) {
            throw new IoxException(ex);
        }
    }

    private void init(TransferDescription td, OutputStreamWriter buffer) throws IoxException {
        this.td = td;
        this.tag2class = XSDGenerator.getTagMap(td);
        this.mapping = this.createMapping(td);
        this.nameMapping = Gml32Generator.createName2NameMapping(td);
        this.xtfModels = Ili2cUtility.buildModelList(td);
        this.recman = new ObjectPoolManager();
        XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
        try {
            this.xout = outputFactory.createXMLStreamWriter(new BufferedWriter(buffer));
            String encoding = Charset.forName(buffer.getEncoding()).name();
            this.xout.writeStartDocument(encoding, "1.0");
        }
        catch (XMLStreamException ex) {
            throw new IoxException(ex);
        }
    }

    private ViewableProperties createMapping(TransferDescription td) {
        ViewableProperties mapping = new ViewableProperties();
        HashMap tagv = Iligml20Generator.createDef2NameMapping(td);
        for (Element ili2cEle : tagv.keySet()) {
            String tag = null;
            ArrayList propv = null;
            if (ili2cEle instanceof AttributeDef) {
                AttributeDef attr = (AttributeDef)ili2cEle;
                tag = ili2cEle.getContainer().getScopedName(null) + "." + ili2cEle.getName();
                propv = Ili2cUtility.mapLinetable(attr);
            } else if (ili2cEle instanceof Viewable) {
                propv = new ArrayList();
                Viewable v = (Viewable)ili2cEle;
                tag = v.getScopedName((Container)null);
                Iterator<ViewableTransferElement> iter = Iligml20Generator.getAttributesAndRoles2(v);
                while (iter.hasNext()) {
                    ViewableTransferElement obj = iter.next();
                    ViewableProperty prop = Ili2cUtility.mapViewableTransferElement(v, obj);
                    propv.add(prop);
                }
            }
            if (tag == null) continue;
            mapping.defineClass(tag, propv.toArray(new ViewableProperty[propv.size()]));
        }
        return mapping;
    }

    public XMLStreamWriter getXout() {
        return this.xout;
    }

    @Override
    public void close() throws IoxException {
        this.flush();
        if (this.xout != null) {
            try {
                this.xout.flush();
            }
            catch (XMLStreamException ex) {
                throw new IoxException(ex);
            }
            this.xout = null;
        }
        if (this.fixrefs != null) {
            this.fixrefs = null;
        }
        if (this.pool != null) {
            this.pool.clear();
            this.pool = null;
        }
        if (this.recman != null) {
            this.recman.close();
        }
        this.recman = null;
    }

    @Override
    public void flush() throws IoxException {
        if (this.xout != null) {
            try {
                this.xout.flush();
            }
            catch (XMLStreamException ex) {
                throw new IoxException(ex);
            }
        }
    }

    public void newline() throws IoxException {
        if (nl == null) {
            nl = System.getProperty("line.separator");
        }
        try {
            this.xout.writeCharacters(nl);
        }
        catch (XMLStreamException ex) {
            throw new IoxException(ex);
        }
    }

    private void writeStartTransfer(String sender, String comment, XtfModel[] models) throws IoxException {
        try {
            this.xout.setPrefix("ili", xmlns_ili);
            this.xout.writeStartElement(xmlns_ili, "TRANSFER");
            this.xout.writeNamespace("ili", xmlns_ili);
            this.xout.writeNamespace("gml", xmlns_gml);
            this.xout.setPrefix("gml", xmlns_gml);
            this.xout.writeNamespace("xlink", xmlns_xlink);
            this.xout.setPrefix("xlink", xmlns_xlink);
            this.xout.writeNamespace("xsi", xmlns_xsi);
            this.xout.setPrefix("xsi", xmlns_xsi);
            for (int i = 0; i < models.length; ++i) {
                XtfModel model = models[i];
                if (i + 1 == models.length) {
                    this.xout.writeDefaultNamespace("http://www.interlis.ch/ILIGML-2.0/" + model.getName());
                    this.xout.setDefaultNamespace("http://www.interlis.ch/ILIGML-2.0/" + model.getName());
                    continue;
                }
                this.xout.writeNamespace(model.getName(), "http://www.interlis.ch/ILIGML-2.0/" + model.getName());
                this.xout.setPrefix(model.getName(), "http://www.interlis.ch/ILIGML-2.0/" + model.getName());
            }
            this.xout.writeAttribute(xmlns_gml, "id", this.getNewTid());
            this.newline();
        }
        catch (XMLStreamException ex) {
            throw new IoxException(ex);
        }
    }

    private void writeEndTransfer() throws IoxException {
        try {
            this.xout.writeEndElement();
            this.xout.writeEndDocument();
            this.xout.flush();
        }
        catch (XMLStreamException ex) {
            throw new IoxException(ex);
        }
        this.xout = null;
    }

    private void writeStartBasket(String type, String bid) throws IoxException {
        this.writeStartBasket(type, bid, 0, 0, null, null, null);
    }

    private void writeStartBasket(String type, String bid, int consistency, int kind, String startstate, String endstate, String[] topicv) throws IoxException {
        this.pool = this.recman.newObjectPool(this.getClass().getSimpleName(), new IomObjectSerializer());
        this.fixrefs = new HashMap<String, FixRefs>();
        this.currentTopic = type;
        try {
            this.xout.writeStartElement(xmlns_ili, "baskets");
            this.newline();
            this.lastBasketNs = this.getXmlNs(type);
            this.xout.writeStartElement(this.lastBasketNs, this.getXmlName(type));
            this.xout.writeAttribute(xmlns_gml, "id", this.makeOid(bid));
            if (kind != 0 && kind != 2) {
                throw new IllegalArgumentException();
            }
            if (consistency != 0) {
                throw new IllegalArgumentException();
            }
            this.newline();
        }
        catch (XMLStreamException ex) {
            throw new IoxException(ex);
        }
    }

    private void writeEndBasket() throws IoxException {
        String modelName = null;
        String topicName = null;
        int mdlNameSep = this.currentTopic.indexOf(46);
        modelName = this.currentTopic.substring(0, mdlNameSep);
        topicName = this.currentTopic.substring(mdlNameSep + 1);
        this.fixReverseLinks();
        this.fixrefs = null;
        this.flushBasket(modelName, topicName);
        this.pool.clear();
        this.pool = null;
        try {
            this.xout.writeEndElement();
            this.newline();
            this.xout.writeEndElement();
            this.newline();
            this.lastBasketNs = null;
        }
        catch (XMLStreamException ex) {
            throw new IoxException(ex);
        }
    }

    private void fixReverseLinks() throws IoxException {
        for (String tid : this.fixrefs.keySet()) {
            FixRefs fixref = this.fixrefs.get(tid);
            IomObject sourceObj = this.pool.get(fixref.getSourceTid());
            if (sourceObj == null) {
                throw new IoxException("unknown object with OID " + fixref.getSourceTid());
            }
            for (String targetRole : fixref.getTargetRoles()) {
                for (String targetTid : fixref.getTargetTids(targetRole)) {
                    sourceObj.addattrobj(targetRole, "REF").setobjectrefoid(targetTid);
                }
            }
        }
    }

    private void flushBasket(String modelName, String topicName) throws IoxException {
        for (String objId : this.pool.keySet()) {
            IomObject iomObj = this.pool.get(objId);
            this.writeInternalObject(iomObj);
        }
    }

    private void writeObject(IomObject iomObj) throws IoxException {
        String currentTid = iomObj.getobjectoid();
        String iliQName = iomObj.getobjecttag();
        if (this.pool.containsKey(currentTid)) {
            throw new IoxException("duplicate tid " + currentTid + " in " + iliQName);
        }
        this.pool.put(currentTid, iomObj);
        this.addReferencesInReferencedObjs(currentTid, iomObj);
        try {
            int tidInt = Integer.parseInt(currentTid);
            if ((long)tidInt > this.maxOid) {
                this.maxOid = tidInt;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void addReferencesInReferencedObjs(String tid, IomObject iomObj) {
        this.allReferencesKnownHelper(tid, iomObj);
    }

    private void allReferencesKnownHelper(String thisOid, IomObject iomObj) {
        String tag = iomObj.getobjecttag();
        Object modelele = this.tag2class.get(tag);
        if (modelele == null) {
            return;
        }
        Viewable aclass = (Viewable)modelele;
        Iterator<ViewableTransferElement> iter = aclass.getAttributesAndRoles2();
        while (iter.hasNext()) {
            RoleDef oppend;
            IomObject targetObj;
            RoleDef role;
            ViewableTransferElement obj = iter.next();
            if (obj.obj instanceof AttributeDef) {
                // empty if block
            }
            if (!(obj.obj instanceof RoleDef) || (role = (RoleDef)obj.obj).getExtending() != null) continue;
            String roleName = role.getName();
            if (obj.embedded) {
                IomObject structvalue;
                RoleDef oppend2;
                AssociationDef roleOwner = (AssociationDef)role.getContainer();
                if (roleOwner.getDerivedFrom() != null || (oppend2 = role.getOppEnd()).isExternal() || (structvalue = iomObj.getattrobj(roleName, 0)) == null) continue;
                String refoid = structvalue.getobjectrefoid();
                AbstractClassDef targetClass = role.getDestination();
                targetObj = this.getIomObject(refoid);
                if (targetObj != null) {
                    targetObj.addattrobj(oppend2.getName(), "REF").setobjectrefoid(thisOid);
                    continue;
                }
                this.addRefFix(refoid, oppend2.getName(), thisOid);
                continue;
            }
            if (!role.hasOneOppEnd() || (oppend = role.getOppEnd()).isExternal()) continue;
            String oppendName = oppend.getName();
            String oppendoid = iomObj.getattrobj(oppendName, 0).getobjectrefoid();
            IomObject structvalue = iomObj.getattrobj(roleName, 0);
            String refoid = structvalue.getobjectrefoid();
            targetObj = this.getIomObject(refoid);
            if (targetObj != null) {
                targetObj.addattrobj(oppendName, "REF").setobjectrefoid(oppendoid);
                continue;
            }
            this.addRefFix(refoid, oppend.getName(), oppendoid);
        }
    }

    private void addRefFix(String fromOid, String byRoleName, String toOid) {
        FixRefs fixref = this.fixrefs.get(fromOid);
        if (fixref == null) {
            fixref = new FixRefs(fromOid);
            this.fixrefs.put(fromOid, fixref);
        }
        fixref.addRef(byRoleName, toOid);
    }

    private IomObject getIomObject(String oid) {
        if (this.pool.containsKey(oid)) {
            return this.pool.get(oid);
        }
        return null;
    }

    private void writeInternalObject(IomObject iomObj) throws IoxException {
        String currentTid = iomObj.getobjectoid();
        String iliQName = iomObj.getobjecttag();
        try {
            this.xout.writeStartElement(this.lastBasketNs, "member");
            this.xout.writeStartElement(this.getXmlNs(iliQName), this.getXmlName(iliQName));
            this.xout.writeAttribute(xmlns_gml, "id", this.makeOid(currentTid));
            this.writeObjAttrs(iomObj);
            this.xout.writeEndElement();
            this.xout.writeEndElement();
            this.newline();
        }
        catch (XMLStreamException ex) {
            throw new IoxException(ex);
        }
    }

    private void writeObjAttrs(IomObject obj) throws IoxException {
        String tag = obj.getobjecttag();
        if (this.mapping != null && this.mapping.existsClass(tag)) {
            ViewableProperty[] attrv = this.mapping.getClassVProperties(tag);
            for (int i = 0; i < attrv.length; ++i) {
                this.writeObjAttr(obj, attrv[i]);
            }
        } else {
            if (!this.unkClsv.contains(tag)) {
                EhiLogger.logError("unknown class " + tag);
                this.unkClsv.add(tag);
            }
            for (int i = 0; i < obj.getattrcount(); ++i) {
                this.writeObjAttr(obj, new ViewableProperty(obj.getattrname(i)));
            }
        }
    }

    private void writeObjAttr(IomObject obj, ViewableProperty attr) throws IoxException {
        String xmlns_attr = this.getXmlNs(obj.getobjecttag());
        String baseAttrInClass = attr.getBaseDefInClass();
        if (baseAttrInClass != null) {
            xmlns_attr = this.getXmlNs(baseAttrInClass);
        }
        String attrName = attr.getName();
        try {
            int valueCount = obj.getattrvaluecount(attrName);
            if (valueCount > 0) {
                String val = obj.getattrprim(attrName, 0);
                if (val == null) {
                    for (int valuei = 0; valuei < valueCount; ++valuei) {
                        boolean isRef;
                        IomObject child = obj.getattrobj(attrName, 0);
                        if (child == null) continue;
                        if (child.getobjecttag().equals("COORD")) {
                            this.xout.writeStartElement(xmlns_attr, attrName);
                            this.writeCoord(child, this.getDefaultCrs());
                            this.xout.writeEndElement();
                            if (valueCount <= 1) continue;
                            throw new IoxException("max one COORD value allowed (" + attrName + ")");
                        }
                        if (child.getobjecttag().equals("POLYLINE")) {
                            if (attrName.startsWith("_itf_geom_")) {
                                this.xout.writeStartElement(xmlns_attr, "geometry");
                            } else {
                                this.xout.writeStartElement(xmlns_attr, attrName);
                            }
                            this.writePolyline(child, false, this.getDefaultCrs());
                            this.xout.writeEndElement();
                            if (valueCount <= 1) continue;
                            throw new IoxException("max one POLYLINE value allowed (" + attrName + ")");
                        }
                        if (child.getobjecttag().equals("MULTISURFACE")) {
                            this.xout.writeStartElement(xmlns_attr, attrName);
                            this.writeSurface(child, this.getDefaultCrs());
                            this.xout.writeEndElement();
                            if (valueCount <= 1) continue;
                            throw new IoxException("max one MULTISURFACE value allowed (" + attrName + ")");
                        }
                        String aref = child.getobjectrefoid();
                        boolean bl = isRef = aref != null;
                        if (isRef) {
                            String orderpos = null;
                            if (child.getobjectreforderpos() > 0L) {
                                orderpos = Long.toString(child.getobjectreforderpos());
                            }
                            String extref = null;
                            String bid = child.getobjectrefbid();
                            if (bid != null) {
                                extref = aref;
                                aref = null;
                            }
                            this.xout.writeStartElement(xmlns_attr, attrName);
                            if (aref != null) {
                                this.xout.writeAttribute(xmlns_xlink, "href", "#" + this.makeOid(aref));
                            } else {
                                this.xout.writeAttribute(xmlns_xlink, "href", "#" + this.makeOid(extref));
                            }
                            this.writeAttributeStringOptional(xmlns_ili, "ORDER_POS", orderpos);
                            this.xout.writeEndElement();
                            if (child.getattrcount() <= 0) continue;
                            this.xout.writeStartElement(xmlns_attr, attrName + "." + "LINK_DATA");
                            String structType = child.getobjecttag();
                            String structTid = child.getobjectoid();
                            if (structTid == null) {
                                structTid = this.getNewTid();
                            }
                            this.xout.writeStartElement(this.getXmlNs(structType), this.getXmlName(structType));
                            this.xout.writeAttribute(xmlns_gml, "id", structTid);
                            this.writeObjAttrs(child);
                            this.xout.writeEndElement();
                            this.xout.writeEndElement();
                            continue;
                        }
                        this.xout.writeStartElement(xmlns_attr, attrName);
                        String structType = child.getobjecttag();
                        String structTid = child.getobjectoid();
                        if (structTid == null) {
                            structTid = this.getNewTid();
                        }
                        this.xout.writeStartElement(this.getXmlNs(structType), this.getXmlName(structType));
                        this.xout.writeAttribute(xmlns_gml, "id", structTid);
                        this.writeObjAttrs(child);
                        this.xout.writeEndElement();
                        this.xout.writeEndElement();
                    }
                } else {
                    if (attr.getEnumType() != null && !attr.isTypeFinal()) {
                        if ((val = StringUtility.purge(val)) != null) {
                            this.xout.writeStartElement(xmlns_attr, attrName);
                            String type = attr.getEnumType();
                            String codeSpace = null;
                            int pos = type.lastIndexOf(58);
                            if (pos > 0) {
                                String enumAttrDef = type.substring(pos + 1);
                                type = type.substring(0, pos);
                                codeSpace = this.getXmlNs(type) + "/" + this.getXmlName(type) + "/" + enumAttrDef;
                            } else {
                                codeSpace = this.getXmlNs(type) + "/" + this.getXmlName(type);
                            }
                            this.xout.writeAttribute("codeSpace", codeSpace);
                            this.xout.writeCharacters(val);
                            this.xout.writeEndElement();
                        }
                    } else {
                        this.writeElementStringOptional(xmlns_attr, attrName, val);
                    }
                    if (valueCount > 1) {
                        throw new IoxException("max one primitive-type value allowed (" + attrName + ")");
                    }
                }
            }
        }
        catch (XMLStreamException ex) {
            throw new IoxException(ex);
        }
    }

    private void writeCoord(IomObject obj, String srs) throws IoxException {
        try {
            this.xout.writeStartElement(xmlns_gml, "Point");
            String structTid = obj.getobjectoid();
            if (structTid == null) {
                structTid = this.getNewTid();
            }
            this.xout.writeAttribute(xmlns_gml, "id", structTid);
            if (srs != null) {
                this.xout.writeAttribute("srsName", srs);
            }
            this.xout.writeStartElement(xmlns_gml, "pos");
            this.writePosContent(obj);
            this.xout.writeEndElement();
            this.xout.writeEndElement();
        }
        catch (XMLStreamException ex) {
            throw new IoxException(ex);
        }
    }

    private void writePosContent(IomObject obj) throws XMLStreamException {
        String c1 = obj.getattrprim("C1", 0);
        this.xout.writeCharacters(c1);
        String c2 = obj.getattrprim("C2", 0);
        if (c2 != null) {
            this.xout.writeCharacters(" ");
            this.xout.writeCharacters(c2);
            String c3 = obj.getattrprim("C3", 0);
            if (c3 != null) {
                this.xout.writeCharacters(" ");
                this.xout.writeCharacters(c3);
            }
        }
    }

    private void writePolyline(IomObject obj, boolean hasLineAttr, String srs) throws IoxException {
        try {
            boolean clipped;
            IomObject lineattr;
            this.xout.writeStartElement(xmlns_gml, "Curve");
            String structTid = obj.getobjectoid();
            if (structTid == null) {
                structTid = this.getNewTid();
            }
            this.xout.writeAttribute(xmlns_gml, "id", structTid);
            if (srs != null) {
                this.xout.writeAttribute("srsName", srs);
            }
            this.xout.writeStartElement(xmlns_gml, "segments");
            if (hasLineAttr && (lineattr = obj.getattrobj("lineattr", 0)) != null) {
                this.xout.writeStartElement(xmlns_ili, "LINEATTR");
                this.xout.writeStartElement(xmlns_ili, lineattr.getobjecttag());
                this.writeObjAttrs(lineattr);
                this.xout.writeEndElement();
                this.xout.writeEndElement();
            }
            boolean bl = clipped = obj.getobjectconsistency() == 1;
            if (clipped) {
                throw new IoxException("clipped polyline not supported");
            }
            for (int sequencei = 0; sequencei < obj.getattrvaluecount("sequence"); ++sequencei) {
                if (!clipped && sequencei > 0) {
                    throw new IllegalArgumentException("unclipped polyline with multi 'sequence' elements");
                }
                IomObject sequence = obj.getattrobj("sequence", sequencei);
                int segmentc = sequence.getattrvaluecount("segment");
                for (int segmenti = 0; segmenti < segmentc; ++segmenti) {
                    IomObject lastSegment;
                    IomObject segment = sequence.getattrobj("segment", segmenti);
                    if (segment.getobjecttag().equals("COORD")) {
                        if (segmenti == 0 && !sequence.getattrobj("segment", segmenti + 1).getobjecttag().equals("COORD")) continue;
                        if (segmenti == 0 || !sequence.getattrobj("segment", segmenti - 1).getobjecttag().equals("COORD")) {
                            this.xout.writeStartElement(xmlns_gml, "LineStringSegment");
                            this.xout.writeAttribute("interpolation", "linear");
                            this.xout.writeStartElement(xmlns_gml, "posList");
                            if (segmenti > 0) {
                                lastSegment = sequence.getattrobj("segment", segmenti - 1);
                                this.writePosContent(lastSegment);
                                this.xout.writeCharacters(" ");
                            }
                        } else {
                            this.xout.writeCharacters(" ");
                        }
                        this.writePosContent(segment);
                        if (segmenti + 1 != segmentc && sequence.getattrobj("segment", segmenti + 1).getobjecttag().equals("COORD")) continue;
                        this.xout.writeEndElement();
                        this.xout.writeEndElement();
                        continue;
                    }
                    if (segment.getobjecttag().equals("ARC")) {
                        this.xout.writeStartElement(xmlns_gml, "Arc");
                        this.xout.writeAttribute("numArc", "1");
                        this.xout.writeAttribute("interpolation", "circularArc3Points");
                        this.xout.writeStartElement(xmlns_gml, "posList");
                        lastSegment = sequence.getattrobj("segment", segmenti - 1);
                        this.writePosContent(lastSegment);
                        this.xout.writeCharacters(" ");
                        String a1 = segment.getattrprim("A1", 0);
                        String a2 = segment.getattrprim("A2", 0);
                        this.xout.writeCharacters(" ");
                        this.xout.writeCharacters(a1);
                        this.xout.writeCharacters(" ");
                        this.xout.writeCharacters(a2);
                        this.xout.writeCharacters(" ");
                        this.writePosContent(segment);
                        this.xout.writeEndElement();
                        this.xout.writeEndElement();
                        continue;
                    }
                    throw new IoxException("custum line form not supported (" + segment.getobjecttag() + ")");
                }
            }
            this.xout.writeEndElement();
            this.xout.writeEndElement();
        }
        catch (XMLStreamException ex) {
            throw new IoxException(ex);
        }
    }

    private void writeSurface(IomObject obj, String srs) throws IoxException {
        try {
            boolean clipped;
            this.xout.writeStartElement(xmlns_gml, "Polygon");
            String structTid = obj.getobjectoid();
            if (structTid == null) {
                structTid = this.getNewTid();
            }
            this.xout.writeAttribute(xmlns_gml, "id", structTid);
            if (srs != null) {
                this.xout.writeAttribute("srsName", srs);
            }
            boolean bl = clipped = obj.getobjectconsistency() == 1;
            if (clipped) {
                throw new IoxException("clipped surface not supported");
            }
            for (int surfacei = 0; surfacei < obj.getattrvaluecount("surface"); ++surfacei) {
                if (!clipped && surfacei > 0) {
                    throw new IllegalArgumentException("unclipped surface with multi 'surface' elements");
                }
                IomObject surface = obj.getattrobj("surface", surfacei);
                for (int boundaryi = 0; boundaryi < surface.getattrvaluecount("boundary"); ++boundaryi) {
                    IomObject boundary = surface.getattrobj("boundary", boundaryi);
                    if (boundaryi == 0) {
                        this.xout.writeStartElement(xmlns_gml, "exterior");
                        this.xout.writeStartElement(xmlns_gml, "Ring");
                    } else {
                        this.xout.writeStartElement(xmlns_gml, "interior");
                        this.xout.writeStartElement(xmlns_gml, "Ring");
                    }
                    for (int polylinei = 0; polylinei < boundary.getattrvaluecount("polyline"); ++polylinei) {
                        IomObject polyline = boundary.getattrobj("polyline", polylinei);
                        this.xout.writeStartElement(xmlns_gml, "curveMember");
                        this.writePolyline(polyline, true, null);
                        this.xout.writeEndElement();
                    }
                    this.xout.writeEndElement();
                    this.xout.writeEndElement();
                }
            }
            this.xout.writeEndElement();
        }
        catch (XMLStreamException ex) {
            throw new IoxException(ex);
        }
    }

    private void writeElementStringOptional(String nsuri, String name, String value) throws IoxException {
        try {
            String v;
            if (value != null && (v = value.trim()).length() > 0) {
                this.xout.writeStartElement(nsuri, name);
                this.xout.writeCharacters(v);
                this.xout.writeEndElement();
            }
        }
        catch (XMLStreamException ex) {
            throw new IoxException(ex);
        }
    }

    private void writeAttributeStringOptional(String nsuri, String name, String value) throws IoxException {
        try {
            String v;
            if (value != null && (v = value.trim()).length() > 0) {
                this.xout.writeAttribute(nsuri, name, v);
            }
        }
        catch (XMLStreamException ex) {
            throw new IoxException(ex);
        }
    }

    private String getXmlNs(String type) {
        int pos = type.indexOf(46);
        String ret = "http://www.interlis.ch/ILIGML-2.0/" + type.substring(0, pos);
        return ret;
    }

    private String getXmlName(String type) {
        if (!this.nameMapping.containsKey(type)) {
            throw new IllegalArgumentException();
        }
        String ret = (String)this.nameMapping.get(type);
        return ret;
    }

    private String makeOid(String value) {
        String v;
        if (value != null && (v = value.trim()).length() > 0) {
            if (Character.isDigit(v.charAt(0))) {
                return "x" + v;
            }
            return v;
        }
        return null;
    }

    private String getNewTid() {
        return "iox" + Integer.toString(this.tid++);
    }

    private void getPolygonAttrs(Viewable aclass, ArrayList<AttributeDef> attrs_areaAttrs) {
        Iterator<Extendable> attri = aclass.getAttributes();
        while (attri.hasNext()) {
            AttributeDef attr;
            Type type;
            Extendable attrObj = attri.next();
            if (!(attrObj instanceof AttributeDef) || !((type = Type.findReal((attr = (AttributeDef)attrObj).getDomain())) instanceof AreaType)) continue;
            attrs_areaAttrs.add(attr);
        }
    }

    @Override
    public IomObject createIomObject(String type, String oid) throws IoxException {
        return this.factory.createIomObject(type, oid);
    }

    @Override
    public IoxFactoryCollection getFactory() throws IoxException {
        return this.factory;
    }

    @Override
    public void setFactory(IoxFactoryCollection arg0) throws IoxException {
        this.factory = this.factory;
    }

    @Override
    public void write(IoxEvent event) throws IoxException {
        if (event instanceof StartTransferEvent) {
            StartTransferEvent e = (StartTransferEvent)event;
            this.writeStartTransfer(e.getSender(), e.getComment(), this.xtfModels);
        } else if (event instanceof StartBasketEvent) {
            StartBasketEvent e = (StartBasketEvent)event;
            this.writeStartBasket(e.getType(), e.getBid(), e.getConsistency(), e.getKind(), e.getStartstate(), e.getEndstate(), e.getTopicv());
        } else if (event instanceof ObjectEvent) {
            ObjectEvent e = (ObjectEvent)event;
            this.writeObject(e.getIomObject());
        } else if (event instanceof EndBasketEvent) {
            this.writeEndBasket();
        } else if (event instanceof EndTransferEvent) {
            this.writeEndTransfer();
        } else {
            throw new IoxException("unknown event type " + event.getClass().getName());
        }
    }

    public void setDefaultCrs(String defaultCrs) {
        this.defaultCrs = defaultCrs;
    }

    public String getDefaultCrs() {
        return this.defaultCrs;
    }
}

