/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c.metamodel;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.basics.settings.Settings;
import ch.interlis.ili2c.metamodel.Container;
import ch.interlis.ili2c.metamodel.ElementAlias;
import ch.interlis.ili2c.metamodel.ErrorMessages;
import ch.interlis.ili2c.metamodel.Extendable;
import ch.interlis.ili2c.metamodel.Ili2cSemanticException;
import ch.interlis.ili2c.metamodel.Model;
import ch.interlis.ili2c.metamodel.Topic;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.ili2c.metamodel.Viewable;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.beancontext.BeanContext;
import java.lang.reflect.Array;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;

public abstract class Element
implements ElementAlias {
    static final ResourceBundle rsrc = ResourceBundle.getBundle(ErrorMessages.class.getName(), Locale.getDefault());
    private String documentation = null;
    private Settings metaValues = null;
    private boolean dirty = false;
    private int sourceLine = 0;
    private final int defidx = _defidx++;
    private static int _defidx = 0;
    private Container container = null;
    private Element nextElement;
    private String alias;
    private Element baseLanguageElement = null;

    static final String formatMessage(String msg, Object[] args) {
        try {
            MessageFormat mess = new MessageFormat(rsrc.getString(msg));
            return mess.format(args);
        }
        catch (Exception ex) {
            return "Internal compiler error [" + ex.getLocalizedMessage() + "]";
        }
    }

    static Ili2cSemanticException checkElementRef(Element ele1, Element ele2, int sourceLine, String msg) {
        if (!Element.equalElementRef(ele1, ele2)) {
            return new Ili2cSemanticException(sourceLine, Element.formatMessage(msg));
        }
        return null;
    }

    static boolean equalElementRef(Element ele1, Element ele2) {
        if (ele1 != null || ele2 != null) {
            if (ele1 == null || ele2 == null) {
                return false;
            }
            if (ele1.getTranslationOfOrSame() != ele2.getTranslationOfOrSame()) {
                return false;
            }
        }
        return true;
    }

    static final String formatMessage(String msg) {
        return Element.formatMessage(msg, "");
    }

    public static final String formatMessage(String msg, String arg) {
        return Element.formatMessage(msg, new Object[]{arg});
    }

    static final String formatMessage(String msg, String arg1, String arg2) {
        return Element.formatMessage(msg, new Object[]{arg1, arg2});
    }

    static final String formatMessage(String msg, String arg1, String arg2, String arg3) {
        return Element.formatMessage(msg, new Object[]{arg1, arg2, arg3});
    }

    static final String formatMessage(String msg, String arg1, String arg2, String arg3, String arg4) {
        return Element.formatMessage(msg, new Object[]{arg1, arg2, arg3, arg4});
    }

    static final String formatMessage(String msg, String arg1, String arg2, String arg3, String arg4, String arg5) {
        return Element.formatMessage(msg, new Object[]{arg1, arg2, arg3, arg4, arg5});
    }

    static final String formatMessage(String msg, String arg1, String arg2, String arg3, String arg4, String arg5, String arg6) {
        return Element.formatMessage(msg, new Object[]{arg1, arg2, arg3, arg4, arg5, arg6});
    }

    public boolean isDependentOn(Element other) {
        return false;
    }

    public final void setBeanContext(BeanContext bc) throws PropertyVetoException {
        throw new UnsupportedOperationException();
    }

    public final BeanContext getBeanContext() {
        throw new UnsupportedOperationException();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
    }

    public void addVetoableChangeListener(String propertyName, VetoableChangeListener listener) {
    }

    public void removeVetoableChangeListener(String propertyName, VetoableChangeListener listener) {
    }

    protected void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }

    protected void firePropertyChange(String propertyName, int oldValue, int newValue) {
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
    }

    protected void fireVetoableChange(String propertyName, boolean oldValue, boolean newValue) throws PropertyVetoException {
    }

    protected void fireVetoableChange(String propertyName, Object oldValue, Object newValue) throws PropertyVetoException {
    }

    protected static <E> E[] retrieveAllInstancesOf(Iterator<?> it, Class<E> clazz) {
        LinkedList l = new LinkedList();
        while (it.hasNext()) {
            Object o = it.next();
            if (!clazz.isInstance(o)) continue;
            l.add(o);
        }
        return l.toArray((Object[])Array.newInstance(clazz, l.size()));
    }

    public final Container<?> getContainer(Class<?> klass) {
        for (Container bc = this.getContainer(); bc != null; bc = bc.getContainer()) {
            if (!klass.isInstance(bc)) continue;
            return bc;
        }
        return null;
    }

    public Container getContainer() {
        return this.container;
    }

    public final void setContainer(Container c) {
        this.container = c;
    }

    public String getName() {
        return null;
    }

    public String getScopedName(Container<?> scope) {
        Model enclosingModel = (Model)this.getContainer(Model.class);
        if (enclosingModel == null) {
            return this.getName();
        }
        Topic enclosingTopic = (Topic)this.getContainer(Topic.class);
        Viewable enclosingClass = (Viewable)this.getContainer(Viewable.class);
        if (scope == null) {
            return this.getContainer().getScopedName() + "." + this.getName();
        }
        Model scopeModel = (Model)scope.getContainerOrSame(Model.class);
        Topic scopeTopic = (Topic)scope.getContainerOrSame(Topic.class);
        Viewable scopeClass = (Viewable)scope.getContainerOrSame(Viewable.class);
        if (scopeClass != null && scopeClass == enclosingClass) {
            return this.getName();
        }
        if (scopeTopic != null && scopeTopic == enclosingTopic) {
            if (enclosingClass == null) {
                return this.getName();
            }
            if (scopeClass == null) {
                return enclosingClass.getName() + "." + this.getName();
            }
        }
        if (scopeModel != null && scopeModel == enclosingModel && enclosingTopic == null) {
            return this.getName();
        }
        return this.getContainer().getScopedName() + "." + this.getName();
    }

    public String getScopedName() {
        return this.getScopedName(null);
    }

    public Element[] getElementPath() {
        ArrayList<Element> path = new ArrayList<Element>();
        path.add(this);
        for (Container parent = this.getContainer(); parent != null && !(parent instanceof TransferDescription); parent = parent.getContainer()) {
            path.add(0, parent);
        }
        return path.toArray(new Element[path.size()]);
    }

    protected static final void checkNameSanity(String s, boolean emptyStringIsOK) throws IllegalArgumentException {
        if (s == null) {
            throw new IllegalArgumentException();
        }
        int len = s.length();
        if (!emptyStringIsOK && len == 0) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < len; ++i) {
            char curChar = s.charAt(i);
            if (curChar != ' ') continue;
            throw new IllegalArgumentException(Element.formatMessage("err_name_withSpaces", s));
        }
    }

    protected void checkNameUniqueness(String proposedName, Class klass, Element acceptable, String errorKey) {
        Container<?> container = this.getContainer(Container.class);
        if (container == null) {
            return;
        }
        Element conflicting = container.getRealElement(klass, proposedName);
        if (conflicting == null || conflicting == this || conflicting == acceptable) {
            return;
        }
        throw new IllegalArgumentException(Element.formatMessage(errorKey, proposedName, container.toString(), conflicting.toString()));
    }

    public static final String makeErrorName(Element elt) {
        if (elt == null) {
            return rsrc.getString("err_dumpErrorName");
        }
        return elt.toString();
    }

    public void checkIntegrity(List<Ili2cSemanticException> errs) throws IllegalStateException {
    }

    public Container getCommonContainer(Element elt) {
        if (elt == null) {
            return null;
        }
        for (Container myCtr = this.getContainer(); myCtr != null; myCtr = myCtr.getContainer()) {
            for (Container eltCtr = elt.getContainer(); eltCtr != null; eltCtr = eltCtr.getContainer()) {
                if (eltCtr != myCtr) continue;
                return myCtr;
            }
        }
        return null;
    }

    public boolean isDeclaredBefore(Element elt) {
        Container commonContainer = this.getCommonContainer(elt);
        if (commonContainer == null) {
            return false;
        }
        Iterator iter = commonContainer.iterator();
        while (iter.hasNext()) {
            Element curElt = (Element)iter.next();
            if (curElt == this || curElt instanceof Container && ((Container)curElt).containsIndirectly(this)) {
                return true;
            }
            if (curElt != elt && (!(curElt instanceof Container) || !((Container)curElt).containsIndirectly(elt))) continue;
            return false;
        }
        throw new IllegalStateException("Internal error; check ch.interlis.Element.isDeclaredBefore");
    }

    public boolean canAccess(Element other) {
        if (other == null) {
            throw new IllegalArgumentException();
        }
        if (this == other) {
            return true;
        }
        if (!other.isDeclaredBefore(this)) {
            return false;
        }
        Model myModel = this instanceof Model ? (Model)this : (Model)this.getContainer(Model.class);
        Model otherModel = other instanceof Model ? (Model)other : (Model)other.getContainer(Model.class);
        if (myModel == null || otherModel == null) {
            return false;
        }
        return myModel == otherModel || myModel.isImporting(otherModel);
    }

    public Set<Extendable> getAccessiblePolymorphicEquivalents(Extendable forExtendable) {
        if (forExtendable == null) {
            return new HashSet<Extendable>();
        }
        Set result = forExtendable.getExtensions();
        result.add(forExtendable);
        Iterator iter = result.iterator();
        while (iter.hasNext()) {
            Element elt = (Element)iter.next();
            if (this.canAccess(elt)) continue;
            iter.remove();
        }
        return result;
    }

    public boolean checkStructuralEquivalence(Element with) {
        if (this.isAlias()) {
            return this.getReal().checkStructuralEquivalence(with);
        }
        if (with == null) {
            return false;
        }
        if (this.getClass() != with.getClass()) {
            EhiLogger.logError(Element.formatMessage("err_diff_mismatchInClass", this.toString(), with.toString()));
            return false;
        }
        return true;
    }

    protected boolean checkStructuralEquivalenceOfArrays(Element with, Element[] myArray, Element[] withArray, String numElementMismatchMessageKey) {
        if (myArray == null || withArray == null || with == null) {
            return false;
        }
        if (myArray.length != withArray.length) {
            EhiLogger.logError(Element.formatMessage(numElementMismatchMessageKey, this.toString(), with.toString()));
            return false;
        }
        boolean fine = true;
        for (int i = 0; i < myArray.length; ++i) {
            if (myArray[i] == null != (withArray[i] == null)) {
                fine = false;
            }
            if (myArray[i] == null || myArray[i].checkStructuralEquivalence(withArray[i])) continue;
            fine = false;
        }
        return fine;
    }

    @Override
    public Element getNext() {
        return this.nextElement;
    }

    protected void setNext(Element nextElement) {
        this.nextElement = nextElement;
    }

    @Override
    public Element getReal() {
        Element real = this;
        while (real.getNext() != null) {
            real = real.getNext();
        }
        return real;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @Override
    public void setAlias(String alias) {
        this.alias = alias;
    }

    @Override
    public boolean isAlias() {
        return this.alias != null;
    }

    @Override
    public ElementAlias createAlias(String alias) {
        return null;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public void setDocumentation(String string) {
        this.documentation = string;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean b) {
        this.dirty = b;
    }

    public int getSourceLine() {
        return this.sourceLine;
    }

    public void setSourceLine(int sourceLine) {
        this.sourceLine = sourceLine;
    }

    public Settings getMetaValues() {
        if (this.metaValues == null) {
            this.metaValues = new Settings();
        }
        return this.metaValues;
    }

    public void setMetaValues(Settings metaValues) {
        this.metaValues = metaValues;
    }

    public String getMetaValue(String name) {
        return this.getMetaValues().getValue(name);
    }

    public void setMetaValue(String name, String value) {
        this.getMetaValues().setValue(name, value);
    }

    public Object getTransientMetaValue(String name) {
        return this.getMetaValues().getTransientObject(name);
    }

    public void setTransientMetaValue(String name, Object value) {
        this.getMetaValues().setTransientObject(name, value);
    }

    public int getDefidx() {
        return this.defidx;
    }

    public Element getTranslationOf() {
        return this.baseLanguageElement;
    }

    public Element getTranslationOfOrSame() {
        if (this.baseLanguageElement == null) {
            return this;
        }
        return this.baseLanguageElement.getTranslationOfOrSame();
    }

    public Element getElementInRootLanguage() {
        Element ele = this;
        Element baseLanguageElement = ele.getTranslationOf();
        while (baseLanguageElement != null) {
            ele = baseLanguageElement;
            baseLanguageElement = ele.getTranslationOf();
        }
        return ele;
    }

    protected void linkTranslationOf(Element baseElement) {
        if (baseElement == this) {
            throw new IllegalArgumentException("base element must be different from translated element " + this.getScopedName());
        }
        this.baseLanguageElement = baseElement;
    }

    protected void checkTranslationOf(List<Ili2cSemanticException> errs, String name, String baseName) {
    }
}

