/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.iox_j.validator.functions;

import ch.ehi.iox.objpool.impl.ObjPoolImpl2;
import ch.interlis.ili2c.Ili2cException;
import ch.interlis.ili2c.metamodel.AttributeDef;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.EnumerationType;
import ch.interlis.ili2c.metamodel.Evaluable;
import ch.interlis.ili2c.metamodel.Function;
import ch.interlis.ili2c.metamodel.FunctionCall;
import ch.interlis.ili2c.metamodel.NumericType;
import ch.interlis.ili2c.metamodel.Projection;
import ch.interlis.ili2c.metamodel.RoleDef;
import ch.interlis.ili2c.metamodel.TextType;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.ili2c.metamodel.Type;
import ch.interlis.ili2c.metamodel.Viewable;
import ch.interlis.ili2c.parser.Ili23Parser;
import ch.interlis.iom.IomObject;
import ch.interlis.iox_j.logging.LogEventFactory;
import ch.interlis.iox_j.validator.ObjectPool;
import ch.interlis.iox_j.validator.Validator;
import ch.interlis.iox_j.validator.Value;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ObjectPoolFunctions {
    private final Validator validator;
    private final ObjectPool objectPool;
    private final LogEventFactory logger;
    private final TransferDescription td;
    private final HashMap<String, SoftReference<List<IomObject>>> allObjectsCache = new HashMap();
    public static final String OBJECTPOOL = "ObjectPool_V1_0";

    public ObjectPoolFunctions(Validator validator, TransferDescription td, ObjectPool objectPool, LogEventFactory logger) {
        this.validator = validator;
        this.objectPool = objectPool;
        this.logger = logger;
        this.td = td;
    }

    public Value evaluateFunction(Function currentFunction, FunctionCall functionCallObj, IomObject parentObject, String validationKind, String usageScope, IomObject iomObj, TextType texttype, RoleDef firstRole) {
        Evaluable[] arguments = functionCallObj.getArguments();
        Value[] actualArguments = new Value[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            Value result = this.validator.evaluateExpression(parentObject, validationKind, usageScope, iomObj, arguments[i], firstRole);
            if (result.skipEvaluation()) {
                return result;
            }
            actualArguments[i] = result;
        }
        if (currentFunction.getName().equals("allObjects")) {
            return this.evaluateAllObjects(validationKind, usageScope, iomObj, actualArguments);
        }
        if (currentFunction.getName().equals("filter")) {
            return this.evaluateFilter(validationKind, usageScope, iomObj, actualArguments);
        }
        return Value.createNotYetImplemented();
    }

    private Value evaluateAllObjects(String validationKind, String usageScope, IomObject iomObj, Value[] actualArguments) {
        List<IomObject> cachedObjects;
        Viewable viewable = actualArguments[0].getViewable();
        if (viewable == null) {
            this.logger.addEvent(this.logger.logErrorMsg("Missing ObjectClass argument for allObjects", new String[0]));
            return Value.createUndefined();
        }
        String cacheKey = viewable.getScopedName();
        SoftReference<List<IomObject>> cachedRefence = this.allObjectsCache.get(cacheKey);
        List<IomObject> list = cachedObjects = cachedRefence == null ? null : cachedRefence.get();
        if (cachedObjects != null) {
            return new Value(cachedObjects);
        }
        Projection projection = null;
        Viewable objectClass = viewable;
        if (viewable instanceof Projection) {
            projection = (Projection)viewable;
            objectClass = projection.getSelected().getAliasing();
        }
        String className = objectClass.getScopedName();
        ArrayList<IomObject> objects = new ArrayList<IomObject>();
        for (String basketId : this.objectPool.getDataBids()) {
            ObjPoolImpl2 basketObjectPool = this.objectPool.getObjectsOfBasketId(basketId);
            Iterator valueIterator = basketObjectPool.valueIterator();
            while (valueIterator.hasNext()) {
                IomObject object = (IomObject)valueIterator.next();
                if (!object.getobjecttag().equals(className) || projection != null && !this.validator.viewIncludesObject(projection, object)) continue;
                objects.add(object);
            }
        }
        this.allObjectsCache.put(cacheKey, new SoftReference(objects));
        return new Value(objects);
    }

    private Value evaluateFilter(String validationKind, String usageScope, IomObject iomObect, Value[] actualArguments) {
        Value argObjects = actualArguments[0];
        Value argFilter = actualArguments[1];
        if (argObjects.isUndefined() || argObjects.getComplexObjects() == null || argFilter.isUndefined() || argFilter.getValue() == null) {
            return Value.createUndefined();
        }
        Collection<IomObject> objects = argObjects.getComplexObjects();
        if (objects.isEmpty()) {
            return argObjects;
        }
        Viewable<?> objectClass = ObjectPoolFunctions.getCommonBaseClass(this.td, objects);
        if (objectClass == null) {
            this.logger.addEvent(this.logger.logErrorMsg("Objects have no common base class in " + usageScope, new String[0]));
            return Value.createUndefined();
        }
        String expression = this.resolveAttributesInExpression(iomObect, argFilter.getValue());
        this.logger.addEvent(this.logger.logDetailInfoMsg("Resolved filter expression: " + expression, new String[0]));
        if (expression == null) {
            return Value.createUndefined();
        }
        Evaluable filter = this.parseLogicExpression(objectClass, expression, usageScope);
        if (filter == null) {
            return Value.createUndefined();
        }
        ArrayList<IomObject> filteredObjects = new ArrayList<IomObject>();
        for (IomObject object : objects) {
            Value value = this.validator.evaluateExpression(null, validationKind, usageScope, object, filter, null);
            if (value.skipEvaluation() || !value.isTrue()) continue;
            filteredObjects.add(object);
        }
        return new Value(filteredObjects);
    }

    private Evaluable parseLogicExpression(Viewable<?> viewable, String expression, String usageScope) {
        Type booleanType = Type.findReal(this.td.INTERLIS.BOOLEAN.getType());
        try {
            return Ili23Parser.parseExpression(this.td, expression, viewable, booleanType, null);
        }
        catch (Ili2cException e) {
            this.logger.addEvent(this.logger.logErrorMsg("Failed to parse filter expression in " + usageScope + ": " + e.getMessage(), new String[0]));
            return null;
        }
    }

    private static Viewable<?> getCommonBaseClass(TransferDescription td, Collection<IomObject> objects) {
        if (objects.isEmpty()) {
            return null;
        }
        HashSet<String> classNames = new HashSet<String>();
        for (IomObject obj : objects) {
            classNames.add(obj.getobjecttag());
        }
        Viewable<?> firstClass = (Viewable<?>)td.getElement((String)classNames.iterator().next());
        if (classNames.size() == 1) {
            return firstClass;
        }
        Viewable<?> commonBaseClass = firstClass;
        for (String className : classNames) {
            Viewable classViewable = (Viewable)td.getElement(className);
            commonBaseClass = ObjectPoolFunctions.getCommonBaseClass(commonBaseClass, classViewable);
        }
        return commonBaseClass;
    }

    private static Viewable<?> getCommonBaseClass(Viewable<?> classA, Viewable<?> classB) {
        if (classA == null || classB == null) {
            return null;
        }
        for (Viewable currentClass = classA; currentClass != null; currentClass = (Viewable)currentClass.getExtending()) {
            if (currentClass != classB && !classB.isExtending(currentClass)) continue;
            return currentClass;
        }
        return null;
    }

    private String resolveAttributesInExpression(IomObject iomObject, String expression) {
        if (expression == null || iomObject == null) {
            return expression;
        }
        Element element = this.td.getElement(iomObject.getobjecttag());
        if (!(element instanceof Viewable)) {
            this.logger.addEvent(this.logger.logErrorMsg("Element '" + iomObject.getobjecttag() + "' is not a Viewable type.", new String[0]));
            return null;
        }
        Viewable viewable = (Viewable)element;
        Pattern pattern = Pattern.compile("\\{([^}]+)}");
        Matcher matcher = pattern.matcher(expression);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String attrName = matcher.group(1);
            AttributeDef attributeDef = viewable.findAttribute(attrName);
            if (attributeDef == null) {
                this.logger.addEvent(this.logger.logErrorMsg("Could not find attribute '" + attrName + "' in class '" + viewable.getScopedName() + "'", new String[0]));
                return null;
            }
            Type type = attributeDef.getDomainResolvingAll();
            String attrValue = iomObject.getattrvalue(attrName);
            if (type instanceof EnumerationType) {
                attrValue = attrValue == null ? "UNDEFINED" : "#" + attrValue;
            } else if (type instanceof TextType) {
                attrValue = attrValue == null ? "UNDEFINED" : '\"' + attrValue + '\"';
            } else if (type instanceof NumericType) {
                attrValue = attrValue == null ? "UNDEFINED" : attrValue;
            } else {
                this.logger.addEvent(this.logger.logErrorMsg("Unsupported attribute type for attribute '" + attrName + "' in class '" + viewable.getScopedName() + "'", new String[0]));
                return null;
            }
            String replacement = Matcher.quoteReplacement(attrValue);
            matcher.appendReplacement(sb, replacement);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }
}

