/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.iox_j.filter;

import ch.ehi.basics.settings.Settings;
import ch.interlis.ili2c.generator.XSDGenerator;
import ch.interlis.ili2c.metamodel.AbstractClassDef;
import ch.interlis.ili2c.metamodel.AttributeDef;
import ch.interlis.ili2c.metamodel.CompositionType;
import ch.interlis.ili2c.metamodel.Container;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.EnumTreeValueType;
import ch.interlis.ili2c.metamodel.Enumeration;
import ch.interlis.ili2c.metamodel.EnumerationType;
import ch.interlis.ili2c.metamodel.Model;
import ch.interlis.ili2c.metamodel.ObjectType;
import ch.interlis.ili2c.metamodel.RoleDef;
import ch.interlis.ili2c.metamodel.Table;
import ch.interlis.ili2c.metamodel.Topic;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.ili2c.metamodel.Type;
import ch.interlis.ili2c.metamodel.Viewable;
import ch.interlis.ili2c.metamodel.ViewableTransferElement;
import ch.interlis.iom.IomObject;
import ch.interlis.iom_j.itf.ModelUtilities;
import ch.interlis.iox.EndBasketEvent;
import ch.interlis.iox.EndTransferEvent;
import ch.interlis.iox.IoxEvent;
import ch.interlis.iox.IoxException;
import ch.interlis.iox.IoxLogging;
import ch.interlis.iox.IoxValidationDataPool;
import ch.interlis.iox.ObjectEvent;
import ch.interlis.iox.StartBasketEvent;
import ch.interlis.iox.StartTransferEvent;
import ch.interlis.iox_j.filter.IoxFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ReduceToBaseModel
implements IoxFilter {
    private IoxLogging loggingHandler = null;
    private TransferDescription td = null;
    private boolean doItfLineTables = false;
    private List<Model> destModels = null;
    private HashMap<String, Object> tag2class = null;
    private HashMap<String, Topic> tag2topic = new HashMap();
    private HashMap<String, Object> srctag2destElement = new HashMap();
    private HashMap<Topic, ArrayList<Topic>> topicTranslatedBy = new HashMap();
    Map<Type, Map<String, String>> src2destEles = new HashMap<Type, Map<String, String>>();
    private Topic srcTopic;
    private Topic destTopic;

    public ReduceToBaseModel(List<Model> exportModels, TransferDescription td, Settings config) {
        this.td = td;
        this.destModels = exportModels;
        this.doItfLineTables = "doItfLinetables".equals(config.getValue("ch.interlis.iox_j.validator.doItfLinetables"));
        this.tag2class = this.doItfLineTables ? ModelUtilities.getTagMap(td) : XSDGenerator.getTagMap(td);
        Iterator models = td.iterator();
        while (models.hasNext()) {
            Model model = (Model)models.next();
            Iterator topics = model.iterator();
            while (topics.hasNext()) {
                Topic originTopic;
                Element topic = (Element)topics.next();
                if (!(topic instanceof Topic)) continue;
                this.tag2topic.put(topic.getScopedName(), (Topic)topic);
                ArrayList<Topic> translatedBy = this.topicTranslatedBy.get(topic);
                if (translatedBy == null) {
                    translatedBy = new ArrayList();
                    this.topicTranslatedBy.put((Topic)topic, translatedBy);
                }
                if ((originTopic = (Topic)topic.getTranslationOf()) == null) continue;
                translatedBy = this.topicTranslatedBy.get(originTopic);
                translatedBy.add((Topic)topic);
            }
        }
    }

    private void setupTranslation(Topic srcTopic) {
        Topic destTopic = srcTopic;
        do {
            if (this.destModels.contains(destTopic.getContainer(Model.class))) {
                this.setupTopicTranslation(srcTopic, destTopic);
                return;
            }
            List<Topic> destTopics = this.getTranslationsOf(destTopic);
            for (Topic d : destTopics) {
                if (!this.destModels.contains(d.getContainer(Model.class))) continue;
                this.setupTopicTranslation(srcTopic, d);
                return;
            }
        } while ((destTopic = (Topic)destTopic.getExtending()) != null);
    }

    private List<Topic> getTranslationsOf(Topic start) {
        ArrayList<Topic> ret = new ArrayList<Topic>();
        ArrayList<Topic> queue = new ArrayList<Topic>();
        Topic topic = (Topic)start.getTranslationOfOrSame();
        queue.add(topic);
        ret.add(topic);
        while (queue.size() > 0) {
            topic = (Topic)queue.remove(0);
            ArrayList<Topic> translatedBy = this.topicTranslatedBy.get(topic);
            for (Topic t : translatedBy) {
                if (ret.contains(t)) continue;
                ret.add(t);
            }
            queue.addAll(translatedBy);
        }
        ret.remove(start);
        return ret;
    }

    private void setupTopicTranslation(Topic srcTopic, Topic destTopic) {
        this.srctag2destElement.put(srcTopic.getScopedName(), destTopic);
        if (srcTopic == destTopic) {
            return;
        }
        Topic originDestTopic = (Topic)destTopic.getTranslationOfOrSame();
        while (srcTopic != null) {
            Element srcEle;
            Iterator eleIt;
            if ((srcTopic.isExtending(destTopic) || srcTopic.getTranslationOfOrSame() == originDestTopic) && srcTopic != destTopic) {
                eleIt = srcTopic.iterator();
                while (eleIt.hasNext()) {
                    AbstractClassDef originSrcEle;
                    AbstractClassDef originDestEle;
                    srcEle = (Element)eleIt.next();
                    if (!(srcEle instanceof AbstractClassDef)) continue;
                    for (originDestEle = originSrcEle = (AbstractClassDef)srcEle.getTranslationOfOrSame(); originDestEle != null && originDestEle.getContainer() != originDestTopic; originDestEle = (AbstractClassDef)originDestEle.getExtending()) {
                    }
                    AbstractClassDef destEle = null;
                    if (originDestEle != null && !originDestEle.isAbstract()) {
                        destEle = this.findTranslatedEle(originDestEle, destTopic);
                        if (destEle == null) {
                            throw new IllegalStateException("destEle " + originDestEle.getScopedName() + " in " + destTopic.getScopedName() + "not found");
                        }
                        this.srctag2destElement.put(srcEle.getScopedName(), destEle);
                        if (srcEle == destEle) continue;
                        this.setupClassTranslation((AbstractClassDef)srcEle, destEle);
                        continue;
                    }
                    this.srctag2destElement.put(srcEle.getScopedName(), null);
                }
            } else {
                eleIt = srcTopic.iterator();
                while (eleIt.hasNext()) {
                    srcEle = (Element)eleIt.next();
                    if (!(srcEle instanceof AbstractClassDef)) continue;
                    AbstractClassDef destEle = (AbstractClassDef)srcEle;
                    this.srctag2destElement.put(srcEle.getScopedName(), destEle);
                }
            }
            srcTopic = (Topic)srcTopic.getExtending();
        }
    }

    private AbstractClassDef findTranslatedEle(AbstractClassDef originDestEle, Topic destTopic) {
        Iterator eleIt = destTopic.iterator();
        while (eleIt.hasNext()) {
            AbstractClassDef originEle;
            Element destEle = (Element)eleIt.next();
            if (!(destEle instanceof AbstractClassDef) || (originEle = (AbstractClassDef)destEle.getTranslationOfOrSame()) != originDestEle) continue;
            return (AbstractClassDef)destEle;
        }
        return null;
    }

    private void setupClassTranslation(AbstractClassDef srcEle, AbstractClassDef destEle) {
        HashMap<String, ViewableTransferElement> destAttrs = new HashMap<String, ViewableTransferElement>();
        Iterator<ViewableTransferElement> destPropIt = destEle.getAttributesAndRoles2();
        while (destPropIt.hasNext()) {
            ViewableTransferElement destProp = destPropIt.next();
            String destOriginPropName = ((Element)destProp.obj).getTranslationOfOrSame().getName();
            destAttrs.put(destOriginPropName, destProp);
        }
        Iterator<ViewableTransferElement> srcPropIt = srcEle.getAttributesAndRoles2();
        while (srcPropIt.hasNext()) {
            ViewableTransferElement srcProp = srcPropIt.next();
            String srcOriginPropName = ((Element)srcProp.obj).getTranslationOfOrSame().getName();
            if (destAttrs.containsKey(srcOriginPropName)) {
                this.srctag2destElement.put(((Element)srcProp.obj).getScopedName(), ((ViewableTransferElement)destAttrs.get((Object)srcOriginPropName)).obj);
                continue;
            }
            this.srctag2destElement.put(((Element)srcProp.obj).getScopedName(), null);
        }
    }

    private void setupStructMapping(Table srcStruct, Table destStruct) {
        if (this.srctag2destElement.containsKey(srcStruct.getScopedName())) {
            return;
        }
        Container destContainer = destStruct;
        Container srcContainer = srcStruct;
        do {
            destContainer = destContainer.getContainer();
            if (this.srctag2destElement.containsKey((srcContainer = srcContainer.getContainer()).getScopedName())) continue;
            if (srcContainer instanceof Topic) {
                this.setupTopicTranslation((Topic)srcContainer, (Topic)destContainer);
                continue;
            }
            Iterator it = destContainer.iterator();
            Iterator srcIt = srcContainer.iterator();
            while (it.hasNext() && srcIt.hasNext()) {
                Element destEle = (Element)it.next();
                Element srcEle = (Element)srcIt.next();
                if (!(destEle instanceof Table) || ((Table)destEle).isIdentifiable() || this.srctag2destElement.containsKey(srcEle.getScopedName())) continue;
                this.srctag2destElement.put(srcEle.getScopedName(), destEle);
                if (srcEle == destEle) continue;
                this.setupClassTranslation((Table)srcEle, (Table)destEle);
            }
        } while (!(destContainer instanceof Model));
    }

    @Override
    public IoxEvent filter(IoxEvent event) throws IoxException {
        if (!(event instanceof StartTransferEvent)) {
            if (event instanceof StartBasketEvent) {
                String srcTopicName = ((StartBasketEvent)event).getType();
                this.srcTopic = this.tag2topic.get(srcTopicName);
                this.resetMapping();
                this.setupTranslation(this.srcTopic);
                this.destTopic = (Topic)this.getTranslatedElement(this.srcTopic);
                if (this.destTopic != this.srcTopic && this.destTopic != null) {
                    ((ch.interlis.iox_j.StartBasketEvent)event).setType(this.destTopic.getScopedName());
                }
            } else if (event instanceof ObjectEvent) {
                if (this.destTopic != this.srcTopic && this.destTopic != null) {
                    IomObject iomObj = ((ObjectEvent)event).getIomObject();
                    if (this.srctag2destElement.get(iomObj.getobjecttag()) == null) {
                        return null;
                    }
                    this.translateObject(iomObj);
                }
            } else if (event instanceof EndBasketEvent || event instanceof EndTransferEvent) {
                // empty if block
            }
        }
        return event;
    }

    private void resetMapping() {
        this.srctag2destElement = new HashMap();
        this.src2destEles = new HashMap<Type, Map<String, String>>();
    }

    private void translateObject(IomObject iomObj) {
        Element modelElement = (Element)this.tag2class.get(iomObj.getobjecttag());
        Element destModelEle = this.getTranslatedElement(modelElement);
        if (destModelEle == modelElement) {
            return;
        }
        if (!this.doItfLineTables || modelElement instanceof AttributeDef) {
            // empty if block
        }
        Viewable aclass = (Viewable)modelElement;
        Viewable destClass = (Viewable)destModelEle;
        String destName = destClass.getScopedName();
        iomObj.setobjecttag(destName);
        Iterator<ViewableTransferElement> iter = aclass.getAttributesAndRoles2();
        while (iter.hasNext()) {
            ViewableTransferElement srcProp = iter.next();
            Element destEle = (Element)this.srctag2destElement.get(((Element)srcProp.obj).getScopedName());
            if (destEle == null) {
                iomObj.setattrundefined(((Element)srcProp.obj).getName());
                continue;
            }
            if (srcProp.obj instanceof AttributeDef) {
                Type proxyType;
                AttributeDef attr = (AttributeDef)srcProp.obj;
                if (attr.isTransient() || (proxyType = attr.getDomain()) != null && proxyType instanceof ObjectType) continue;
                this.translateAttrValue(iomObj, attr);
                continue;
            }
            if (!(srcProp.obj instanceof RoleDef)) continue;
            RoleDef srcRole = (RoleDef)srcProp.obj;
            RoleDef destRole = (RoleDef)this.getTranslatedElement(srcRole);
            String srcRoleName = srcRole.getName();
            if (iomObj.getattrvaluecount(srcRoleName) <= 0) continue;
            IomObject structvalue = iomObj.getattrobj(srcRoleName, 0);
            iomObj.deleteattrobj(srcRoleName, 0);
            iomObj.addattrobj(destRole.getName(), structvalue);
        }
    }

    private Element getTranslatedElement(Element modelElement) {
        String scopedName = modelElement.getScopedName();
        if (this.srctag2destElement.containsKey(scopedName)) {
            return (Element)this.srctag2destElement.get(scopedName);
        }
        return modelElement;
    }

    private void translateAttrValue(IomObject iomObj, AttributeDef srcAttr) {
        IomObject structValue;
        String attrValue;
        int attri;
        String srcAttrName = srcAttr.getName();
        int attrc = iomObj.getattrvaluecount(srcAttrName);
        if (attrc == 0) {
            return;
        }
        boolean isCompType = srcAttr.getDomain() instanceof CompositionType;
        boolean isEnumType = srcAttr.getDomainResolvingAliases() instanceof EnumerationType;
        boolean isEnumAllType = srcAttr.getDomainResolvingAliases() instanceof EnumTreeValueType;
        EnumerationType srcEnumType = null;
        EnumTreeValueType srcEnumAllType = null;
        if (isEnumType) {
            srcEnumType = (EnumerationType)srcAttr.getDomainResolvingAliases();
        } else if (isEnumAllType) {
            srcEnumAllType = (EnumTreeValueType)srcAttr.getDomainResolvingAliases();
        }
        AttributeDef destAttr = (AttributeDef)this.srctag2destElement.get(srcAttr.getScopedName());
        String destAttrName = destAttr.getName();
        ArrayList<Object> attrValues = new ArrayList<Object>();
        for (attri = 0; attri < attrc; ++attri) {
            attrValue = iomObj.getattrprim(srcAttrName, attri);
            if (attrValue != null) {
                attrValues.add(attrValue);
                continue;
            }
            structValue = iomObj.getattrobj(srcAttrName, attri);
            attrValues.add(structValue);
        }
        iomObj.setattrundefined(srcAttrName);
        for (attri = 0; attri < attrc; ++attri) {
            attrValue = attrValues.get(attri);
            if (attrValue == null) continue;
            if (attrValue instanceof String) {
                if (isEnumType) {
                    attrValue = this.translateEnumValue(attrValue, srcEnumType, (EnumerationType)destAttr.getDomainResolvingAliases());
                } else if (isEnumAllType) {
                    attrValue = this.translateEnumAllValue(attrValue, srcEnumAllType, (EnumTreeValueType)destAttr.getDomainResolvingAliases());
                }
                iomObj.setattrvalue(destAttrName, attrValue);
                continue;
            }
            structValue = (IomObject)((Object)attrValue);
            if (isCompType) {
                this.setupStructMapping(((CompositionType)srcAttr.getDomain()).getComponentType(), ((CompositionType)destAttr.getDomain()).getComponentType());
                this.translateObject(structValue);
            }
            iomObj.addattrobj(destAttrName, structValue);
        }
    }

    private String translateEnumValue(String attrValue, EnumerationType srcEnumType, EnumerationType destEnumType) {
        Map<String, String> src2dest = this.getEnumMapping(srcEnumType, destEnumType);
        String destValue = src2dest.get(attrValue);
        return destValue;
    }

    private String translateEnumAllValue(String attrValue, EnumTreeValueType srcEnumType, EnumTreeValueType destEnumType) {
        Map<String, String> src2dest = this.getEnumAllMapping(srcEnumType, destEnumType);
        String destValue = src2dest.get(attrValue);
        return destValue;
    }

    private Map<String, String> getEnumMapping(EnumerationType srcEnumType, EnumerationType destEnumType) {
        Map<String, String> src2dest = this.src2destEles.get(srcEnumType);
        if (src2dest == null) {
            src2dest = new HashMap<String, String>();
            ReduceToBaseModel.buildEnumList(src2dest, "", srcEnumType.getConsolidatedEnumeration(), "", destEnumType.getConsolidatedEnumeration(), null);
            this.src2destEles.put(srcEnumType, src2dest);
        }
        return src2dest;
    }

    private Map<String, String> getEnumAllMapping(EnumTreeValueType srcEnumType, EnumTreeValueType destEnumType) {
        Map<String, String> src2dest = this.src2destEles.get(srcEnumType);
        if (src2dest == null) {
            src2dest = new HashMap<String, String>();
            ReduceToBaseModel.buildEnumAllList(src2dest, "", srcEnumType.getConsolidatedEnumeration(), "", destEnumType.getConsolidatedEnumeration(), null);
            this.src2destEles.put(srcEnumType, src2dest);
        }
        return src2dest;
    }

    public static void buildEnumList(Map<String, String> accu, String srcPrefix1, Enumeration srcEnumer, String destPrefix1, Enumeration destEnumer, String destEeName) {
        ReduceToBaseModel.buildEnumList(accu, srcPrefix1, srcEnumer, destPrefix1, destEnumer, destEeName, false);
    }

    public static void buildEnumAllList(Map<String, String> accu, String srcPrefix1, Enumeration srcEnumer, String destPrefix1, Enumeration destEnumer, String destEeName) {
        ReduceToBaseModel.buildEnumList(accu, srcPrefix1, srcEnumer, destPrefix1, destEnumer, destEeName, true);
    }

    private static void buildEnumList(Map<String, String> accu, String srcPrefix1, Enumeration srcEnumer, String destPrefix1, Enumeration destEnumer, String destEeName, boolean includeNonLeaf) {
        String srcPrefix = "";
        String destPrefix = "";
        if (srcPrefix1.length() > 0) {
            srcPrefix = srcPrefix1 + ".";
        }
        if (destPrefix1 != null && destPrefix1.length() > 0) {
            destPrefix = destPrefix1 + ".";
        }
        Iterator<Enumeration.Element> srcIter = srcEnumer.getElements();
        Iterator<Enumeration.Element> destIter = null;
        if (destEnumer != null) {
            destIter = destEnumer.getElements();
        }
        while (srcIter.hasNext()) {
            Enumeration.Element srcEe = srcIter.next();
            Enumeration srcSubEnum = srcEe.getSubEnumeration();
            Enumeration destSubEnum = null;
            Enumeration.Element destEe = null;
            if (destIter != null) {
                destEe = destIter.next();
                destSubEnum = destEe.getSubEnumeration();
                destEeName = destPrefix + destEe.getName();
            }
            if (srcSubEnum != null) {
                if (destSubEnum != null) {
                    ReduceToBaseModel.buildEnumList(accu, srcPrefix + srcEe.getName(), srcSubEnum, destPrefix + destEe.getName(), destSubEnum, null, includeNonLeaf);
                } else {
                    ReduceToBaseModel.buildEnumList(accu, srcPrefix + srcEe.getName(), srcSubEnum, null, null, destEeName, includeNonLeaf);
                }
            }
            if (srcSubEnum != null && !includeNonLeaf) continue;
            accu.put(srcPrefix + srcEe.getName(), destEeName);
        }
    }

    @Override
    public void close() {
        this.loggingHandler = null;
    }

    @Override
    public IoxLogging getLoggingHandler() {
        return this.loggingHandler;
    }

    @Override
    public void setLoggingHandler(IoxLogging errs) {
        this.loggingHandler = errs;
    }

    @Override
    public IoxValidationDataPool getDataPool() {
        return null;
    }
}

