/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2fme;

import COM.safe.fme.pluginbuilder.IFMEMappingFile;
import COM.safe.fme.pluginbuilder.IFMEReader;
import COM.safe.fmeobjects.FMEException;
import COM.safe.fmeobjects.IFMEArea;
import COM.safe.fmeobjects.IFMEFeature;
import COM.safe.fmeobjects.IFMEGeometry;
import COM.safe.fmeobjects.IFMELogFile;
import COM.safe.fmeobjects.IFMEMultiArea;
import COM.safe.fmeobjects.IFMEMultiCurve;
import COM.safe.fmeobjects.IFMEMultiPoint;
import COM.safe.fmeobjects.IFMEPath;
import COM.safe.fmeobjects.IFMEPoint;
import COM.safe.fmeobjects.IFMESession;
import COM.safe.fmeobjects.IFMEStringArray;
import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.basics.settings.Settings;
import ch.ehi.basics.tools.StringUtility;
import ch.ehi.basics.types.OutParam;
import ch.ehi.basics.view.GenericFileFilter;
import ch.ehi.fme.Main;
import ch.ehi.iox.adddefval.ItfAddDefValueReader;
import ch.interlis.ili2c.Ili2c;
import ch.interlis.ili2c.Ili2cException;
import ch.interlis.ili2c.config.Configuration;
import ch.interlis.ili2c.generator.XSDGenerator;
import ch.interlis.ili2c.metamodel.AbstractClassDef;
import ch.interlis.ili2c.metamodel.AbstractCoordType;
import ch.interlis.ili2c.metamodel.AreaType;
import ch.interlis.ili2c.metamodel.AssociationDef;
import ch.interlis.ili2c.metamodel.AttributeDef;
import ch.interlis.ili2c.metamodel.BasketType;
import ch.interlis.ili2c.metamodel.BlackboxType;
import ch.interlis.ili2c.metamodel.CompositionType;
import ch.interlis.ili2c.metamodel.Container;
import ch.interlis.ili2c.metamodel.CoordType;
import ch.interlis.ili2c.metamodel.Domain;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.EnumerationType;
import ch.interlis.ili2c.metamodel.Extendable;
import ch.interlis.ili2c.metamodel.FormattedType;
import ch.interlis.ili2c.metamodel.LineType;
import ch.interlis.ili2c.metamodel.Model;
import ch.interlis.ili2c.metamodel.MultiAreaType;
import ch.interlis.ili2c.metamodel.MultiCoordType;
import ch.interlis.ili2c.metamodel.MultiPolylineType;
import ch.interlis.ili2c.metamodel.MultiSurfaceOrAreaType;
import ch.interlis.ili2c.metamodel.MultiSurfaceType;
import ch.interlis.ili2c.metamodel.NumericType;
import ch.interlis.ili2c.metamodel.NumericalType;
import ch.interlis.ili2c.metamodel.PolylineType;
import ch.interlis.ili2c.metamodel.PrecisionDecimal;
import ch.interlis.ili2c.metamodel.ReferenceType;
import ch.interlis.ili2c.metamodel.RoleDef;
import ch.interlis.ili2c.metamodel.SurfaceOrAreaType;
import ch.interlis.ili2c.metamodel.SurfaceType;
import ch.interlis.ili2c.metamodel.Table;
import ch.interlis.ili2c.metamodel.TextType;
import ch.interlis.ili2c.metamodel.Topic;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.ili2c.metamodel.Type;
import ch.interlis.ili2c.metamodel.TypeAlias;
import ch.interlis.ili2c.metamodel.Viewable;
import ch.interlis.ili2c.metamodel.ViewableTransferElement;
import ch.interlis.ili2fme.ConfigException;
import ch.interlis.ili2fme.CreateEnumFeatureTypes;
import ch.interlis.ili2fme.DataException;
import ch.interlis.ili2fme.FmeLogListener;
import ch.interlis.ili2fme.FmeUtility;
import ch.interlis.ili2fme.GeomAttrIterator;
import ch.interlis.ili2fme.GeomAttrMapping;
import ch.interlis.ili2fme.GeometryConverter;
import ch.interlis.ili2fme.GeometryEncoding;
import ch.interlis.ili2fme.InheritanceMapping;
import ch.interlis.ili2fme.Iox2fme;
import ch.interlis.ili2fme.LinetableMapping;
import ch.interlis.ili2fme.ModelUtility;
import ch.interlis.ili2fme.StructWrapper;
import ch.interlis.ili2fme.ViewableWrapper;
import ch.interlis.ilirepository.IliManager;
import ch.interlis.iom.IomObject;
import ch.interlis.iom_j.Iom_jObject;
import ch.interlis.iom_j.itf.ItfReader;
import ch.interlis.iom_j.itf.ItfReader2;
import ch.interlis.iom_j.itf.ModelUtilities;
import ch.interlis.iom_j.xtf.OidSpace;
import ch.interlis.iom_j.xtf.XtfStartTransferEvent;
import ch.interlis.iox.EndBasketEvent;
import ch.interlis.iox.EndTransferEvent;
import ch.interlis.iox.IoxEvent;
import ch.interlis.iox.IoxException;
import ch.interlis.iox.IoxReader;
import ch.interlis.iox.ObjectEvent;
import ch.interlis.iox.StartBasketEvent;
import ch.interlis.iox.StartTransferEvent;
import ch.interlis.iox_j.IoxIliReader;
import ch.interlis.iox_j.IoxInvalidDataException;
import ch.interlis.iox_j.PipelinePool;
import ch.interlis.iox_j.inifile.MetaConfig;
import ch.interlis.iox_j.jts.Iox2jts;
import ch.interlis.iox_j.jts.Iox2jtsException;
import ch.interlis.iox_j.logging.Log2EhiLogger;
import ch.interlis.iox_j.logging.LogEventFactory;
import ch.interlis.iox_j.utility.IoxUtility;
import ch.interlis.iox_j.utility.ReaderFactory;
import ch.interlis.iox_j.validator.ValidationConfig;
import ch.interlis.iox_j.validator.Validator;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Ili2Reader
implements IFMEReader {
    private IFMEMappingFile mappingFile = null;
    private IFMESession session = null;
    private ArrayList<IoxInvalidDataException> dataerrs = null;
    private String readerKeyword = null;
    private TransferDescription iliTd = null;
    private ArrayList<String> iliModelv = null;
    private HashMap tag2class = null;
    private Map<String, ViewableWrapper> transferViewables = null;
    private Iterator<String> transferViewablei = null;
    private HashSet<ViewableWrapper> seenFmeTypes = null;
    private IFMEFeature pendingSchemaFeature = null;
    private IFMEFeature pendingMaintableFeature = null;
    private AttributeDef pendingMaintableFeatureAttribute;
    private boolean skipBasket = false;
    private HashSet<String> topicFilterv = null;
    private int formatFeatureTypeIdx = 0;
    private static final int FORMAT_FEATURETYPE_XTFTRANSFER = 0;
    private static final int FORMAT_FEATURETYPE_XTFBASKETS = 1;
    private static final int FORMAT_FEATURETYPE_XTFDELETEOBJECT = 2;
    private static final int FORMAT_FEATURETYPE_XTFERRORS = 3;
    private static final int FORMAT_FEATURETYPE_ENUMS = 4;
    private String xtfFile = null;
    private IoxReader ioxReader = null;
    private InputStream inputFile = null;
    private String currentBid = null;
    private int basketSeq = 1;
    private int iliQNameSize = 0;
    private int formatMode = 0;
    private static final int MODE_XTF = 1;
    private static final int MODE_ITF = 2;
    private int itfMode = 1;
    private Boolean v6_createLineTableFeatures = null;
    private Boolean v6_skipPolygonBuilding = null;
    private boolean ili1AddDefVal = false;
    private boolean doRichGeometry = false;
    private int inheritanceMapping = 1;
    private boolean ili1EnumAsItfCode = false;
    private boolean ili1IgnorePolygonBuildingErrors = false;
    private int createEnumTypes = 1;
    private boolean checkUniqueOid = false;
    private String metaConfig = null;
    private Validator validator = null;
    private boolean validate = false;
    private String validationConfig = null;
    private boolean validateMultiplicity = false;
    private boolean trimValues = true;
    private boolean ili1RenumberTid = false;
    private GeometryConverter geomConv = null;
    private int geometryEncoding = 1;
    private int geomAttrMapping = 1;
    private IFMELogFile fmeLog = null;
    private static final String ERR_FEATURETYPE_PREFIX = "ERR.";
    private static final String ERRMSG_ATTRIBUTE = "_errmsg";
    HashMap checkoids = null;
    private GeomAttrIterator geomAttrIterator = null;
    private HashMap typeCache = new HashMap();
    private ArrayList structQueue = null;
    private FmeLogListener listener = null;
    private ArrayList enumDefs = null;
    private Iterator enumDefi = null;
    private Element currentEnumDef = null;
    private int currentEnumItfCode = 0;
    private int currentEnumSeq = 0;
    private Iterator currentEnumElementIterator = null;

    public Ili2Reader(IFMESession session1, IFMEMappingFile mappingFile1, String keyword, IFMELogFile log) {
        this.mappingFile = mappingFile1;
        this.readerKeyword = keyword;
        this.session = session1;
        this.fmeLog = log;
    }

    public void open(ArrayList args) throws Exception {
        this.listener = Main.setupLogging(this.fmeLog);
        try {
            this.myopen(args);
        }
        catch (Exception ex) {
            EhiLogger.logError(ex);
            throw ex;
        }
    }

    public void myopen(ArrayList args) throws Exception {
        String fmeUseRichGeometry;
        int entc;
        IFMEStringArray settings;
        if (args.size() == 0) {
            throw new IllegalArgumentException("args.size()==0");
        }
        for (int i = 0; i < args.size(); ++i) {
            String arg = (String)args.get(i);
            if (!arg.equals("TRACEMSGS")) continue;
            EhiLogger.getInstance().setTraceFilter(!FmeUtility.isTrue((String)args.get(++i)));
            break;
        }
        Iterator elei = this.mappingFile.elements();
        while (elei.hasNext()) {
            ArrayList ele;
            String val;
            Object eleo = elei.next();
            if (!(eleo instanceof ArrayList) || !(val = (String)(ele = (ArrayList)eleo).get(0)).equals(this.readerKeyword + "_" + "TRACEMSGS")) continue;
            EhiLogger.getInstance().setTraceFilter(!FmeUtility.isTrue((String)ele.get(1)));
            break;
        }
        int fme_buildnr = this.session.fmeBuildNumber();
        this.doRichGeometry = false;
        if (fme_buildnr >= 5608) {
            settings = this.session.createStringArray();
            this.session.getSettings("FME_GEOMETRY_HANDLING", settings);
            entc = settings.entries();
            if (entc >= 1 && (fmeUseRichGeometry = settings.getElement(0)).equals("Enhanced")) {
                this.doRichGeometry = true;
            }
        } else {
            settings = this.session.createStringArray();
            this.session.getSettings("FME_USE_RICH_GEOMETRY", settings);
            entc = settings.entries();
            if (entc == 1 && (fmeUseRichGeometry = settings.getElement(0)).equals("yes")) {
                this.doRichGeometry = true;
            }
        }
        if (!this.doRichGeometry) {
            EhiLogger.logState("ili2fme reader uses classic geometry handling");
        } else {
            EhiLogger.logState("ili2fme reader uses enhanced geometry handling");
        }
        EhiLogger.traceState("readerKeyword <" + this.readerKeyword + ">");
        String httpProxyHost = null;
        String httpProxyPort = null;
        String models = null;
        String modeldir = null;
        String topicsFilter = null;
        for (int i = 0; i < args.size(); ++i) {
            String arg = (String)args.get(i);
            EhiLogger.traceState("arg[" + Integer.toString(i) + "] " + arg);
            if (arg.equals("MODELS")) {
                models = (String)args.get(++i);
                continue;
            }
            if (arg.equals("MODEL_DIR")) {
                modeldir = (String)args.get(++i);
                continue;
            }
            if (arg.equals("TOPICS_FILTER")) {
                topicsFilter = (String)args.get(++i);
                continue;
            }
            if (arg.equals("CREATE_LINETABLES")) {
                this.v6_createLineTableFeatures = FmeUtility.isTrue((String)args.get(++i));
                continue;
            }
            if (arg.equals("SKIP_POLYGONBUILDING")) {
                this.v6_skipPolygonBuilding = FmeUtility.isTrue((String)args.get(++i));
                continue;
            }
            if (arg.equals("ILI1_LINETABLES")) {
                this.itfMode = LinetableMapping.valueOf((String)args.get(++i));
                continue;
            }
            if (arg.equals("ILI1_ADDDEFVAL")) {
                this.ili1AddDefVal = FmeUtility.isTrue((String)args.get(++i));
                continue;
            }
            if (arg.equals("META_CONFIG")) {
                this.metaConfig = (String)args.get(++i);
                continue;
            }
            if (arg.equals("VALIDATE")) {
                this.validate = FmeUtility.isTrue((String)args.get(++i));
                continue;
            }
            if (arg.equals("VALIDATE_CONFIG")) {
                this.validationConfig = (String)args.get(++i);
                continue;
            }
            if (arg.equals("VALIDATE_MULTIPLICITY")) {
                this.validateMultiplicity = FmeUtility.isTrue((String)args.get(++i));
                continue;
            }
            if (arg.equals("TRIM_VALUES")) {
                this.trimValues = FmeUtility.isTrue((String)args.get(++i));
                continue;
            }
            if (arg.equals(Main.ILI1_IGNOREPOLYGONBUILDINGERRORS)) {
                this.ili1IgnorePolygonBuildingErrors = FmeUtility.isTrue((String)args.get(++i));
                continue;
            }
            if (arg.equals("ILI1_ENUMASITFCODE")) {
                this.ili1EnumAsItfCode = FmeUtility.isTrue((String)args.get(++i));
                continue;
            }
            if (arg.equals("INHERITANCE_MAPPING")) {
                this.inheritanceMapping = InheritanceMapping.valueOf((String)args.get(++i));
                continue;
            }
            if (arg.equals("CREATEFEATURETYPE4ENUM")) {
                this.createEnumTypes = CreateEnumFeatureTypes.valueOf((String)args.get(++i));
                continue;
            }
            if (arg.equals("GEOMETRY_ENCODING")) {
                this.geometryEncoding = GeometryEncoding.valueOf((String)args.get(++i));
                continue;
            }
            if (arg.equals("GEOM_ATTR_MAPPING")) {
                this.geomAttrMapping = GeomAttrMapping.valueOf((String)args.get(++i));
                continue;
            }
            if (arg.equals("CHECK_UNIQUEOID")) {
                this.checkUniqueOid = FmeUtility.isTrue((String)args.get(++i));
                continue;
            }
            if (arg.equals("ILI1_RENUMBERTID")) {
                this.ili1RenumberTid = FmeUtility.isTrue((String)args.get(++i));
                continue;
            }
            if (arg.equals("HTTP_PROXYHOST")) {
                httpProxyHost = (String)args.get(++i);
                continue;
            }
            if (!arg.equals("HTTP_PROXYPORT")) continue;
            httpProxyPort = (String)args.get(++i);
        }
        Iterator elei2 = this.mappingFile.elements();
        while (elei2.hasNext()) {
            Object eleo = elei2.next();
            EhiLogger.traceState("element " + eleo.getClass() + "," + eleo);
            if (!(eleo instanceof ArrayList)) continue;
            ArrayList ele = (ArrayList)eleo;
            String val = (String)ele.get(0);
            if (val.equals(this.readerKeyword + "_" + "MODELS")) {
                models = (String)ele.get(1);
                continue;
            }
            if (val.equals(this.readerKeyword + "_" + "MODEL_DIR")) {
                modeldir = (String)ele.get(1);
                continue;
            }
            if (val.equals(this.readerKeyword + "_" + "TOPICS_FILTER")) {
                topicsFilter = (String)ele.get(1);
                continue;
            }
            if (val.equals(this.readerKeyword + "_" + "CREATE_LINETABLES")) {
                this.v6_createLineTableFeatures = FmeUtility.isTrue((String)ele.get(1));
                continue;
            }
            if (val.equals(this.readerKeyword + "_" + "SKIP_POLYGONBUILDING")) {
                this.v6_skipPolygonBuilding = FmeUtility.isTrue((String)ele.get(1));
                continue;
            }
            if (val.equals(this.readerKeyword + "_" + "ILI1_LINETABLES")) {
                this.itfMode = LinetableMapping.valueOf((String)ele.get(1));
                continue;
            }
            if (val.equals(this.readerKeyword + "_" + "ILI1_ADDDEFVAL")) {
                this.ili1AddDefVal = FmeUtility.isTrue((String)ele.get(1));
                continue;
            }
            if (val.equals(this.readerKeyword + "_" + "META_CONFIG")) {
                this.metaConfig = StringUtility.purge((String)ele.get(1));
                continue;
            }
            if (val.equals(this.readerKeyword + "_" + "VALIDATE")) {
                this.validate = FmeUtility.isTrue((String)ele.get(1));
                continue;
            }
            if (val.equals(this.readerKeyword + "_" + "VALIDATE_CONFIG")) {
                this.validationConfig = StringUtility.purge((String)ele.get(1));
                continue;
            }
            if (val.equals(this.readerKeyword + "_" + "VALIDATE_MULTIPLICITY")) {
                this.validateMultiplicity = FmeUtility.isTrue((String)ele.get(1));
                continue;
            }
            if (val.equals(this.readerKeyword + "_" + "TRIM_VALUES")) {
                this.trimValues = FmeUtility.isTrue((String)ele.get(1));
                continue;
            }
            if (val.equals(this.readerKeyword + "_" + "INHERITANCE_MAPPING")) {
                this.inheritanceMapping = InheritanceMapping.valueOf((String)ele.get(1));
                continue;
            }
            if (val.equals(this.readerKeyword + "_" + "CREATEFEATURETYPE4ENUM")) {
                this.createEnumTypes = CreateEnumFeatureTypes.valueOf((String)ele.get(1));
                continue;
            }
            if (val.equals(this.readerKeyword + "_" + "GEOMETRY_ENCODING")) {
                this.geometryEncoding = GeometryEncoding.valueOf((String)ele.get(1));
                continue;
            }
            if (val.equals(this.readerKeyword + "_" + "GEOM_ATTR_MAPPING")) {
                this.geomAttrMapping = GeomAttrMapping.valueOf((String)ele.get(1));
                continue;
            }
            if (val.equals(this.readerKeyword + "_" + Main.ILI1_IGNOREPOLYGONBUILDINGERRORS)) {
                this.ili1IgnorePolygonBuildingErrors = FmeUtility.isTrue((String)ele.get(1));
                continue;
            }
            if (val.equals(this.readerKeyword + "_" + "ILI1_ENUMASITFCODE")) {
                this.ili1EnumAsItfCode = FmeUtility.isTrue((String)ele.get(1));
                continue;
            }
            if (val.equals(this.readerKeyword + "_" + "CHECK_UNIQUEOID")) {
                this.checkUniqueOid = FmeUtility.isTrue((String)ele.get(1));
                continue;
            }
            if (val.equals(this.readerKeyword + "_" + "ILI1_RENUMBERTID")) {
                this.ili1RenumberTid = FmeUtility.isTrue((String)ele.get(1));
                continue;
            }
            if (val.equals(this.readerKeyword + "_" + "HTTP_PROXYHOST")) {
                httpProxyHost = StringUtility.purge((String)ele.get(1));
                continue;
            }
            if (!val.equals(this.readerKeyword + "_" + "HTTP_PROXYPORT")) continue;
            httpProxyPort = StringUtility.purge((String)ele.get(1));
        }
        Settings settings2 = new Settings();
        settings2.setValue("ch.interlis.ili2c.http_proxy_host", httpProxyHost);
        settings2.setValue("ch.interlis.ili2c.http_proxy_port", httpProxyPort);
        settings2.setValue("ch.ehi.ili2fme.validationConfig", this.validationConfig);
        if (this.v6_createLineTableFeatures != null) {
            EhiLogger.logState("v6_createLineTables <" + this.v6_createLineTableFeatures + ">");
            if (this.v6_skipPolygonBuilding != null) {
                EhiLogger.logState("v6_skipPolygonBuilding <" + this.v6_skipPolygonBuilding + ">");
            }
            if (this.v6_createLineTableFeatures.booleanValue()) {
                if (this.v6_skipPolygonBuilding.booleanValue()) {
                    this.itfMode = 3;
                } else {
                    this.itfMode = 2;
                    this.ili1IgnorePolygonBuildingErrors = true;
                }
            } else {
                this.itfMode = 1;
                this.ili1IgnorePolygonBuildingErrors = true;
            }
            this.validate = false;
        }
        EhiLogger.logState("checkUniqueOid <" + this.checkUniqueOid + ">");
        EhiLogger.logState("metaConfig <" + (this.metaConfig != null ? this.metaConfig : "") + ">");
        EhiLogger.logState("validate <" + this.validate + ">");
        EhiLogger.logState("validationConfig <" + (this.validationConfig != null ? this.validationConfig : "") + ">");
        EhiLogger.logState("validateMultiplicity <" + this.validateMultiplicity + ">");
        EhiLogger.logState("ili1IgnorePolygonBuildingErrors <" + this.ili1IgnorePolygonBuildingErrors + ">");
        EhiLogger.logState("trimValues <" + this.trimValues + ">");
        EhiLogger.logState("geometryEncoding <" + GeometryEncoding.toString(this.geometryEncoding) + ">");
        EhiLogger.logState("geoAttrMapping <" + GeomAttrMapping.toString(this.geomAttrMapping) + ">");
        EhiLogger.logState("ili1RenumberTid <" + this.ili1RenumberTid + ">");
        EhiLogger.logState("lineTables <" + LinetableMapping.toString(this.itfMode) + ">");
        EhiLogger.logState("inheritanceMapping <" + InheritanceMapping.toString(this.inheritanceMapping) + ">");
        EhiLogger.logState("createEnumTypes <" + CreateEnumFeatureTypes.toString(this.createEnumTypes) + ">");
        EhiLogger.logState("ili1AddDefVal <" + this.ili1AddDefVal + ">");
        EhiLogger.logState("ili1EnumAsItfCode <" + this.ili1EnumAsItfCode + ">");
        if (models == null) {
            models = "%DATA";
        }
        EhiLogger.traceState("models <" + models + ">");
        EhiLogger.traceState("topicsFilter <" + (topicsFilter != null ? topicsFilter : "") + ">");
        if (topicsFilter != null) {
            String[] topicFilter = topicsFilter.split(";");
            for (int i = 0; i < topicFilter.length; ++i) {
                topicFilter[i] = StringUtility.purge(topicFilter[i]);
                if (topicFilter[i] == null) continue;
                if (this.topicFilterv == null) {
                    this.topicFilterv = new HashSet();
                }
                EhiLogger.logState("topicFilter <" + topicFilter[i] + ">");
                this.topicFilterv.add(topicFilter[i]);
            }
        }
        this.xtfFile = (String)args.get(0);
        if (this.xtfFile.length() >= 2 && this.xtfFile.charAt(0) == '/' && this.xtfFile.charAt(1) == '/') {
            StringBuffer x = new StringBuffer(this.xtfFile);
            x.setCharAt(0, '\\');
            x.setCharAt(1, '\\');
            this.xtfFile = x.toString();
        }
        EhiLogger.logState("xtfFile <" + this.xtfFile + ">");
        if (modeldir == null) {
            modeldir = new File(this.session.fmeHome(), "plugins/interlis2/ili22models").getAbsolutePath();
            modeldir = new File(this.session.fmeHome(), "plugins/interlis2/ilimodels").getAbsolutePath() + ";" + modeldir;
            modeldir = "http://models.interlis.ch/;" + modeldir;
            modeldir = "%XTF_DIR;" + modeldir;
        }
        EhiLogger.logState("modeldir <" + modeldir + ">");
        ch.interlis.ili2c.Main.setHttpProxySystemProperties(settings2);
        IliManager repositoryManager = (IliManager)settings2.getTransientObject("ch.interlis.ili2c.customIliManager");
        if (repositoryManager == null) {
            repositoryManager = new IliManager();
            settings2.setTransientObject("ch.interlis.ili2c.customIliManager", repositoryManager);
        }
        String XTF_DATA_FILE = null;
        if (!this.xtfFile.startsWith("ilidata:")) {
            XTF_DATA_FILE = this.xtfFile;
        }
        Map<String, String> pathMap = Main.getPathMap(XTF_DATA_FILE, this.session.fmeHome());
        List<String> modeldirv = ch.interlis.ili2c.Main.resolvePathMap(modeldir, pathMap);
        repositoryManager.setRepositories(modeldirv.toArray(new String[0]));
        String metaConfigFilename = this.metaConfig;
        if (metaConfigFilename != null) {
            ArrayList<String> metaConfigFiles = new ArrayList<String>();
            HashSet<String> visitedFiles = new HashSet<String>();
            metaConfigFiles.add(metaConfigFilename);
            Settings metaSettings = new Settings();
            while (!metaConfigFiles.isEmpty()) {
                metaConfigFilename = (String)metaConfigFiles.remove(0);
                if (visitedFiles.contains(metaConfigFilename)) continue;
                visitedFiles.add(metaConfigFilename);
                EhiLogger.traceState("metaConfigFile <" + metaConfigFilename + ">");
                File metaConfigFile = null;
                try {
                    metaConfigFile = IliManager.getLocalCopyOfReposFile(repositoryManager, metaConfigFilename);
                }
                catch (Ili2cException e1) {
                    throw new IllegalArgumentException("failed to get local copy of meta config file <" + metaConfigFilename + ">");
                }
                OutParam<String> baseConfigs = new OutParam<String>();
                Settings newSettings = null;
                try {
                    newSettings = Main.readMetaConfig(metaConfigFile, baseConfigs);
                    if (baseConfigs.value != null) {
                        String[] baseConfigv;
                        for (String baseConfig : baseConfigv = ((String)baseConfigs.value).split(";")) {
                            metaConfigFiles.add(baseConfig);
                        }
                    }
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("failed to read meta config file <" + metaConfigFile.getPath() + ">", e);
                }
                MetaConfig.mergeSettings(newSettings, metaSettings);
            }
            MetaConfig.mergeSettings(metaSettings, settings2);
        }
        MetaConfig.removeNullFromSettings(settings2);
        this.validationConfig = settings2.getValue("ch.ehi.ili2fme.validationConfig");
        try {
            File localFile = IliManager.getLocalCopyOfReposFile(repositoryManager, this.xtfFile);
            this.xtfFile = localFile.getPath();
            if (this.validationConfig != null) {
                localFile = IliManager.getLocalCopyOfReposFile(repositoryManager, this.validationConfig);
                this.validationConfig = localFile.getPath();
            }
        }
        catch (Ili2cException e2) {
            throw new IllegalArgumentException("failed to get local copy of remote files", e2);
        }
        String xtfExt = GenericFileFilter.getFileExtension(this.xtfFile);
        if (xtfExt != null) {
            xtfExt = xtfExt.toLowerCase();
        }
        if (xtfExt != null && xtfExt.equals("itf")) {
            this.formatMode = 2;
            if (this.itfMode == 3) {
                EhiLogger.logState("use raw ITF reader");
            }
        } else {
            if (xtfExt != null && xtfExt.equals("gml")) {
                throw new IllegalArgumentException("INTERLIS GML not yet supported by ili2fme reader");
            }
            this.formatMode = 1;
        }
        if (xtfExt != null && xtfExt.equals("ili")) {
            ArrayList<String> iliFilev = new ArrayList<String>();
            iliFilev.add(this.xtfFile);
            this.xtfFile = null;
            Configuration ili2cConfig = repositoryManager.getConfigWithFiles(iliFilev);
            ili2cConfig.setGenerateWarnings(false);
            Ili2c.logIliFiles(ili2cConfig);
            this.iliTd = Ili2c.runCompiler(ili2cConfig);
            if (this.iliTd == null) {
                throw new IllegalArgumentException("INTERLIS compiler failed");
            }
            this.formatMode = this.iliTd.getIli1Format() != null ? 2 : 1;
        } else if (models.equals("%DATA") || models.equals("XTF")) {
            this.iliModelv = new ArrayList<String>(IoxUtility.getModels(new File(this.xtfFile)));
            Log2EhiLogger errHandler = new Log2EhiLogger();
            LogEventFactory errFactory = new LogEventFactory();
            errFactory.setLogger(errHandler);
            String modelVersion = null;
            try {
                modelVersion = IoxUtility.getModelVersion(new String[]{this.xtfFile}, errFactory);
                EhiLogger.logState("modelVersion from xtf <" + modelVersion + ">");
            }
            catch (IoxException ex) {
                EhiLogger.logAdaption("failed to get version from data file; " + ex.toString() + "; ignored");
            }
            for (String modelName : this.iliModelv) {
                EhiLogger.logState("model from xtf <" + modelName + ">");
            }
            Configuration ili2cConfig = null;
            ili2cConfig = modelVersion != null ? repositoryManager.getConfig(this.iliModelv, Double.parseDouble(modelVersion)) : repositoryManager.getConfig(this.iliModelv, 0.0);
            Ili2c.logIliFiles(ili2cConfig);
            ili2cConfig.setGenerateWarnings(false);
            this.iliTd = Ili2c.runCompiler(ili2cConfig);
            if (this.iliTd == null) {
                throw new IllegalArgumentException("INTERLIS compiler failed");
            }
        } else {
            this.iliModelv = new ArrayList<String>(Arrays.asList(models.split(";")));
            Configuration ili2cConfig = repositoryManager.getConfig(this.iliModelv, 0.0);
            Ili2c.logIliFiles(ili2cConfig);
            ili2cConfig.setGenerateWarnings(false);
            this.iliTd = Ili2c.runCompiler(ili2cConfig);
            if (this.iliTd == null) {
                return;
            }
        }
        if (this.formatMode == 1) {
            this.transferViewables = ModelUtility.getXtfTransferViewables(this.iliTd, this.inheritanceMapping);
        } else if (this.formatMode == 2) {
            this.transferViewables = this.itfMode == 1 ? ModelUtility.getItf2TransferViewables(this.iliTd) : ModelUtility.getItfTransferViewables(this.iliTd);
        } else {
            throw new IllegalStateException("unexpected formatMode");
        }
        this.transferViewablei = null;
        if (this.createEnumTypes == 3 || this.createEnumTypes == 2) {
            this.collectEnums(this.iliTd);
        }
        if (this.geometryEncoding != 1) {
            this.geomConv = new GeometryConverter(this.session, this.geometryEncoding);
        }
        if (this.formatMode == 1) {
            this.tag2class = XSDGenerator.getTagMap(this.iliTd);
        } else if (this.formatMode == 2) {
            this.tag2class = this.itfMode == 1 ? ModelUtilities.getTagMap2(this.iliTd) : ModelUtilities.getTagMap(this.iliTd);
        } else {
            throw new IllegalStateException("unexpected formatMode");
        }
        for (String iliqname : this.tag2class.keySet()) {
            if (iliqname.length() <= this.iliQNameSize) continue;
            this.iliQNameSize = iliqname.length();
        }
        ++this.iliQNameSize;
        if (this.checkUniqueOid) {
            this.checkoids = new HashMap();
        }
        this.basketSeq = 1;
    }

    public void abort() throws Exception {
        try {
            this.myabort();
        }
        catch (Exception ex) {
            EhiLogger.logError(ex);
            throw ex;
        }
    }

    private void myabort() throws Exception {
        this.cleanup();
    }

    public void close() throws Exception {
        try {
            this.myclose();
        }
        catch (Exception ex) {
            EhiLogger.logError(ex);
            throw ex;
        }
    }

    private void myclose() throws Exception {
        this.cleanup();
    }

    public int id() {
        return 0;
    }

    public IFMEFeature read(IFMEFeature ret) throws Exception {
        try {
            return this.myread(ret);
        }
        catch (Error ex) {
            EhiLogger.logError(ex);
            throw new Exception(ex);
        }
    }

    private IFMEFeature myread(IFMEFeature ret) throws Exception {
        IFMEFeature enumEle;
        if (this.xtfFile == null) {
            if (this.createEnumTypes == 3 || this.createEnumTypes == 2) {
                return this.processEnums(ret);
            }
            return null;
        }
        if ((this.createEnumTypes == 3 || this.createEnumTypes == 2) && (enumEle = this.processEnums(ret)) != null) {
            return enumEle;
        }
        if (this.dataerrs != null && this.dataerrs.size() > 0) {
            IoxInvalidDataException dataerr = this.dataerrs.get(0);
            this.mapDataErr(ret, dataerr);
            this.dataerrs.remove(0);
            return ret;
        }
        if (this.pendingMaintableFeature != null) {
            ret.dispose();
            ret = this.pendingMaintableFeature;
            this.pendingMaintableFeature = null;
            return ret;
        }
        if (this.geomAttrIterator != null) {
            if (this.geomAttrIterator.hasNext()) {
                this.geomAttrIterator.next(ret);
                return ret;
            }
            this.geomAttrIterator.dispose();
            this.geomAttrIterator = null;
        }
        if (this.ioxReader == null) {
            this.inputFile = this.openInputFile(this.xtfFile);
            if (this.formatMode == 1) {
                this.ioxReader = new ReaderFactory().createReader(new File(this.xtfFile), new LogEventFactory());
                if (this.ioxReader instanceof IoxIliReader) {
                    ((IoxIliReader)((Object)this.ioxReader)).setModel(this.iliTd);
                }
            } else if (this.formatMode == 2) {
                if (this.itfMode == 3) {
                    this.ioxReader = new ItfReader(this.inputFile);
                    ((ItfReader)this.ioxReader).setModel(this.iliTd);
                    ((ItfReader)this.ioxReader).setReadEnumValAsItfCode(this.ili1EnumAsItfCode);
                    ((ItfReader)this.ioxReader).setRenumberTids(this.ili1RenumberTid);
                } else {
                    this.ioxReader = new ItfReader2(this.inputFile, this.ili1IgnorePolygonBuildingErrors);
                    ((ItfReader2)this.ioxReader).setModel(this.iliTd);
                    ((ItfReader2)this.ioxReader).setReadEnumValAsItfCode(this.ili1EnumAsItfCode);
                    ((ItfReader2)this.ioxReader).setRenumberTids(this.ili1RenumberTid);
                    if (this.itfMode == 2) {
                        ((ItfReader2)this.ioxReader).setReadLinetables(true);
                    }
                }
            } else {
                throw new IllegalStateException("unexpected formatMode");
            }
            if (this.ioxReader instanceof IoxIliReader && this.topicFilterv != null && !this.topicFilterv.isEmpty()) {
                ((IoxIliReader)((Object)this.ioxReader)).setTopicFilter(this.topicFilterv.toArray(new String[this.topicFilterv.size()]));
            }
            if (this.formatMode == 2 && this.ili1AddDefVal) {
                this.ioxReader = new ItfAddDefValueReader(this.ioxReader, this.iliTd, this.ili1EnumAsItfCode);
            }
            if (this.validate) {
                ValidationConfig modelConfig = new ValidationConfig();
                modelConfig.mergeIliMetaAttrs(this.iliTd);
                String configFilename = this.validationConfig;
                if (configFilename != null) {
                    try {
                        modelConfig.mergeConfigFile(new File(configFilename));
                    }
                    catch (IOException e) {
                        EhiLogger.logError("failed to read validator config file <" + configFilename + ">");
                    }
                }
                modelConfig.setConfigValue("PARAMETER", "multiplicity", this.validateMultiplicity ? "on" : "off");
                Settings config = new Settings();
                if (this.formatMode == 2) {
                    Validator.initItfValidation(config);
                    if (this.itfMode == 3) {
                        config.setValue("ch.interlis.iox_j.validator.doItfLinetables", "doItfLinetables");
                    }
                }
                Log2EhiLogger errHandler = new Log2EhiLogger();
                LogEventFactory errFactory = new LogEventFactory();
                errFactory.setDataSource(this.xtfFile);
                PipelinePool pipelinePool = new PipelinePool();
                if (this.formatMode == 2) {
                    Validator.initItfValidation(config);
                }
                this.validator = new Validator(this.iliTd, modelConfig, errHandler, errFactory, pipelinePool, config);
                if (this.ioxReader instanceof ItfReader2) {
                    ((ItfReader2)this.ioxReader).setIoxDataPool(pipelinePool);
                }
            }
        }
        while (true) {
            IoxEvent event = this.ioxReader.read();
            if (this.validator != null) {
                if (this.formatMode == 2 && this.itfMode == 2 && event instanceof ObjectEvent) {
                    IomObject iomObj = ((ObjectEvent)event).getIomObject();
                    String tag = iomObj.getobjecttag();
                    ViewableWrapper wrapper = this.transferViewables.get(tag);
                    if (!wrapper.isHelper() || !(wrapper.getGeomAttr4FME().getDomainResolvingAll() instanceof SurfaceOrAreaType)) {
                        this.validator.validate(event);
                    }
                } else {
                    this.validator.validate(event);
                }
            }
            if (event instanceof StartTransferEvent) {
                ret.setFeatureType("XTF_TRANSFER");
                if (event instanceof XtfStartTransferEvent) {
                    XtfStartTransferEvent startEvent = (XtfStartTransferEvent)event;
                    String value = null;
                    List<OidSpace> oids = startEvent.getOidSpaces();
                    for (int i = 0; i < oids.size(); ++i) {
                        OidSpace oid = oids.get(i);
                        String prefix = "oidspace{" + i + "}.";
                        value = oid.getName();
                        if (value != null) {
                            ret.setStringAttribute(prefix + "name", value);
                        }
                        if ((value = oid.getOiddomain()) == null) continue;
                        ret.setStringAttribute(prefix + "oiddomain", value);
                    }
                    value = startEvent.getComment();
                    if (value != null) {
                        ret.setStringAttribute("comment", value);
                    }
                }
                return ret;
            }
            if (!this.skipBasket && event instanceof ObjectEvent) {
                String oid;
                ObjectEvent oe = (ObjectEvent)event;
                IomObject iomObj = oe.getIomObject();
                if (this.checkoids != null && (oid = iomObj.getobjectoid()) != null) {
                    if (this.checkoids.containsKey(oid)) {
                        EhiLogger.logError(iomObj.getobjecttag() + " at line " + iomObj.getobjectline() + ": duplicate oid " + oid + " (same as at line " + ((Integer)this.checkoids.get(oid)).toString() + ")");
                    } else {
                        this.checkoids.put(oid, new Integer(iomObj.getobjectline()));
                    }
                }
                try {
                    ViewableWrapper wrapper;
                    ArrayList<String> geomAttrsCollector = new ArrayList<String>();
                    ret = this.mapFeature(ret, iomObj, null, geomAttrsCollector);
                    if (ret == null) {
                        ret = this.session.createFeature();
                        continue;
                    }
                    if (this.geomAttrMapping == 2 && (wrapper = this.transferViewables.get(iomObj.getobjecttag())).getViewable() != null) {
                        this.geomAttrIterator = new GeomAttrIterator(this.session, ret, geomAttrsCollector, this.geometryEncoding);
                    }
                }
                catch (DataException ex) {
                    EhiLogger.logError("object " + iomObj.getobjecttag() + " " + iomObj.getobjectoid() + " skipped; " + Iom_jObject.dumpObject(iomObj), ex);
                    ret.dispose();
                    ret = this.session.createFeature();
                    continue;
                }
                catch (Exception ex) {
                    EhiLogger.logError("object " + iomObj.getobjecttag() + " " + iomObj.getobjectoid() + " " + Iom_jObject.dumpObject(iomObj), ex);
                    return null;
                }
                return ret;
            }
            if (event instanceof StartBasketEvent) {
                StartBasketEvent be = (StartBasketEvent)event;
                this.currentBid = be.getBid();
                this.dataerrs = null;
                String topic = be.getType();
                EhiLogger.logState(topic + " " + this.currentBid + "...");
                if (this.topicFilterv != null && !this.topicFilterv.contains(topic)) {
                    this.skipBasket = true;
                    continue;
                }
                this.mapBasket(ret, be);
                return ret;
            }
            if (event instanceof EndBasketEvent) {
                this.currentBid = null;
                if (this.skipBasket) {
                    this.skipBasket = false;
                    continue;
                }
                if (this.dataerrs == null && this.ioxReader instanceof ItfReader2) {
                    if (!this.ili1IgnorePolygonBuildingErrors) {
                        this.dataerrs = new ArrayList<IoxInvalidDataException>(((ItfReader2)this.ioxReader).getDataErrs());
                        if (this.dataerrs.size() > 0) {
                            for (IoxInvalidDataException dataerr : this.dataerrs) {
                                EhiLogger.logError(dataerr);
                            }
                        }
                    }
                    ((ItfReader2)this.ioxReader).clearDataErrs();
                }
                if (this.dataerrs == null || this.dataerrs.size() <= 0) continue;
                IoxInvalidDataException dataerr = this.dataerrs.get(0);
                this.mapDataErr(ret, dataerr);
                this.dataerrs.remove(0);
                return ret;
            }
            if (event instanceof EndTransferEvent) break;
        }
        this.ioxReader.close();
        this.ioxReader = null;
        if (this.listener.hasSeenErrors()) {
            this.listener.clearErrors();
            throw new Exception("INTERLIS 2 reader failed");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mapDataErr(IFMEFeature ret, IoxInvalidDataException dataerr) throws DataException {
        IomObject geom;
        ret.setFeatureType("XTF_ERRORS");
        ret.setStringAttribute("message", dataerr.getMessage());
        if (dataerr.getIliqname() != null) {
            ret.setStringAttribute("iliname", dataerr.getIliqname());
        }
        if ((geom = dataerr.getGeom()) != null) {
            IFMEGeometry fmeGeom = null;
            try {
                fmeGeom = Iox2fme.geom2FME(this.session, geom);
                ret.setGeometry(fmeGeom);
            }
            finally {
                if (fmeGeom != null) {
                    fmeGeom.dispose();
                    fmeGeom = null;
                }
            }
        }
        if (dataerr.getTid() != null) {
            ret.setStringAttribute("tid{" + Integer.toString(0) + "}", dataerr.getTid());
        }
    }

    private InputStream openInputFile(String xtfFile) throws IOException, URISyntaxException {
        InputStream input = null;
        String urilc = xtfFile.toLowerCase();
        if (!urilc.startsWith("http:") && !urilc.startsWith("https:")) {
            input = new FileInputStream(xtfFile);
        } else {
            URL url = null;
            url = new URI(xtfFile).toURL();
            EhiLogger.traceState("fetching <" + url + "> ...");
            URLConnection conn = null;
            conn = url.openConnection();
            input = new BufferedInputStream(conn.getInputStream());
        }
        return input;
    }

    private void checkConvertedFeature(IFMEFeature ret, AttributeDef attr) {
        String featureType = ret.getFeatureType();
        if (featureType.startsWith(ERR_FEATURETYPE_PREFIX)) {
            String errmsg = featureType;
            if (ret.attributeExists(ERRMSG_ATTRIBUTE)) {
                try {
                    String msg = ret.getStringAttribute(ERRMSG_ATTRIBUTE);
                    if (msg != null && msg.length() > 0) {
                        errmsg = msg;
                    }
                }
                catch (FMEException ex) {
                    EhiLogger.logError(ex);
                }
            }
            String geomAttrIliQName = attr.getContainer().getScopedName(null) + "." + attr.getName();
            ret.setStringAttribute("iliname", geomAttrIliQName);
            ret.setStringAttribute("message", "polygon building error: " + errmsg);
            ret.setFeatureType("XTF_ERRORS");
        }
    }

    private void mapBasket(IFMEFeature ret, StartBasketEvent be) {
        Map<String, String> domains;
        String consistency;
        String endState;
        ret.setFeatureType("XTF_BASKETS");
        ret.setStringAttribute("xtf_topic", be.getType());
        ret.setStringAttribute("xtf_id", be.getBid());
        ret.setIntAttribute("xtf_seq", this.basketSeq++);
        String startState = be.getStartstate();
        if (startState != null) {
            ret.setStringAttribute("xtf_startstate", startState);
        }
        if ((endState = be.getEndstate()) != null) {
            ret.setStringAttribute("xtf_endstate", endState);
        }
        if ((consistency = FmeUtility.mapIox2FmeConsistency(be.getConsistency())) != null) {
            ret.setStringAttribute("xtf_consistency", consistency);
        }
        if (be instanceof ch.interlis.iox_j.StartBasketEvent && (domains = ((ch.interlis.iox_j.StartBasketEvent)be).getDomains()) != null && domains.size() > 0) {
            ArrayList<String> keys = new ArrayList<String>(domains.keySet());
            Collections.sort(keys);
            int idx = 0;
            for (String genericDomain : keys) {
                String concreteDomain = domains.get(genericDomain);
                ret.setStringAttribute("xtf_domains{" + idx + "}." + "generic", genericDomain);
                ret.setStringAttribute("xtf_domains{" + idx + "}." + "concrete", concreteDomain);
                ++idx;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private IFMEFeature mapFeature(IFMEFeature ret, IomObject iomObj, String prefix, ArrayList<String> geomAttrsCollector) throws DataException, ConfigException {
        Iterator<ViewableTransferElement> iter;
        AttributeDef geomattr;
        boolean isStruct;
        boolean bl = isStruct = prefix != null;
        if (!isStruct) {
            prefix = "";
        }
        String tag = iomObj.getobjecttag();
        if (this.formatMode == 1 && tag.equals("DELETE")) {
            ret.setFeatureType("XTF_DELETEOBJECT");
            ret.setStringAttribute("xtf_id", iomObj.getobjectoid());
            ret.setStringAttribute("xtf_basket", this.currentBid);
            return ret;
        }
        ViewableWrapper wrapper = null;
        if (this.formatMode == 1) {
            Viewable aclass = (Viewable)this.tag2class.get(tag);
            if (aclass == null) {
                EhiLogger.logError("line " + iomObj.getobjectline() + ": unknonw class <" + tag + ">; ignored");
                return null;
            }
            wrapper = this.transferViewables.get(tag);
        } else if (this.formatMode == 2 && (wrapper = this.transferViewables.get(tag)) == null) {
            EhiLogger.logError("line " + iomObj.getobjectline() + ": unknonw class <" + tag + ">; ignored");
            return null;
        }
        if (!isStruct) {
            ret.setFeatureType(wrapper.getFmeFeatureType());
            if (iomObj.getobjectoid() != null) {
                ret.setStringAttribute("xtf_id", iomObj.getobjectoid());
            }
            ret.setStringAttribute("xtf_basket", this.currentBid);
            if (this.formatMode == 1) {
                String operation;
                String consistency = FmeUtility.mapIox2FmeConsistency(iomObj.getobjectconsistency());
                if (consistency != null) {
                    ret.setStringAttribute("xtf_consistency", consistency);
                }
                if ((operation = FmeUtility.mapIox2FmeOperation(iomObj.getobjectoperation())) != null) {
                    ret.setStringAttribute("xtf_operation", operation);
                }
            }
        }
        if (this.formatMode == 2 && wrapper.getGeomAttr4FME() != null && wrapper.getGeomAttr4FME().getDomainResolvingAll() instanceof SurfaceOrAreaType) {
            String featureType;
            if (wrapper.isHelper()) {
                String refoid;
                IomObject structvalue;
                String fkName;
                SurfaceOrAreaType type;
                if (this.v6_createLineTableFeatures != null && this.v6_createLineTableFeatures.booleanValue()) {
                    featureType = ret.getFeatureType();
                    ret.setFeatureType(featureType + "_LT");
                }
                if ((type = (SurfaceOrAreaType)wrapper.getGeomAttr4FME().getDomainResolvingAll()) instanceof SurfaceType) {
                    fkName = ModelUtilities.getHelperTableMainTableRef(wrapper.getGeomAttr4FME());
                    structvalue = iomObj.getattrobj(fkName, 0);
                    if (structvalue != null) {
                        refoid = structvalue.getobjectrefoid();
                        ret.setStringAttribute(fkName, refoid);
                    }
                } else {
                    if (!(type instanceof AreaType)) throw new IllegalStateException();
                    if (this.itfMode == 2) {
                        String fk2Name;
                        fkName = ModelUtilities.getHelperTableMainTableRef(wrapper.getGeomAttr4FME());
                        structvalue = iomObj.getattrobj(fkName, 0);
                        if (structvalue != null) {
                            refoid = structvalue.getobjectrefoid();
                            ret.setStringAttribute(fkName, refoid);
                        }
                        if ((structvalue = iomObj.getattrobj(fk2Name = ModelUtilities.getHelperTableMainTableRef2(wrapper.getGeomAttr4FME()), 0)) != null) {
                            String refoid2 = structvalue.getobjectrefoid();
                            ret.setStringAttribute(fk2Name, refoid2);
                        }
                    }
                }
            } else if (this.itfMode == 3 && this.v6_createLineTableFeatures != null && this.v6_createLineTableFeatures.booleanValue()) {
                featureType = ret.getFeatureType();
                ret.setFeatureType(featureType + "_MT");
            }
        }
        AttributeDef attributeDef = geomattr = isStruct ? null : wrapper.getGeomAttr4FME();
        if (geomattr != null) {
            ret.setStringAttribute("xtf_geomattr", geomattr.getName());
        }
        ret.setStringAttribute(prefix + "xtf_class", tag);
        if (this.formatMode == 2) {
            iter = wrapper.getAttrIterator();
        } else {
            Viewable aclass = (Viewable)this.tag2class.get(tag);
            iter = aclass.getAttributesAndRoles2();
        }
        this.pendingMaintableFeatureAttribute = null;
        while (iter.hasNext()) {
            ViewableTransferElement prop = iter.next();
            if (prop.obj instanceof AttributeDef) {
                AttributeDef attr = (AttributeDef)prop.obj;
                this.mapAttributeValue(geomattr, ret, iomObj, attr, prefix, wrapper, geomAttrsCollector);
            }
            if (!(prop.obj instanceof RoleDef)) continue;
            RoleDef role = (RoleDef)prop.obj;
            String roleName = role.getName();
            if (prop.embedded) {
                IomObject structvalue;
                AssociationDef roleOwner = (AssociationDef)role.getContainer();
                if (roleOwner.getDerivedFrom() != null || (structvalue = iomObj.getattrobj(roleName, 0)) == null) continue;
                if (roleOwner.getAttributes().hasNext() || roleOwner.getLightweightAssociations().iterator().hasNext()) {
                    this.mapFeature(ret, structvalue, prefix + roleName + "{0}.", geomAttrsCollector);
                }
                String refoid = structvalue.getobjectrefoid();
                long orderPos = structvalue.getobjectreforderpos();
                if (orderPos != 0L) {
                    ret.setStringAttribute(prefix + roleName, refoid);
                    ret.setStringAttribute(prefix + roleName + "." + "orderPos", Long.toString(orderPos));
                    continue;
                }
                ret.setStringAttribute(prefix + roleName, refoid);
                continue;
            }
            if (((AssociationDef)role.getContainer()).isLightweight()) continue;
            IomObject structvalue = iomObj.getattrobj(roleName, 0);
            String refoid = structvalue.getobjectrefoid();
            long orderPos = structvalue.getobjectreforderpos();
            if (orderPos != 0L) {
                ret.setStringAttribute(prefix + roleName, refoid);
                ret.setStringAttribute(prefix + roleName + "." + "orderPos", Long.toString(orderPos));
                continue;
            }
            ret.setStringAttribute(prefix + roleName, refoid);
        }
        if (this.pendingMaintableFeatureAttribute == null) return ret;
        Type type = this.pendingMaintableFeatureAttribute.getDomainResolvingAll();
        String attrName = this.pendingMaintableFeatureAttribute.getName();
        this.pendingMaintableFeature = this.session.createFeature();
        try {
            ret.clone(this.pendingMaintableFeature);
        }
        catch (FMEException e) {
            throw new IllegalStateException(e);
        }
        if (type instanceof SurfaceType) {
            this.pendingMaintableFeature.setStringAttribute("xtf_geomtype", "xtf_none");
            this.pendingMaintableFeature.setGeometryType(0);
        } else {
            if (!(type instanceof AreaType)) throw new IllegalStateException();
            this.pendingMaintableFeature.setStringAttribute("xtf_geomtype", "xtf_coord");
            IomObject value = iomObj.getattrobj("_itf_" + attrName, 0);
            if (value != null) {
                if (this.doRichGeometry) {
                    IFMEPoint point = null;
                    try {
                        point = Iox2fme.coord2FME(this.session, value);
                        this.pendingMaintableFeature.setGeometry((IFMEGeometry)point);
                    }
                    finally {
                        if (point != null) {
                            point.dispose();
                            point = null;
                        }
                    }
                } else {
                    this.pendingMaintableFeature.setGeometryType(1);
                    this.addCoord(this.pendingMaintableFeature, value);
                }
            }
        }
        String featureType = ret.getFeatureType();
        this.pendingMaintableFeature.setFeatureType(featureType + "_MT");
        this.pendingMaintableFeatureAttribute = null;
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mapAttributeValue(AttributeDef geomattr, IFMEFeature ret, IomObject iomObj, AttributeDef attr, String prefix, ViewableWrapper wrapper, ArrayList<String> geomAttrsCollector) throws DataException, ConfigException {
        block100: {
            String attrName;
            block110: {
                Type type;
                block109: {
                    block108: {
                        block106: {
                            IomObject value;
                            block107: {
                                block104: {
                                    IomObject value2;
                                    block105: {
                                        block102: {
                                            IomObject value3;
                                            block103: {
                                                block101: {
                                                    block99: {
                                                        if (prefix == null) {
                                                            prefix = "";
                                                        }
                                                        type = attr.getDomainResolvingAll();
                                                        attrName = attr.getName();
                                                        if (!(type instanceof CompositionType)) break block99;
                                                        int valuec = iomObj.getattrvaluecount(attrName);
                                                        for (int valuei = 0; valuei < valuec; ++valuei) {
                                                            IomObject value4 = iomObj.getattrobj(attrName, valuei);
                                                            if (value4 == null) continue;
                                                            this.mapFeature(ret, value4, prefix + attr.getName() + "{" + Integer.toString(valuei) + "}.", geomAttrsCollector);
                                                        }
                                                        break block100;
                                                    }
                                                    if (!(type instanceof PolylineType)) break block101;
                                                    IomObject value5 = iomObj.getattrobj(attrName, 0);
                                                    if (value5 == null) break block100;
                                                    if (attr != geomattr) {
                                                        if (this.geomConv == null) {
                                                            String wkb;
                                                            try {
                                                                wkb = Iox2jts.polyline2hexwkb(value5, this.getP((PolylineType)type));
                                                            }
                                                            catch (Iox2jtsException e) {
                                                                throw new DataException(e);
                                                            }
                                                            this.checkWkb(ret, prefix + attrName, wkb);
                                                            ret.setStringAttribute(prefix + attrName, wkb);
                                                        } else {
                                                            this.geomConv.polyline2FME(ret, prefix + attrName, value5);
                                                        }
                                                        geomAttrsCollector.add(prefix + attrName);
                                                    } else {
                                                        ret.setStringAttribute("xtf_geomtype", "xtf_polyline");
                                                        if (this.doRichGeometry) {
                                                            IFMEPath fmeLine = null;
                                                            try {
                                                                fmeLine = Iox2fme.polyline2FME(this.session, value5, false);
                                                                ret.setGeometry((IFMEGeometry)fmeLine);
                                                            }
                                                            finally {
                                                                if (fmeLine != null) {
                                                                    fmeLine.dispose();
                                                                    fmeLine = null;
                                                                }
                                                            }
                                                        } else {
                                                            this.setPolyline(ret, value5, false, this.getP((PolylineType)type));
                                                        }
                                                    }
                                                    break block100;
                                                }
                                                if (!(type instanceof MultiPolylineType)) break block102;
                                                value3 = iomObj.getattrobj(attrName, 0);
                                                if (value3 == null) break block100;
                                                if (attr == geomattr) break block103;
                                                if (this.geomConv == null) {
                                                    String wkb;
                                                    try {
                                                        wkb = Iox2jts.multipolyline2hexwkb(value3, this.getP((LineType)type));
                                                    }
                                                    catch (Iox2jtsException e) {
                                                        throw new DataException(e);
                                                    }
                                                    ret.setStringAttribute(prefix + attrName, wkb);
                                                } else {
                                                    this.geomConv.multipolyline2FME(ret, prefix + attrName, value3);
                                                }
                                                geomAttrsCollector.add(prefix + attrName);
                                                break block100;
                                            }
                                            ret.setStringAttribute("xtf_geomtype", "xtf_multipolyline");
                                            if (this.doRichGeometry) {
                                                IFMEMultiCurve multiCurve = null;
                                                try {
                                                    multiCurve = Iox2fme.multipolyline2FME(this.session, value3);
                                                    ret.setGeometry((IFMEGeometry)multiCurve);
                                                }
                                                finally {
                                                    if (multiCurve != null) {
                                                        multiCurve.dispose();
                                                    }
                                                }
                                            }
                                            throw new IllegalStateException("MultiPolylineType requires enhanced geometry handling");
                                        }
                                        if (!(type instanceof SurfaceOrAreaType)) break block104;
                                        if (attr == geomattr) break block105;
                                        IomObject value6 = iomObj.getattrobj(attrName, 0);
                                        if (value6 == null) break block100;
                                        if (this.geomConv == null) {
                                            String wkb;
                                            try {
                                                wkb = Iox2jts.surface2hexwkb(value6, this.getP((SurfaceOrAreaType)type));
                                            }
                                            catch (Iox2jtsException e) {
                                                throw new DataException(e);
                                            }
                                            this.checkWkb(ret, prefix + attrName, wkb);
                                            ret.setStringAttribute(prefix + attrName, wkb);
                                        } else {
                                            this.geomConv.surface2FME(ret, prefix + attrName, value6);
                                        }
                                        geomAttrsCollector.add(prefix + attrName);
                                        break block100;
                                    }
                                    if (!wrapper.isHelper() && (value2 = iomObj.getattrobj(attrName, 0)) != null) {
                                        if (this.formatMode == 2 && this.itfMode == 3) {
                                            if (type instanceof AreaType) {
                                                ret.setStringAttribute("xtf_geomtype", "xtf_coord");
                                                if (this.doRichGeometry) {
                                                    IFMEPoint point = null;
                                                    try {
                                                        point = Iox2fme.coord2FME(this.session, value2);
                                                        ret.setGeometry((IFMEGeometry)point);
                                                    }
                                                    finally {
                                                        if (point != null) {
                                                            point.dispose();
                                                            point = null;
                                                        }
                                                    }
                                                } else {
                                                    ret.setGeometryType(1);
                                                    this.addCoord(ret, value2);
                                                }
                                            }
                                        } else {
                                            if (type instanceof AreaType) {
                                                ret.setStringAttribute("xtf_geomtype", "xtf_area");
                                            } else if (type instanceof SurfaceType) {
                                                ret.setStringAttribute("xtf_geomtype", "xtf_surface");
                                            } else {
                                                throw new IllegalStateException();
                                            }
                                            if (this.doRichGeometry) {
                                                IFMEArea fmeSurface = null;
                                                try {
                                                    fmeSurface = Iox2fme.surface2FME(this.session, value2);
                                                    ret.setGeometry((IFMEGeometry)fmeSurface);
                                                }
                                                finally {
                                                    if (fmeSurface != null) {
                                                        fmeSurface.dispose();
                                                        fmeSurface = null;
                                                    }
                                                }
                                            } else {
                                                this.setSurface(ret, value2, (SurfaceOrAreaType)type);
                                            }
                                            if (this.formatMode == 2 && this.itfMode == 2) {
                                                this.pendingMaintableFeatureAttribute = attr;
                                            }
                                        }
                                    }
                                    if (this.formatMode != 2 || !wrapper.isHelper() || (value2 = iomObj.getattrobj(ModelUtilities.getHelperTableGeomAttrName(attr), 0)) == null) break block100;
                                    ret.setStringAttribute("xtf_geomtype", "xtf_polyline");
                                    if (this.doRichGeometry) {
                                        IFMEPath fmeLine = null;
                                        try {
                                            fmeLine = Iox2fme.polyline2FME(this.session, value2, false);
                                            ret.setGeometry((IFMEGeometry)fmeLine);
                                        }
                                        finally {
                                            if (fmeLine != null) {
                                                fmeLine.dispose();
                                                fmeLine = null;
                                            }
                                        }
                                    } else {
                                        this.setPolyline(ret, value2, false, this.getP((SurfaceOrAreaType)type));
                                    }
                                    SurfaceOrAreaType surfaceType = (SurfaceOrAreaType)type;
                                    Table lineAttrTable = surfaceType.getLineAttributeStructure();
                                    if (lineAttrTable == null) break block100;
                                    Iterator<Extendable> attri = lineAttrTable.getAttributes();
                                    while (attri.hasNext()) {
                                        AttributeDef lineattr = (AttributeDef)attri.next();
                                        this.mapAttributeValue(null, ret, iomObj, lineattr, null, null, geomAttrsCollector);
                                    }
                                    break block100;
                                }
                                if (!(type instanceof MultiSurfaceOrAreaType)) break block106;
                                value = iomObj.getattrobj(attrName, 0);
                                if (value == null) break block100;
                                if (attr == geomattr) break block107;
                                if (this.geomConv == null) {
                                    String wkb;
                                    try {
                                        wkb = Iox2jts.multisurface2hexwkb(value, this.getP((MultiSurfaceOrAreaType)type));
                                    }
                                    catch (Iox2jtsException e) {
                                        throw new DataException(e);
                                    }
                                    ret.setStringAttribute(prefix + attrName, wkb);
                                } else {
                                    this.geomConv.mutlisurface2FME(ret, prefix + attrName, value);
                                }
                                geomAttrsCollector.add(prefix + attrName);
                                break block100;
                            }
                            if (type instanceof MultiAreaType) {
                                ret.setStringAttribute("xtf_geomtype", "xtf_multiarea");
                            } else if (type instanceof MultiSurfaceType) {
                                ret.setStringAttribute("xtf_geomtype", "xtf_multisurface");
                            } else {
                                throw new IllegalStateException();
                            }
                            if (this.doRichGeometry) {
                                IFMEMultiArea fmeSurface = null;
                                try {
                                    fmeSurface = Iox2fme.multisurface2FME(this.session, value);
                                    ret.setGeometry((IFMEGeometry)fmeSurface);
                                }
                                finally {
                                    if (fmeSurface != null) {
                                        fmeSurface.dispose();
                                    }
                                }
                            }
                            throw new IllegalStateException("MultiSurfaceOrAreaType requires enhanced geometry handling");
                        }
                        if (!(type instanceof CoordType)) break block108;
                        IomObject value = iomObj.getattrobj(attrName, 0);
                        if (value == null) break block100;
                        if (!value.getobjecttag().equals("COORD")) {
                            throw new DataException("COORD expected for attribute " + attrName);
                        }
                        if (attr != geomattr) {
                            if (((CoordType)type).getDimensions().length == 1) {
                                String c1 = value.getattrvalue("C1");
                                if (c1 != null) {
                                    ret.setStringAttribute(prefix + attrName, c1);
                                }
                            } else if (this.geomConv == null) {
                                String wkb;
                                try {
                                    wkb = Iox2jts.coord2hexwkb(value);
                                }
                                catch (Iox2jtsException e) {
                                    throw new DataException(e);
                                }
                                this.checkWkb(ret, prefix + attrName, wkb);
                                ret.setStringAttribute(prefix + attrName, wkb);
                            } else {
                                this.geomConv.coord2FME(ret, prefix + attrName, value);
                            }
                            geomAttrsCollector.add(prefix + attrName);
                        } else {
                            ret.setStringAttribute("xtf_geomtype", "xtf_coord");
                            if (this.doRichGeometry) {
                                IFMEPoint point = null;
                                try {
                                    point = Iox2fme.coord2FME(this.session, value);
                                    ret.setGeometry((IFMEGeometry)point);
                                }
                                finally {
                                    if (point != null) {
                                        point.dispose();
                                        point = null;
                                    }
                                }
                            } else {
                                ret.setGeometryType(1);
                                this.addCoord(ret, value);
                            }
                        }
                        break block100;
                    }
                    if (!(type instanceof MultiCoordType)) break block109;
                    IomObject value = iomObj.getattrobj(attrName, 0);
                    if (value == null) break block100;
                    if (attr != geomattr) {
                        if (((MultiCoordType)type).getDimensions().length == 1) {
                            for (int coordi = 0; coordi < value.getattrvaluecount("coord"); ++coordi) {
                                IomObject coord = value.getattrobj("coord", coordi);
                                String c1 = coord.getattrvalue("C1");
                                if (c1 == null) continue;
                                ret.setStringAttribute(prefix + attrName + "{" + coordi + "}", c1);
                            }
                        } else if (this.geomConv == null) {
                            String wkb;
                            try {
                                wkb = Iox2jts.multicoord2hexwkb(value);
                            }
                            catch (Iox2jtsException e) {
                                throw new DataException(e);
                            }
                            ret.setStringAttribute(prefix + attrName, wkb);
                        } else {
                            this.geomConv.multicoord2FME(ret, prefix + attrName, value);
                        }
                        geomAttrsCollector.add(prefix + attrName);
                    } else {
                        ret.setStringAttribute("xtf_geomtype", "xtf_multicoord");
                        IFMEMultiPoint multiPoint = null;
                        try {
                            multiPoint = Iox2fme.multicoord2FME(this.session, value);
                            ret.setGeometry((IFMEGeometry)multiPoint);
                        }
                        finally {
                            if (multiPoint != null) {
                                multiPoint.dispose();
                            }
                        }
                    }
                    break block100;
                }
                if (!(type instanceof ReferenceType)) break block110;
                IomObject structvalue = iomObj.getattrobj(attrName, 0);
                if (structvalue == null) break block100;
                String refoid = structvalue.getobjectrefoid();
                ret.setStringAttribute(prefix + attrName, refoid);
                break block100;
            }
            for (int i = 0; i < iomObj.getattrvaluecount(attrName); ++i) {
                String value = iomObj.getattrprim(attrName, i);
                if (this.trimValues) {
                    value = StringUtility.purge(value);
                }
                if (value == null) continue;
                String fmeIndex = attr.getDomainOrDerivedDomain().getCardinality().getMaximum() > 1L ? String.format("{%d}.%s", i, attrName) : "";
                ret.setStringAttribute(prefix + attrName + fmeIndex, value);
            }
        }
    }

    private void checkWkb(IFMEFeature fme, String attr, String value) throws DataException {
    }

    private double getP(LineType type) {
        if (this.typeCache.containsKey(type)) {
            return (Double)this.typeCache.get(type);
        }
        CoordType coordType = (CoordType)type.getControlPointDomain().getType();
        NumericalType[] dimv = coordType.getDimensions();
        int accuracy = ((NumericType)dimv[0]).getMaximum().getAccuracy();
        double p = accuracy == 0 ? 0.5 : Math.pow(10.0, -accuracy);
        this.typeCache.put(type, new Double(p));
        return p;
    }

    public IFMEFeature readSchema(IFMEFeature ret) throws Exception {
        try {
            return this.myreadSchema(ret);
        }
        catch (Exception ex) {
            EhiLogger.logError(ex);
            throw ex;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IFMEFeature myreadSchema(IFMEFeature ret) throws Exception {
        if (this.iliTd == null) {
            return null;
        }
        if (this.pendingSchemaFeature != null) {
            ret.dispose();
            ret = this.pendingSchemaFeature;
            this.pendingSchemaFeature = null;
            return ret;
        }
        if (this.transferViewablei == null) {
            if (this.formatFeatureTypeIdx == 0) {
                ret.setFeatureType("XTF_TRANSFER");
                ret.setSequencedAttribute("fme_geometry{0}", "xtf_none");
                ret.setSequencedAttribute("oidspace{}.name", "xtf_char(255)");
                ret.setSequencedAttribute("oidspace{}.oiddomain", "xtf_char(255)");
                ret.setSequencedAttribute("comment", "xtf_char(255)");
                ++this.formatFeatureTypeIdx;
                return ret;
            }
            if (this.formatFeatureTypeIdx == 1) {
                ret.setFeatureType("XTF_BASKETS");
                ret.setSequencedAttribute("fme_geometry{0}", "xtf_none");
                ret.setSequencedAttribute("xtf_topic", this.getIliQNameType());
                ret.setSequencedAttribute("xtf_id", "xtf_char(200)");
                ret.setSequencedAttribute("xtf_seq", "xtf_int16");
                ret.setSequencedAttribute("xtf_startstate", "xtf_char(250)");
                ret.setSequencedAttribute("xtf_endstate", "xtf_char(250)");
                ret.setSequencedAttribute("xtf_consistency", "xtf_char(12)");
                ret.setSequencedAttribute("xtf_domains{}.generic", "xtf_char(250)");
                ret.setSequencedAttribute("xtf_domains{}.concrete", "xtf_char(250)");
                ++this.formatFeatureTypeIdx;
                return ret;
            }
            if (this.formatFeatureTypeIdx == 2) {
                ret.setFeatureType("XTF_DELETEOBJECT");
                ret.setSequencedAttribute("fme_geometry{0}", "xtf_none");
                ret.setSequencedAttribute("xtf_id", "xtf_char(200)");
                ret.setSequencedAttribute("xtf_basket", "xtf_char(200)");
                ++this.formatFeatureTypeIdx;
                return ret;
            }
            if (this.formatFeatureTypeIdx == 3) {
                ret.setFeatureType("XTF_ERRORS");
                ret.setSequencedAttribute("fme_geometry{0}", "xtf_none");
                ret.setSequencedAttribute("message", "xtf_char(255)");
                ret.setSequencedAttribute("iliname", "xtf_char(255)");
                ret.setSequencedAttribute("tid{}", "xtf_char(200)");
                ++this.formatFeatureTypeIdx;
                return ret;
            }
            if (this.formatFeatureTypeIdx == 4 && this.createEnumTypes == 2) {
                ret.setFeatureType("XTF_ENUMS");
                ret.setSequencedAttribute("fme_geometry{0}", "xtf_none");
                ret.setSequencedAttribute("thisEnum", "xtf_char(255)");
                ret.setSequencedAttribute("baseEnum", "xtf_char(255)");
                ret.setSequencedAttribute("iliCode", "xtf_char(255)");
                ret.setSequencedAttribute("itfCode", "xtf_int16");
                ret.setSequencedAttribute("seq", "xtf_int16");
                ++this.formatFeatureTypeIdx;
                return ret;
            }
            if (this.formatFeatureTypeIdx >= 4 && this.createEnumTypes == 3) {
                if (this.formatFeatureTypeIdx == 4) {
                    this.enumDefi = this.enumDefs.iterator();
                }
                if (this.enumDefi != null) {
                    if (this.enumDefi.hasNext()) {
                        Object enumDef = this.enumDefi.next();
                        String enumTypeName = this.mapEnumDefName(enumDef);
                        ret.setFeatureType(enumTypeName);
                        ret.setSequencedAttribute("fme_geometry{0}", "xtf_none");
                        ret.setSequencedAttribute("iliCode", "xtf_char(255)");
                        ret.setSequencedAttribute("itfCode", "xtf_int16");
                        ret.setSequencedAttribute("seq", "xtf_int16");
                        ++this.formatFeatureTypeIdx;
                        return ret;
                    }
                    this.enumDefi = null;
                }
            }
            this.transferViewablei = this.transferViewables.keySet().iterator();
            this.seenFmeTypes = new HashSet();
        }
        while (this.transferViewablei.hasNext()) {
            ViewableWrapper wrapper;
            String iliQName = this.transferViewablei.next();
            Element v = (Element)this.tag2class.get(iliQName);
            if (v instanceof Table && !((Table)v).isIdentifiable() || v instanceof AssociationDef && ((AssociationDef)v).isLightweight() || this.seenFmeTypes.contains(wrapper = this.transferViewables.get(iliQName))) continue;
            AttributeDef geomattr = wrapper.getGeomAttr4FME();
            this.mapFeatureType(geomattr, ret, wrapper, null);
            if (geomattr == null) {
                ret.setSequencedAttribute("fme_geometry{0}", "xtf_none");
            } else {
                Type type = geomattr.getDomainResolvingAll();
                if (this.formatMode == 1) {
                    if (type instanceof PolylineType) {
                        ret.setSequencedAttribute("fme_geometry{0}", "xtf_polyline");
                    } else if (type instanceof MultiPolylineType) {
                        ret.setSequencedAttribute("fme_geometry{0}", "xtf_multipolyline");
                    } else if (type instanceof SurfaceType) {
                        ret.setSequencedAttribute("fme_geometry{0}", "xtf_surface");
                    } else if (type instanceof MultiSurfaceType) {
                        ret.setSequencedAttribute("fme_geometry{0}", "xtf_multisurface");
                    } else if (type instanceof AreaType) {
                        ret.setSequencedAttribute("fme_geometry{0}", "xtf_area");
                    } else if (type instanceof MultiAreaType) {
                        ret.setSequencedAttribute("fme_geometry{0}", "xtf_multiarea");
                    } else if (type instanceof CoordType) {
                        ret.setSequencedAttribute("fme_geometry{0}", "xtf_coord");
                    } else {
                        if (!(type instanceof MultiCoordType)) throw new IllegalStateException("!(type instanceof geomType)");
                        ret.setSequencedAttribute("fme_geometry{0}", "xtf_multicoord");
                    }
                } else if (this.formatMode == 2) {
                    if (type instanceof PolylineType) {
                        ret.setSequencedAttribute("fme_geometry{0}", "xtf_polyline");
                    } else if (type instanceof SurfaceOrAreaType) {
                        if (!wrapper.isHelper()) {
                            if (type instanceof SurfaceType) {
                                ret.setSequencedAttribute("fme_geometry{0}", "xtf_surface");
                            } else {
                                if (!(type instanceof AreaType)) throw new IllegalStateException();
                                ret.setSequencedAttribute("fme_geometry{0}", "xtf_area");
                            }
                            if (this.itfMode == 2) {
                                this.pendingSchemaFeature = this.session.createFeature();
                                ret.clone(this.pendingSchemaFeature);
                                if (type instanceof SurfaceType) {
                                    this.pendingSchemaFeature.setSequencedAttribute("fme_geometry{0}", "xtf_none");
                                } else {
                                    if (!(type instanceof AreaType)) throw new IllegalStateException();
                                    this.pendingSchemaFeature.setSequencedAttribute("fme_geometry{0}", "xtf_coord");
                                }
                                String featureType = ret.getFeatureType();
                                this.pendingSchemaFeature.setFeatureType(featureType + "_MT");
                            } else if (this.itfMode == 3) {
                                if (type instanceof SurfaceType) {
                                    ret.setSequencedAttribute("fme_geometry{0}", "xtf_none");
                                } else {
                                    if (!(type instanceof AreaType)) throw new IllegalStateException();
                                    ret.setSequencedAttribute("fme_geometry{0}", "xtf_coord");
                                }
                                if (this.v6_createLineTableFeatures != null && this.v6_createLineTableFeatures.booleanValue()) {
                                    String featureType = ret.getFeatureType();
                                    ret.setFeatureType(featureType + "_MT");
                                }
                            }
                        } else {
                            String fkName;
                            if (this.itfMode != 3 && this.itfMode != 2) continue;
                            if (this.v6_createLineTableFeatures != null && this.v6_createLineTableFeatures.booleanValue()) {
                                String featureType = ret.getFeatureType();
                                ret.setFeatureType(featureType + "_LT");
                            }
                            ret.setSequencedAttribute("fme_geometry{0}", "xtf_polyline");
                            if (type instanceof SurfaceType) {
                                fkName = ModelUtilities.getHelperTableMainTableRef(wrapper.getGeomAttr4FME());
                                ret.setSequencedAttribute(fkName, "xtf_char(200)");
                            } else {
                                if (!(type instanceof AreaType)) throw new IllegalStateException();
                                if (this.itfMode == 2) {
                                    fkName = ModelUtilities.getHelperTableMainTableRef(wrapper.getGeomAttr4FME());
                                    ret.setSequencedAttribute(fkName, "xtf_char(200)");
                                    String fk2Name = ModelUtilities.getHelperTableMainTableRef2(wrapper.getGeomAttr4FME());
                                    ret.setSequencedAttribute(fk2Name, "xtf_char(200)");
                                }
                            }
                            SurfaceOrAreaType surfaceType = (SurfaceOrAreaType)type;
                            Table lineAttrTable = surfaceType.getLineAttributeStructure();
                            if (lineAttrTable != null) {
                                Iterator<Extendable> attri = lineAttrTable.getAttributes();
                                while (attri.hasNext()) {
                                    AttributeDef attr = (AttributeDef)attri.next();
                                    this.mapAttributeDef(null, ret, attr, null);
                                }
                            }
                        }
                    } else {
                        if (!(type instanceof CoordType)) throw new IllegalStateException("!(type instanceof geomType)");
                        ret.setSequencedAttribute("fme_geometry{0}", "xtf_coord");
                    }
                }
            }
            this.seenFmeTypes.add(wrapper);
            return ret;
        }
        this.transferViewablei = null;
        return null;
    }

    private String mapEnumDefName(Object enumDef) {
        String enumTypeName = null;
        if (enumDef instanceof AttributeDef) {
            AttributeDef attr = (AttributeDef)enumDef;
            enumTypeName = attr.getContainer().getScopedName(null) + "." + attr.getName();
        } else if (enumDef instanceof Domain) {
            Domain domain = (Domain)enumDef;
            enumTypeName = domain.getScopedName(null);
        } else {
            throw new IllegalStateException();
        }
        return enumTypeName;
    }

    private void mapFeatureType(AttributeDef geomAttr, IFMEFeature ret, ViewableWrapper wrapper, String attrNamePrefix) {
        boolean isStruct;
        boolean bl = isStruct = attrNamePrefix != null;
        if (!isStruct) {
            attrNamePrefix = "";
        }
        List attrv = wrapper.getAttrv();
        if (!isStruct) {
            ret.setFeatureType(wrapper.getFmeFeatureType());
            ret.setSequencedAttribute("xtf_id", "xtf_char(200)");
        } else {
            ret.setSequencedAttribute(attrNamePrefix + "xtf_class", this.getIliQNameType());
        }
        for (int i = 0; i < attrv.size(); ++i) {
            AssociationDef assocClass;
            ViewableTransferElement attro = (ViewableTransferElement)attrv.get(i);
            if (attro.obj instanceof AttributeDef) {
                AttributeDef attr = (AttributeDef)attro.obj;
                this.mapAttributeDef(geomAttr, ret, attr, attrNamePrefix);
                continue;
            }
            if (!(attro.obj instanceof RoleDef)) continue;
            RoleDef role = (RoleDef)attro.obj;
            ret.setSequencedAttribute(attrNamePrefix + role.getName(), "xtf_char(200)");
            if (!attro.embedded || !(assocClass = (AssociationDef)role.getContainer()).getAttributes().hasNext() && !assocClass.getLightweightAssociations().iterator().hasNext()) continue;
            Viewable rootAssocClass = ModelUtility.getRoot(assocClass);
            if (rootAssocClass == null) {
                rootAssocClass = assocClass;
            }
            this.mapFeatureType(null, ret, this.transferViewables.get(rootAssocClass.getScopedName((Container)null)), attrNamePrefix + role.getName() + "{}.");
        }
    }

    private void mapAttributeDef(AttributeDef geomAttr, IFMEFeature ret, AttributeDef attr, String attrNamePrefix) {
        Type type;
        if (attrNamePrefix == null) {
            attrNamePrefix = "";
        }
        if ((type = attr.getDomainResolvingAll()) instanceof LineType || type instanceof AbstractCoordType) {
            if (type instanceof AbstractCoordType && ((AbstractCoordType)type).getDimensions().length == 1) {
                String numType = this.mapNumericType((NumericType)((AbstractCoordType)type).getDimensions()[0]);
                if (type instanceof MultiCoordType) {
                    ret.setSequencedAttribute(attrNamePrefix + attr.getName() + "{}", numType);
                } else {
                    ret.setSequencedAttribute(attrNamePrefix + attr.getName(), numType);
                }
            } else if (geomAttr != attr) {
                ret.setSequencedAttribute(attrNamePrefix + attr.getName(), "xtf_buffer");
            }
        } else if (type instanceof CompositionType) {
            Table structClass = ((CompositionType)type).getComponentType();
            Viewable rootClass = ModelUtility.getRoot(structClass);
            if (rootClass == null) {
                rootClass = structClass;
            }
            this.mapFeatureType(null, ret, this.transferViewables.get(rootClass.getScopedName((Container)null)), attrNamePrefix + attr.getName() + "{}.");
        } else {
            String returnType = "xtf_char(255)";
            String fmeAttributeName = attrNamePrefix + attr.getName();
            if (Ili2Reader.isBoolean(this.iliTd, attr)) {
                returnType = "xtf_boolean";
            } else if (Ili2Reader.isIli1Date(this.iliTd, attr)) {
                returnType = "xtf_date";
            } else if (Ili2Reader.isIli2Date(this.iliTd, attr)) {
                returnType = "xtf_date";
            } else if (Ili2Reader.isIli2DateTime(this.iliTd, attr)) {
                returnType = "xtf_datetime";
            } else if (Ili2Reader.isIli2Time(this.iliTd, attr)) {
                returnType = "xtf_time";
            } else if (type instanceof ReferenceType) {
                returnType = "xtf_char(200)";
            } else if (!(type instanceof BasketType)) {
                if (type instanceof EnumerationType) {
                    returnType = this.ili1EnumAsItfCode ? "xtf_int16" : "xtf_char(255)";
                } else if (type instanceof NumericType) {
                    if (!type.isAbstract()) {
                        returnType = this.mapNumericType((NumericType)type);
                    }
                } else if (type instanceof TextType) {
                    returnType = ((TextType)type).getMaxLength() > 0 ? "xtf_char(" + ((TextType)type).getMaxLength() + ")" : "xtf_buffer";
                } else if (type instanceof BlackboxType) {
                    returnType = "xtf_buffer";
                }
            }
            if (attr.getDomainOrDerivedDomain().getCardinality().getMaximum() > 1L) {
                fmeAttributeName = String.format("%s{}.%s", fmeAttributeName, attr.getName());
            }
            ret.setSequencedAttribute(fmeAttributeName, returnType);
        }
    }

    private String mapNumericType(NumericType type) {
        String numType = null;
        PrecisionDecimal min = type.getMinimum();
        PrecisionDecimal max = type.getMaximum();
        if (min.getAccuracy() > 0) {
            int size = Math.max(min.toString().length(), max.toString().length());
            int precision = min.getAccuracy();
            numType = "xtf_decimal(" + size + "," + precision + ")";
        } else if (min.compareTo(new PrecisionDecimal(-2.147483648E9)) >= 0 && max.compareTo(new PrecisionDecimal(2.147483647E9)) <= 0) {
            numType = "xtf_int32";
        } else {
            int size = Math.max(min.toString().length(), max.toString().length());
            numType = "xtf_decimal(" + size + "," + 0 + ")";
        }
        return numType;
    }

    public static boolean isBoolean(TransferDescription td, Type type) {
        while (type instanceof TypeAlias) {
            if (((TypeAlias)type).getAliasing() == td.INTERLIS.BOOLEAN) {
                return true;
            }
            type = ((TypeAlias)type).getAliasing().getType();
        }
        return false;
    }

    public static boolean isBoolean(TransferDescription td, AttributeDef attr) {
        return attr.getDomain() instanceof TypeAlias && Ili2Reader.isBoolean(td, attr.getDomain());
    }

    public static boolean isIli1Date(TransferDescription td, AttributeDef attr) {
        if (attr.getDomain() instanceof TypeAlias) {
            Type type = attr.getDomain();
            while (type instanceof TypeAlias) {
                if (((TypeAlias)type).getAliasing() == td.INTERLIS.INTERLIS_1_DATE) {
                    return true;
                }
                type = ((TypeAlias)type).getAliasing().getType();
            }
        }
        return false;
    }

    public static boolean isIli2Date(TransferDescription td, AttributeDef attr) {
        FormattedType ft;
        Type type = attr.getDomain();
        if (type instanceof TypeAlias) {
            while (type instanceof TypeAlias) {
                if (((TypeAlias)type).getAliasing() == td.INTERLIS.XmlDate) {
                    return true;
                }
                type = ((TypeAlias)type).getAliasing().getType();
            }
        }
        return type instanceof FormattedType && (ft = (FormattedType)type).getDefinedBaseDomain() == td.INTERLIS.XmlDate;
    }

    public static boolean isIli2Time(TransferDescription td, AttributeDef attr) {
        FormattedType ft;
        Type type = attr.getDomain();
        if (type instanceof TypeAlias) {
            while (type instanceof TypeAlias) {
                if (((TypeAlias)type).getAliasing() == td.INTERLIS.XmlTime) {
                    return true;
                }
                type = ((TypeAlias)type).getAliasing().getType();
            }
        }
        return type instanceof FormattedType && (ft = (FormattedType)type).getDefinedBaseDomain() == td.INTERLIS.XmlTime;
    }

    public static boolean isIli2DateTime(TransferDescription td, AttributeDef attr) {
        FormattedType ft;
        Type type = attr.getDomain();
        if (type instanceof TypeAlias) {
            while (type instanceof TypeAlias) {
                if (((TypeAlias)type).getAliasing() == td.INTERLIS.XmlDateTime) {
                    return true;
                }
                type = ((TypeAlias)type).getAliasing().getType();
            }
        }
        return type instanceof FormattedType && (ft = (FormattedType)type).getDefinedBaseDomain() == td.INTERLIS.XmlDateTime;
    }

    public boolean spatialEnabled() throws Exception {
        return false;
    }

    public void setConstraints(IFMEFeature arg0) throws Exception {
    }

    private void addCoord(IFMEFeature ret, IomObject value) throws DataException {
        if (value != null) {
            double yCoord;
            double xCoord;
            String c1 = value.getattrvalue("C1");
            String c2 = value.getattrvalue("C2");
            String c3 = value.getattrvalue("C3");
            try {
                xCoord = Double.parseDouble(c1);
            }
            catch (Exception ex) {
                throw new DataException("failed to read C1 <" + c1 + ">", ex);
            }
            try {
                yCoord = Double.parseDouble(c2);
            }
            catch (Exception ex) {
                throw new DataException("failed to read C2 <" + c2 + ">", ex);
            }
            if (c3 == null) {
                ret.setDimension(2);
                ret.add2DCoordinate(xCoord, yCoord);
            } else {
                double zCoord;
                try {
                    zCoord = Double.parseDouble(c3);
                }
                catch (Exception ex) {
                    throw new DataException("failed to read C3 <" + c3 + ">", ex);
                }
                ret.setDimension(3);
                ret.add3DCoordinate(xCoord, yCoord, zCoord);
            }
        }
    }

    private void addArc(IFMEFeature ret, IomObject value, double p) throws DataException {
        if (value != null) {
            double pti_ho;
            double pti_re;
            int i;
            double ri;
            double arcPt_ho;
            double arcPt_re;
            double pt2_ho;
            double pt2_re;
            String c1 = value.getattrvalue("C1");
            String c2 = value.getattrvalue("C2");
            String c3 = value.getattrvalue("C3");
            String a1 = value.getattrvalue("A1");
            String a2 = value.getattrvalue("A2");
            try {
                pt2_re = Double.parseDouble(c1);
            }
            catch (Exception ex) {
                throw new DataException("failed to read C1 <" + c1 + ">", ex);
            }
            try {
                pt2_ho = Double.parseDouble(c2);
            }
            catch (Exception ex) {
                throw new DataException("failed to read C2 <" + c2 + ">", ex);
            }
            try {
                arcPt_re = Double.parseDouble(a1);
            }
            catch (Exception ex) {
                throw new DataException("failed to read A1 <" + a1 + ">", ex);
            }
            try {
                arcPt_ho = Double.parseDouble(a2);
            }
            catch (Exception ex) {
                throw new DataException("failed to read A2 <" + a2 + ">", ex);
            }
            if (p == 0.0) {
                ret.add2DCoordinate(arcPt_re, arcPt_ho);
                ret.add2DCoordinate(pt2_re, pt2_ho);
                return;
            }
            int lastCoord = ret.numCoords();
            double[] p1 = null;
            try {
                p1 = ret.get2DCoordinate(lastCoord - 1);
            }
            catch (FMEException ex) {
                EhiLogger.logError(ex);
                ret.add2DCoordinate(arcPt_re, arcPt_ho);
                ret.add2DCoordinate(pt2_re, pt2_ho);
            }
            double pt1_re = p1[0];
            double pt1_ho = p1[1];
            double a = Ili2Reader.dist(pt1_re, pt1_ho, arcPt_re, arcPt_ho);
            double b = Ili2Reader.dist(arcPt_re, arcPt_ho, pt2_re, pt2_ho);
            double c = Ili2Reader.dist(pt1_re, pt1_ho, pt2_re, pt2_ho);
            double s = (a + b + c) / 2.0;
            double ds = Math.atan2(pt2_re - arcPt_re, pt2_ho - arcPt_ho) - Math.atan2(pt1_re - arcPt_re, pt1_ho - arcPt_ho);
            double rSign = Math.sin(ds) > 0.0 ? -1.0 : 1.0;
            double r = a * b * c / 4.0 / Math.sqrt(s * (s - a) * (s - b) * (s - c)) * rSign;
            double thetaM = Math.atan2(arcPt_re - pt1_re, arcPt_ho - pt1_ho) + Math.acos(a / 2.0 / r);
            double reM = pt1_re + r * Math.sin(thetaM);
            double hoM = pt1_ho + r * Math.cos(thetaM);
            double theta = 2.0 * Math.acos(1.0 - p / Math.abs(r));
            if (a > 2.0 * p) {
                double alpha = 2.0 * Math.asin(a / 2.0 / Math.abs(r));
                int alphan = (int)Math.ceil(alpha / theta);
                double alphai = alpha / (double)(alphan * (r > 0.0 ? 1 : -1));
                ri = Math.atan2(pt1_re - reM, pt1_ho - hoM);
                for (i = 1; i < alphan; ++i) {
                    pti_re = reM + Math.abs(r) * Math.sin(ri += alphai);
                    pti_ho = hoM + Math.abs(r) * Math.cos(ri);
                    ret.add2DCoordinate(pti_re, pti_ho);
                }
            }
            ret.add2DCoordinate(arcPt_re, arcPt_ho);
            if (b > 2.0 * p) {
                double beta = 2.0 * Math.asin(b / 2.0 / Math.abs(r));
                int betan = (int)Math.ceil(beta / theta);
                double betai = beta / (double)(betan * (r > 0.0 ? 1 : -1));
                ri = Math.atan2(arcPt_re - reM, arcPt_ho - hoM);
                for (i = 1; i < betan; ++i) {
                    pti_re = reM + Math.abs(r) * Math.sin(ri += betai);
                    pti_ho = hoM + Math.abs(r) * Math.cos(ri);
                    ret.add2DCoordinate(pti_re, pti_ho);
                }
            }
            ret.add2DCoordinate(pt2_re, pt2_ho);
        }
    }

    private static double sqr(double x) {
        return x * x;
    }

    private static double dist(double re1, double ho1, double re2, double ho2) {
        double ret = Math.hypot(re2 - re1, ho2 - ho1);
        return ret;
    }

    private void setPolyline(IFMEFeature ret, IomObject obj, boolean isSurfaceOrArea, double p) throws DataException {
        IomObject lineattr;
        if (obj == null) {
            return;
        }
        if (!isSurfaceOrArea) {
            ret.setGeometryType(2);
        }
        if (isSurfaceOrArea && (lineattr = obj.getattrobj("lineattr", 0)) != null) {
            EhiLogger.logAdaption("Lineattributes not supported by FME; ignored");
        }
        boolean clipped = obj.getobjectconsistency() == 1;
        for (int sequencei = 0; sequencei < obj.getattrvaluecount("sequence"); ++sequencei) {
            if (!clipped && sequencei > 0) {
                EhiLogger.logError("unclipped polyline with multi 'sequence' elements");
                break;
            }
            IomObject sequence = obj.getattrobj("sequence", sequencei);
            for (int segmenti = 0; segmenti < sequence.getattrvaluecount("segment"); ++segmenti) {
                IomObject segment = sequence.getattrobj("segment", segmenti);
                if (segment.getobjecttag().equals("COORD")) {
                    this.addCoord(ret, segment);
                    continue;
                }
                if (segment.getobjecttag().equals("ARC")) {
                    this.addArc(ret, segment, p);
                    continue;
                }
                EhiLogger.logAdaption("custom line form not supported by FME; ignored");
            }
            if (!clipped) continue;
        }
    }

    private void setSurface(IFMEFeature ret, IomObject obj, SurfaceOrAreaType type) throws DataException {
        if (obj == null) {
            return;
        }
        ret.setGeometryType(8);
        boolean clipped = obj.getobjectconsistency() == 1;
        for (int surfacei = 0; surfacei < obj.getattrvaluecount("surface"); ++surfacei) {
            if (!clipped && surfacei > 0) {
                EhiLogger.logError("unclipped surface with multi 'surface' elements");
                break;
            }
            IomObject surface = obj.getattrobj("surface", surfacei);
            for (int boundaryi = 0; boundaryi < surface.getattrvaluecount("boundary"); ++boundaryi) {
                IomObject boundary = surface.getattrobj("boundary", boundaryi);
                for (int polylinei = 0; polylinei < boundary.getattrvaluecount("polyline"); ++polylinei) {
                    IomObject polyline = boundary.getattrobj("polyline", polylinei);
                    this.setPolyline(ret, polyline, true, this.getP(type));
                }
            }
            if (!clipped) continue;
        }
    }

    private void setSurface(IFMEFeature ret, IomObject obj) throws DataException {
        if (obj == null) {
            return;
        }
        ret.setGeometryType(8);
        boolean clipped = obj.getobjectconsistency() == 1;
        for (int surfacei = 0; surfacei < obj.getattrvaluecount("surface"); ++surfacei) {
            if (!clipped && surfacei > 0) {
                EhiLogger.logError("unclipped surface with multi 'surface' elements");
                break;
            }
            IomObject surface = obj.getattrobj("surface", surfacei);
            for (int boundaryi = 0; boundaryi < surface.getattrvaluecount("boundary"); ++boundaryi) {
                IomObject boundary = surface.getattrobj("boundary", boundaryi);
                for (int polylinei = 0; polylinei < boundary.getattrvaluecount("polyline"); ++polylinei) {
                    IomObject polyline = boundary.getattrobj("polyline", polylinei);
                    this.setPolyline(ret, polyline, true, 0.0);
                }
            }
            if (!clipped) continue;
        }
    }

    private void enqueStructValue(int parentSqlId, String parentSqlType, String parentSqlAttr, IomObject struct, int structi) {
        this.structQueue.add(new StructWrapper(parentSqlId, parentSqlType, parentSqlAttr, struct, structi));
    }

    private void cleanup() {
        if (this.geomConv != null) {
            this.geomConv.dispose();
        }
        if (this.geomAttrIterator != null) {
            this.geomAttrIterator.dispose();
            this.geomAttrIterator = null;
        }
        if (this.validator != null) {
            this.validator.close();
            this.validator = null;
        }
        if (this.ioxReader != null) {
            try {
                this.ioxReader.close();
            }
            catch (IoxException ex) {
                EhiLogger.logError(ex);
            }
            this.ioxReader = null;
        }
        if (this.inputFile != null) {
            try {
                this.inputFile.close();
            }
            catch (IOException ex) {
                EhiLogger.logError(ex);
            }
            this.inputFile = null;
        }
        if (this.listener != null) {
            Main.endLogging(this.listener);
            this.listener = null;
        }
    }

    private String getIliQNameType() {
        return "xtf_char(" + Integer.toString(this.iliQNameSize) + ")";
    }

    private void collectEnums(TransferDescription td) {
        this.enumDefs = new ArrayList();
        this.enumDefi = null;
        Iterator modeli = td.iterator();
        while (modeli.hasNext()) {
            Object modelo = modeli.next();
            if (!(modelo instanceof Model)) continue;
            Model model = (Model)modelo;
            Iterator topici = model.iterator();
            while (topici.hasNext()) {
                Object topico = topici.next();
                if (topico instanceof Topic) {
                    Topic topic = (Topic)topico;
                    Iterator classi = topic.iterator();
                    while (classi.hasNext()) {
                        Element ele = (Element)classi.next();
                        if (ele instanceof AbstractClassDef) {
                            AbstractClassDef aclass = (AbstractClassDef)ele;
                            Iterator iter = aclass.iterator();
                            while (iter.hasNext()) {
                                AttributeDef attr;
                                Object obj = iter.next();
                                if (!(obj instanceof AttributeDef) || (attr = (AttributeDef)obj).getExtending() != null || attr.isTransient() || !(attr.getDomain() instanceof EnumerationType)) continue;
                                this.enumDefs.add(attr);
                            }
                            continue;
                        }
                        if (!(ele instanceof Domain) || !(((Domain)ele).getType() instanceof EnumerationType)) continue;
                        this.enumDefs.add(ele);
                    }
                    continue;
                }
                if (topico instanceof AbstractClassDef) {
                    AbstractClassDef aclass = (AbstractClassDef)topico;
                    Iterator iter = aclass.iterator();
                    while (iter.hasNext()) {
                        AttributeDef attr;
                        Object obj = iter.next();
                        if (!(obj instanceof AttributeDef) || (attr = (AttributeDef)obj).getExtending() != null || attr.isTransient() || !(attr.getDomain() instanceof EnumerationType)) continue;
                        this.enumDefs.add(attr);
                    }
                    continue;
                }
                if (!(topico instanceof Domain) || !(((Domain)topico).getType() instanceof EnumerationType)) continue;
                this.enumDefs.add(topico);
            }
        }
    }

    private IFMEFeature processEnums(IFMEFeature ret) {
        if (this.enumDefi == null) {
            this.enumDefi = this.enumDefs.iterator();
        }
        while (this.enumDefi.hasNext() || this.currentEnumElementIterator != null && this.currentEnumElementIterator.hasNext()) {
            if (this.currentEnumElementIterator == null || !this.currentEnumElementIterator.hasNext()) {
                this.currentEnumDef = (Element)this.enumDefi.next();
            }
            String enumTypeName = this.mapEnumDefName(this.currentEnumDef);
            EnumerationType type = null;
            Element base = null;
            if (this.currentEnumDef instanceof AttributeDef) {
                type = (EnumerationType)((AttributeDef)this.currentEnumDef).getDomain();
                base = ((AttributeDef)this.currentEnumDef).getExtending();
            } else if (this.currentEnumDef instanceof Domain) {
                type = (EnumerationType)((Domain)this.currentEnumDef).getType();
                base = ((Domain)this.currentEnumDef).getExtending();
            } else {
                throw new IllegalStateException();
            }
            ArrayList ev = new ArrayList();
            boolean isOrdered = type.isOrdered();
            String baseClass = null;
            if (base != null) {
                baseClass = this.mapEnumDefName(base);
            }
            if (this.currentEnumElementIterator == null || !this.currentEnumElementIterator.hasNext()) {
                ModelUtilities.buildEnumList(ev, "", type.getConsolidatedEnumeration());
                this.currentEnumItfCode = 0;
                this.currentEnumSeq = 0;
                this.currentEnumElementIterator = ev.iterator();
            }
            if (!this.currentEnumElementIterator.hasNext()) continue;
            String ele = (String)this.currentEnumElementIterator.next();
            if (this.createEnumTypes == 2) {
                ret.setFeatureType("XTF_ENUMS");
            } else {
                ret.setFeatureType(enumTypeName);
            }
            ret.setStringAttribute("iliCode", ele);
            ret.setStringAttribute("itfCode", Integer.toString(this.currentEnumItfCode));
            if (isOrdered) {
                ret.setStringAttribute("seq", Integer.toString(this.currentEnumSeq));
            }
            if (this.createEnumTypes == 2) {
                ret.setStringAttribute("thisEnum", enumTypeName);
                if (baseClass != null) {
                    ret.setStringAttribute("baseEnum", baseClass);
                }
            }
            ++this.currentEnumItfCode;
            ++this.currentEnumSeq;
            return ret;
        }
        return null;
    }

    public boolean getProperties(String propertyCategory, ArrayList values) throws Exception {
        values.clear();
        return false;
    }
}

