/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2fme;

import COM.safe.fmeobjects.IFMEArc;
import COM.safe.fmeobjects.IFMEArea;
import COM.safe.fmeobjects.IFMECurve;
import COM.safe.fmeobjects.IFMEDonut;
import COM.safe.fmeobjects.IFMEGeometry;
import COM.safe.fmeobjects.IFMEGeometryTools;
import COM.safe.fmeobjects.IFMELine;
import COM.safe.fmeobjects.IFMEMultiArea;
import COM.safe.fmeobjects.IFMEMultiCurve;
import COM.safe.fmeobjects.IFMEMultiPoint;
import COM.safe.fmeobjects.IFMEPath;
import COM.safe.fmeobjects.IFMEPoint;
import COM.safe.fmeobjects.IFMEPolygon;
import COM.safe.fmeobjects.IFMESession;
import ch.ehi.basics.logging.EhiLogger;
import ch.interlis.ili2fme.DataException;
import ch.interlis.iom.IomObject;

public class Iox2fme {
    private static boolean firstLineattrib = true;

    private Iox2fme() {
    }

    public static IFMEPoint coord2FME(IFMESession session, IomObject value) throws DataException {
        double yCoord;
        double xCoord;
        if (value == null) {
            return null;
        }
        String c1 = value.getattrvalue("C1");
        String c2 = value.getattrvalue("C2");
        String c3 = value.getattrvalue("C3");
        try {
            xCoord = Double.parseDouble(c1);
        }
        catch (Exception ex) {
            throw new DataException("failed to read C1 <" + c1 + ">", ex);
        }
        try {
            yCoord = Double.parseDouble(c2);
        }
        catch (Exception ex) {
            throw new DataException("failed to read C2 <" + c2 + ">", ex);
        }
        IFMEPoint coord = null;
        IFMEGeometryTools tools = session.getGeometryTools();
        if (c3 == null) {
            coord = tools.createPointXY(xCoord, yCoord);
        } else {
            double zCoord;
            try {
                zCoord = Double.parseDouble(c3);
            }
            catch (Exception ex) {
                throw new DataException("failed to read C3 <" + c3 + ">", ex);
            }
            coord = tools.createPointXYZ(xCoord, yCoord, zCoord);
        }
        return coord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addArc(IFMESession session, IFMEPath path, IomObject startPt, IomObject value) throws DataException {
        block26: {
            if (value != null) {
                double arcPt_ho;
                double arcPt_re;
                double pt2_ho;
                double pt2_re;
                String c1 = value.getattrvalue("C1");
                String c2 = value.getattrvalue("C2");
                String c3 = value.getattrvalue("C3");
                String a1 = value.getattrvalue("A1");
                String a2 = value.getattrvalue("A2");
                try {
                    pt2_re = Double.parseDouble(c1);
                }
                catch (Exception ex) {
                    throw new DataException("failed to read C1 <" + c1 + ">", ex);
                }
                try {
                    pt2_ho = Double.parseDouble(c2);
                }
                catch (Exception ex) {
                    throw new DataException("failed to read C2 <" + c2 + ">", ex);
                }
                try {
                    arcPt_re = Double.parseDouble(a1);
                }
                catch (Exception ex) {
                    throw new DataException("failed to read A1 <" + a1 + ">", ex);
                }
                try {
                    arcPt_ho = Double.parseDouble(a2);
                }
                catch (Exception ex) {
                    throw new DataException("failed to read A2 <" + a2 + ">", ex);
                }
                IFMEGeometryTools tools = session.getGeometryTools();
                IFMEPoint startPoint = null;
                IFMEPoint arcPoint = null;
                IFMEPoint endPoint = null;
                IFMEArc arc = null;
                try {
                    startPoint = Iox2fme.coord2FME(session, startPt);
                    arcPoint = tools.createPointXY(arcPt_re, arcPt_ho);
                    endPoint = tools.createPointXY(pt2_re, pt2_ho);
                    arc = tools.createArcBy3Points(startPoint, arcPoint, endPoint);
                    if (!Double.valueOf(arc.getSweepAngle()).isNaN() && !(Math.abs(arc.getSweepAngle()) < 1.0E-4)) {
                        if (startPoint.equals(arcPoint) || endPoint.equals(arcPoint)) {
                            EhiLogger.logAdaption("Ignored arc because arcpoint identical to start or end point(" + arcPoint.getX() + "," + arcPoint.getY() + ")");
                            IFMELine line = null;
                            try {
                                line = tools.convertToLine((IFMECurve)arc);
                                path.appendCurve((IFMECurve)line);
                                break block26;
                            }
                            finally {
                                if (line != null) {
                                    line.dispose();
                                    line = null;
                                }
                            }
                        }
                        path.appendCurve((IFMECurve)arc);
                        break block26;
                    }
                    EhiLogger.logAdaption("Changed straight arc to straight on arc point (" + arcPoint.getX() + "," + arcPoint.getY() + ")");
                    IFMELine line = null;
                    try {
                        line = tools.convertToLine((IFMECurve)arc);
                        path.appendCurve((IFMECurve)line);
                    }
                    finally {
                        if (line != null) {
                            line.dispose();
                            line = null;
                        }
                    }
                }
                finally {
                    if (startPoint != null) {
                        startPoint.dispose();
                        startPoint = null;
                    }
                    if (arcPoint != null) {
                        arcPoint.dispose();
                        arcPoint = null;
                    }
                    if (endPoint != null) {
                        endPoint.dispose();
                        endPoint = null;
                    }
                    if (arc != null) {
                        arc.dispose();
                        arc = null;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IFMEPath polyline2FME(IFMESession session, IomObject polylineObj, boolean isSurfaceOrArea) throws DataException {
        boolean clipped;
        IomObject lineattr;
        if (polylineObj == null) {
            return null;
        }
        IFMEGeometryTools tools = session.getGeometryTools();
        IFMEPath ret = tools.createPath();
        if (isSurfaceOrArea && (lineattr = polylineObj.getattrobj("lineattr", 0)) != null && firstLineattrib) {
            EhiLogger.logAdaption("XTF lineattributes not yet supported");
            firstLineattrib = false;
        }
        boolean bl = clipped = polylineObj.getobjectconsistency() == 1;
        if (clipped) {
            throw new DataException("clipped polyline not supported");
        }
        IomObject arcStartPt = null;
        for (int sequencei = 0; sequencei < polylineObj.getattrvaluecount("sequence"); ++sequencei) {
            if (!clipped && sequencei > 0) {
                throw new DataException("unclipped polyline with multi 'sequence' elements");
            }
            IomObject sequence = polylineObj.getattrobj("sequence", sequencei);
            int segmentc = sequence.getattrvaluecount("segment");
            for (int segmenti = 0; segmenti < segmentc; ++segmenti) {
                IomObject segment = sequence.getattrobj("segment", segmenti);
                if (segment.getobjecttag().equals("COORD")) {
                    if (sequencei != 0 || segmenti != 0 || segmentc <= 1 || sequence.getattrobj("segment", segmenti + 1).getobjecttag().equals("COORD")) {
                        IFMEPoint point = null;
                        try {
                            point = Iox2fme.coord2FME(session, segment);
                            ret.extendToPoint(point);
                        }
                        finally {
                            if (point != null) {
                                point.dispose();
                                point = null;
                            }
                        }
                    }
                } else if (segment.getobjecttag().equals("ARC")) {
                    Iox2fme.addArc(session, ret, arcStartPt, segment);
                } else {
                    throw new DataException("custom line form not supported");
                }
                arcStartPt = segment;
            }
            if (!clipped) continue;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IFMEArea surface2FMEUnchecked(IFMESession session, IomObject surface) throws DataException {
        IFMEPolygon ret = null;
        IFMEGeometryTools tools = session.getGeometryTools();
        int boundaryc = surface.getattrvaluecount("boundary");
        for (int boundaryi = 0; boundaryi < boundaryc; ++boundaryi) {
            IomObject boundary = surface.getattrobj("boundary", boundaryi);
            IFMEPath fmeBoundary = null;
            try {
                fmeBoundary = tools.createPath();
                for (int polylinei = 0; polylinei < boundary.getattrvaluecount("polyline"); ++polylinei) {
                    IomObject polyline = boundary.getattrobj("polyline", polylinei);
                    IFMEPath fmeLine = null;
                    try {
                        fmeLine = Iox2fme.polyline2FME(session, polyline, true);
                        fmeBoundary.appendCurve((IFMECurve)fmeLine);
                        continue;
                    }
                    finally {
                        if (fmeLine != null) {
                            fmeLine.dispose();
                        }
                    }
                }
                if (boundaryi == 0) {
                    if (boundaryc == 1) {
                        ret = tools.createPolygonByCurve((IFMECurve)fmeBoundary);
                        continue;
                    }
                    ret = tools.createDonutByCurve((IFMECurve)fmeBoundary);
                    continue;
                }
                ((IFMEDonut)ret).addInnerBoundaryCurve((IFMECurve)fmeBoundary);
                continue;
            }
            finally {
                if (fmeBoundary != null) {
                    fmeBoundary.dispose();
                }
            }
        }
        return ret;
    }

    public static IFMEArea surface2FME(IFMESession session, IomObject obj) throws DataException {
        boolean clipped;
        if (obj == null || obj.getattrvaluecount("surface") == 0) {
            return null;
        }
        boolean bl = clipped = obj.getobjectconsistency() == 1;
        if (clipped) {
            throw new DataException("clipped surface not supported");
        }
        if (obj.getattrvaluecount("surface") > 1) {
            throw new DataException("unclipped surface with multi 'surface' elements");
        }
        IomObject surface = obj.getattrobj("surface", 0);
        return Iox2fme.surface2FMEUnchecked(session, surface);
    }

    public static IFMEGeometry geom2FME(IFMESession session, IomObject obj) throws DataException {
        if (obj == null) {
            return null;
        }
        String type = obj.getobjecttag();
        if (type.equals("COORD")) {
            return Iox2fme.coord2FME(session, obj);
        }
        if (type.equals("POLYLINE")) {
            return Iox2fme.polyline2FME(session, obj, false);
        }
        if (type.equals("MULTISURFACE")) {
            return Iox2fme.surface2FME(session, obj);
        }
        throw new DataException("unexpected type " + type);
    }

    public static IFMEMultiCurve multipolyline2FME(IFMESession session, IomObject value) throws DataException {
        IFMEGeometryTools tools = session.getGeometryTools();
        IFMEMultiCurve multiCurve = tools.createMultiCurve();
        for (int i = 0; i < value.getattrvaluecount("polyline"); ++i) {
            IomObject polyline = value.getattrobj("polyline", i);
            IFMEPath curve = Iox2fme.polyline2FME(session, polyline, false);
            multiCurve.appendPart((IFMECurve)curve);
        }
        return multiCurve;
    }

    public static IFMEMultiArea multisurface2FME(IFMESession session, IomObject value) throws DataException {
        boolean clipped;
        boolean bl = clipped = value.getobjectconsistency() == 1;
        if (clipped) {
            throw new DataException("clipped surface not supported");
        }
        IFMEGeometryTools tools = session.getGeometryTools();
        IFMEMultiArea multiArea = tools.createMultiArea();
        for (int i = 0; i < value.getattrvaluecount("surface"); ++i) {
            IomObject surface = value.getattrobj("surface", i);
            IFMEArea area = Iox2fme.surface2FMEUnchecked(session, surface);
            multiArea.appendPart(area);
        }
        return multiArea;
    }

    public static IFMEMultiPoint multicoord2FME(IFMESession session, IomObject value) throws DataException {
        IFMEGeometryTools tools = session.getGeometryTools();
        IFMEMultiPoint multiPoint = tools.createMultiPoint();
        for (int i = 0; i < value.getattrvaluecount("coord"); ++i) {
            IomObject coord = value.getattrobj("coord", i);
            IFMEPoint point = Iox2fme.coord2FME(session, coord);
            multiPoint.appendPart(point);
        }
        return multiPoint;
    }
}

