/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2fme;

import COM.safe.fme.pluginbuilder.IFMEMappingFile;
import COM.safe.fme.pluginbuilder.IFMEWriter;
import COM.safe.fmeobjects.FMEException;
import COM.safe.fmeobjects.IFMEArea;
import COM.safe.fmeobjects.IFMECoordSysManager;
import COM.safe.fmeobjects.IFMECurve;
import COM.safe.fmeobjects.IFMEDonut;
import COM.safe.fmeobjects.IFMEFactoryPipeline;
import COM.safe.fmeobjects.IFMEFeature;
import COM.safe.fmeobjects.IFMEFeatureVectorOnDisk;
import COM.safe.fmeobjects.IFMEGeometry;
import COM.safe.fmeobjects.IFMELogFile;
import COM.safe.fmeobjects.IFMEMultiArea;
import COM.safe.fmeobjects.IFMEMultiCurve;
import COM.safe.fmeobjects.IFMEMultiPoint;
import COM.safe.fmeobjects.IFMENull;
import COM.safe.fmeobjects.IFMEPoint;
import COM.safe.fmeobjects.IFMESession;
import COM.safe.fmeobjects.IFMESimpleArea;
import COM.safe.fmeobjects.IFMEStringArray;
import COM.safe.fmeobjects.IFMEText;
import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.basics.settings.Settings;
import ch.ehi.basics.tools.StringUtility;
import ch.ehi.basics.types.OutParam;
import ch.ehi.basics.view.GenericFileFilter;
import ch.ehi.fme.Main;
import ch.interlis.ili2c.Ili2c;
import ch.interlis.ili2c.Ili2cException;
import ch.interlis.ili2c.config.Configuration;
import ch.interlis.ili2c.generator.XSDGenerator;
import ch.interlis.ili2c.metamodel.AreaType;
import ch.interlis.ili2c.metamodel.AssociationDef;
import ch.interlis.ili2c.metamodel.AttributeDef;
import ch.interlis.ili2c.metamodel.CompositionType;
import ch.interlis.ili2c.metamodel.Container;
import ch.interlis.ili2c.metamodel.CoordType;
import ch.interlis.ili2c.metamodel.Domain;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.Extendable;
import ch.interlis.ili2c.metamodel.Model;
import ch.interlis.ili2c.metamodel.MultiCoordType;
import ch.interlis.ili2c.metamodel.MultiPolylineType;
import ch.interlis.ili2c.metamodel.MultiSurfaceOrAreaType;
import ch.interlis.ili2c.metamodel.NoOid;
import ch.interlis.ili2c.metamodel.PolylineType;
import ch.interlis.ili2c.metamodel.PredefinedModel;
import ch.interlis.ili2c.metamodel.ReferenceType;
import ch.interlis.ili2c.metamodel.RoleDef;
import ch.interlis.ili2c.metamodel.SurfaceOrAreaType;
import ch.interlis.ili2c.metamodel.SurfaceType;
import ch.interlis.ili2c.metamodel.Table;
import ch.interlis.ili2c.metamodel.Topic;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.ili2c.metamodel.Type;
import ch.interlis.ili2c.metamodel.TypeModel;
import ch.interlis.ili2c.metamodel.Viewable;
import ch.interlis.ili2c.metamodel.ViewableTransferElement;
import ch.interlis.ili2fme.ConfigException;
import ch.interlis.ili2fme.DataException;
import ch.interlis.ili2fme.Fme2iox;
import ch.interlis.ili2fme.FmeLogListener;
import ch.interlis.ili2fme.FmeUtility;
import ch.interlis.ili2fme.GeometryConverter;
import ch.interlis.ili2fme.GeometryEncoding;
import ch.interlis.ili2fme.InheritanceMapping;
import ch.interlis.ili2fme.ModelUtility;
import ch.interlis.ili2fme.ViewableWrapper;
import ch.interlis.ilirepository.IliManager;
import ch.interlis.iom.IomObject;
import ch.interlis.iom_j.Iom_jObject;
import ch.interlis.iom_j.iligml.IligmlWriter;
import ch.interlis.iom_j.itf.ItfWriter;
import ch.interlis.iom_j.itf.ModelUtilities;
import ch.interlis.iom_j.xtf.OidSpace;
import ch.interlis.iom_j.xtf.XtfStartTransferEvent;
import ch.interlis.iom_j.xtf.XtfWriter;
import ch.interlis.iox.IoxException;
import ch.interlis.iox.IoxWriter;
import ch.interlis.iox.StartBasketEvent;
import ch.interlis.iox_j.EndBasketEvent;
import ch.interlis.iox_j.EndTransferEvent;
import ch.interlis.iox_j.ObjectEvent;
import ch.interlis.iox_j.PipelinePool;
import ch.interlis.iox_j.StartTransferEvent;
import ch.interlis.iox_j.inifile.MetaConfig;
import ch.interlis.iox_j.jts.Iox2jtsException;
import ch.interlis.iox_j.jts.Jts2iox;
import ch.interlis.iox_j.logging.Log2EhiLogger;
import ch.interlis.iox_j.logging.LogEventFactory;
import ch.interlis.iox_j.validator.ValidationConfig;
import ch.interlis.iox_j.validator.Validator;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Ili2Writer
implements IFMEWriter {
    private IFMEMappingFile mappingFile = null;
    private IFMESession session = null;
    private String writerKeyword = null;
    private String writerTypename = null;
    private String xtfFile = null;
    private IoxWriter ioxWriter = null;
    private OutputStream outputFile = null;
    private TransferDescription iliTd = null;
    private HashMap<String, StartBasketEvent> basketv = null;
    private ArrayList<BasketSeq> basketOrder = null;
    private HashMap<String, IFMEFeatureVectorOnDisk> featurebufferv = new HashMap();
    private HashMap<String, ViewableWrapper> fmeFeatureTypev = null;
    private HashMap<String, Element> tag2class = null;
    private int formatMode = 0;
    private static final int MODE_XTF = 1;
    private static final int MODE_ITF = 2;
    private static final int MODE_GML = 3;
    private static final int MODE_XRF = 4;
    private int inheritanceMapping = 1;
    private boolean useLineTableFeatures = true;
    private boolean scanXtfBaskets = true;
    private boolean autoXtfBaskets = true;
    private IliManager repositoryManager = null;
    private HashSet<String> modelsFromFME = null;
    private String fme_coord_sys = null;
    private String epsgCode = null;
    private int geometryEncoding = 1;
    private GeometryConverter geomConv = null;
    private String metaConfig = null;
    private Validator validator = null;
    private boolean validate = false;
    private String validationConfig = null;
    private boolean validateMultiplicity = false;
    private boolean checkUniqueOid = false;
    private boolean trimValues = true;
    private HashMap<String, String> checkoids = null;
    private int maxTid = 1;
    private IFMELogFile fmeLog = null;
    private XtfStartTransferEvent startTransferEvent = null;
    private FmeLogListener listener = null;

    public Ili2Writer(IFMESession session1, IFMEMappingFile mappingFile1, String writerTypename, String keyword, IFMELogFile log) {
        this.mappingFile = mappingFile1;
        this.writerKeyword = keyword;
        this.session = session1;
        this.writerTypename = writerTypename;
        this.fmeLog = log;
    }

    public void open(ArrayList<String> args) throws Exception {
        this.listener = Main.setupLogging(this.fmeLog);
        try {
            this.myopen(args);
        }
        catch (Exception ex) {
            EhiLogger.logError(ex);
            throw ex;
        }
    }

    private void myopen(ArrayList<String> args) throws Exception {
        if (args.size() == 0) {
            throw new IllegalArgumentException("args.size()==0");
        }
        this.maxTid = 1;
        for (int i = 0; i < args.size(); ++i) {
            String arg = args.get(i);
            if (!arg.equals("TRACEMSGS")) continue;
            EhiLogger.getInstance().setTraceFilter(!FmeUtility.isTrue(args.get(++i)));
            break;
        }
        Iterator elei = this.mappingFile.elements();
        while (elei.hasNext()) {
            ArrayList ele;
            String val;
            Object eleo = elei.next();
            if (!(eleo instanceof ArrayList) || !(val = (String)(ele = (ArrayList)eleo).get(0)).equals(this.writerKeyword + "_" + "TRACEMSGS")) continue;
            EhiLogger.getInstance().setTraceFilter(!FmeUtility.isTrue((String)ele.get(1)));
            break;
        }
        String httpProxyHost = null;
        String httpProxyPort = null;
        String models = null;
        String modeldir = null;
        for (int i = 0; i < args.size(); ++i) {
            String arg = args.get(i);
            EhiLogger.traceState("arg[" + Integer.toString(i) + "] " + arg);
            if (arg.equals("MODELS")) {
                models = args.get(++i);
                continue;
            }
            if (arg.equals("MODEL_DIR")) {
                modeldir = args.get(++i);
                continue;
            }
            if (arg.equals("INHERITANCE_MAPPING")) {
                this.inheritanceMapping = InheritanceMapping.valueOf(args.get(++i));
                continue;
            }
            if (arg.equals("GEOMETRY_ENCODING")) {
                this.geometryEncoding = GeometryEncoding.valueOf(args.get(++i));
                continue;
            }
            if (arg.equals("USE_LINETABLES")) {
                this.useLineTableFeatures = FmeUtility.isTrue(args.get(++i));
                continue;
            }
            if (arg.equals("CHECK_UNIQUEOID")) {
                this.checkUniqueOid = FmeUtility.isTrue(args.get(++i));
                continue;
            }
            if (arg.equals("META_CONFIG")) {
                this.metaConfig = args.get(++i);
                continue;
            }
            if (arg.equals("VALIDATE")) {
                this.validate = FmeUtility.isTrue(args.get(++i));
                continue;
            }
            if (arg.equals("VALIDATE_CONFIG")) {
                this.validationConfig = args.get(++i);
                continue;
            }
            if (arg.equals("VALIDATE_MULTIPLICITY")) {
                this.validateMultiplicity = FmeUtility.isTrue(args.get(++i));
                continue;
            }
            if (arg.equals("TRIM_VALUES")) {
                this.trimValues = FmeUtility.isTrue(args.get(++i));
                continue;
            }
            if (arg.equals("HTTP_PROXYHOST")) {
                httpProxyHost = args.get(++i);
                continue;
            }
            if (!arg.equals("HTTP_PROXYPORT")) continue;
            httpProxyPort = args.get(++i);
        }
        Iterator elei2 = this.mappingFile.elements();
        while (elei2.hasNext()) {
            Object eleo = elei2.next();
            EhiLogger.traceState("element " + eleo.getClass() + "," + eleo);
            if (!(eleo instanceof ArrayList)) continue;
            ArrayList ele = (ArrayList)eleo;
            String val = (String)ele.get(0);
            if (val.equals(this.writerKeyword + "_" + "MODELS")) {
                models = (String)ele.get(1);
                continue;
            }
            if (val.equals(this.writerKeyword + "_" + "MODEL_DIR")) {
                modeldir = (String)ele.get(1);
                continue;
            }
            if (val.equals(this.writerKeyword + "_" + "USE_LINETABLES")) {
                this.useLineTableFeatures = FmeUtility.isTrue((String)ele.get(1));
                continue;
            }
            if (val.equals(this.writerKeyword + "_" + "CHECK_UNIQUEOID")) {
                this.checkUniqueOid = FmeUtility.isTrue((String)ele.get(1));
                continue;
            }
            if (val.equals(this.writerKeyword + "_" + "META_CONFIG")) {
                this.metaConfig = StringUtility.purge((String)ele.get(1));
                continue;
            }
            if (val.equals(this.writerKeyword + "_" + "VALIDATE")) {
                this.validate = FmeUtility.isTrue((String)ele.get(1));
                continue;
            }
            if (val.equals(this.writerKeyword + "_" + "VALIDATE_CONFIG")) {
                this.validationConfig = StringUtility.purge((String)ele.get(1));
                continue;
            }
            if (val.equals(this.writerKeyword + "_" + "VALIDATE_MULTIPLICITY")) {
                this.validateMultiplicity = FmeUtility.isTrue((String)ele.get(1));
                continue;
            }
            if (val.equals(this.writerKeyword + "_" + "TRIM_VALUES")) {
                this.trimValues = FmeUtility.isTrue((String)ele.get(1));
                continue;
            }
            if (val.equals(this.writerKeyword + "_" + "INHERITANCE_MAPPING")) {
                this.inheritanceMapping = InheritanceMapping.valueOf((String)ele.get(1));
                continue;
            }
            if (val.equals(this.writerKeyword + "_" + "GEOMETRY_ENCODING")) {
                this.geometryEncoding = GeometryEncoding.valueOf((String)ele.get(1));
                continue;
            }
            if (val.equals(this.writerKeyword + "_" + "COORDINATE_SYSTEM")) {
                this.fme_coord_sys = (String)ele.get(1);
                continue;
            }
            if (val.equals(this.writerKeyword + "_" + "HTTP_PROXYHOST")) {
                httpProxyHost = StringUtility.purge((String)ele.get(1));
                continue;
            }
            if (!val.equals(this.writerKeyword + "_" + "HTTP_PROXYPORT")) continue;
            httpProxyPort = StringUtility.purge((String)ele.get(1));
        }
        if (models == null) {
            throw new IllegalArgumentException("model name not specified; set FME-Parameter Models");
        }
        Settings settings = new Settings();
        settings.setValue("ch.interlis.ili2c.http_proxy_host", httpProxyHost);
        settings.setValue("ch.interlis.ili2c.http_proxy_port", httpProxyPort);
        settings.setValue("ch.ehi.ili2fme.validationConfig", this.validationConfig);
        EhiLogger.logState("geometryEncoding <" + GeometryEncoding.toString(this.geometryEncoding) + ">");
        EhiLogger.logState("useLineTables <" + this.useLineTableFeatures + ">");
        EhiLogger.logState("checkUniqueOid <" + this.checkUniqueOid + ">");
        EhiLogger.logState("metaConfig <" + (this.metaConfig != null ? this.metaConfig : "") + ">");
        EhiLogger.logState("validate <" + this.validate + ">");
        EhiLogger.logState("validationConfig <" + (this.validationConfig != null ? this.validationConfig : "") + ">");
        EhiLogger.logState("validateMultiplicity <" + this.validateMultiplicity + ">");
        EhiLogger.logState("trimValues <" + this.trimValues + ">");
        EhiLogger.logState("inheritanceMapping <" + InheritanceMapping.toString(this.inheritanceMapping) + ">");
        EhiLogger.traceState("models <" + models + ">");
        this.xtfFile = args.get(0);
        if (this.xtfFile.length() >= 2 && this.xtfFile.charAt(0) == '/' && this.xtfFile.charAt(1) == '/') {
            StringBuffer x = new StringBuffer(this.xtfFile);
            x.setCharAt(0, '\\');
            x.setCharAt(1, '\\');
            this.xtfFile = x.toString();
        }
        EhiLogger.logState("xtfFile <" + this.xtfFile + ">");
        if (modeldir == null) {
            modeldir = new File(this.session.fmeHome(), "plugins/interlis2/ili22models").getAbsolutePath();
            modeldir = new File(this.session.fmeHome(), "plugins/interlis2/ilimodels").getAbsolutePath() + ";" + modeldir;
            modeldir = "http://models.interlis.ch/;" + modeldir;
            modeldir = "%XTF_DIR;" + modeldir;
        }
        EhiLogger.logState("modeldir <" + modeldir + ">");
        ch.interlis.ili2c.Main.setHttpProxySystemProperties(settings);
        this.repositoryManager = (IliManager)settings.getTransientObject("ch.interlis.ili2c.customIliManager");
        if (this.repositoryManager == null) {
            this.repositoryManager = new IliManager();
            settings.setTransientObject("ch.interlis.ili2c.customIliManager", this.repositoryManager);
        }
        String XTF_DATA_FILE = null;
        if (!this.xtfFile.startsWith("ilidata:")) {
            XTF_DATA_FILE = this.xtfFile;
        }
        Map<String, String> pathMap = Main.getPathMap(XTF_DATA_FILE, this.session.fmeHome());
        List<String> modeldirv = ch.interlis.ili2c.Main.resolvePathMap(modeldir, pathMap);
        this.repositoryManager.setRepositories(modeldirv.toArray(new String[0]));
        String metaConfigFilename = this.metaConfig;
        if (metaConfigFilename != null) {
            ArrayList<String> metaConfigFiles = new ArrayList<String>();
            HashSet<String> visitedFiles = new HashSet<String>();
            metaConfigFiles.add(metaConfigFilename);
            Settings metaSettings = new Settings();
            while (!metaConfigFiles.isEmpty()) {
                metaConfigFilename = (String)metaConfigFiles.remove(0);
                if (visitedFiles.contains(metaConfigFilename)) continue;
                visitedFiles.add(metaConfigFilename);
                EhiLogger.traceState("metaConfigFile <" + metaConfigFilename + ">");
                File metaConfigFile = null;
                try {
                    metaConfigFile = IliManager.getLocalCopyOfReposFile(this.repositoryManager, metaConfigFilename);
                }
                catch (Ili2cException e1) {
                    throw new IllegalArgumentException("failed to get local copy of meta config file <" + metaConfigFilename + ">");
                }
                OutParam<String> baseConfigs = new OutParam<String>();
                Settings newSettings = null;
                try {
                    newSettings = Main.readMetaConfig(metaConfigFile, baseConfigs);
                    if (baseConfigs.value != null) {
                        String[] baseConfigv;
                        for (String baseConfig : baseConfigv = ((String)baseConfigs.value).split(";")) {
                            metaConfigFiles.add(baseConfig);
                        }
                    }
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("failed to read meta config file <" + metaConfigFile.getPath() + ">", e);
                }
                MetaConfig.mergeSettings(newSettings, metaSettings);
            }
            MetaConfig.mergeSettings(metaSettings, settings);
        }
        MetaConfig.removeNullFromSettings(settings);
        this.validationConfig = settings.getValue("ch.ehi.ili2fme.validationConfig");
        try {
            if (this.validationConfig != null) {
                File localFile = IliManager.getLocalCopyOfReposFile(this.repositoryManager, this.validationConfig);
                this.validationConfig = localFile.getPath();
            }
        }
        catch (Ili2cException e2) {
            throw new IllegalArgumentException("failed to get local copy of remote files", e2);
        }
        String xtfExt = GenericFileFilter.getFileExtension(new File(this.xtfFile)).toLowerCase();
        if (xtfExt.equals("itf")) {
            this.formatMode = 2;
        } else if (xtfExt.equals("gml")) {
            this.formatMode = 3;
        } else if (xtfExt.equals("xrf")) {
            this.formatMode = 4;
        } else {
            if (xtfExt.equals("ili")) {
                throw new IllegalArgumentException("generating of INTERLIS model not yet supported by ili2fme");
            }
            this.formatMode = 1;
        }
        if (this.formatMode == 3) {
            if (this.fme_coord_sys == null) {
                throw new IllegalArgumentException("Coordinate System required if writing GML");
            }
            IFMECoordSysManager crs_mgr = this.session.coordSysManager();
            IFMEStringArray defv = this.session.createStringArray();
            crs_mgr.getCoordSysParms(this.fme_coord_sys, defv);
            int defc = defv.entries();
            int defi = 0;
            while (defi < defc) {
                String param = defv.getElement(defi++);
                String val = defv.getElement(defi++);
                if (!param.equals("EPSG")) continue;
                this.epsgCode = "urn:ogc:def:crs:EPSG::" + val;
            }
            EhiLogger.logState("default gml:srsName <" + this.epsgCode + ">");
        }
        ArrayList<String> iliModelv = null;
        this.modelsFromFME = new HashSet();
        if (!models.equals("%DATA")) {
            iliModelv = new ArrayList<String>(Arrays.asList(models.split(";")));
            this.setupModel(this.repositoryManager, iliModelv);
        }
        if (this.geometryEncoding != 1) {
            this.geomConv = new GeometryConverter(this.session, this.geometryEncoding);
        }
        if (this.checkUniqueOid) {
            this.checkoids = new HashMap();
        }
        this.outputFile = null;
        File outfile = new File(this.xtfFile);
        File outdir = outfile.getAbsoluteFile().getParentFile();
        if (!outdir.exists() && !outdir.mkdirs()) {
            throw new IOException("failed to create directory " + outdir.getAbsolutePath());
        }
        this.outputFile = new FileOutputStream(outfile);
    }

    private void setupModel(IliManager manager, ArrayList<String> iliModelv) throws Ili2cException {
        Configuration config = manager.getConfig(iliModelv, 0.0);
        Ili2c.logIliFiles(config);
        config.setGenerateWarnings(false);
        this.iliTd = Ili2c.runCompiler(config);
        if (this.iliTd == null) {
            throw new IllegalArgumentException("INTERLIS compiler failed");
        }
        if (this.formatMode == 1 || this.formatMode == 3) {
            this.fmeFeatureTypev = ModelUtility.getXtfTransferViewables(this.iliTd, this.inheritanceMapping);
            this.tag2class = XSDGenerator.getTagMap(this.iliTd);
        } else if (this.formatMode == 4) {
            this.fmeFeatureTypev = ModelUtility.getXtfTransferViewables(this.iliTd, this.inheritanceMapping);
            this.tag2class = XSDGenerator.getTagMap(this.iliTd);
        } else {
            this.fmeFeatureTypev = ModelUtility.getItfTransferViewables(this.iliTd);
            this.tag2class = ModelUtilities.getTagMap(this.iliTd);
        }
    }

    public void abort() throws Exception {
        try {
            this.myabort();
        }
        catch (Exception ex) {
            EhiLogger.logError(ex);
            throw ex;
        }
    }

    private void myabort() throws Exception {
        this.cleanup();
    }

    public void close() throws Exception {
        try {
            this.myclose();
        }
        catch (Exception ex) {
            EhiLogger.logError(ex);
            throw ex;
        }
    }

    private void myclose() throws Exception {
        if (this.outputFile != null && (this.iliTd != null || !this.modelsFromFME.isEmpty() || this.basketv != null && !this.basketv.isEmpty())) {
            if (this.iliTd == null) {
                ArrayList<String> iliModelv = new ArrayList<String>();
                iliModelv.addAll(this.modelsFromFME);
                this.setupModel(this.repositoryManager, iliModelv);
            }
            this.ioxWriter = this.formatMode == 1 ? new XtfWriter(this.outputFile, this.iliTd) : (this.formatMode == 3 ? new IligmlWriter(new OutputStreamWriter(this.outputFile), this.iliTd) : (this.formatMode == 4 ? null : new ItfWriter(this.outputFile, this.iliTd)));
            if (this.validate) {
                ValidationConfig modelConfig = new ValidationConfig();
                modelConfig.mergeIliMetaAttrs(this.iliTd);
                String configFilename = this.validationConfig;
                if (configFilename != null) {
                    try {
                        modelConfig.mergeConfigFile(new File(configFilename));
                    }
                    catch (IOException e) {
                        EhiLogger.logError("failed to read validator config file <" + configFilename + ">");
                    }
                }
                modelConfig.setConfigValue("PARAMETER", "multiplicity", this.validateMultiplicity ? "on" : "off");
                Settings config = new Settings();
                if (this.formatMode == 2) {
                    config.setValue("ch.interlis.iox_j.validator.doItfLinetables", "doItfLinetables");
                    Validator.initItfValidation(config);
                }
                Log2EhiLogger errHandler = new Log2EhiLogger();
                LogEventFactory errFactory = new LogEventFactory();
                errFactory.setDataSource(this.xtfFile);
                PipelinePool pipelinePool = new PipelinePool();
                this.validator = new Validator(this.iliTd, modelConfig, errHandler, errFactory, pipelinePool, config);
                this.validator.setAutoSecondPass(false);
            }
            if (this.startTransferEvent != null) {
                if (this.validator != null) {
                    this.validator.validate(this.startTransferEvent);
                }
                this.ioxWriter.write(this.startTransferEvent);
            } else {
                StartTransferEvent startTransferEvent = new StartTransferEvent(this.getStartTransferEventVersion(), null, null);
                if (this.validator != null) {
                    this.validator.validate(startTransferEvent);
                }
                this.ioxWriter.write(startTransferEvent);
            }
            if (this.formatMode == 1 || this.formatMode == 3) {
                this.writeXtfBuffers();
            } else if (this.formatMode == 4) {
                this.writeXtfBuffers();
            } else {
                this.writeItfBuffers();
            }
            EndTransferEvent endTransferEvent = new EndTransferEvent();
            if (this.validator != null) {
                this.validator.validate(endTransferEvent);
                this.validator.doSecondPass();
                this.validator.close();
                this.validator = null;
            }
            this.ioxWriter.write(endTransferEvent);
            this.ioxWriter.flush();
            this.ioxWriter.close();
            this.ioxWriter = null;
        }
        if (this.listener != null && this.listener.hasSeenErrors()) {
            this.listener.clearErrors();
            throw new Exception("INTERLIS 2 writer failed");
        }
        this.cleanup();
    }

    private String getStartTransferEventVersion() {
        return "ili2fme-" + Main.getVersion();
    }

    private void writeXtfBuffers() throws IoxException, Exception {
        if (this.basketv != null) {
            this.basketOrder.sort(new Comparator<BasketSeq>(){

                @Override
                public int compare(BasketSeq o1, BasketSeq o2) {
                    return Integer.compare(o1.getBasketSeq(), o2.getBasketSeq());
                }
            });
            Iterator<BasketSeq> basketi = this.basketOrder.iterator();
            while (basketi.hasNext()) {
                String basketId = basketi.next().getBasketId();
                ch.interlis.iox_j.StartBasketEvent startBasketEvent = (ch.interlis.iox_j.StartBasketEvent)this.basketv.get(basketId);
                if (this.autoXtfBaskets) {
                    startBasketEvent.setBid(this.newTid());
                }
                EhiLogger.logState(startBasketEvent.getType() + " " + startBasketEvent.getBid() + "...");
                Topic topic = (Topic)this.iliTd.getElement(startBasketEvent.getType());
                if (topic == null) {
                    throw new DataException("unknown TOPIC '" + startBasketEvent.getType() + "'");
                }
                Model model = (Model)topic.getContainer();
                if ("2.4".equals(model.getIliVersion()) && model.getTranslationOf() != null) {
                    throw new DataException("INTERLIS 2.4 features/attributes must be untranslated");
                }
                if (this.validator != null) {
                    this.validator.validate(startBasketEvent);
                }
                this.ioxWriter.write(startBasketEvent);
                this.writeBasket(basketId, false, null);
                EndBasketEvent endBasketEvent = new EndBasketEvent();
                if (this.validator != null) {
                    this.validator.validate(endBasketEvent);
                }
                this.ioxWriter.write(endBasketEvent);
            }
        }
    }

    private StartBasketEvent writeBasket(String bufferKey, boolean autoTid, StartBasketEvent startBasketEvent) throws Exception, IoxException {
        IFMEFeatureVectorOnDisk featurev = this.getFeatureBuffer(bufferKey);
        int featurec = featurev.entries();
        if (featurec > 0) {
            for (int featurei = 0; featurei < featurec; ++featurei) {
                IFMEFeature feature = featurev.getAt(featurei);
                try {
                    IomObject iomObj = this.mapFeature(feature, null, null, null, autoTid);
                    if (iomObj == null) {
                        throw new DataException("iomObj==null with feature " + feature.toString());
                    }
                    if (startBasketEvent != null) {
                        if (this.validator != null) {
                            this.validator.validate(startBasketEvent);
                        }
                        this.ioxWriter.write(startBasketEvent);
                        startBasketEvent = null;
                    }
                    ObjectEvent objEvent = new ObjectEvent(iomObj);
                    if (this.validator != null) {
                        this.validator.validate(objEvent);
                    }
                    this.ioxWriter.write(objEvent);
                }
                catch (Exception e) {
                    feature.performFunction("@Log()");
                    if (e instanceof DataException) {
                        EhiLogger.logError(e);
                    }
                    throw e;
                }
                feature.dispose();
            }
        }
        return startBasketEvent;
    }

    private StartBasketEvent writeItfLineTableArea(String mainTableName, String lineTableName, StartBasketEvent startBasketEvent) throws Exception, IoxException {
        IFMEFeatureVectorOnDisk featurev = this.getFeatureBuffer(mainTableName);
        int featurec = featurev.entries();
        if (featurec > 0) {
            IFMEFactoryPipeline lineTableBuilder = null;
            lineTableBuilder = this.session.createFactoryPipeline(mainTableName, null);
            String factory = null;
            boolean useTopology = false;
            if (useTopology) {
                factory = "FACTORY_DEF * TopologyFactory  INPUT FEATURE_TYPE * IGNORE_NODE_HEIGHTS yes OUTPUT LINE  FEATURE_TYPE " + lineTableName;
                EhiLogger.traceState("factory " + factory);
                lineTableBuilder.addFactory(factory, " ");
            } else {
                factory = "FACTORY_DEF * IntersectionFactory  INPUT FEATURE_TYPE * IGNORE_NODE_HEIGHTS yes OUTPUT SEGMENT  FEATURE_TYPE " + lineTableName;
                EhiLogger.traceState("factory " + factory);
                lineTableBuilder.addFactory(factory, " ");
            }
            for (int featurei = 0; featurei < featurec; ++featurei) {
                IFMEFeature feature = featurev.getAt(featurei);
                lineTableBuilder.processFeature(feature);
                feature.dispose();
            }
            lineTableBuilder.allDone();
            ViewableWrapper wrapper = this.fmeFeatureTypev.get(lineTableName);
            AttributeDef attr = wrapper.getGeomAttr4FME();
            String iomAttrName = ModelUtilities.getHelperTableGeomAttrName(attr);
            Type type = attr.getDomainResolvingAll();
            IFMEFeature feature = this.session.createFeature();
            while (lineTableBuilder.getOutputFeature(feature)) {
                Iom_jObject iomObj = null;
                iomObj = new Iom_jObject(lineTableName, this.newTid());
                this.mapItfPolylineValueOfLineTable(feature, iomObj, wrapper, type, iomAttrName);
                if (startBasketEvent != null) {
                    if (this.validator != null) {
                        this.validator.validate(startBasketEvent);
                    }
                    this.ioxWriter.write(startBasketEvent);
                    startBasketEvent = null;
                }
                ObjectEvent objEvent = new ObjectEvent(iomObj);
                if (this.validator != null) {
                    this.validator.validate(objEvent);
                }
                this.ioxWriter.write(objEvent);
            }
            feature.dispose();
            lineTableBuilder.dispose();
        }
        return startBasketEvent;
    }

    private String newTid() {
        return Integer.toString(++this.maxTid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StartBasketEvent writeItfLineTableSurface(String mainTableName, String lineTableName, StartBasketEvent startBasketEvent) throws Exception, IoxException {
        IFMEFeatureVectorOnDisk featurev = this.getFeatureBuffer(mainTableName);
        int featurec = featurev.entries();
        if (featurec > 0) {
            ViewableWrapper wrapper = this.fmeFeatureTypev.get(lineTableName);
            AttributeDef attr = wrapper.getGeomAttr4FME();
            String iomAttrName = ModelUtilities.getHelperTableGeomAttrName(attr);
            String fkName = ModelUtilities.getHelperTableMainTableRef(attr);
            Type type = attr.getDomainResolvingAll();
            for (int featurei = 0; featurei < featurec; ++featurei) {
                IFMEFeature feature = null;
                try {
                    feature = featurev.getAt(featurei);
                    boolean is3D = 3 == ((CoordType)((SurfaceOrAreaType)type).getControlPointDomain().getType()).getDimensions().length;
                    IFMEGeometry fmeGeom = null;
                    try {
                        fmeGeom = feature.getGeometry();
                        if (fmeGeom instanceof IFMEDonut) {
                            IFMEDonut fmeDonut = (IFMEDonut)fmeGeom;
                            Iom_jObject iomObj = new Iom_jObject(lineTableName, this.newTid());
                            IomObject structvalue = iomObj.addattrobj(fkName, "REF");
                            structvalue.setobjectrefoid(this.getStringAttribute(feature, "xtf_id"));
                            IFMECurve shell = null;
                            try {
                                shell = fmeDonut.getOuterBoundaryAsCurve();
                                IomObject polyline = Fme2iox.FME2polyline(this.session, shell);
                                iomObj.addattrobj(iomAttrName, polyline);
                            }
                            finally {
                                if (shell != null) {
                                    shell.dispose();
                                    shell = null;
                                }
                            }
                            if (startBasketEvent != null) {
                                if (this.validator != null) {
                                    this.validator.validate(startBasketEvent);
                                }
                                this.ioxWriter.write(startBasketEvent);
                                startBasketEvent = null;
                            }
                            ObjectEvent objEvent = new ObjectEvent(iomObj);
                            if (this.validator != null) {
                                this.validator.validate(objEvent);
                            }
                            this.ioxWriter.write(objEvent);
                            int holec = fmeDonut.numInnerBoundaries();
                            for (int holei = 0; holei < holec; ++holei) {
                                Iom_jObject iomObj2 = new Iom_jObject(lineTableName, this.newTid());
                                IomObject structvalue2 = iomObj2.addattrobj(fkName, "REF");
                                structvalue2.setobjectrefoid(this.getStringAttribute(feature, "xtf_id"));
                                IFMECurve hole = null;
                                try {
                                    hole = fmeDonut.getInnerBoundaryAsCurveAt(holei);
                                    IomObject polyline = Fme2iox.FME2polyline(this.session, hole);
                                    iomObj2.addattrobj(iomAttrName, polyline);
                                }
                                finally {
                                    if (hole != null) {
                                        hole.dispose();
                                        hole = null;
                                    }
                                }
                                if (startBasketEvent != null) {
                                    if (this.validator != null) {
                                        this.validator.validate(startBasketEvent);
                                    }
                                    this.ioxWriter.write(startBasketEvent);
                                    startBasketEvent = null;
                                }
                                ObjectEvent objEvent2 = new ObjectEvent(iomObj2);
                                if (this.validator != null) {
                                    this.validator.validate(objEvent2);
                                }
                                this.ioxWriter.write(objEvent2);
                            }
                            continue;
                        }
                        if (fmeGeom instanceof IFMESimpleArea) {
                            Iom_jObject iomObj = new Iom_jObject(lineTableName, this.newTid());
                            IomObject structvalue = iomObj.addattrobj(fkName, "REF");
                            structvalue.setobjectrefoid(this.getStringAttribute(feature, "xtf_id"));
                            IFMECurve shell = null;
                            try {
                                shell = ((IFMESimpleArea)fmeGeom).getBoundaryAsCurve();
                                IomObject polyline = Fme2iox.FME2polyline(this.session, shell);
                                iomObj.addattrobj(iomAttrName, polyline);
                            }
                            finally {
                                if (shell != null) {
                                    shell.dispose();
                                    shell = null;
                                }
                            }
                            if (startBasketEvent != null) {
                                if (this.validator != null) {
                                    this.validator.validate(startBasketEvent);
                                }
                                this.ioxWriter.write(startBasketEvent);
                                startBasketEvent = null;
                            }
                            ObjectEvent objEvent = new ObjectEvent(iomObj);
                            if (this.validator != null) {
                                this.validator.validate(objEvent);
                            }
                            this.ioxWriter.write(objEvent);
                            continue;
                        }
                        if (fmeGeom instanceof IFMENull) {
                            continue;
                        }
                        feature.performFunction("@Log()");
                        throw new DataException("unexpected geometry type " + fmeGeom.getClass().getName());
                    }
                    finally {
                        if (fmeGeom != null) {
                            fmeGeom.dispose();
                            fmeGeom = null;
                        }
                    }
                }
                finally {
                    if (feature != null) {
                        feature.dispose();
                        feature = null;
                    }
                }
            }
        }
        return startBasketEvent;
    }

    private void addItfLineAttributes(IomObject iomObj, IFMEFeature feature, ViewableWrapper wrapper, SurfaceOrAreaType surfaceType) throws Exception, DataException, FMEException, Iox2jtsException {
        Table lineAttrTable = surfaceType.getLineAttributeStructure();
        if (lineAttrTable != null) {
            Iterator<Extendable> attri = lineAttrTable.getAttributes();
            while (attri.hasNext()) {
                AttributeDef lineattr = (AttributeDef)attri.next();
                this.mapAttributeValue(feature, null, iomObj, wrapper, null, lineattr);
            }
        }
    }

    private void writeItfBuffers() throws IoxException, Exception {
        Iterator modeli = this.iliTd.iterator();
        int topicNr = 0;
        while (modeli.hasNext()) {
            Model model;
            Object mObj = modeli.next();
            if (!(mObj instanceof Model) || (model = (Model)mObj) instanceof TypeModel || model instanceof PredefinedModel) continue;
            Iterator topici = model.iterator();
            while (topici.hasNext()) {
                Object tObj = topici.next();
                if (!(tObj instanceof Topic)) continue;
                Topic topic = (Topic)tObj;
                StartBasketEvent startBasketEvent = new ch.interlis.iox_j.StartBasketEvent(topic.getScopedName(null), Integer.toString(++topicNr));
                for (Viewable<?> obj : topic.getViewables()) {
                    String lineTableName;
                    Viewable<?> v;
                    if (!(obj instanceof Viewable) || (v = obj) instanceof Table && !((Table)v).isIdentifiable() || ModelUtility.isPureRefAssoc(v)) continue;
                    Iterator<Extendable> attri = null;
                    String className = v.getScopedName((Container)null);
                    if (this.useLineTableFeatures && this.itfLineTableExists(v)) {
                        String helperTableName;
                        AttributeDef attr;
                        Type type;
                        Extendable attrObj;
                        attri = v.getAttributes();
                        while (attri.hasNext()) {
                            attrObj = attri.next();
                            if (!(attrObj instanceof AttributeDef) || !((type = Type.findReal((attr = (AttributeDef)attrObj).getDomain())) instanceof AreaType)) continue;
                            helperTableName = v.getContainer().getScopedName(null) + "." + v.getName() + "_" + attr.getName();
                            EhiLogger.logState(helperTableName + "...");
                            startBasketEvent = this.writeBasket(helperTableName, true, startBasketEvent);
                        }
                        EhiLogger.logState(className + "...");
                        startBasketEvent = this.writeBasket(className, false, startBasketEvent);
                        attri = v.getAttributes();
                        while (attri.hasNext()) {
                            attrObj = attri.next();
                            if (!(attrObj instanceof AttributeDef) || !((type = Type.findReal((attr = (AttributeDef)attrObj).getDomain())) instanceof SurfaceType)) continue;
                            helperTableName = v.getContainer().getScopedName(null) + "." + v.getName() + "_" + attr.getName();
                            EhiLogger.logState(helperTableName + "...");
                            startBasketEvent = this.writeBasket(helperTableName, true, startBasketEvent);
                        }
                        continue;
                    }
                    ViewableWrapper wrapper = this.fmeFeatureTypev.get(className);
                    if (wrapper.getGeomAttr4FME() != null && wrapper.getGeomAttr4FME().getDomainResolvingAll() instanceof AreaType) {
                        lineTableName = v.getContainer().getScopedName(null) + "." + v.getName() + "_" + wrapper.getGeomAttr4FME().getName();
                        EhiLogger.logState(lineTableName + "...");
                        startBasketEvent = this.writeItfLineTableArea(className, lineTableName, startBasketEvent);
                    }
                    EhiLogger.logState(className + "...");
                    startBasketEvent = this.writeBasket(className, false, startBasketEvent);
                    if (wrapper.getGeomAttr4FME() == null || !(wrapper.getGeomAttr4FME().getDomainResolvingAll() instanceof SurfaceType)) continue;
                    lineTableName = v.getContainer().getScopedName(null) + "." + v.getName() + "_" + wrapper.getGeomAttr4FME().getName();
                    startBasketEvent = this.writeItfLineTableSurface(className, lineTableName, startBasketEvent);
                }
                if (startBasketEvent != null) continue;
                EndBasketEvent endBasketEvent = new EndBasketEvent();
                if (this.validator != null) {
                    this.validator.validate(endBasketEvent);
                }
                this.ioxWriter.write(endBasketEvent);
            }
        }
    }

    private boolean itfLineTableExists(Viewable v) {
        String helperTableName;
        IFMEFeatureVectorOnDisk featurev;
        int featurec;
        AttributeDef attr;
        Type type;
        Extendable attrObj;
        Iterator<Extendable> attri = v.getAttributes();
        while (attri.hasNext()) {
            attrObj = attri.next();
            if (!(attrObj instanceof AttributeDef) || !((type = Type.findReal((attr = (AttributeDef)attrObj).getDomain())) instanceof AreaType) || (featurec = (featurev = this.getFeatureBuffer(helperTableName = v.getContainer().getScopedName(null) + "." + v.getName() + "_" + attr.getName())).entries()) <= 0) continue;
            return true;
        }
        attri = v.getAttributes();
        while (attri.hasNext()) {
            attrObj = attri.next();
            if (!(attrObj instanceof AttributeDef) || !((type = Type.findReal((attr = (AttributeDef)attrObj).getDomain())) instanceof SurfaceType) || (featurec = (featurev = this.getFeatureBuffer(helperTableName = v.getContainer().getScopedName(null) + "." + v.getName() + "_" + attr.getName())).entries()) <= 0) continue;
            return true;
        }
        return false;
    }

    public int id() {
        return 0;
    }

    public void write(IFMEFeature obj) throws Exception {
        try {
            if (obj.getFeatureType().equals("XTF_TRANSFER")) {
                if (this.startTransferEvent != null) {
                    throw new Exception("unexpected second feature XTF_TRANSFER");
                }
                String comment = null;
                if (obj.attributeExists("comment")) {
                    comment = obj.getStringAttribute("comment");
                }
                this.startTransferEvent = new XtfStartTransferEvent(this.getStartTransferEventVersion(), comment, null);
                int i = 0;
                while (true) {
                    String prefix = "oidspace{" + i + "}.";
                    String oidname = null;
                    if (obj.attributeExists(prefix + "name")) {
                        oidname = obj.getStringAttribute(prefix + "name");
                    }
                    String oiddomain = null;
                    if (obj.attributeExists(prefix + "oiddomain")) {
                        oiddomain = obj.getStringAttribute(prefix + "oiddomain");
                    }
                    if (oidname != null || oiddomain != null) {
                        this.startTransferEvent.addOidSpace(new OidSpace(oidname, oiddomain));
                        ++i;
                        continue;
                    }
                    break;
                }
            } else if (obj.getFeatureType().equals("XTF_BASKETS")) {
                this.mapBasket(obj);
            } else {
                this.bufferFeature(obj);
            }
        }
        catch (Exception ex) {
            EhiLogger.logError(ex);
            throw ex;
        }
    }

    private void bufferFeature(IFMEFeature obj) throws Exception {
        String bufferKey = null;
        String fmeRecInfo = obj.getFeatureType();
        String tag = null;
        if (obj.attributeExists("xtf_class")) {
            tag = this.getStringAttribute(obj, "xtf_class");
        }
        if (tag == null || tag.length() == 0) {
            tag = obj.getFeatureType();
        }
        if (!tag.equals("XTF_DELETEOBJECT")) {
            String tid;
            if (tag.indexOf(46) == -1) {
                String err = fmeRecInfo + ": qualified INTERLIS name expected instead of <" + tag + ">";
                throw new ConfigException(err);
            }
            this.trackModel(tag);
            if (obj.attributeExists("xtf_id") && (tid = obj.getStringAttribute("xtf_id")) != null && tid.length() > 0) {
                if (this.checkoids != null) {
                    if (this.checkoids.containsKey(tid)) {
                        EhiLogger.logError("Object " + tag + ": duplicate oid " + tid + " (same as object " + this.checkoids.get(tid) + ")");
                    } else {
                        this.checkoids.put(tid, tag);
                    }
                }
                try {
                    int tidInt = Integer.parseInt(tid);
                    if (tidInt > this.maxTid) {
                        this.maxTid = tidInt;
                    }
                }
                catch (NumberFormatException tidInt) {
                    // empty catch block
                }
            }
        }
        if (this.formatMode == 1 || this.formatMode == 3) {
            String err;
            if (this.scanXtfBaskets) {
                this.scanXtfBaskets = false;
                this.autoXtfBaskets = !obj.attributeExists("xtf_basket") && !tag.equals("XTF_DELETEOBJECT");
            } else if (this.autoXtfBaskets && obj.attributeExists("xtf_basket")) {
                err = fmeRecInfo + ": no " + "xtf_basket" + " attribute in auto XTF baskes mode allowed";
                throw new ConfigException(err);
            }
            if (this.autoXtfBaskets) {
                bufferKey = tag.substring(0, tag.lastIndexOf(46));
                if (this.basketv == null) {
                    this.initBaskets();
                }
                String topic = bufferKey;
                String basketId = bufferKey;
                if (!this.basketv.containsKey(basketId)) {
                    ch.interlis.iox_j.StartBasketEvent basket = new ch.interlis.iox_j.StartBasketEvent(topic, basketId);
                    this.addBasket(basketId, basket, 0);
                }
            } else {
                if (!obj.attributeExists("xtf_basket")) {
                    err = fmeRecInfo + ": missing mandatory attribute " + "xtf_basket";
                    EhiLogger.logError(err);
                    throw new Exception(err);
                }
                bufferKey = obj.getStringAttribute("xtf_basket");
                if (bufferKey == null || bufferKey.length() == 0) {
                    err = fmeRecInfo + ": missing mandatory attribute " + "xtf_basket";
                    EhiLogger.logError(err);
                    throw new Exception(err);
                }
            }
        } else {
            bufferKey = tag;
        }
        IFMEFeatureVectorOnDisk featurev = this.getFeatureBuffer(bufferKey);
        featurev.append(obj);
    }

    private void initBaskets() {
        this.basketv = new HashMap();
        this.basketOrder = new ArrayList();
    }

    protected void addBasket(String basketId, ch.interlis.iox_j.StartBasketEvent basket, int basketSeq) {
        this.basketv.put(basketId, basket);
        this.basketOrder.add(new BasketSeq(basketId, basketSeq));
    }

    private void trackModel(String tag) {
        String iliModel = tag.substring(0, tag.indexOf(46));
        if (!this.modelsFromFME.contains(iliModel)) {
            this.modelsFromFME.add(iliModel);
        }
    }

    private void mapBasket(IFMEFeature obj) throws Exception {
        if (this.formatMode == 1 || this.formatMode == 3) {
            if (this.scanXtfBaskets) {
                this.scanXtfBaskets = false;
                this.autoXtfBaskets = false;
            } else if (this.autoXtfBaskets) {
                throw new ConfigException("no XTF_BASKETS feature in auto XTF baskes mode allowed");
            }
            if (this.basketv == null) {
                this.initBaskets();
            }
            String topic = obj.getStringAttribute("xtf_topic");
            this.trackModel(topic);
            String basketId = obj.getStringAttribute("xtf_id");
            if (this.basketv.containsKey(basketId)) {
                EhiLogger.logAdaption("dupliacte basket id " + basketId + "; ignored");
            } else {
                EhiLogger.traceState("basket topic <" + topic + ">, id <" + basketId + ">");
                ch.interlis.iox_j.StartBasketEvent basket = new ch.interlis.iox_j.StartBasketEvent(topic, basketId);
                int basketSeq = 0;
                if (obj.attributeExists("xtf_seq")) {
                    basketSeq = obj.getIntAttribute("xtf_seq");
                }
                String startState = null;
                if (obj.attributeExists("xtf_startstate")) {
                    startState = StringUtility.purge(obj.getStringAttribute("xtf_startstate"));
                }
                String endState = null;
                if (obj.attributeExists("xtf_endstate")) {
                    endState = StringUtility.purge(obj.getStringAttribute("xtf_endstate"));
                }
                basket.setKind(0);
                if (endState != null) {
                    basket.setEndstate(endState);
                    if (startState == null) {
                        basket.setKind(2);
                    } else {
                        basket.setStartstate(startState);
                        basket.setKind(1);
                    }
                }
                if (obj.attributeExists("xtf_consistency")) {
                    int consistency = FmeUtility.mapFme2IoxConsistency(obj.getStringAttribute("xtf_consistency"));
                    basket.setConsistency(consistency);
                }
                if (obj.attributeExists("xtf_domains{0}.generic")) {
                    int idx = 0;
                    HashMap domains = new HashMap();
                    while (obj.attributeExists("xtf_domains{" + idx + "}." + "generic")) {
                        String genericDomain = obj.getStringAttribute("xtf_domains{" + idx + "}." + "generic");
                        String concreteDomain = obj.getStringAttribute("xtf_domains{" + idx + "}." + "concrete");
                        if (genericDomain.length() > 0) {
                            basket.addDomain(genericDomain, concreteDomain);
                        }
                        ++idx;
                    }
                }
                this.addBasket(basketId, basket, basketSeq);
            }
        }
    }

    private String getStringAttribute(IFMEFeature obj, String attr) throws FMEException {
        return obj.getStringAttribute(attr);
    }

    private IomObject mapFeature(IFMEFeature obj, String fmeListAttrPrefix, IomObject iliStructParent, String iliStructAttrName, boolean autoTid) throws Exception {
        Iterator<ViewableTransferElement> iter;
        ViewableWrapper wrapper;
        String fmeFeatureType;
        boolean isStructEle = fmeListAttrPrefix != null;
        String attrPrefix = "";
        String fmeRecInfo = fmeFeatureType = obj.getFeatureType();
        if (fmeFeatureType.equals("XTF_DELETEOBJECT")) {
            if (!obj.attributeExists("xtf_id")) {
                String err = fmeRecInfo + ": missing mandatory attribute " + "xtf_id";
                EhiLogger.logError(err);
                throw new Exception(err);
            }
            String tid = this.getStringAttribute(obj, "xtf_id");
            if (tid == null || tid.length() == 0) {
                String err = fmeRecInfo + ": missing mandatory attribute " + "xtf_id";
                EhiLogger.logError(err);
                throw new Exception(err);
            }
            Iom_jObject iomObj = new Iom_jObject("DELETE", tid);
            return iomObj;
        }
        if (isStructEle) {
            fmeRecInfo = fmeRecInfo + " " + fmeListAttrPrefix;
            attrPrefix = fmeListAttrPrefix + ".";
        }
        String tag = null;
        if (isStructEle) {
            if (!obj.attributeExists(attrPrefix + "xtf_class")) {
                String err = fmeRecInfo + ": missing mandatory attribute " + attrPrefix + "xtf_class";
                EhiLogger.logError(err);
                throw new Exception(err);
            }
            tag = this.getStringAttribute(obj, attrPrefix + "xtf_class");
            if (tag == null || tag.length() == 0) {
                String err = fmeRecInfo + ": missing mandatory attribute " + attrPrefix + "xtf_class";
                EhiLogger.logError(err);
                throw new Exception(err);
            }
        } else {
            if (obj.attributeExists(attrPrefix + "xtf_class")) {
                tag = this.getStringAttribute(obj, attrPrefix + "xtf_class");
            }
            if (tag == null || tag.length() == 0) {
                tag = fmeFeatureType;
            }
        }
        if ((wrapper = this.fmeFeatureTypev.get(tag)) == null) {
            String err = fmeRecInfo + ": unknown interlis class <" + tag + ">";
            EhiLogger.logError(err);
            throw new Exception(err);
        }
        IomObject iomObj = null;
        if (!isStructEle) {
            boolean classRequiresTid = true;
            Viewable viewable = wrapper.getViewable();
            if (this.formatMode == 1 && viewable instanceof AssociationDef) {
                AssociationDef assoc = (AssociationDef)viewable;
                if (assoc.isIdentifiable()) {
                    classRequiresTid = true;
                } else {
                    Domain oid = assoc.getOid();
                    if (oid == null || oid instanceof NoOid) {
                        classRequiresTid = false;
                    }
                }
            }
            String tid = null;
            if (classRequiresTid) {
                String err;
                if (!obj.attributeExists("xtf_id")) {
                    if (!autoTid) {
                        err = fmeRecInfo + ": missing mandatory attribute " + "xtf_id";
                        EhiLogger.logError(err);
                        throw new Exception(err);
                    }
                    tid = this.newTid();
                } else {
                    tid = this.getStringAttribute(obj, "xtf_id");
                    if (tid == null || tid.length() == 0) {
                        if (!autoTid) {
                            err = fmeRecInfo + ": missing mandatory attribute " + "xtf_id";
                            EhiLogger.logError(err);
                            throw new Exception(err);
                        }
                        tid = this.newTid();
                    }
                }
            }
            iomObj = new Iom_jObject(tag, tid);
        } else {
            iomObj = iliStructParent.addattrobj(iliStructAttrName, tag);
        }
        if (this.formatMode == 2 && wrapper.isHelper() && wrapper.getGeomAttr4FME().getDomainResolvingAll() instanceof SurfaceType) {
            String fkName = ModelUtilities.getHelperTableMainTableRef(wrapper.getGeomAttr4FME());
            IomObject structvalue = iomObj.addattrobj(fkName, "REF");
            structvalue.setobjectrefoid(this.getStringAttribute(obj, fkName));
        }
        if (this.formatMode == 1) {
            if (obj.attributeExists("xtf_consistency")) {
                int consistency = FmeUtility.mapFme2IoxConsistency(this.getStringAttribute(obj, "xtf_consistency"));
                iomObj.setobjectconsistency(consistency);
            }
            if (obj.attributeExists("xtf_operation")) {
                int operation = FmeUtility.mapFme2IoxOperation(this.getStringAttribute(obj, "xtf_operation"));
                iomObj.setobjectoperation(operation);
            }
        }
        if (this.formatMode == 2) {
            iter = wrapper.getAttrIterator();
        } else {
            Viewable aclass = (Viewable)this.tag2class.get(tag);
            iter = aclass.getAttributesAndRoles2();
        }
        String geomattr = null;
        if (!isStructEle) {
            AttributeDef attr;
            if (obj.attributeExists("xtf_geomattr")) {
                geomattr = StringUtility.purge(this.getStringAttribute(obj, "xtf_geomattr"));
            }
            if (geomattr == null && (attr = wrapper.getGeomAttr4FME()) != null) {
                geomattr = attr.getName();
            }
        }
        while (iter.hasNext()) {
            ViewableTransferElement prop = iter.next();
            if (prop.obj instanceof AttributeDef) {
                AttributeDef attr = (AttributeDef)prop.obj;
                this.mapAttributeValue(obj, attrPrefix, iomObj, wrapper, geomattr, attr);
            }
            if (!(prop.obj instanceof RoleDef)) continue;
            RoleDef role = (RoleDef)prop.obj;
            String roleName = role.getName();
            if (prop.embedded) {
                String prefix;
                String refoid;
                AssociationDef roleOwner = (AssociationDef)role.getContainer();
                if (roleOwner.getDerivedFrom() != null || !obj.attributeExists(roleName) || (refoid = StringUtility.purge(this.getStringAttribute(obj, roleName))) == null) continue;
                IomObject structvalue = null;
                if ((roleOwner.getAttributes().hasNext() || roleOwner.getLightweightAssociations().iterator().hasNext()) && obj.attributeExists((prefix = attrPrefix + roleName + "{0}") + "." + "xtf_class")) {
                    structvalue = this.mapFeature(obj, prefix, iomObj, roleName, false);
                }
                if (structvalue == null) {
                    structvalue = iomObj.addattrobj(roleName, "REF");
                }
                structvalue.setobjectrefoid(refoid);
                if (!role.isOrdered()) continue;
                long orderPos = obj.getIntAttribute(roleName + "." + "orderPos");
                structvalue.setobjectreforderpos(orderPos);
                continue;
            }
            if (((AssociationDef)role.getContainer()).isLightweight()) continue;
            String refoid = StringUtility.purge(this.getStringAttribute(obj, roleName));
            IomObject structvalue = iomObj.addattrobj(roleName, "REF");
            structvalue.setobjectrefoid(refoid);
            if (!role.isOrdered()) continue;
            long orderPos = obj.getIntAttribute(roleName + "." + "orderPos");
            structvalue.setobjectreforderpos(orderPos);
        }
        return iomObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mapAttributeValue(IFMEFeature obj, String attrPrefix, IomObject iomObj, ViewableWrapper wrapper, String geomattr, AttributeDef attr) throws Exception, DataException, FMEException, Iox2jtsException {
        Type type = attr.getDomainResolvingAll();
        String attrName = attr.getName();
        if (attrPrefix == null) {
            attrPrefix = "";
        }
        if (type instanceof CompositionType) {
            int elei = 0;
            String prefix = attrPrefix + attrName + "{" + Integer.toString(elei) + "}";
            while (obj.attributeExists(prefix + "." + "xtf_class")) {
                this.mapFeature(obj, prefix, iomObj, attrName, false);
                prefix = attrPrefix + attrName + "{" + Integer.toString(++elei) + "}";
            }
        } else if (type instanceof ReferenceType) {
            String refoid;
            if (obj.attributeExists(attrPrefix + attrName) && (refoid = StringUtility.purge(this.getStringAttribute(obj, attrPrefix + attrName))) != null) {
                IomObject structvalue = iomObj.addattrobj(attrName, "REF");
                structvalue.setobjectrefoid(refoid);
            }
        } else if (type instanceof PolylineType) {
            if (geomattr != null && attrName.equals(geomattr)) {
                boolean is3D = 3 == ((CoordType)((PolylineType)type).getControlPointDomain().getType()).getDimensions().length;
                IFMEGeometry fmeGeom = null;
                try {
                    fmeGeom = obj.getGeometry();
                    if (fmeGeom instanceof IFMECurve) {
                        IomObject polyline = Fme2iox.FME2polyline(this.session, (IFMECurve)fmeGeom);
                        iomObj.addattrobj(attrName, polyline);
                    }
                    if (fmeGeom instanceof IFMENull) {
                    }
                    throw new DataException("unexpected geometry type " + fmeGeom.getClass().getName());
                }
                finally {
                    if (fmeGeom != null) {
                        fmeGeom.dispose();
                        fmeGeom = null;
                    }
                }
            } else if (obj.attributeExists(attrPrefix + attrName)) {
                if (this.geomConv == null) {
                    String value = this.getStringAttribute(obj, attrPrefix + attrName);
                    if (value != null && value.length() > 0) {
                        iomObj.addattrobj(attrName, Jts2iox.hexwkb2polyline(value));
                    }
                } else {
                    this.geomConv.FME2polyline(iomObj, attrName, obj, attrPrefix + attrName);
                }
            }
        } else if (type instanceof MultiPolylineType) {
            if (geomattr != null && attrName.equals(geomattr)) {
                IFMEGeometry fmeGeom = null;
                try {
                    fmeGeom = obj.getGeometry();
                    if (fmeGeom instanceof IFMEMultiCurve) {
                        IomObject polyline = Fme2iox.FME2multipolyline(this.session, (IFMEMultiCurve)fmeGeom);
                        iomObj.addattrobj(attrName, polyline);
                    }
                    if (fmeGeom instanceof IFMECurve) {
                        IomObject polyline = Fme2iox.FME2multipolyline(this.session, (IFMECurve)fmeGeom);
                        iomObj.addattrobj(attrName, polyline);
                    }
                    if (fmeGeom instanceof IFMENull) {
                    }
                    throw new DataException("unexpected geometry type " + fmeGeom.getClass().getName());
                }
                finally {
                    if (fmeGeom != null) {
                        fmeGeom.dispose();
                    }
                }
            } else if (obj.attributeExists(attrPrefix + attrName)) {
                if (this.geomConv == null) {
                    String value = this.getStringAttribute(obj, attrPrefix + attrName);
                    if (value != null && value.length() > 0) {
                        iomObj.addattrobj(attrName, Jts2iox.hexwkb2multipolyline(value));
                    }
                } else {
                    this.geomConv.FME2multipolyline(iomObj, attrName, obj, attrPrefix + attrName);
                }
            }
        } else if (type instanceof SurfaceOrAreaType) {
            if (this.formatMode == 1 || this.formatMode == 3) {
                if (geomattr != null && attrName.equals(geomattr)) {
                    IFMEGeometry fmeGeom = null;
                    try {
                        fmeGeom = obj.getGeometry();
                        if (fmeGeom instanceof IFMEArea) {
                            IomObject surface = Fme2iox.FME2surface(this.session, (IFMEArea)fmeGeom);
                            iomObj.addattrobj(attrName, surface);
                        }
                        if (fmeGeom instanceof IFMENull) {
                        }
                        throw new DataException("unexpected geometry type " + fmeGeom.getClass().getName());
                    }
                    finally {
                        if (fmeGeom != null) {
                            fmeGeom.dispose();
                            fmeGeom = null;
                        }
                    }
                } else if (obj.attributeExists(attrPrefix + attrName)) {
                    if (this.geomConv == null) {
                        String value = this.getStringAttribute(obj, attrPrefix + attrName);
                        if (value != null && value.length() > 0) {
                            iomObj.addattrobj(attrName, Jts2iox.hexwkb2surface(value));
                        }
                    } else {
                        this.geomConv.FME2surface(iomObj, attrName, obj, attrPrefix + attrName);
                    }
                }
            } else if (wrapper.isHelper()) {
                String iomAttrName = ModelUtilities.getHelperTableGeomAttrName(attr);
                this.mapItfPolylineValueOfLineTable(obj, iomObj, wrapper, type, iomAttrName);
                SurfaceOrAreaType surfaceType = (SurfaceOrAreaType)type;
                this.addItfLineAttributes(iomObj, obj, wrapper, surfaceType);
            } else if (type instanceof AreaType && geomattr != null && attrName.equals(geomattr)) {
                IFMEGeometry fmeGeom = null;
                try {
                    fmeGeom = obj.getGeometry();
                    if (fmeGeom instanceof IFMEPoint) {
                        IomObject coord = Fme2iox.FME2coord((IFMEPoint)fmeGeom);
                        iomObj.addattrobj(attrName, coord);
                    }
                    if (fmeGeom instanceof IFMEText) {
                        IomObject coord = Fme2iox.FME2coord(((IFMEText)fmeGeom).getLocationAsPoint());
                        iomObj.addattrobj(attrName, coord);
                    }
                    if (fmeGeom instanceof IFMENull) {
                    }
                    if (fmeGeom instanceof IFMEArea) {
                        double[] valuev = obj.generatePointInPolygon(true);
                        IomObject coord = iomObj.addattrobj(attrName, "COORD");
                        coord.setattrvalue("C1", Double.toString(valuev[0]));
                        coord.setattrvalue("C2", Double.toString(valuev[1]));
                    }
                    throw new DataException("unexpected geometry type " + fmeGeom.getClass().getName());
                }
                finally {
                    if (fmeGeom != null) {
                        fmeGeom.dispose();
                        fmeGeom = null;
                    }
                }
            }
        } else if (type instanceof MultiSurfaceOrAreaType) {
            if (geomattr != null && attrName.equals(geomattr)) {
                IFMEGeometry fmeGeom = null;
                try {
                    fmeGeom = obj.getGeometry();
                    if (fmeGeom instanceof IFMEMultiArea) {
                        IomObject surface = Fme2iox.FME2multisurface(this.session, (IFMEMultiArea)fmeGeom);
                        iomObj.addattrobj(attrName, surface);
                    }
                    if (fmeGeom instanceof IFMEArea) {
                        IomObject surface = Fme2iox.FME2multisurface(this.session, (IFMEArea)fmeGeom);
                        iomObj.addattrobj(attrName, surface);
                    }
                    if (fmeGeom instanceof IFMENull) {
                    }
                    throw new DataException("unexpected geometry type " + fmeGeom.getClass().getName());
                }
                finally {
                    if (fmeGeom != null) {
                        fmeGeom.dispose();
                    }
                }
            } else if (obj.attributeExists(attrPrefix + attrName)) {
                if (this.geomConv == null) {
                    String value = this.getStringAttribute(obj, attrPrefix + attrName);
                    if (value != null && value.length() > 0) {
                        iomObj.addattrobj(attrName, Jts2iox.hexwkb2multisurface(value));
                    }
                } else {
                    this.geomConv.FME2multisurface(iomObj, attrName, obj, attrPrefix + attrName);
                }
            }
        } else if (type instanceof CoordType) {
            if (geomattr != null && attrName.equals(geomattr)) {
                IFMEGeometry fmeGeom = null;
                try {
                    fmeGeom = obj.getGeometry();
                    if (fmeGeom instanceof IFMEPoint) {
                        IomObject coord = Fme2iox.FME2coord((IFMEPoint)fmeGeom);
                        iomObj.addattrobj(attrName, coord);
                    }
                    if (fmeGeom instanceof IFMEText) {
                        IomObject coord = Fme2iox.FME2coord(((IFMEText)fmeGeom).getLocationAsPoint());
                        iomObj.addattrobj(attrName, coord);
                    }
                    if (fmeGeom instanceof IFMENull) {
                    }
                    throw new DataException("unexpected geometry type " + fmeGeom.getClass().getName());
                }
                finally {
                    if (fmeGeom != null) {
                        fmeGeom.dispose();
                        fmeGeom = null;
                    }
                }
            } else if (obj.attributeExists(attrPrefix + attrName)) {
                if (type instanceof CoordType && ((CoordType)type).getDimensions().length == 1) {
                    String c1 = this.getStringAttribute(obj, attrPrefix + attrName);
                    if (c1 != null && c1.length() > 0) {
                        IomObject coord = iomObj.addattrobj(attrName, "COORD");
                        coord.setattrvalue("C1", c1);
                        iomObj.addattrobj(attrName, coord);
                    }
                } else if (this.geomConv == null) {
                    String value = this.getStringAttribute(obj, attrPrefix + attrName);
                    if (value != null && value.length() > 0) {
                        iomObj.addattrobj(attrName, Jts2iox.hexwkb2coord(value));
                    }
                } else {
                    this.geomConv.FME2coord(iomObj, attrName, obj, attrPrefix + attrName);
                }
            }
        } else if (type instanceof MultiCoordType) {
            if (geomattr != null && attrName.equals(geomattr)) {
                IFMEGeometry fmeGeom = null;
                try {
                    fmeGeom = obj.getGeometry();
                    if (fmeGeom instanceof IFMEMultiPoint) {
                        IomObject multicoord = Fme2iox.FME2multicoord((IFMEMultiPoint)fmeGeom);
                        iomObj.addattrobj(attrName, multicoord);
                    }
                    if (fmeGeom instanceof IFMEPoint) {
                        IomObject coord = Fme2iox.FME2coord((IFMEPoint)fmeGeom);
                        Iom_jObject multicoord = new Iom_jObject("MULTICOORD", null);
                        multicoord.addattrobj("coord", coord);
                        iomObj.addattrobj(attrName, multicoord);
                    }
                    if (fmeGeom instanceof IFMEText) {
                        IomObject coord = Fme2iox.FME2coord(((IFMEText)fmeGeom).getLocationAsPoint());
                        Iom_jObject multicoord = new Iom_jObject("MULTICOORD", null);
                        multicoord.addattrobj("coord", coord);
                        iomObj.addattrobj(attrName, multicoord);
                    }
                    if (fmeGeom instanceof IFMENull) {
                    }
                    throw new DataException("unexpected geometry type " + fmeGeom.getClass().getName());
                }
                finally {
                    if (fmeGeom != null) {
                        fmeGeom.dispose();
                    }
                }
            } else if (obj.attributeExists(attrPrefix + attrName)) {
                if (((MultiCoordType)type).getDimensions().length == 1) {
                    String c1 = this.getStringAttribute(obj, attrPrefix + attrName);
                    if (c1 != null && c1.length() > 0) {
                        IomObject coord = iomObj.addattrobj(attrName, "COORD");
                        coord.setattrvalue("C1", c1);
                        Iom_jObject multicoord = new Iom_jObject("MULTICOORD", null);
                        multicoord.addattrobj("coord", coord);
                        iomObj.addattrobj(attrName, multicoord);
                    }
                } else if (this.geomConv == null) {
                    String value = this.getStringAttribute(obj, attrPrefix + attrName);
                    if (value != null && value.length() > 0) {
                        iomObj.addattrobj(attrName, Jts2iox.hexwkb2multicoord(value));
                    }
                } else {
                    this.geomConv.FME2multicoord(iomObj, attrName, obj, attrPrefix + attrName);
                }
            }
        } else if (attr.getDomainOrDerivedDomain().getCardinality().getMaximum() > 1L) {
            int i = 0;
            while (obj.attributeExists(attrPrefix + attrName + "{" + i + "}." + attrName)) {
                String value = this.getStringAttribute(obj, attrPrefix + attrName + "{" + i + "}." + attrName);
                if (this.trimValues) {
                    value = StringUtility.purge(value);
                }
                if (value != null && value.length() > 0) {
                    ((Iom_jObject)iomObj).addattrvalue(attrName, value);
                }
                ++i;
            }
        } else if (obj.attributeExists(attrPrefix + attrName)) {
            String value = this.getStringAttribute(obj, attrPrefix + attrName);
            if (this.trimValues) {
                value = StringUtility.purge(value);
            }
            if (value != null && value.length() > 0) {
                iomObj.setattrvalue(attrName, value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mapItfPolylineValueOfLineTable(IFMEFeature obj, IomObject iomObj, ViewableWrapper wrapper, Type type, String iomAttrName) throws DataException, FMEException, Exception, Iox2jtsException {
        block10: {
            IFMEGeometry fmeGeom = null;
            try {
                fmeGeom = obj.getGeometry();
                if (fmeGeom instanceof IFMECurve) {
                    IomObject polyline = Fme2iox.FME2polyline(this.session, (IFMECurve)fmeGeom);
                    iomObj.addattrobj(iomAttrName, polyline);
                    break block10;
                }
                if (fmeGeom instanceof IFMESimpleArea) {
                    IFMECurve shell = null;
                    try {
                        shell = ((IFMESimpleArea)fmeGeom).getBoundaryAsCurve();
                        IomObject polyline = Fme2iox.FME2polyline(this.session, shell);
                        iomObj.addattrobj(iomAttrName, polyline);
                        break block10;
                    }
                    finally {
                        if (shell != null) {
                            shell.dispose();
                            shell = null;
                        }
                    }
                }
                obj.performFunction("@Log()");
                throw new DataException("unexpected geometry type " + fmeGeom.getClass().getName());
            }
            finally {
                if (fmeGeom != null) {
                    fmeGeom.dispose();
                    fmeGeom = null;
                }
            }
        }
    }

    private IFMEFeatureVectorOnDisk getFeatureBuffer(String bufferKey) {
        if (this.featurebufferv.containsKey(bufferKey)) {
            return this.featurebufferv.get(bufferKey);
        }
        IFMEFeatureVectorOnDisk ret = this.session.createFeatureVectorOnDisk(1000);
        this.featurebufferv.put(bufferKey, ret);
        return ret;
    }

    public boolean multiFileWriter() {
        return false;
    }

    public void startTransaction() throws Exception {
    }

    public void commitTransaction() throws Exception {
    }

    public void rollbackTransaction() throws Exception {
    }

    private void cleanup() {
        if (this.geomConv != null) {
            this.geomConv.dispose();
        }
        if (this.featurebufferv != null) {
            for (IFMEFeatureVectorOnDisk buf : this.featurebufferv.values()) {
                buf.dispose();
                Object var2_4 = null;
            }
            this.featurebufferv = null;
        }
        if (this.validator != null) {
            this.validator.close();
            this.validator = null;
        }
        if (this.ioxWriter != null) {
            try {
                this.ioxWriter.close();
            }
            catch (IoxException ex) {
                EhiLogger.logError(ex);
            }
            this.ioxWriter = null;
        }
        if (this.outputFile != null) {
            try {
                this.outputFile.close();
            }
            catch (IOException ex) {
                EhiLogger.logError(ex);
            }
            this.outputFile = null;
        }
        if (this.listener != null) {
            Main.endLogging(this.listener);
            this.listener = null;
        }
    }

    public void addMappingFileDefLine(ArrayList<String> arg0) throws Exception {
    }

    private static class BasketSeq {
        private String basketId;
        private int basketSeq;

        public BasketSeq(String basketId, int basketSeq) {
            this.basketId = basketId;
            this.basketSeq = basketSeq;
        }

        public String getBasketId() {
            return this.basketId;
        }

        public int getBasketSeq() {
            return this.basketSeq;
        }
    }
}

