/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.iox_j.plugins;

import ch.ehi.basics.logging.EhiLogger;
import ch.interlis.iox_j.plugins.IoxPlugin;
import ch.interlis.iox_j.plugins.JARClassLoader;
import ch.interlis.iox_j.validator.InterlisFunction;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PluginLoader {
    public static final String IOX_PLUGIN = "IoxPlugin";
    public static final String IOX_PLUGIN_CLASSES = "ch.ehi.iox-ili.pluginClasses";
    public static final String systemPropertyPluginClasses = System.getProperty("ch.ehi.iox-ili.pluginClasses");
    private ArrayList<IoxPlugin> plugins = new ArrayList();

    public void loadPlugins() {
        if (systemPropertyPluginClasses != null) {
            String[] pluginClasses;
            for (String name : pluginClasses = systemPropertyPluginClasses.split(",")) {
                if (name == null || (name = name.trim()).length() <= 0) continue;
                this.loadPluginClass(name);
            }
        }
    }

    public void loadPluginClass(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            IoxPlugin plugin = (IoxPlugin)clazz.newInstance();
            this.addPlugin(plugin);
        }
        catch (Throwable t) {
            EhiLogger.logError("Error while starting plugin " + className, t);
        }
    }

    public void loadPlugins(File dir) {
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        File[] plugins = dir.listFiles();
        if (plugins == null) {
            return;
        }
        for (int i = 0; i < plugins.length; ++i) {
            File plugin = plugins[i];
            if (!plugin.getName().toLowerCase().endsWith(".jar")) continue;
            String path = plugin.getAbsolutePath();
            try {
                JARClassLoader loader = new JARClassLoader(path);
                loader.loadAllPlugins(this);
                continue;
            }
            catch (IOException io) {
                EhiLogger.logError("Cannot load plugin " + path, io);
            }
        }
    }

    public void addPlugin(IoxPlugin plugin) {
        EhiLogger.traceState("IoxPlugin <" + plugin.getClass().getName() + ">");
        this.plugins.add(plugin);
    }

    public List<IoxPlugin> getAllPlugins() {
        return this.plugins;
    }

    public static Map<String, Class> getInterlisFunctions(List<IoxPlugin> plugins) {
        HashMap<String, Class> funcs = new HashMap<String, Class>();
        for (IoxPlugin plugin : plugins) {
            if (!(plugin instanceof InterlisFunction)) continue;
            funcs.put(((InterlisFunction)plugin).getQualifiedIliName(), plugin.getClass());
        }
        return funcs;
    }
}

