/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.iom_j.itf.impl.jtsext.geom;

import ch.ehi.basics.logging.EhiLogger;
import ch.interlis.iom_j.itf.impl.hrg.HrgUtility;
import ch.interlis.iom_j.itf.impl.jtsext.algorithm.CurveSegmentIntersector;
import ch.interlis.iom_j.itf.impl.jtsext.geom.ArcSegment;
import ch.interlis.iom_j.itf.impl.jtsext.geom.CompoundCurveRing;
import ch.interlis.iom_j.itf.impl.jtsext.geom.CurveSegment;
import ch.interlis.iom_j.itf.impl.jtsext.geom.JtsextGeometryFactory;
import ch.interlis.iom_j.itf.impl.jtsext.geom.StraightSegment;
import ch.interlis.iom_j.itf.impl.jtsext.io.WKTWriterJtsext;
import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateArrays;
import com.vividsolutions.jts.geom.CoordinateList;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class CompoundCurve
extends LineString {
    public static final String OVERLAP_TID_TAG = "overlap-";
    public static final String MODIFIED_TID_TAG = "modified-";
    private ArrayList<CurveSegment> segments = null;
    public static final double ARC_MIN_DIRECTION_PT = 0.1;

    public CompoundCurve(List<CurveSegment> segments, GeometryFactory factory) {
        super(CompoundCurve.derivePoints(segments, factory), factory);
        this.segments = new ArrayList<CurveSegment>(segments);
    }

    private static CoordinateSequence derivePoints(List<CurveSegment> segments, GeometryFactory factory) {
        CoordinateList ret = new CoordinateList();
        for (CurveSegment seg : segments) {
            ret.add(seg.getCoordinates(), false);
        }
        return factory.getCoordinateSequenceFactory().create(ret.toCoordinateArray());
    }

    public ArrayList<CurveSegment> getSegments() {
        return this.segments;
    }

    public int getNumSegments() {
        return this.segments.size();
    }

    public Point getStartPoint() {
        return this.factory.createPoint(this.segments.get(0).getStartPoint());
    }

    public Point getEndPoint() {
        return this.factory.createPoint(this.segments.get(this.segments.size() - 1).getEndPoint());
    }

    public Geometry reverse() {
        ArrayList<CurveSegment> newsegv = new ArrayList<CurveSegment>();
        for (int i = this.segments.size() - 1; i >= 0; --i) {
            CurveSegment seg = this.segments.get(i);
            if (seg instanceof ArcSegment) {
                newsegv.add(new ArcSegment(seg.getEndPoint(), ((ArcSegment)seg).getMidPoint(), seg.getStartPoint()));
                continue;
            }
            newsegv.add(new StraightSegment(seg.getEndPoint(), seg.getStartPoint()));
        }
        return ((JtsextGeometryFactory)this.factory).createCompoundCurve(newsegv);
    }

    public String toText() {
        WKTWriterJtsext writer = new WKTWriterJtsext();
        return writer.write((Geometry)this);
    }

    protected Envelope computeEnvelopeInternal() {
        Envelope ret = new Envelope();
        if (this.isEmpty()) {
            return ret;
        }
        for (CurveSegment seg : this.segments) {
            ret = seg.expandEnvelope(ret);
        }
        return ret;
    }

    public boolean removeOverlap(ArcSegment thisSegment, CurveSegment otherSegment, double newVertexOffset) {
        int thisSegmentIdx = this.segments.indexOf(thisSegment);
        boolean atStartOfLine = thisSegment.getStartPoint().equals2D(otherSegment.getStartPoint()) || thisSegment.getStartPoint().equals2D(otherSegment.getEndPoint());
        CurveSegment newSegment = null;
        Coordinate newVertexPt = null;
        boolean replaceArcWithStraight = false;
        if (otherSegment instanceof ArcSegment) {
            double otherRadius = ((ArcSegment)otherSegment).getRadius();
            if (thisSegment.getRadius() > otherRadius) {
                throw new IllegalStateException("thisSegment.radius>otherSegment.radius");
            }
            double newRadius = 0.0;
            double segCenterDist = CurveSegment.dist(((ArcSegment)otherSegment).getCenterPoint().x, ((ArcSegment)otherSegment).getCenterPoint().y, thisSegment.getCenterPoint().x, thisSegment.getCenterPoint().y);
            newRadius = segCenterDist > otherRadius ? otherRadius + newVertexOffset : otherRadius - newVertexOffset;
            Coordinate otherSegCenter = ((ArcSegment)otherSegment).getCenterPoint();
            Coordinate newStartPt = this.newRadius(newRadius, otherSegment.getStartPoint(), otherSegCenter);
            Coordinate newMidPt = this.newRadius(newRadius, ((ArcSegment)otherSegment).getMidPoint(), otherSegCenter);
            Coordinate newEndPt = this.newRadius(newRadius, otherSegment.getEndPoint(), otherSegCenter);
            ArcSegment helperSeg = new ArcSegment(newStartPt, newMidPt, newEndPt);
            CurveSegmentIntersector li = new CurveSegmentIntersector();
            li.computeIntersection(thisSegment, helperSeg);
            if (!li.hasIntersection()) {
                replaceArcWithStraight = true;
            } else {
                if (li.getIntersectionNum() != 1) {
                    throw new IllegalStateException("unexpected number of intersections");
                }
                Coordinate is = li.getIntersection(0);
                newVertexPt = new Coordinate(is);
            }
            if (!replaceArcWithStraight) {
                Coordinate newArcMidPt = null;
                if (!atStartOfLine) {
                    double s = CurveSegment.dist(newVertexPt, thisSegment.getEndPoint());
                    double s2 = s / 2.0;
                    double h = otherRadius - Math.sqrt(otherRadius * otherRadius - s2 * s2);
                    newArcMidPt = CGAlgorithms.computeOrientation((Coordinate)newVertexPt, (Coordinate)thisSegment.getEndPoint(), (Coordinate)otherSegCenter) > 0 ? CompoundCurve.calcKleinp(newVertexPt, thisSegment.getEndPoint(), s2, -h) : CompoundCurve.calcKleinp(newVertexPt, thisSegment.getEndPoint(), s2, h);
                } else {
                    double s = CurveSegment.dist(thisSegment.getStartPoint(), newVertexPt);
                    double s2 = s / 2.0;
                    double h = otherRadius - Math.sqrt(otherRadius * otherRadius - s2 * s2);
                    newArcMidPt = CGAlgorithms.computeOrientation((Coordinate)thisSegment.getStartPoint(), (Coordinate)newVertexPt, (Coordinate)otherSegCenter) > 0 ? CompoundCurve.calcKleinp(thisSegment.getStartPoint(), newVertexPt, s2, -h) : CompoundCurve.calcKleinp(thisSegment.getStartPoint(), newVertexPt, s2, h);
                }
                if (!atStartOfLine) {
                    newSegment = new ArcSegment(OVERLAP_TID_TAG + thisSegment.getUserData(), newVertexPt, newArcMidPt, thisSegment.getEndPoint());
                    if (((ArcSegment)newSegment).isStraight()) {
                        newSegment = new StraightSegment(OVERLAP_TID_TAG + thisSegment.getUserData(), newVertexPt, thisSegment.getEndPoint());
                    }
                } else {
                    newSegment = new ArcSegment(OVERLAP_TID_TAG + thisSegment.getUserData(), thisSegment.getStartPoint(), newArcMidPt, newVertexPt);
                    if (((ArcSegment)newSegment).isStraight()) {
                        newSegment = new StraightSegment(OVERLAP_TID_TAG + thisSegment.getUserData(), thisSegment.getStartPoint(), newVertexPt);
                    }
                }
            }
        } else {
            Coordinate newStartPt = null;
            Coordinate newEndPt = null;
            double s = CurveSegment.dist(otherSegment.getStartPoint().x, otherSegment.getStartPoint().y, otherSegment.getEndPoint().x, otherSegment.getEndPoint().y);
            if (CGAlgorithms.computeOrientation((Coordinate)otherSegment.getStartPoint(), (Coordinate)otherSegment.getEndPoint(), (Coordinate)thisSegment.getCenterPoint()) > 0) {
                newStartPt = CompoundCurve.calcKleinp(otherSegment.getStartPoint(), otherSegment.getEndPoint(), 0.0, newVertexOffset);
                newEndPt = CompoundCurve.calcKleinp(otherSegment.getStartPoint(), otherSegment.getEndPoint(), s, newVertexOffset);
            } else {
                newStartPt = CompoundCurve.calcKleinp(otherSegment.getStartPoint(), otherSegment.getEndPoint(), 0.0, -newVertexOffset);
                newEndPt = CompoundCurve.calcKleinp(otherSegment.getStartPoint(), otherSegment.getEndPoint(), s, -newVertexOffset);
            }
            StraightSegment movedOtherSeg = new StraightSegment(newStartPt, newEndPt);
            CurveSegmentIntersector li = new CurveSegmentIntersector();
            li.computeIntersection(thisSegment, movedOtherSeg);
            if (!li.hasIntersection()) {
                replaceArcWithStraight = true;
            } else {
                if (li.getIntersectionNum() != 1) {
                    throw new IllegalStateException("unexpected number of intersections");
                }
                Coordinate is = li.getIntersection(0);
                newVertexPt = new Coordinate(is);
                newSegment = !atStartOfLine ? new StraightSegment(OVERLAP_TID_TAG + thisSegment.getUserData(), newVertexPt, thisSegment.getEndPoint()) : new StraightSegment(OVERLAP_TID_TAG + thisSegment.getUserData(), thisSegment.getStartPoint(), newVertexPt);
            }
        }
        if (replaceArcWithStraight) {
            StraightSegment modifiedSegment = new StraightSegment(MODIFIED_TID_TAG + thisSegment.getUserData(), thisSegment.getStartPoint(), thisSegment.getEndPoint());
            this.segments.set(thisSegmentIdx, modifiedSegment);
        } else {
            Coordinate end;
            ArcSegment modifiedSegment = null;
            if (!atStartOfLine) {
                Coordinate midPt = thisSegment.getMidPoint();
                Coordinate start = thisSegment.getStartPoint();
                end = newVertexPt;
                Coordinate center = thisSegment.getCenterPoint();
                double r = thisSegment.getRadius();
                double sign = thisSegment.sign;
                midPt = this.adjustMidPt(start, midPt, end, center, r, sign);
                modifiedSegment = new ArcSegment(MODIFIED_TID_TAG + thisSegment.getUserData(), thisSegment.getStartPoint(), midPt, newVertexPt);
                this.segments.set(thisSegmentIdx, modifiedSegment);
                this.segments.add(thisSegmentIdx + 1, newSegment);
            } else {
                Coordinate midPt = thisSegment.getMidPoint();
                Coordinate start = newVertexPt;
                end = thisSegment.getEndPoint();
                Coordinate center = thisSegment.getCenterPoint();
                double r = thisSegment.getRadius();
                double sign = thisSegment.sign;
                midPt = this.adjustMidPt(start, midPt, end, center, r, sign);
                modifiedSegment = new ArcSegment(MODIFIED_TID_TAG + thisSegment.getUserData(), newVertexPt, midPt, thisSegment.getEndPoint());
                this.segments.set(thisSegmentIdx, modifiedSegment);
                this.segments.add(thisSegmentIdx, newSegment);
            }
        }
        this.points = CompoundCurve.derivePoints(this.segments, this.factory);
        this.envelope = null;
        return true;
    }

    private Coordinate newRadius(double newRadius, Coordinate oldPt, Coordinate center) {
        Coordinate newPt = new Coordinate();
        double alpha = Math.atan2(oldPt.x - center.x, oldPt.y - center.y);
        newPt.x = center.x + newRadius * Math.sin(alpha);
        newPt.y = center.y + newRadius * Math.cos(alpha);
        return newPt;
    }

    private Coordinate adjustMidPt(Coordinate start, Coordinate midPt, Coordinate end, Coordinate center, double radius, double sign) {
        double BETA;
        double ALFA = HrgUtility.PSECOS(start.x, start.y, center.x, center.y, end.x, end.y);
        if (ALFA != (BETA = HrgUtility.PSECOS(start.x, start.y, center.x, center.y, midPt.x, midPt.y)) && Math.signum(BETA - ALFA) != sign) {
            midPt = ArcSegment.calcArcPt(start, end, center, radius, sign);
        }
        return midPt;
    }

    public static Coordinate calcKleinp(Coordinate p0, Coordinate p1, double u, double v) {
        double s = CurveSegment.dist(p0.x, p0.y, p1.x, p1.y);
        double o = (p1.y - p0.y) / s;
        double a = (p1.x - p0.x) / s;
        Coordinate ret = new Coordinate();
        ret.x = p0.x + a * u - o * v;
        ret.y = p0.y + o * u + a * v;
        return ret;
    }

    public void setSegmentsUserData(Object obj) {
        for (CurveSegment seg : this.segments) {
            seg.setUserData(obj);
        }
    }

    public String[] getSegmentTids() {
        HashSet<String> uniqueTids = new HashSet<String>();
        for (CurveSegment seg : this.getSegments()) {
            String tid;
            if (seg.getUserData() == null || uniqueTids.contains(tid = seg.getUserData().toString())) continue;
            uniqueTids.add(tid);
        }
        return uniqueTids.toArray(new String[uniqueTids.size()]);
    }

    public void dumpLineAsJava(String segs) {
        for (CurveSegment seg : this.segments) {
            CurveSegment s;
            if (seg instanceof StraightSegment) {
                s = (StraightSegment)seg;
                EhiLogger.debug(segs + ".add(new StraightSegment(\"" + s.getUserData() + "\",new Coordinate(" + ((StraightSegment)s).getStartPoint().x + ", " + ((StraightSegment)s).getStartPoint().y + "),new Coordinate( " + ((StraightSegment)s).getEndPoint().x + ", " + ((StraightSegment)s).getEndPoint().y + ")));");
                continue;
            }
            s = (ArcSegment)seg;
            EhiLogger.debug(segs + ".add(new ArcSegment(\"" + s.getUserData() + "\",new Coordinate(" + ((ArcSegment)s).getStartPoint().x + ", " + ((ArcSegment)s).getStartPoint().y + "),new Coordinate(" + ((ArcSegment)s).getMidPoint().x + ", " + ((ArcSegment)s).getMidPoint().y + "),new Coordinate( " + ((ArcSegment)s).getEndPoint().x + ", " + ((ArcSegment)s).getEndPoint().y + ")));");
        }
    }

    public static Coordinate getDirectionPt(LineString line, boolean atStart, double dist) {
        if (line instanceof CompoundCurveRing) {
            if (atStart) {
                line = ((CompoundCurveRing)line).getLines().get(0);
            } else {
                ArrayList<CompoundCurve> lines = ((CompoundCurveRing)line).getLines();
                line = lines.get(lines.size() - 1);
            }
        }
        if (line instanceof CompoundCurve) {
            ArrayList<CurveSegment> segs = ((CompoundCurve)line).getSegments();
            CurveSegment seg = null;
            if (atStart) {
                seg = segs.get(0);
                if (seg instanceof StraightSegment) {
                    return seg.getEndPoint();
                }
            } else {
                seg = segs.get(segs.size() - 1);
                if (seg instanceof StraightSegment) {
                    return seg.getStartPoint();
                }
            }
            if (dist == 0.0) {
                dist = 0.1;
            }
            Coordinate directionPt = ((ArcSegment)seg).getDirectionPt(atStart, dist);
            return directionPt;
        }
        Coordinate[] linePts = CoordinateArrays.removeRepeatedPoints((Coordinate[])line.getCoordinates());
        if (atStart) {
            Coordinate startPt = linePts[1];
            return startPt;
        }
        Coordinate endPt = linePts[linePts.length - 2];
        return endPt;
    }

    public static boolean isArc(LineString line, boolean atStart) {
        if (line instanceof CompoundCurveRing) {
            if (atStart) {
                line = ((CompoundCurveRing)line).getLines().get(0);
            } else {
                ArrayList<CompoundCurve> lines = ((CompoundCurveRing)line).getLines();
                line = lines.get(lines.size() - 1);
            }
        }
        if (line instanceof CompoundCurve) {
            ArrayList<CurveSegment> segs = ((CompoundCurve)line).getSegments();
            CurveSegment seg = null;
            return !(atStart ? (seg = segs.get(0)) instanceof StraightSegment : (seg = segs.get(segs.size() - 1)) instanceof StraightSegment);
        }
        return false;
    }
}

