/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.iox.objpool.impl;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.iox.objpool.ObjectPoolManager;
import ch.ehi.iox.objpool.impl.ObjPoolEntry;
import ch.ehi.iox.objpool.impl.Serializer;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.ref.ReferenceQueue;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ObjPoolImpl
implements Map {
    private HashMap pool = new HashMap();
    private ReferenceQueue<ObjPoolEntry> writeQueue = new ReferenceQueue();
    private RandomAccessFile outFile = null;
    private File outFilename = null;
    private ObjectPoolManager recman = null;
    private Serializer serializer = null;
    private String poolName = null;

    public ObjPoolImpl(ObjectPoolManager objectPoolManager, Serializer serializer) {
        this(objectPoolManager, null, serializer);
    }

    public ObjPoolImpl(ObjectPoolManager objectPoolManager, String poolName, Serializer serializer) {
        this.recman = objectPoolManager;
        this.serializer = serializer;
        this.poolName = poolName;
    }

    @Override
    public void clear() {
        this.pool.clear();
        if (this.outFile != null) {
            try {
                EhiLogger.traceState((this.poolName != null ? this.poolName : this.getClass().getSimpleName()) + ": size " + this.outFile.length() + " <" + this.outFilename.getPath() + ">");
                this.outFile.close();
                this.outFile = null;
                this.outFilename.delete();
                this.outFilename = null;
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        this.writeQueue = new ReferenceQueue();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.pool.containsKey(key);
    }

    @Override
    public boolean containsValue(Object arg0) {
        throw new UnsupportedOperationException();
    }

    public Set entrySet() {
        throw new UnsupportedOperationException();
    }

    public Object get(Object key) {
        ObjPoolEntry entry = (ObjPoolEntry)this.pool.get(key);
        if (entry == null) {
            return null;
        }
        Object ret = this.getRealObj(entry);
        this.recman.flushWriteQueues();
        return ret;
    }

    @Override
    public boolean isEmpty() {
        return this.pool.isEmpty();
    }

    public Set keySet() {
        return this.pool.keySet();
    }

    public Object put(Object key, Object value) {
        ObjPoolEntry entry;
        try {
            entry = new ObjPoolEntry(this.serializer.getBytes(value), value, this.writeQueue);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        this.recman.flushWriteQueues();
        return this.pool.put(key, entry);
    }

    public void flushWriteQueue() {
        ObjPoolEntry entry = (ObjPoolEntry)this.writeQueue.poll();
        while (entry != null) {
            if (!entry.isPhantom()) {
                if (entry.getFilePos() == -1L) {
                    long pos = -1L;
                    try {
                        if (this.outFile == null) {
                            this.outFilename = ObjectPoolManager.getCacheTmpFilename();
                            this.outFile = new RandomAccessFile(this.outFilename, "rw");
                        }
                        pos = this.outFile.length();
                        this.outFile.seek(pos);
                        this.outFile.write(entry.getByteBuffer());
                    }
                    catch (IOException e) {
                        throw new IllegalStateException(e);
                    }
                    entry.setFilePos(pos);
                }
                entry.freeByteBuffer();
            }
            entry = (ObjPoolEntry)this.writeQueue.poll();
        }
    }

    public void putAll(Map arg0) {
        throw new UnsupportedOperationException();
    }

    public Object remove(Object key) {
        ObjPoolEntry entry = (ObjPoolEntry)this.pool.remove(key);
        if (entry == null) {
            return null;
        }
        entry.setPhantom();
        Object ret = this.getRealObj(entry);
        this.recman.flushWriteQueues();
        return ret;
    }

    private Object getRealObj(ObjPoolEntry entry) {
        Object obj = entry.get();
        if (obj == null) {
            byte[] buffer = entry.getByteBuffer();
            if (buffer == null) {
                buffer = new byte[entry.getSize()];
                try {
                    this.outFile.seek(entry.getFilePos());
                    this.outFile.read(buffer);
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
                entry.refillBuffer(buffer);
            }
            try {
                obj = this.serializer.getObject(buffer);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e);
            }
        }
        return obj;
    }

    @Override
    public int size() {
        return this.pool.size();
    }

    public Collection values() {
        throw new UnsupportedOperationException();
    }

    public Iterator valueIterator() {
        Iterator ret = new Iterator(){
            Iterator<Object> kevi;
            {
                this.kevi = ObjPoolImpl.this.pool.keySet().iterator();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            public Object next() {
                return ObjPoolImpl.this.get(this.kevi.next());
            }

            @Override
            public boolean hasNext() {
                return this.kevi.hasNext();
            }
        };
        return ret;
    }
}

