/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.iox_j.validator.functions;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.basics.types.OutParam;
import ch.interlis.ili2c.metamodel.Evaluable;
import ch.interlis.ili2c.metamodel.Function;
import ch.interlis.ili2c.metamodel.FunctionCall;
import ch.interlis.ili2c.metamodel.RoleDef;
import ch.interlis.ili2c.metamodel.TextType;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.iom.IomObject;
import ch.interlis.iom_j.itf.impl.jtsext.geom.CompoundCurve;
import ch.interlis.iom_j.itf.impl.jtsext.geom.CompoundCurveRing;
import ch.interlis.iom_j.itf.impl.jtsext.geom.CurvePolygon;
import ch.interlis.iom_j.itf.impl.jtsext.geom.CurveSegment;
import ch.interlis.iox.IoxException;
import ch.interlis.iox.IoxValidationConfig;
import ch.interlis.iox_j.jts.Iox2jtsext;
import ch.interlis.iox_j.logging.LogEventFactory;
import ch.interlis.iox_j.validator.Validator;
import ch.interlis.iox_j.validator.Value;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

public class DmavtymTopologie {
    public static final String DMAVTYM_Topologie_V1_0 = "DMAVTYM_Topologie_V1_0";
    public static final String DMAVTYM_Topologie_V1_1 = "DMAVTYM_Topologie_V1_1";
    private final TransferDescription td;
    private final IoxValidationConfig validationConfig;
    private final Validator validator;
    private final LogEventFactory logger;

    public DmavtymTopologie(Validator validator, TransferDescription td, IoxValidationConfig validationConfig, LogEventFactory logger) {
        this.validator = validator;
        this.td = td;
        this.validationConfig = validationConfig;
        this.logger = logger;
        logger.setValidationConfig(validationConfig);
    }

    public Value evaluateFunction(Function currentFunction, FunctionCall functionCallObj, IomObject parentObject, String validationKind, String usageScope, IomObject iomObj, TextType texttype, RoleDef firstRole) {
        Evaluable[] arguments = functionCallObj.getArguments();
        Value[] actualArguments = new Value[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            Value result = this.validator.evaluateExpression(parentObject, validationKind, usageScope, iomObj, arguments[i], firstRole);
            if (result.skipEvaluation()) {
                return result;
            }
            actualArguments[i] = result;
        }
        if (currentFunction.getName().equals("covers")) {
            return this.evaluateCovers(validationKind, usageScope, iomObj, actualArguments);
        }
        if (currentFunction.getName().equals("coversWithTolerance")) {
            return this.evaluateCoversWithTolerance(validationKind, usageScope, iomObj, actualArguments);
        }
        return Value.createNotYetImplemented();
    }

    private Value evaluateCovers(String validationKind, String usageScope, IomObject mainObj, Value[] actualArguments) {
        Collection<CompoundCurve> lines;
        CurvePolygon surface;
        for (Value arg : actualArguments) {
            if (!arg.isUndefined()) continue;
            return Value.createSkipEvaluation();
        }
        Collection<IomObject> surfaceObjects = actualArguments[0].getComplexObjects();
        String surfaceAttr = actualArguments[1].getValue();
        Collection<IomObject> multiLineObjects = actualArguments[2].getComplexObjects();
        String multiLineAttr = actualArguments[3].getValue();
        if (surfaceObjects == null || surfaceObjects.size() != 1 || surfaceAttr == null || multiLineObjects == null || multiLineObjects.size() != 1 || multiLineAttr == null) {
            return Value.createUndefined();
        }
        IomObject surfaceObject = surfaceObjects.iterator().next();
        IomObject multiLineObject = multiLineObjects.iterator().next();
        if (surfaceObject.getattrvaluecount(surfaceAttr) != 1 || multiLineObject.getattrvaluecount(multiLineAttr) != 1) {
            return Value.createUndefined();
        }
        try {
            surface = this.getSurface(surfaceObject.getattrobj(surfaceAttr, 0), validationKind);
            lines = this.getLines(multiLineObject.getattrobj(multiLineAttr, 0));
        }
        catch (Exception e) {
            EhiLogger.logError(e);
            return Value.createUndefined();
        }
        HashMap<CurveSegment, Boolean> surfaceSegments = new HashMap<CurveSegment, Boolean>();
        for (CompoundCurve line : ((CompoundCurveRing)surface.getExteriorRing()).getLines()) {
            for (CurveSegment segment : line.getSegments()) {
                surfaceSegments.put(segment, false);
            }
        }
        for (int i = 0; i < surface.getNumInteriorRing(); ++i) {
            for (CompoundCurve line : ((CompoundCurveRing)surface.getInteriorRingN(i)).getLines()) {
                for (CurveSegment segment : line.getSegments()) {
                    surfaceSegments.put(segment, false);
                }
            }
        }
        boolean result = true;
        for (CompoundCurve line : lines) {
            for (CurveSegment segment : line.getSegments()) {
                Coordinate point;
                Boolean isSegmentVisited = (Boolean)surfaceSegments.get(segment);
                if (isSegmentVisited == null) {
                    point = segment.getStartPoint();
                    this.logger.addEvent(this.logger.logErrorMsg("MultiLineAttr contains unmatched line segment: {0}.", point.x, point.y, point.z, segment.toString()));
                    result = false;
                    continue;
                }
                if (isSegmentVisited.booleanValue()) {
                    point = segment.getStartPoint();
                    this.logger.addEvent(this.logger.logWarningMsg("MultiLineAttr contains duplicate line segment: {0}.", point.x, point.y, point.z, segment.toString()));
                    continue;
                }
                surfaceSegments.put(segment, true);
            }
        }
        return new Value(result);
    }

    private Value evaluateCoversWithTolerance(String validationKind, String usageScope, IomObject mainObj, Value[] actualArguments) {
        Collection<CompoundCurve> lines;
        for (Value arg : actualArguments) {
            if (!arg.isUndefined()) continue;
            return Value.createSkipEvaluation();
        }
        Collection<IomObject> surfaceObjects = actualArguments[0].getComplexObjects();
        String surfaceAttr = actualArguments[1].getValue();
        Collection<IomObject> multiLineObjects = actualArguments[2].getComplexObjects();
        String multiLineAttr = actualArguments[3].getValue();
        double tolerance = actualArguments[4].getNumeric();
        if (surfaceObjects == null || surfaceAttr == null || multiLineObjects == null || multiLineObjects.size() != 1 || multiLineAttr == null || tolerance < 0.0) {
            return Value.createUndefined();
        }
        IomObject multiLineObject = multiLineObjects.iterator().next();
        if (multiLineObject.getattrvaluecount(multiLineAttr) != 1) {
            return Value.createUndefined();
        }
        ArrayList<CurvePolygon> surfaces = new ArrayList<CurvePolygon>(surfaceObjects.size());
        try {
            for (IomObject surfaceObject : surfaceObjects) {
                if (surfaceObject.getattrvaluecount(surfaceAttr) != 1) {
                    return Value.createUndefined();
                }
                surfaces.add(this.getSurface(surfaceObject.getattrobj(surfaceAttr, 0), validationKind));
            }
            lines = this.getLines(multiLineObject.getattrobj(multiLineAttr, 0));
        }
        catch (IoxException e) {
            EhiLogger.logError(e);
            return Value.createUndefined();
        }
        Envelope linesEnvelope = new Envelope();
        for (CompoundCurve line : lines) {
            linesEnvelope.expandToInclude(line.getEnvelopeInternal());
        }
        linesEnvelope.expandBy(tolerance);
        for (CurvePolygon surface : surfaces) {
            if (!surface.getEnvelopeInternal().intersects(linesEnvelope) || !this.coversWithTolerance(surface, lines, tolerance)) continue;
            return new Value(true);
        }
        return new Value(false);
    }

    private boolean coversWithTolerance(CurvePolygon surface, Collection<CompoundCurve> lines, double tolerance) {
        LineString surfaceOutline = surface.getExteriorRing();
        Geometry bufferedOutline = surfaceOutline.buffer(tolerance);
        if (this.coversAllLines(bufferedOutline, lines)) {
            return true;
        }
        for (int i = 0; i < surface.getNumInteriorRing(); ++i) {
            LineString surfaceInterior = surface.getInteriorRingN(i);
            Geometry bufferedInterior = surfaceInterior.buffer(tolerance);
            if (!this.coversAllLines(bufferedInterior, lines)) continue;
            return true;
        }
        return false;
    }

    private boolean coversAllLines(Geometry geometry, Collection<CompoundCurve> lines) {
        for (CompoundCurve line : lines) {
            if (geometry.covers((Geometry)line)) continue;
            return false;
        }
        return true;
    }

    private Collection<CompoundCurve> getLines(IomObject multiLine) throws IoxException {
        if (multiLine.getobjecttag().equals("POLYLINE")) {
            ArrayList<CompoundCurve> lines = new ArrayList<CompoundCurve>(1);
            lines.add(this.getLine(multiLine));
            return lines;
        }
        ArrayList<CompoundCurve> lines = new ArrayList<CompoundCurve>(multiLine.getattrvaluecount("polyline"));
        for (int i = 0; i < multiLine.getattrvaluecount("polyline"); ++i) {
            lines.add(this.getLine(multiLine.getattrobj("polyline", i)));
        }
        return lines;
    }

    private CompoundCurve getLine(IomObject line) throws IoxException {
        return Iox2jtsext.polyline2JTS(line, false, 0.0, new OutParam<Boolean>(), this.logger, 0.0, "warning", "warning");
    }

    private CurvePolygon getSurface(IomObject surface, String validationKind) throws IoxException {
        return (CurvePolygon)Iox2jtsext.surface2JTS(surface, 0.0, new OutParam<Boolean>(), this.logger, 0.0, validationKind);
    }
}

