/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2fme;

import COM.safe.fmeobjects.FMEException;
import COM.safe.fmeobjects.FMEObjectsPatch;
import COM.safe.fmeobjects.IFMEArc;
import COM.safe.fmeobjects.IFMEArea;
import COM.safe.fmeobjects.IFMECurve;
import COM.safe.fmeobjects.IFMEDonut;
import COM.safe.fmeobjects.IFMEGeometryTools;
import COM.safe.fmeobjects.IFMELine;
import COM.safe.fmeobjects.IFMEMultiArea;
import COM.safe.fmeobjects.IFMEMultiCurve;
import COM.safe.fmeobjects.IFMEMultiPoint;
import COM.safe.fmeobjects.IFMEPath;
import COM.safe.fmeobjects.IFMEPoint;
import COM.safe.fmeobjects.IFMESegment;
import COM.safe.fmeobjects.IFMESession;
import COM.safe.fmeobjects.IFMESimpleArea;
import ch.interlis.ili2fme.DataException;
import ch.interlis.iom.IomObject;
import ch.interlis.iom_j.Iom_jObject;

public class Fme2iox {
    private Fme2iox() {
    }

    public static IomObject FME2coord(IFMEPoint value) throws DataException {
        Iom_jObject ret = new Iom_jObject("COORD", null);
        ret.setattrvalue("C1", Double.toString(value.getX()));
        ret.setattrvalue("C2", Double.toString(value.getY()));
        if (value.is3D()) {
            ret.setattrvalue("C3", Double.toString(value.getZ()));
        }
        return ret;
    }

    public static IomObject FME2multicoord(IFMEMultiPoint value) {
        Iom_jObject ret = new Iom_jObject("MULTICOORD", null);
        for (int i = 0; i < value.numPoints(); ++i) {
            IFMEPoint point = value.getPointAt(i);
            Iom_jObject iomCoord = new Iom_jObject("COORD", null);
            iomCoord.setattrvalue("C1", Double.toString(point.getX()));
            iomCoord.setattrvalue("C2", Double.toString(point.getY()));
            if (value.is3D()) {
                iomCoord.setattrvalue("C3", Double.toString(point.getZ()));
            }
            ret.addattrobj("coord", iomCoord);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IomObject FME2polyline(IFMESession session, IFMEPath value) throws DataException {
        Iom_jObject ret = new Iom_jObject("POLYLINE", null);
        Iom_jObject sequence = new Iom_jObject("SEGMENTS", null);
        ret.addattrobj("sequence", sequence);
        int segc = value.numSegments();
        for (int segi = 0; segi < segc; ++segi) {
            IFMESegment seg = null;
            try {
                seg = value.getSegmentAt(segi);
                FMEObjectsPatch.setOwnsNative(seg, false);
                boolean is3D = value.is3D();
                Fme2iox.addSegment(session, sequence, seg, is3D);
                continue;
            }
            finally {
                if (seg != null) {
                    seg.dispose();
                    seg = null;
                }
            }
        }
        return ret;
    }

    public static IomObject FME2multipolyline(IFMESession session, IFMEMultiCurve fmeGeom) throws DataException {
        Iom_jObject ret = new Iom_jObject("MULTIPOLYLINE", null);
        for (int i = 0; i < fmeGeom.numCurves(); ++i) {
            IFMECurve curve = fmeGeom.getCurveAt(i);
            ret.addattrobj("polyline", Fme2iox.FME2polyline(session, curve));
        }
        return ret;
    }

    public static IomObject FME2multipolyline(IFMESession session, IFMECurve fmeGeom) throws DataException {
        Iom_jObject ret = new Iom_jObject("MULTIPOLYLINE", null);
        ret.addattrobj("polyline", Fme2iox.FME2polyline(session, fmeGeom));
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addSegment(IFMESession session, IomObject sequence, IFMESegment seg, boolean is3D) throws DataException {
        block19: {
            IFMEPoint coord = null;
            IFMEGeometryTools tools = session.getGeometryTools();
            try {
                coord = tools.createPoint();
                if (seg instanceof IFMELine) {
                    int coordi;
                    IFMELine line = (IFMELine)seg;
                    int coordc = line.numPoints();
                    int n = coordi = sequence.getattrvaluecount("segment") > 0 ? 1 : 0;
                    while (coordi < coordc) {
                        try {
                            line.getPointAt(coordi, coord);
                        }
                        catch (FMEException ex) {
                            throw new DataException(ex);
                        }
                        sequence.addattrobj("segment", Fme2iox.FME2coord(coord));
                        ++coordi;
                    }
                    break block19;
                }
                if (seg instanceof IFMEArc) {
                    IFMEArc arc = (IFMEArc)seg;
                    if (arc.isCircular()) {
                        if (sequence.getattrvaluecount("segment") == 0) {
                            try {
                                arc.getStartPoint(coord);
                            }
                            catch (FMEException ex) {
                                throw new DataException(ex);
                            }
                            Iom_jObject iomCoord = new Iom_jObject("COORD", null);
                            iomCoord.setattrvalue("C1", Double.toString(coord.getX()));
                            iomCoord.setattrvalue("C2", Double.toString(coord.getY()));
                            if (is3D) {
                                iomCoord.setattrvalue("C3", Double.toString(coord.getZ()));
                            }
                            sequence.addattrobj("segment", iomCoord);
                        }
                        try {
                            coord = tools.createPoint();
                            arc.getEndPoint(coord);
                        }
                        catch (FMEException ex) {
                            throw new DataException(ex);
                        }
                        Iom_jObject iomArc = new Iom_jObject("ARC", null);
                        iomArc.setattrvalue("C1", Double.toString(coord.getX()));
                        iomArc.setattrvalue("C2", Double.toString(coord.getY()));
                        if (is3D) {
                            iomArc.setattrvalue("C3", Double.toString(coord.getZ()));
                        }
                        try {
                            coord = tools.createPoint();
                            arc.getMidPoint(coord);
                        }
                        catch (FMEException ex) {
                            throw new DataException(ex);
                        }
                        iomArc.setattrvalue("A1", Double.toString(coord.getX()));
                        iomArc.setattrvalue("A2", Double.toString(coord.getY()));
                        sequence.addattrobj("segment", iomArc);
                        break block19;
                    }
                    IFMELine arcAsLine = arc.getAsLine();
                    Fme2iox.addSegment(session, sequence, (IFMESegment)arcAsLine, is3D);
                    break block19;
                }
                throw new IllegalArgumentException("unexpected IFMESegment " + seg.getClass().getName());
            }
            finally {
                if (coord != null) {
                    coord.dispose();
                    coord = null;
                }
            }
        }
    }

    public static IomObject FME2polyline(IFMESession session, IFMECurve value) throws DataException {
        if (value instanceof IFMEPath) {
            return Fme2iox.FME2polyline(session, (IFMEPath)value);
        }
        if (value instanceof IFMESegment) {
            Iom_jObject ret = new Iom_jObject("POLYLINE", null);
            Iom_jObject sequence = new Iom_jObject("SEGMENTS", null);
            ret.addattrobj("sequence", sequence);
            IFMESegment seg = (IFMESegment)value;
            boolean is3D = value.is3D();
            Fme2iox.addSegment(session, sequence, seg, is3D);
            return ret;
        }
        throw new IllegalArgumentException("unexpected IFMECurve " + value.getClass().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IomObject FME2surface(IFMESession session, IFMEDonut value) throws DataException {
        Iom_jObject ret = new Iom_jObject("MULTISURFACE", null);
        Iom_jObject surface = new Iom_jObject("SURFACE", null);
        ret.addattrobj("surface", surface);
        IFMECurve shell = null;
        try {
            shell = value.getOuterBoundaryAsCurve();
            Iom_jObject boundary = new Iom_jObject("BOUNDARY", null);
            surface.addattrobj("boundary", boundary);
            boundary.addattrobj("polyline", Fme2iox.FME2polyline(session, shell));
        }
        finally {
            if (shell != null) {
                shell.dispose();
                shell = null;
            }
        }
        int holec = value.numInnerBoundaries();
        for (int holei = 0; holei < holec; ++holei) {
            IFMECurve hole = null;
            try {
                hole = value.getInnerBoundaryAsCurveAt(holei);
                Iom_jObject boundary = new Iom_jObject("BOUNDARY", null);
                surface.addattrobj("boundary", boundary);
                boundary.addattrobj("polyline", Fme2iox.FME2polyline(session, hole));
                continue;
            }
            finally {
                if (hole != null) {
                    hole.dispose();
                    hole = null;
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IomObject FME2surface(IFMESession session, IFMEArea value) throws DataException {
        if (value instanceof IFMEDonut) {
            return Fme2iox.FME2surface(session, (IFMEDonut)value);
        }
        if (value instanceof IFMESimpleArea) {
            Iom_jObject ret = new Iom_jObject("MULTISURFACE", null);
            Iom_jObject surface = new Iom_jObject("SURFACE", null);
            ret.addattrobj("surface", surface);
            IFMECurve shell = null;
            try {
                shell = ((IFMESimpleArea)value).getBoundaryAsCurve();
                Iom_jObject boundary = new Iom_jObject("BOUNDARY", null);
                surface.addattrobj("boundary", boundary);
                boundary.addattrobj("polyline", Fme2iox.FME2polyline(session, shell));
            }
            finally {
                if (shell != null) {
                    shell.dispose();
                    shell = null;
                }
            }
            return ret;
        }
        throw new IllegalArgumentException("unexpected IFMEArea " + value.getClass().getName());
    }

    public static IomObject FME2multisurface(IFMESession session, IFMEMultiArea value) throws DataException {
        Iom_jObject ret = new Iom_jObject("MULTISURFACE", null);
        for (int i = 0; i < value.numAreas(); ++i) {
            IomObject ioxMultiSurface = Fme2iox.FME2surface(session, value.getAreaAt(i));
            IomObject surface = ioxMultiSurface.getattrobj("surface", 0);
            ret.addattrobj("surface", surface);
        }
        return ret;
    }

    public static IomObject FME2multisurface(IFMESession session, IFMEArea value) throws DataException {
        IomObject ret = Fme2iox.FME2surface(session, value);
        return ret;
    }
}

