/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.fgdb4j;

import ch.ehi.fgdb4j.Fgdb4jException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;

public class Fgdb4j {
    public static final String HARDLIB_PROPERTY_WRAPPER = "ch.ehi.fgdb4j.wrapper";
    public static final String HARDLIB_PROPERTY_ESRIAPI = "ch.ehi.fgdb4j.esriapi";
    private static final String NATIVETMPFILE_PREFIX = "fgdb4j-";
    public static final int FGDB_E_TABLE_NOT_FOUND = -2147220655;
    private static File extractFolder = null;
    private static int refc = 0;
    private static HashMap<String, String> archMapping = new HashMap();
    public static final String X86 = "x86";
    public static final String X86_64 = "x86_64";
    public static final String IA64_32 = "ia64_32";
    public static final String IA64 = "ia64";
    public static final String PPC = "ppc";
    public static final String PPC64 = "ppc64";
    private static String version;

    private Fgdb4j() {
    }

    public static void initialize() throws Fgdb4jException {
        if (++refc == 1) {
            Fgdb4j.loadNativeLibraries();
        }
    }

    public static void close() throws Fgdb4jException {
        if (--refc == 0) {
            // empty if block
        }
    }

    public static void deleteFileGdb(File fgdbFile) {
        if (fgdbFile != null && fgdbFile.exists()) {
            File[] filesInFolder;
            if (fgdbFile.isDirectory() && (filesInFolder = fgdbFile.listFiles()) != null) {
                for (File file : filesInFolder) {
                    if (!file.exists()) continue;
                    file.delete();
                }
            }
            fgdbFile.delete();
        }
    }

    public static void cleanup() {
        if (extractFolder != null && extractFolder.exists()) {
            File[] nativeLibFiles = extractFolder.listFiles();
            if (nativeLibFiles != null) {
                for (File nativeLibFile : nativeLibFiles) {
                    if (!nativeLibFile.exists()) continue;
                    try {
                        boolean bl = nativeLibFile.delete();
                    }
                    catch (SecurityException e) {
                        System.err.println("Failed to delete native lib" + e.getMessage());
                    }
                }
            }
            try {
                boolean bl = extractFolder.delete();
            }
            catch (SecurityException e) {
                System.err.println("Failed to delete native lib folder" + e.getMessage());
            }
        }
    }

    private static void loadNativeLibraries() throws Fgdb4jException {
        if (extractFolder != null) {
            return;
        }
        extractFolder = Fgdb4j.getExtractDir().getAbsoluteFile();
        if (!extractFolder.exists()) {
            extractFolder.mkdirs();
        }
        extractFolder.deleteOnExit();
        String[] file = new String[]{"FileGDBAPI.dll", "fgdb4j.dll"};
        String[] hardlibPropertyName = new String[]{HARDLIB_PROPERTY_ESRIAPI, HARDLIB_PROPERTY_WRAPPER};
        for (int filei = 0; filei < file.length; ++filei) {
            String hardlibPath = System.getProperty(hardlibPropertyName[filei]);
            if (hardlibPath != null) {
                Fgdb4j.loadNativeLibrary(new File(hardlibPath));
                continue;
            }
            String nativeLibraryName = file[filei];
            String packagePath = Fgdb4j.class.getPackage().getName().replaceAll("\\.", "/");
            String nativeLibraryPath = String.format("/%s/native/%s", packagePath, Fgdb4j.getNativeLibFolderPathForCurrentOS());
            boolean hasNativeLib = Fgdb4j.hasResource(nativeLibraryPath + "/" + nativeLibraryName);
            if (!hasNativeLib) {
                extractFolder = null;
                throw new Fgdb4jException(String.format("native library not found: " + nativeLibraryPath + "/" + nativeLibraryName, new Object[0]));
            }
            Fgdb4j.extractAndLoadLibraryFile(nativeLibraryPath, nativeLibraryName, extractFolder);
        }
    }

    private static void loadNativeLibrary(File file) throws Fgdb4jException {
        if (!file.exists()) {
            throw new Fgdb4jException("no native library " + file.getAbsolutePath());
        }
        try {
            System.load(file.getAbsolutePath());
        }
        catch (UnsatisfiedLinkError e) {
            throw new Fgdb4jException("Failed to load native library " + file.getAbsolutePath(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void extractAndLoadLibraryFile(String libFolderForCurrentOS, String libraryFileName, File targetFolder) throws Fgdb4jException {
        String nativeLibraryFilePath = libFolderForCurrentOS + "/" + libraryFileName;
        String extractedLibFileName = libraryFileName;
        File extractedLibFile = new File(targetFolder, extractedLibFileName);
        try {
            if (!extractedLibFile.exists()) {
                InputStream reader = Fgdb4j.class.getResourceAsStream(nativeLibraryFilePath);
                FileOutputStream writer = new FileOutputStream(extractedLibFile);
                try {
                    byte[] buffer = new byte[8192];
                    int bytesRead = 0;
                    while ((bytesRead = reader.read(buffer)) != -1) {
                        writer.write(buffer, 0, bytesRead);
                    }
                }
                finally {
                    extractedLibFile.deleteOnExit();
                    if (writer != null) {
                        writer.close();
                    }
                    if (reader != null) {
                        reader.close();
                    }
                }
                extractedLibFile.setReadable(true);
                extractedLibFile.setWritable(true, true);
                extractedLibFile.setExecutable(true);
            }
            InputStream nativeIn = Fgdb4j.class.getResourceAsStream(nativeLibraryFilePath);
            FileInputStream extractedLibIn = new FileInputStream(extractedLibFile);
            try {
                if (!Fgdb4j.contentsEquals(nativeIn, extractedLibIn)) {
                    throw new IOException("extracted file content different");
                }
            }
            finally {
                if (nativeIn != null) {
                    nativeIn.close();
                }
                if (extractedLibIn != null) {
                    ((InputStream)extractedLibIn).close();
                }
            }
        }
        catch (IOException e) {
            throw new Fgdb4jException("Failed to write a native library file at " + extractedLibFile);
        }
        Fgdb4j.loadNativeLibrary(new File(targetFolder, extractedLibFileName));
    }

    private static boolean contentsEquals(InputStream in1, InputStream in2) throws IOException {
        int ch2;
        if (!(in1 instanceof BufferedInputStream)) {
            in1 = new BufferedInputStream(in1);
        }
        if (!(in2 instanceof BufferedInputStream)) {
            in2 = new BufferedInputStream(in2);
        }
        int ch = in1.read();
        while (ch != -1) {
            ch2 = in2.read();
            if (ch != ch2) {
                return false;
            }
            ch = in1.read();
        }
        ch2 = in2.read();
        return ch2 == -1;
    }

    private static File getExtractDir() {
        String tempFolder = new File(System.getProperty("java.io.tmpdir")).getAbsolutePath();
        return new File(tempFolder, NATIVETMPFILE_PREFIX + Fgdb4j.getArchName() + "-" + Fgdb4j.getVersion());
    }

    private static String getArchName() {
        String osArch = System.getProperty("os.arch");
        String lc = osArch.toLowerCase(Locale.US);
        if (archMapping.containsKey(lc)) {
            return archMapping.get(lc);
        }
        return Fgdb4j.translateArchNameToFolderName(osArch);
    }

    private static String getOSName() {
        return Fgdb4j.translateOSNameToFolderName(System.getProperty("os.name"));
    }

    static String translateOSNameToFolderName(String osName) {
        if (osName.contains("Windows")) {
            return "Windows";
        }
        if (osName.contains("Mac") || osName.contains("Darwin")) {
            return "Mac";
        }
        if (osName.contains("Linux")) {
            return "Linux";
        }
        if (osName.contains("AIX")) {
            return "AIX";
        }
        return osName.replaceAll("\\W", "");
    }

    static String translateArchNameToFolderName(String archName) {
        return archName.replaceAll("\\W", "");
    }

    private static String getNativeLibFolderPathForCurrentOS() {
        return Fgdb4j.getOSName() + "/" + Fgdb4j.getArchName();
    }

    private static boolean hasResource(String path) {
        return Fgdb4j.class.getResource(path) != null;
    }

    public static int getMajorVersion() {
        String[] c = Fgdb4j.getVersion().split("\\.");
        return c.length > 0 ? Integer.parseInt(c[0]) : 1;
    }

    public static int getMinorVersion() {
        String[] c = Fgdb4j.getVersion().split("\\.");
        return c.length > 1 ? Integer.parseInt(c[1]) : 0;
    }

    public static String getVersion() {
        if (version == null) {
            ResourceBundle resVersion = ResourceBundle.getBundle("ch/ehi/fgdb4j/Version");
            StringBuffer ret = new StringBuffer(80);
            ret.append(resVersion.getString("version"));
            ret.append('-');
            ret.append(resVersion.getString("versionCommit"));
            version = ret.toString();
        }
        return version;
    }

    static {
        archMapping.put(X86, X86);
        archMapping.put("i386", X86);
        archMapping.put("i486", X86);
        archMapping.put("i586", X86);
        archMapping.put("i686", X86);
        archMapping.put("pentium", X86);
        archMapping.put(X86_64, X86_64);
        archMapping.put("amd64", X86_64);
        archMapping.put("em64t", X86_64);
        archMapping.put("universal", X86_64);
        archMapping.put(IA64, IA64);
        archMapping.put("ia64w", IA64);
        archMapping.put(IA64_32, IA64_32);
        archMapping.put("ia64n", IA64_32);
        archMapping.put(PPC, PPC);
        archMapping.put("power", PPC);
        archMapping.put("powerpc", PPC);
        archMapping.put("power_pc", PPC);
        archMapping.put("power_rs", PPC);
        archMapping.put(PPC64, PPC64);
        archMapping.put("power64", PPC64);
        archMapping.put("powerpc64", PPC64);
        archMapping.put("power_pc64", PPC64);
        archMapping.put("power_rs64", PPC64);
        version = null;
    }
}

