/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.ili2fgdb.jdbc;

import ch.ehi.fgdb4j.Fgdb4j;
import ch.ehi.fgdb4j.Fgdb4jException;
import ch.ehi.fgdb4j.jni.Geodatabase;
import ch.ehi.fgdb4j.jni.fgbd4j;
import ch.ehi.ili2fgdb.jdbc.FgdbConnection;
import java.io.File;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;

public class FgdbDriver
implements Driver {
    public static final String BASE_URL = "jdbc:ili2fgdb:";

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return url.startsWith(BASE_URL);
    }

    @Override
    public Connection connect(String url, Properties props) throws SQLException {
        if (!this.acceptsURL(url)) {
            return null;
        }
        String fileName = url.substring(BASE_URL.length());
        try {
            Fgdb4j.initialize();
        }
        catch (Fgdb4jException e) {
            throw new SQLException("failed to initialize fgdb4j", e);
        }
        Geodatabase wksp = null;
        File file = new File(fileName);
        if (file.exists()) {
            if (props == null || !props.isEmpty()) {
                // empty if block
            }
            wksp = new Geodatabase();
            int ret = fgbd4j.OpenGeodatabase((String)file.getPath(), (Geodatabase)wksp);
            if (ret != 0) {
                StringBuffer errorDescription = new StringBuffer();
                fgbd4j.GetErrorDescription((int)ret, (StringBuffer)errorDescription);
                throw new SQLException(errorDescription.toString());
            }
        } else {
            wksp = new Geodatabase();
            int ret = fgbd4j.CreateGeodatabase((String)file.getPath(), (Geodatabase)wksp);
            if (ret != 0) {
                StringBuffer errorDescription = new StringBuffer();
                fgbd4j.GetErrorDescription((int)ret, (StringBuffer)errorDescription);
                throw new SQLException(errorDescription.toString());
            }
        }
        return new FgdbConnection(wksp, url);
    }

    @Override
    public int getMajorVersion() {
        return Fgdb4j.getMajorVersion();
    }

    @Override
    public int getMinorVersion() {
        return Fgdb4j.getMinorVersion();
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String arg0, Properties arg1) throws SQLException {
        return null;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }

    static {
        try {
            DriverManager.registerDriver(new FgdbDriver());
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

