/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.ili2fgdb.jdbc;

import ch.ehi.ili2fgdb.jdbc.AbstractResultSet;
import ch.ehi.ili2fgdb.jdbc.sql.AbstractSelectStmt;
import ch.ehi.ili2fgdb.jdbc.sql.JoinStmt;
import ch.ehi.ili2fgdb.jdbc.sql.SelectValue;
import ch.ehi.ili2fgdb.jdbc.sql.SelectValueField;
import ch.ehi.ili2fgdb.jdbc.sql.SelectValueNull;
import ch.ehi.ili2fgdb.jdbc.sql.SelectValueString;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.rowset.RowSetMetaDataImpl;

public class JoinResultSet
extends AbstractResultSet
implements ResultSet {
    private ResultSet rsLeft = null;
    private List<ResultSet> rsRight = null;
    private String leftKeyCol = null;
    private Object[][] rightRecord = null;
    private Map<Object, Object[]>[] rightRecords = null;
    private int[] rightTableFieldCount = null;
    private int[] rightTableKeyIdx = null;
    private boolean lastGetWasNull = false;
    private JoinStmt stmt = null;
    private int rightc;

    public JoinResultSet(ResultSet rsLeft, List<ResultSet> rsRight, JoinStmt jstmt) throws SQLException {
        this.rsLeft = rsLeft;
        this.rsRight = rsRight;
        this.leftKeyCol = jstmt.getLeftKeyCol();
        this.rightc = rsRight.size();
        this.rightTableKeyIdx = new int[this.rightc];
        this.rightTableFieldCount = new int[this.rightc];
        this.rightRecords = new Map[this.rightc];
        for (int i = 0; i < this.rightc; ++i) {
            this.rightTableKeyIdx[i] = rsRight.get(i).findColumn(jstmt.getRightKeyCol().get(i));
            this.rightTableFieldCount[i] = rsRight.get(i).getMetaData().getColumnCount();
            this.rightRecords[i] = new HashMap<Object, Object[]>();
        }
        this.stmt = jstmt;
    }

    @Override
    public boolean next() throws SQLException {
        if (!this.rsLeft.next()) {
            return false;
        }
        Object key = this.rsLeft.getObject(this.leftKeyCol);
        this.rightRecord = this.findRightRecord(key);
        return true;
    }

    private Object[][] findRightRecord(Object key) throws SQLException {
        Object[][] ret = new Object[this.rightc][];
        for (int i = 0; i < this.rightc; ++i) {
            ret[i] = this.findRightRecord(key, this.rightRecords[i], this.rsRight.get(i), this.rightTableFieldCount[i], this.rightTableKeyIdx[i]);
        }
        return ret;
    }

    private Object[] findRightRecord(Object key, Map<Object, Object[]> rightRecords, ResultSet rsRight, int rightTableFieldCount, int rightTableKeyIdx) throws SQLException {
        Object[] rec = rightRecords.get(key);
        if (rec != null) {
            return rec;
        }
        while (rsRight.next()) {
            rec = new Object[rightTableFieldCount];
            for (int i = 0; i < rightTableFieldCount; ++i) {
                rec[i] = rsRight.getObject(i + 1);
            }
            Object recKey = rec[rightTableKeyIdx - 1];
            rightRecords.put(recKey, rec);
            if (!key.equals(recKey)) continue;
            return rec;
        }
        return null;
    }

    @Override
    public void close() throws SQLException {
        if (this.rsLeft != null) {
            this.rsLeft.close();
            this.rsLeft = null;
        }
        if (this.rsRight != null) {
            for (ResultSet rs : this.rsRight) {
                rs.close();
            }
            this.rsRight = null;
        }
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.lastGetWasNull;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        RowSetMetaDataImpl ret = new RowSetMetaDataImpl();
        ret.setColumnCount(this.stmt.getFields().size());
        return ret;
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        Object val = null;
        SelectValue selectValue = this.stmt.getFields().get(columnIndex - 1);
        if (selectValue instanceof SelectValueNull) {
            val = null;
        } else if (selectValue instanceof SelectValueString) {
            val = ((SelectValueString)selectValue).getLiteralValue();
        } else if (selectValue instanceof SelectValueField) {
            String tabName = ((SelectValueField)selectValue).getTableName();
            String colName = selectValue.getColumnName();
            int colIdxInLeftTab = 0;
            int colIdxInRightTab = 0;
            int rightTableIdx = -1;
            if (tabName != null) {
                String leftAlias = this.stmt.getLeftStmt().getTableAlias();
                if (leftAlias == null) {
                    leftAlias = this.stmt.getLeftStmt().getTableName();
                }
                if (leftAlias.equals(tabName)) {
                    colIdxInLeftTab = this.stmt.getLeftStmt().findCol(colName);
                } else {
                    for (int i = 0; i < this.rightc; ++i) {
                        AbstractSelectStmt rightSelectStmt = this.stmt.getRightStmt().get(i);
                        String rightAlias = rightSelectStmt.getTableAlias();
                        if (rightAlias == null) {
                            rightAlias = rightSelectStmt.getTableName();
                        }
                        if (!rightAlias.equals(tabName) || (colIdxInRightTab = rightSelectStmt.findCol(colName)) <= 0) continue;
                        rightTableIdx = i;
                        break;
                    }
                }
            } else {
                colIdxInLeftTab = this.stmt.getLeftStmt().findCol(colName);
                if (colIdxInLeftTab == 0) {
                    for (int i = 0; i < this.rightc; ++i) {
                        colIdxInRightTab = this.stmt.getRightStmt().get(i).findCol(colName);
                        if (colIdxInRightTab <= 0) continue;
                        rightTableIdx = i;
                        break;
                    }
                }
            }
            val = colIdxInLeftTab > 0 ? this.rsLeft.getObject(colIdxInLeftTab) : (this.rightRecord[rightTableIdx] == null ? null : (colIdxInRightTab > 0 ? this.rightRecord[rightTableIdx][colIdxInRightTab - 1] : null));
        }
        this.lastGetWasNull = val == null;
        return val;
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        int idx = this.stmt.findCol(columnLabel);
        if (idx == 0) {
            throw new SQLException("column <" + columnLabel + "> not found");
        }
        return idx;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.rsLeft == null && this.rsRight == null;
    }
}

