/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.ili2fgdb.jdbc;

import ch.ehi.fgdb4j.jni.ByteArray;
import ch.ehi.fgdb4j.jni.EnumRows;
import ch.ehi.fgdb4j.jni.FieldInfo;
import ch.ehi.fgdb4j.jni.FieldType;
import ch.ehi.fgdb4j.jni.Row;
import ch.ehi.fgdb4j.jni.ShapeBuffer;
import ch.ehi.fgdb4j.jni.Table;
import ch.ehi.fgdb4j.jni.ce_time;
import ch.ehi.fgdb4j.jni.fgbd4j;
import ch.ehi.ili2fgdb.jdbc.FgdbConnection;
import ch.ehi.ili2fgdb.jdbc.FgdbResultSet;
import ch.ehi.ili2fgdb.jdbc.JoinResultSet;
import ch.ehi.ili2fgdb.jdbc.MemResultSet;
import ch.ehi.ili2fgdb.jdbc.sql.AbstractSelectStmt;
import ch.ehi.ili2fgdb.jdbc.sql.ColRef;
import ch.ehi.ili2fgdb.jdbc.sql.ComplexSelectStmt;
import ch.ehi.ili2fgdb.jdbc.sql.FgdbSelectStmt;
import ch.ehi.ili2fgdb.jdbc.sql.InsertStmt;
import ch.ehi.ili2fgdb.jdbc.sql.IntConst;
import ch.ehi.ili2fgdb.jdbc.sql.IsNull;
import ch.ehi.ili2fgdb.jdbc.sql.JoinStmt;
import ch.ehi.ili2fgdb.jdbc.sql.SelectValue;
import ch.ehi.ili2fgdb.jdbc.sql.SelectValueField;
import ch.ehi.ili2fgdb.jdbc.sql.SqlQname;
import ch.ehi.ili2fgdb.jdbc.sql.SqlStmt;
import ch.ehi.ili2fgdb.jdbc.sql.StringConst;
import ch.ehi.ili2fgdb.jdbc.sql.UpdateStmt;
import ch.ehi.ili2fgdb.jdbc.sql.Value;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FgdbPreparedStatement
implements PreparedStatement {
    private SqlStmt stmt = null;
    private FgdbConnection conn = null;
    private String stmtStr = null;
    private ArrayList<Object> params = null;
    private int fieldCount = 0;
    private String geometryColumn = null;
    private Map<String, Integer> fieldType = null;

    protected FgdbPreparedStatement(FgdbConnection conn, SqlStmt select, String stmtStr) {
        this.stmt = select;
        this.conn = conn;
        this.stmtStr = stmtStr;
    }

    @Override
    public void addBatch() throws SQLException {
    }

    @Override
    public void clearParameters() throws SQLException {
        this.params = null;
    }

    @Override
    public boolean execute() throws SQLException {
        return false;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        ResultSet ret = this.executeSelectStmt((AbstractSelectStmt)this.stmt, null);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultSet executeSelectStmt(AbstractSelectStmt stmt, String keyCol) throws SQLException {
        Table table = null;
        EnumRows rows = null;
        List<SelectValue> selectCols = null;
        int err = 0;
        ResultSet ret = null;
        try {
            if (stmt instanceof FgdbSelectStmt) {
                FgdbSelectStmt ustmt = (FgdbSelectStmt)stmt;
                table = new Table();
                err = this.conn.getGeodatabase().OpenTable(ustmt.getTableName(), table);
                if (err != 0) {
                    StringBuffer errDesc = new StringBuffer();
                    fgbd4j.GetErrorDescription(err, errDesc);
                    throw new SQLException(errDesc.toString());
                }
                this.setupFieldInfo(table);
                StringBuffer where = new StringBuffer();
                String sep = "";
                int paramIdx = 0;
                for (Map.Entry<Value, Value> set : ustmt.getConditions()) {
                    ColRef colref = (ColRef)set.getKey();
                    where.append(sep);
                    sep = " AND ";
                    where.append(colref.getName());
                    Value rh = set.getValue();
                    if (rh instanceof IntConst) {
                        where.append("=");
                        where.append(Integer.toString(((IntConst)rh).getValue()));
                        continue;
                    }
                    if (rh instanceof IsNull) {
                        where.append(" IS NULL");
                        continue;
                    }
                    if (rh instanceof StringConst) {
                        where.append("='");
                        where.append(((StringConst)rh).getValue());
                        where.append("'");
                        continue;
                    }
                    Object param = this.params.get(paramIdx++);
                    this.appendParam(where, paramIdx, param);
                }
                StringBuffer fields = new StringBuffer();
                String sep2 = "";
                selectCols = ustmt.getFields();
                for (SelectValue colref : selectCols) {
                    if (!(colref instanceof SelectValueField)) continue;
                    fields.append(sep2);
                    sep2 = ",";
                    String columnName = colref.getColumnName();
                    fields.append(columnName);
                    if (keyCol == null || !columnName.equals(keyCol)) continue;
                    keyCol = null;
                }
                if (keyCol != null) {
                    fields.append(sep2);
                    sep2 = ",";
                    fields.append(keyCol);
                    selectCols.add(new SelectValueField(new SqlQname(keyCol)));
                }
                rows = new EnumRows();
                err = table.Search(fields.toString(), where.toString(), false, rows);
                if (err != 0) {
                    StringBuffer errDesc = new StringBuffer();
                    fgbd4j.GetErrorDescription(err, errDesc);
                    throw new SQLException(errDesc.toString());
                }
                ret = new FgdbResultSet(this.conn, table, rows, selectCols);
                rows = null;
                table = null;
            } else if (stmt instanceof JoinStmt) {
                JoinStmt jstmt = (JoinStmt)stmt;
                ResultSet rsLeft = this.executeSelectStmt(jstmt.getLeftStmt(), jstmt.getLeftKeyCol());
                ArrayList<ResultSet> rsRight = new ArrayList<ResultSet>();
                int rightc = jstmt.getRightStmt().size();
                for (int i = 0; i < rightc; ++i) {
                    rsRight.add(this.executeSelectStmt(jstmt.getRightStmt().get(i), jstmt.getRightKeyCol().get(i)));
                }
                ret = new JoinResultSet(rsLeft, rsRight, jstmt);
            } else if (stmt instanceof ComplexSelectStmt) {
                ret = new MemResultSet(this.executeSelectStmt(((ComplexSelectStmt)stmt).getSubSelect(), null), stmt.getConditions(), this.params);
            } else {
                rows = new EnumRows();
                err = this.conn.getGeodatabase().ExecuteSQL(this.stmtStr, true, rows);
                if (err != 0) {
                    StringBuffer errDesc = new StringBuffer();
                    fgbd4j.GetErrorDescription(err, errDesc);
                    throw new SQLException(errDesc.toString());
                }
                ret = new FgdbResultSet(this.conn, table, rows, selectCols);
                rows = null;
                table = null;
            }
        }
        finally {
            if (rows != null) {
                rows.Close();
                rows.delete();
                rows = null;
            }
            if (table != null) {
                this.conn.getGeodatabase().CloseTable(table);
                table.delete();
                table = null;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate() throws SQLException {
        int err = 0;
        if (this.stmt instanceof InsertStmt) {
            Table table = null;
            Row row = null;
            ShapeBuffer shapeBuffer = null;
            try {
                table = new Table();
                err = this.conn.getGeodatabase().OpenTable(((InsertStmt)this.stmt).getTableName(), table);
                if (err != 0) {
                    StringBuffer errDesc = new StringBuffer();
                    fgbd4j.GetErrorDescription(err, errDesc);
                    throw new SQLException(errDesc.toString());
                }
                this.setupFieldInfo(table);
                row = new Row();
                err = table.CreateRowObject(row);
                if (err != 0) {
                    StringBuffer errDesc = new StringBuffer();
                    fgbd4j.GetErrorDescription(err, errDesc);
                    throw new SQLException(errDesc.toString());
                }
                for (int i = 0; i < ((InsertStmt)this.stmt).getFields().size(); ++i) {
                    String colName = ((InsertStmt)this.stmt).getFields().get(i);
                    Object val = this.params.get(i);
                    if (colName.equals(this.geometryColumn)) {
                        if (val == null) {
                            this.setRowVal(row, this.geometryColumn, null);
                            continue;
                        }
                        shapeBuffer = new ShapeBuffer();
                        shapeBuffer.setBuffer((byte[])val);
                        row.SetGeometry(shapeBuffer);
                        continue;
                    }
                    this.setRowVal(row, colName, val);
                }
                if (shapeBuffer == null && this.geometryColumn != null) {
                    this.setRowVal(row, this.geometryColumn, null);
                }
                if (shapeBuffer != null) {
                    shapeBuffer.delete();
                    shapeBuffer = null;
                }
                if ((err = table.Insert(row)) != 0) {
                    StringBuffer errDesc = new StringBuffer();
                    fgbd4j.GetErrorDescription(err, errDesc);
                    throw new SQLException(errDesc.toString());
                }
                this.params = null;
            }
            finally {
                if (shapeBuffer != null) {
                    shapeBuffer.delete();
                    shapeBuffer = null;
                }
                if (row != null) {
                    row.delete();
                    row = null;
                }
                if (table != null) {
                    err = this.conn.getGeodatabase().CloseTable(table);
                    if (err != 0) {
                        StringBuffer errDesc = new StringBuffer();
                        fgbd4j.GetErrorDescription(err, errDesc);
                        throw new SQLException(errDesc.toString());
                    }
                    table.delete();
                    table = null;
                }
            }
        }
        if (this.stmt instanceof UpdateStmt) {
            UpdateStmt ustmt = (UpdateStmt)this.stmt;
            Table table = null;
            Row row = null;
            EnumRows rows = null;
            try {
                table = new Table();
                err = this.conn.getGeodatabase().OpenTable(ustmt.getTableName(), table);
                if (err != 0) {
                    StringBuffer errDesc = new StringBuffer();
                    fgbd4j.GetErrorDescription(err, errDesc);
                    throw new SQLException(errDesc.toString());
                }
                this.setupFieldInfo(table);
                rows = new EnumRows();
                StringBuffer where = new StringBuffer();
                String sep = "";
                int paramIdx = ustmt.getSettings().size();
                for (Map.Entry<Value, Value> set : ustmt.getConditions()) {
                    ColRef colref = (ColRef)set.getKey();
                    where.append(sep);
                    sep = " AND ";
                    where.append(colref.getName());
                    Object param = this.params.get(paramIdx++);
                    this.appendParam(where, paramIdx, param);
                }
                err = table.Search("*", where.toString(), false, rows);
                if (err != 0) {
                    StringBuffer errDesc = new StringBuffer();
                    fgbd4j.GetErrorDescription(err, errDesc);
                    throw new SQLException(errDesc.toString());
                }
                row = new Row();
                while (rows.Next(row) == 0) {
                    int paramIdx2 = 0;
                    for (Map.Entry<Value, Value> set : ustmt.getSettings()) {
                        Object param = this.params.get(paramIdx2++);
                        String colName = ((ColRef)set.getKey()).getName();
                        this.setRowVal(row, colName, param);
                    }
                    err = table.Update(row);
                    if (err == 0) continue;
                    StringBuffer errDesc = new StringBuffer();
                    fgbd4j.GetErrorDescription(err, errDesc);
                    throw new SQLException(errDesc.toString());
                }
                this.params = null;
            }
            finally {
                if (rows != null) {
                    rows.Close();
                    rows.delete();
                    rows = null;
                }
                if (row != null) {
                    row.delete();
                    row = null;
                }
                if (table != null) {
                    err = this.conn.getGeodatabase().CloseTable(table);
                    if (err != 0) {
                        StringBuffer errDesc = new StringBuffer();
                        fgbd4j.GetErrorDescription(err, errDesc);
                        throw new SQLException(errDesc.toString());
                    }
                    table.delete();
                    table = null;
                }
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupFieldInfo(Table table) {
        if (this.fieldType == null) {
            this.fieldType = new HashMap<String, Integer>();
            FieldInfo fieldInfo = null;
            try {
                fieldInfo = new FieldInfo();
                int err = table.GetFieldInformation(fieldInfo);
                int[] fieldCounto = new int[1];
                err = fieldInfo.GetFieldCount(fieldCounto);
                this.fieldCount = fieldCounto[0];
                int[] fieldType = new int[1];
                for (int colIdx = 0; colIdx < this.fieldCount; ++colIdx) {
                    StringBuffer fieldName = new StringBuffer();
                    fieldInfo.GetFieldName(colIdx, fieldName);
                    fieldInfo.GetFieldType(colIdx, fieldType);
                    this.fieldType.put(fieldName.toString(), fieldType[0]);
                    if (fieldType[0] != FieldType.fieldTypeGeometry.swigValue()) continue;
                    this.geometryColumn = fieldName.toString();
                }
            }
            finally {
                if (fieldInfo != null) {
                    fieldInfo.delete();
                    fieldInfo = null;
                }
            }
        }
    }

    private void appendParam(StringBuffer where, int paramIdx, Object param) {
        if (param == null) {
            where.append(" IS NULL");
        } else {
            where.append("=");
            if (param instanceof String) {
                where.append("'");
                where.append(param);
                where.append("'");
            } else if (param instanceof Long) {
                where.append(param);
            } else {
                throw new IllegalArgumentException("param " + paramIdx + " unexpected type " + param.getClass().getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setRowVal(Row row, String colName, Object val) throws SQLException {
        Object value;
        int err = 0;
        if (val == null) {
            err = row.SetNull(colName);
        } else if (val instanceof String) {
            err = this.fieldType.get(colName).intValue() == FieldType.fieldTypeXML.swigValue() ? row.SetXML(colName, (String)val) : row.SetString(colName, (String)val);
        } else if (val instanceof Long) {
            err = row.SetInteger(colName, ((Long)val).intValue());
        } else if (val instanceof Integer) {
            err = row.SetInteger(colName, (int)((Integer)val));
        } else if (val instanceof Double) {
            err = row.SetDouble(colName, (double)((Double)val));
        } else if (val instanceof Boolean) {
            err = row.SetShort(colName, (short)((Boolean)val != false ? 1 : 0));
        } else if (val instanceof Timestamp) {
            value = new GregorianCalendar();
            ((Calendar)value).setTimeInMillis(((Timestamp)val).getTime());
            ce_time time = null;
            try {
                time = new ce_time();
                time.setTm_year(((Calendar)value).get(1) - 1900);
                time.setTm_mon(((Calendar)value).get(2));
                time.setTm_mday(((Calendar)value).get(5));
                time.setTm_hour(((Calendar)value).get(11));
                time.setTm_min(((Calendar)value).get(12));
                time.setTm_sec(((Calendar)value).get(13));
                time.setTm_isdst(0);
                time.setTm_wday(0);
                time.setTm_yday(0);
                err = row.setDateTime(colName, time);
            }
            finally {
                if (time != null) {
                    time.delete();
                }
            }
        } else if (val instanceof Date) {
            value = new GregorianCalendar();
            ((Calendar)value).setTimeInMillis(((Date)val).getTime());
            ce_time time = null;
            try {
                time = new ce_time();
                time.setTm_year(((Calendar)value).get(1) - 1900);
                time.setTm_mon(((Calendar)value).get(2));
                time.setTm_mday(((Calendar)value).get(5));
                time.setTm_hour(0);
                time.setTm_min(0);
                time.setTm_sec(0);
                time.setTm_isdst(0);
                time.setTm_wday(0);
                time.setTm_yday(0);
                err = row.setDateTime(colName, time);
            }
            finally {
                if (time != null) {
                    time.delete();
                }
            }
        } else if (val instanceof Time) {
            value = new GregorianCalendar();
            ((Calendar)value).setTimeInMillis(((Time)val).getTime());
            ce_time time = null;
            try {
                time = new ce_time();
                time.setTm_year(-1);
                time.setTm_mon(11);
                time.setTm_mday(30);
                time.setTm_hour(((Calendar)value).get(11));
                time.setTm_min(((Calendar)value).get(12));
                time.setTm_sec(((Calendar)value).get(13));
                time.setTm_isdst(-1);
                time.setTm_wday(6);
                time.setTm_yday(363);
                err = row.setDateTime(colName, time);
            }
            finally {
                if (time != null) {
                    time.delete();
                }
            }
        } else if (val instanceof byte[]) {
            value = (byte[])val;
            ByteArray binaryBuf = new ByteArray();
            binaryBuf.setBuffer((byte[])value);
            row.SetBinary(colName, binaryBuf);
        } else {
            throw new IllegalArgumentException("param " + colName + " unexpected type " + val.getClass().getName());
        }
        if (err != 0) {
            StringBuffer errDesc = new StringBuffer();
            fgbd4j.GetErrorDescription(err, errDesc);
            throw new SQLException(errDesc.toString());
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return null;
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return null;
    }

    @Override
    public void setArray(int arg0, Array arg1) throws SQLException {
        this.setParam(arg0, arg1);
    }

    @Override
    public void setAsciiStream(int arg0, InputStream arg1) throws SQLException {
    }

    @Override
    public void setAsciiStream(int arg0, InputStream arg1, int arg2) throws SQLException {
    }

    @Override
    public void setAsciiStream(int arg0, InputStream arg1, long arg2) throws SQLException {
    }

    @Override
    public void setBigDecimal(int arg0, BigDecimal arg1) throws SQLException {
        this.setParam(arg0, arg1);
    }

    @Override
    public void setBinaryStream(int arg0, InputStream arg1) throws SQLException {
    }

    @Override
    public void setBinaryStream(int arg0, InputStream arg1, int arg2) throws SQLException {
    }

    @Override
    public void setBinaryStream(int arg0, InputStream arg1, long arg2) throws SQLException {
    }

    @Override
    public void setBlob(int arg0, Blob arg1) throws SQLException {
        this.setParam(arg0, arg1);
    }

    @Override
    public void setBlob(int arg0, InputStream arg1) throws SQLException {
    }

    @Override
    public void setBlob(int arg0, InputStream arg1, long arg2) throws SQLException {
    }

    @Override
    public void setBoolean(int arg0, boolean arg1) throws SQLException {
        this.setParam(arg0, arg1);
    }

    @Override
    public void setByte(int arg0, byte arg1) throws SQLException {
        this.setParam(arg0, arg1);
    }

    @Override
    public void setBytes(int arg0, byte[] arg1) throws SQLException {
        this.setParam(arg0, arg1);
    }

    @Override
    public void setCharacterStream(int arg0, Reader arg1) throws SQLException {
    }

    @Override
    public void setCharacterStream(int arg0, Reader arg1, int arg2) throws SQLException {
    }

    @Override
    public void setCharacterStream(int arg0, Reader arg1, long arg2) throws SQLException {
    }

    @Override
    public void setClob(int arg0, Clob arg1) throws SQLException {
        this.setParam(arg0, arg1);
    }

    @Override
    public void setClob(int arg0, Reader arg1) throws SQLException {
    }

    @Override
    public void setClob(int arg0, Reader arg1, long arg2) throws SQLException {
    }

    @Override
    public void setDate(int arg0, Date arg1) throws SQLException {
        this.setParam(arg0, arg1);
    }

    @Override
    public void setDate(int arg0, Date arg1, Calendar arg2) throws SQLException {
        this.setParam(arg0, arg1);
    }

    @Override
    public void setDouble(int arg0, double arg1) throws SQLException {
        this.setParam(arg0, arg1);
    }

    @Override
    public void setFloat(int arg0, float arg1) throws SQLException {
        this.setParam(arg0, Float.valueOf(arg1));
    }

    @Override
    public void setInt(int arg0, int arg1) throws SQLException {
        this.setParam(arg0, arg1);
    }

    @Override
    public void setLong(int arg0, long arg1) throws SQLException {
        this.setParam(arg0, arg1);
    }

    @Override
    public void setNCharacterStream(int arg0, Reader arg1) throws SQLException {
    }

    @Override
    public void setNCharacterStream(int arg0, Reader arg1, long arg2) throws SQLException {
    }

    @Override
    public void setNClob(int arg0, NClob arg1) throws SQLException {
        this.setParam(arg0, arg1);
    }

    @Override
    public void setNClob(int arg0, Reader arg1) throws SQLException {
    }

    @Override
    public void setNClob(int arg0, Reader arg1, long arg2) throws SQLException {
    }

    @Override
    public void setNString(int arg0, String arg1) throws SQLException {
        this.setParam(arg0, arg1);
    }

    @Override
    public void setNull(int idx, int sqlType) throws SQLException {
        this.setParam(idx, null);
    }

    @Override
    public void setNull(int idx, int arg1, String arg2) throws SQLException {
        this.setParam(idx, null);
    }

    @Override
    public void setObject(int idx, Object value) throws SQLException {
        this.setParam(idx, value);
    }

    @Override
    public void setObject(int idx, Object value, int arg2) throws SQLException {
        this.setParam(idx, value);
    }

    @Override
    public void setObject(int idx, Object value, int arg2, int arg3) throws SQLException {
        this.setParam(idx, value);
    }

    @Override
    public void setRef(int arg0, Ref arg1) throws SQLException {
        this.setParam(arg0, arg1);
    }

    @Override
    public void setRowId(int arg0, RowId arg1) throws SQLException {
        this.setParam(arg0, arg1);
    }

    @Override
    public void setSQLXML(int arg0, SQLXML arg1) throws SQLException {
        this.setParam(arg0, arg1);
    }

    @Override
    public void setShort(int arg0, short arg1) throws SQLException {
        this.setParam(arg0, arg1);
    }

    @Override
    public void setString(int idx, String value) throws SQLException {
        this.setParam(idx, value);
    }

    private void setParam(int idx, Object value) {
        this.prepParamSet(idx);
        this.params.set(idx - 1, value);
    }

    private void prepParamSet(int idx) {
        if (this.params == null) {
            this.params = new ArrayList();
        }
        for (int i = this.params.size(); i < idx; ++i) {
            this.params.add(null);
        }
    }

    @Override
    public void setTime(int arg0, Time arg1) throws SQLException {
        this.setParam(arg0, arg1);
    }

    @Override
    public void setTime(int arg0, Time arg1, Calendar arg2) throws SQLException {
        this.setParam(arg0, arg1);
    }

    @Override
    public void setTimestamp(int idx, Timestamp value) throws SQLException {
        this.setParam(idx, value);
    }

    @Override
    public void setTimestamp(int arg0, Timestamp arg1, Calendar arg2) throws SQLException {
        this.setParam(arg0, arg1);
    }

    @Override
    public void setURL(int arg0, URL arg1) throws SQLException {
        this.setParam(arg0, arg1);
    }

    @Override
    public void setUnicodeStream(int arg0, InputStream arg1, int arg2) throws SQLException {
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        return null;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        return 0;
    }

    @Override
    public void close() throws SQLException {
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return 0;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
    }

    @Override
    public int getMaxRows() throws SQLException {
        return 0;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return 0;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
    }

    @Override
    public void cancel() throws SQLException {
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public void setCursorName(String name) throws SQLException {
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        return false;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return null;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return 0;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return false;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 0;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
    }

    @Override
    public int getFetchSize() throws SQLException {
        return 0;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return 0;
    }

    @Override
    public int getResultSetType() throws SQLException {
        return 0;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
    }

    @Override
    public void clearBatch() throws SQLException {
    }

    @Override
    public int[] executeBatch() throws SQLException {
        return null;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return null;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        return false;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return null;
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return 0;
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return 0;
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return 0;
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return false;
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return false;
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return false;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 0;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return false;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return false;
    }
}

